/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.fund.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchFluentHelperBasic;

/**
 * Default implementation of the {@link FundServiceBatch} interface exposed in the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.FundService FundService}, allowing you to create multiple
 * changesets and finally execute the batch request.
 *
 */
public class DefaultFundServiceBatch extends BatchFluentHelperBasic<FundServiceBatch, FundServiceBatchChangeSet>
    implements
    FundServiceBatch
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.FundService service;
    @Nonnull
    private final String servicePath;

    /**
     * Creates a new instance of this DefaultFundServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultFundServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.FundService service )
    {
        this(service, com.sap.cloud.sdk.s4hana.datamodel.odata.services.FundService.DEFAULT_SERVICE_PATH);
    }

    /**
     * Creates a new instance of this DefaultFundServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     * @param servicePath
     *            The custom service path to operate on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultFundServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.FundService service,
        @Nonnull final String servicePath )
    {
        this.service = service;
        this.servicePath = servicePath;
    }

    @Nonnull
    @Override
    protected String getServicePathForBatchRequest()
    {
        return servicePath;
    }

    @Nonnull
    @Override
    protected DefaultFundServiceBatch getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public FundServiceBatchChangeSet beginChangeSet()
    {
        return new DefaultFundServiceBatchChangeSet(this, service);
    }

}
