/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.fund.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchChangeSetFluentHelperBasic;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.fund.FundCore;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.fund.FundText;

/**
 * Implementation of the {@link FundServiceBatchChangeSet} interface, enabling you to combine multiple operations into
 * one changeset. For further information have a look into the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.FundService FundService}.
 *
 */
public class DefaultFundServiceBatchChangeSet
    extends
    BatchChangeSetFluentHelperBasic<FundServiceBatch, FundServiceBatchChangeSet>
    implements
    FundServiceBatchChangeSet
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.FundService service;

    @SuppressWarnings( "deprecation" )
    DefaultFundServiceBatchChangeSet(
        @Nonnull final DefaultFundServiceBatch batchFluentHelper,
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.FundService service )
    {
        super(batchFluentHelper, batchFluentHelper);
        this.service = service;
    }

    @Nonnull
    @Override
    protected DefaultFundServiceBatchChangeSet getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public FundServiceBatchChangeSet createFundCore( @Nonnull final FundCore fundCore )
    {
        return addRequestCreate(service::createFundCore, fundCore);
    }

    @Nonnull
    @Override
    public FundServiceBatchChangeSet updateFundCore( @Nonnull final FundCore fundCore )
    {
        return addRequestUpdate(service::updateFundCore, fundCore);
    }

    @Nonnull
    @Override
    public FundServiceBatchChangeSet deleteFundCore( @Nonnull final FundCore fundCore )
    {
        return addRequestDelete(service::deleteFundCore, fundCore);
    }

    @Nonnull
    @Override
    public FundServiceBatchChangeSet updateFundText( @Nonnull final FundText fundText )
    {
        return addRequestUpdate(service::updateFundText, fundText);
    }

}
