/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.fund.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.FluentHelperBatchChangeSet;
import com.sap.cloud.sdk.datamodel.odata.helper.batch.FluentHelperBatchEndChangeSet;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.fund.FundCore;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.fund.FundText;

/**
 * This interface enables you to combine multiple operations into one change set. For further information have a look
 * into the {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.FundService FundService}.
 *
 */
public interface FundServiceBatchChangeSet
    extends
    FluentHelperBatchChangeSet<FundServiceBatchChangeSet>,
    FluentHelperBatchEndChangeSet<FundServiceBatch>
{

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.fund.FundCore FundCore} entity and save
     * it to the S/4HANA system.
     *
     * @param fundCore
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.fund.FundCore FundCore} entity object that
     *            will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    FundServiceBatchChangeSet createFundCore( @Nonnull final FundCore fundCore );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.fund.FundCore FundCore} entity and
     * save it to the S/4HANA system.
     *
     * @param fundCore
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.fund.FundCore FundCore} entity object that
     *            will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    FundServiceBatchChangeSet updateFundCore( @Nonnull final FundCore fundCore );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.fund.FundCore FundCore} entity in
     * the S/4HANA system.
     *
     * @param fundCore
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.fund.FundCore FundCore} entity object that
     *            will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    FundServiceBatchChangeSet deleteFundCore( @Nonnull final FundCore fundCore );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.fund.FundText FundText} entity and
     * save it to the S/4HANA system.
     *
     * @param fundText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.fund.FundText FundText} entity object that
     *            will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    FundServiceBatchChangeSet updateFundText( @Nonnull final FundText fundText );

}
