/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.fund.link;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.EntityLink;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmObject;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.fund.FundCore;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.fund.selectable.FundCoreSelectable;

/**
 * Template class to represent entity navigation links of
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.fund.FundCore FundCore} to other entities. Instances of
 * this object are used in query modifier methods of the entity fluent helpers. Contains methods to compare a field's
 * value with a provided value.
 *
 * Use the constants declared in each entity inner class. Instantiating directly requires knowing the underlying OData
 * field names, so use the constructor with caution.
 *
 * @param <ObjectT>
 *            Entity type of subclasses from {@link com.sap.cloud.sdk.datamodel.odata.helper.VdmObject VdmObject}.
 *
 */
public class FundCoreLink<ObjectT extends VdmObject<?>> extends EntityLink<FundCoreLink<ObjectT>, FundCore, ObjectT>
    implements
    FundCoreSelectable
{

    /**
     * Use the constants declared in each entity inner class. Instantiating directly requires knowing the underlying
     * OData field names, so use with caution.
     *
     * @param fieldName
     *            OData navigation field name. Must match the field returned by the underlying OData service.
     */
    public FundCoreLink( final String fieldName )
    {
        super(fieldName);
    }

    private FundCoreLink( final EntityLink<FundCoreLink<ObjectT>, FundCore, ObjectT> toClone )
    {
        super(toClone);
    }

    @Nonnull
    @Override
    protected FundCoreLink<ObjectT> translateLinkType( final EntityLink<FundCoreLink<ObjectT>, FundCore, ObjectT> link )
    {
        return new FundCoreLink<ObjectT>(link);
    }

}
