/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.fund.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.fund.FundCore;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.fund.FundCore FundCore}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.fund.field.FundCoreField FundCoreField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.fund.link.FundCoreLink FundCoreLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.fund.FundCore#FINANCIAL_MANAGEMENT_AREA
 * FINANCIAL_MANAGEMENT_AREA}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.fund.FundCore#FUND FUND}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.fund.FundCore#FUND_TYPE FUND_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.fund.FundCore#FUND_PERIODICITY FUND_PERIODICITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.fund.FundCore#FUND_AUTHZN_GRP FUND_AUTHZN_GRP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.fund.FundCore#VALIDITY_START_DATE
 * VALIDITY_START_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.fund.FundCore#VALIDITY_END_DATE
 * VALIDITY_END_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.fund.FundCore#FUND_NAME FUND_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.fund.FundCore#FUND_DESCRIPTION FUND_DESCRIPTION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.fund.FundCore#FUND_FIN_MGMT_AREA_FOR_AUTHZN
 * FUND_FIN_MGMT_AREA_FOR_AUTHZN}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.fund.FundCore#TO_TEXT TO_TEXT}</li>
 * </ul>
 *
 */
public interface FundCoreSelectable extends EntitySelectable<FundCore>
{

}
