/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.fund.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.fund.FundText;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.fund.FundText FundText}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.fund.field.FundTextField FundTextField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.fund.link.FundTextLink FundTextLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.fund.FundText#FINANCIAL_MANAGEMENT_AREA
 * FINANCIAL_MANAGEMENT_AREA}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.fund.FundText#FUND FUND}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.fund.FundText#LANGUAGE LANGUAGE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.fund.FundText#FUND_NAME FUND_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.fund.FundText#FUND_DESCRIPTION FUND_DESCRIPTION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.fund.FundText#TO_FUND TO_FUND}</li>
 * </ul>
 *
 */
public interface FundTextSelectable extends EntitySelectable<FundText>
{

}
