/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.fundhierarchy;

import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.fundhierarchy.field.FundCoreHierNodeField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.fundhierarchy.link.FundCoreHierNodeLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.fundhierarchy.link.FundCoreHierNodeOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.fundhierarchy.selectable.FundCoreHierNodeSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Fund Hierarchy Node
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_FundCoreHierNode_Type</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class FundCoreHierNode extends VdmEntity<FundCoreHierNode>
{

    /**
     * Selector for all available fields of FundCoreHierNode.
     *
     */
    public final static FundCoreHierNodeSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 42
     * <p>
     * Original property name from the Odata EDM: <b>FundHierarchy</b>
     * </p>
     *
     * @return Fund Hierarchy
     */
    @Key
    @SerializedName( "FundHierarchy" )
    @JsonProperty( "FundHierarchy" )
    @Nullable
    @ODataField( odataName = "FundHierarchy" )
    private String fundHierarchy;
    /**
     * Use with available fluent helpers to apply the <b>FundHierarchy</b> field to query operations.
     *
     */
    public final static FundCoreHierNodeField<String> FUND_HIERARCHY =
        new FundCoreHierNodeField<String>("FundHierarchy");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>HierarchyNode</b>
     * </p>
     *
     * @return Hierarchy node
     */
    @Key
    @SerializedName( "HierarchyNode" )
    @JsonProperty( "HierarchyNode" )
    @Nullable
    @ODataField( odataName = "HierarchyNode" )
    private String hierarchyNode;
    /**
     * Use with available fluent helpers to apply the <b>HierarchyNode</b> field to query operations.
     *
     */
    public final static FundCoreHierNodeField<String> HIERARCHY_NODE =
        new FundCoreHierNodeField<String>("HierarchyNode");
    /**
     * (Key Field) Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityEndDate</b>
     * </p>
     *
     * @return Validity End Date
     */
    @Key
    @SerializedName( "ValidityEndDate" )
    @JsonProperty( "ValidityEndDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ValidityEndDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime validityEndDate;
    /**
     * Use with available fluent helpers to apply the <b>ValidityEndDate</b> field to query operations.
     *
     */
    public final static FundCoreHierNodeField<LocalDateTime> VALIDITY_END_DATE =
        new FundCoreHierNodeField<LocalDateTime>("ValidityEndDate");
    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>ParentNode</b>
     * </p>
     *
     * @return Hierarchy parent node
     */
    @SerializedName( "ParentNode" )
    @JsonProperty( "ParentNode" )
    @Nullable
    @ODataField( odataName = "ParentNode" )
    private String parentNode;
    /**
     * Use with available fluent helpers to apply the <b>ParentNode</b> field to query operations.
     *
     */
    public final static FundCoreHierNodeField<String> PARENT_NODE = new FundCoreHierNodeField<String>("ParentNode");
    /**
     * Constraints: Not nullable, Maximum length: 15
     * <p>
     * Original property name from the Odata EDM: <b>HierarchyVersion</b>
     * </p>
     *
     * @return Hierarchy version
     */
    @SerializedName( "HierarchyVersion" )
    @JsonProperty( "HierarchyVersion" )
    @Nullable
    @ODataField( odataName = "HierarchyVersion" )
    private String hierarchyVersion;
    /**
     * Use with available fluent helpers to apply the <b>HierarchyVersion</b> field to query operations.
     *
     */
    public final static FundCoreHierNodeField<String> HIERARCHY_VERSION =
        new FundCoreHierNodeField<String>("HierarchyVersion");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityStartDate</b>
     * </p>
     *
     * @return Validity Start Date
     */
    @SerializedName( "ValidityStartDate" )
    @JsonProperty( "ValidityStartDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ValidityStartDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime validityStartDate;
    /**
     * Use with available fluent helpers to apply the <b>ValidityStartDate</b> field to query operations.
     *
     */
    public final static FundCoreHierNodeField<LocalDateTime> VALIDITY_START_DATE =
        new FundCoreHierNodeField<LocalDateTime>("ValidityStartDate");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>FinancialManagementArea</b>
     * </p>
     *
     * @return Financial Management Area
     */
    @SerializedName( "FinancialManagementArea" )
    @JsonProperty( "FinancialManagementArea" )
    @Nullable
    @ODataField( odataName = "FinancialManagementArea" )
    private String financialManagementArea;
    /**
     * Use with available fluent helpers to apply the <b>FinancialManagementArea</b> field to query operations.
     *
     */
    public final static FundCoreHierNodeField<String> FINANCIAL_MANAGEMENT_AREA =
        new FundCoreHierNodeField<String>("FinancialManagementArea");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Fund</b>
     * </p>
     *
     * @return Fund
     */
    @SerializedName( "Fund" )
    @JsonProperty( "Fund" )
    @Nullable
    @ODataField( odataName = "Fund" )
    private String fund;
    /**
     * Use with available fluent helpers to apply the <b>Fund</b> field to query operations.
     *
     */
    public final static FundCoreHierNodeField<String> FUND = new FundCoreHierNodeField<String>("Fund");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>HierarchyNodeSequence</b>
     * </p>
     *
     * @return Hierarchy Sequence Number
     */
    @SerializedName( "HierarchyNodeSequence" )
    @JsonProperty( "HierarchyNodeSequence" )
    @Nullable
    @ODataField( odataName = "HierarchyNodeSequence" )
    private String hierarchyNodeSequence;
    /**
     * Use with available fluent helpers to apply the <b>HierarchyNodeSequence</b> field to query operations.
     *
     */
    public final static FundCoreHierNodeField<String> HIERARCHY_NODE_SEQUENCE =
        new FundCoreHierNodeField<String>("HierarchyNodeSequence");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>HierarchyNodeLevel</b>
     * </p>
     *
     * @return Hierarchy Level
     */
    @SerializedName( "HierarchyNodeLevel" )
    @JsonProperty( "HierarchyNodeLevel" )
    @Nullable
    @ODataField( odataName = "HierarchyNodeLevel" )
    private String hierarchyNodeLevel;
    /**
     * Use with available fluent helpers to apply the <b>HierarchyNodeLevel</b> field to query operations.
     *
     */
    public final static FundCoreHierNodeField<String> HIERARCHY_NODE_LEVEL =
        new FundCoreHierNodeField<String>("HierarchyNodeLevel");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>NodeType</b>
     * </p>
     *
     * @return Hierarchy node type
     */
    @SerializedName( "NodeType" )
    @JsonProperty( "NodeType" )
    @Nullable
    @ODataField( odataName = "NodeType" )
    private String nodeType;
    /**
     * Use with available fluent helpers to apply the <b>NodeType</b> field to query operations.
     *
     */
    public final static FundCoreHierNodeField<String> NODE_TYPE = new FundCoreHierNodeField<String>("NodeType");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>HierarchyNodeVal</b>
     * </p>
     *
     * @return Node value
     */
    @SerializedName( "HierarchyNodeVal" )
    @JsonProperty( "HierarchyNodeVal" )
    @Nullable
    @ODataField( odataName = "HierarchyNodeVal" )
    private String hierarchyNodeVal;
    /**
     * Use with available fluent helpers to apply the <b>HierarchyNodeVal</b> field to query operations.
     *
     */
    public final static FundCoreHierNodeField<String> HIERARCHY_NODE_VAL =
        new FundCoreHierNodeField<String>("HierarchyNodeVal");
    /**
     * Navigation property <b>to_FundCoreHierarchy</b> for <b>FundCoreHierNode</b> to single <b>FundCoreHierarchy</b>.
     *
     */
    @SerializedName( "to_FundCoreHierarchy" )
    @JsonProperty( "to_FundCoreHierarchy" )
    @ODataField( odataName = "to_FundCoreHierarchy" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private FundCoreHierarchy toFundCoreHierarchy;
    /**
     * Navigation property <b>to_FundCoreHierarchyNodeText</b> for <b>FundCoreHierNode</b> to multiple
     * <b>FundCoreHierarchyNodeText</b>.
     *
     */
    @SerializedName( "to_FundCoreHierarchyNodeText" )
    @JsonProperty( "to_FundCoreHierarchyNodeText" )
    @ODataField( odataName = "to_FundCoreHierarchyNodeText" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<FundCoreHierarchyNodeText> toFundCoreHierarchyNodeText;
    /**
     * Use with available fluent helpers to apply the <b>to_FundCoreHierarchy</b> navigation property to query
     * operations.
     *
     */
    public final static FundCoreHierNodeOneToOneLink<FundCoreHierarchy> TO_FUND_CORE_HIERARCHY =
        new FundCoreHierNodeOneToOneLink<FundCoreHierarchy>("to_FundCoreHierarchy");
    /**
     * Use with available fluent helpers to apply the <b>to_FundCoreHierarchyNodeText</b> navigation property to query
     * operations.
     *
     */
    public final static FundCoreHierNodeLink<FundCoreHierarchyNodeText> TO_FUND_CORE_HIERARCHY_NODE_TEXT =
        new FundCoreHierNodeLink<FundCoreHierarchyNodeText>("to_FundCoreHierarchyNodeText");

    @Nonnull
    @Override
    public Class<FundCoreHierNode> getType()
    {
        return FundCoreHierNode.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 42
     * <p>
     * Original property name from the Odata EDM: <b>FundHierarchy</b>
     * </p>
     *
     * @param fundHierarchy
     *            Fund Hierarchy
     */
    public void setFundHierarchy( @Nullable final String fundHierarchy )
    {
        rememberChangedField("FundHierarchy", this.fundHierarchy);
        this.fundHierarchy = fundHierarchy;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>HierarchyNode</b>
     * </p>
     *
     * @param hierarchyNode
     *            Hierarchy node
     */
    public void setHierarchyNode( @Nullable final String hierarchyNode )
    {
        rememberChangedField("HierarchyNode", this.hierarchyNode);
        this.hierarchyNode = hierarchyNode;
    }

    /**
     * (Key Field) Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityEndDate</b>
     * </p>
     *
     * @param validityEndDate
     *            Validity End Date
     */
    public void setValidityEndDate( @Nullable final LocalDateTime validityEndDate )
    {
        rememberChangedField("ValidityEndDate", this.validityEndDate);
        this.validityEndDate = validityEndDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>ParentNode</b>
     * </p>
     *
     * @param parentNode
     *            Hierarchy parent node
     */
    public void setParentNode( @Nullable final String parentNode )
    {
        rememberChangedField("ParentNode", this.parentNode);
        this.parentNode = parentNode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 15
     * <p>
     * Original property name from the Odata EDM: <b>HierarchyVersion</b>
     * </p>
     *
     * @param hierarchyVersion
     *            Hierarchy version
     */
    public void setHierarchyVersion( @Nullable final String hierarchyVersion )
    {
        rememberChangedField("HierarchyVersion", this.hierarchyVersion);
        this.hierarchyVersion = hierarchyVersion;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityStartDate</b>
     * </p>
     *
     * @param validityStartDate
     *            Validity Start Date
     */
    public void setValidityStartDate( @Nullable final LocalDateTime validityStartDate )
    {
        rememberChangedField("ValidityStartDate", this.validityStartDate);
        this.validityStartDate = validityStartDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>FinancialManagementArea</b>
     * </p>
     *
     * @param financialManagementArea
     *            Financial Management Area
     */
    public void setFinancialManagementArea( @Nullable final String financialManagementArea )
    {
        rememberChangedField("FinancialManagementArea", this.financialManagementArea);
        this.financialManagementArea = financialManagementArea;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Fund</b>
     * </p>
     *
     * @param fund
     *            Fund
     */
    public void setFund( @Nullable final String fund )
    {
        rememberChangedField("Fund", this.fund);
        this.fund = fund;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>HierarchyNodeSequence</b>
     * </p>
     *
     * @param hierarchyNodeSequence
     *            Hierarchy Sequence Number
     */
    public void setHierarchyNodeSequence( @Nullable final String hierarchyNodeSequence )
    {
        rememberChangedField("HierarchyNodeSequence", this.hierarchyNodeSequence);
        this.hierarchyNodeSequence = hierarchyNodeSequence;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>HierarchyNodeLevel</b>
     * </p>
     *
     * @param hierarchyNodeLevel
     *            Hierarchy Level
     */
    public void setHierarchyNodeLevel( @Nullable final String hierarchyNodeLevel )
    {
        rememberChangedField("HierarchyNodeLevel", this.hierarchyNodeLevel);
        this.hierarchyNodeLevel = hierarchyNodeLevel;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>NodeType</b>
     * </p>
     *
     * @param nodeType
     *            Hierarchy node type
     */
    public void setNodeType( @Nullable final String nodeType )
    {
        rememberChangedField("NodeType", this.nodeType);
        this.nodeType = nodeType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>HierarchyNodeVal</b>
     * </p>
     *
     * @param hierarchyNodeVal
     *            Node value
     */
    public void setHierarchyNodeVal( @Nullable final String hierarchyNodeVal )
    {
        rememberChangedField("HierarchyNodeVal", this.hierarchyNodeVal);
        this.hierarchyNodeVal = hierarchyNodeVal;
    }

    @Override
    protected String getEntityCollection()
    {
        return "FundHierarchyNode";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("FundHierarchy", getFundHierarchy());
        result.put("HierarchyNode", getHierarchyNode());
        result.put("ValidityEndDate", getValidityEndDate());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("FundHierarchy", getFundHierarchy());
        values.put("HierarchyNode", getHierarchyNode());
        values.put("ValidityEndDate", getValidityEndDate());
        values.put("ParentNode", getParentNode());
        values.put("HierarchyVersion", getHierarchyVersion());
        values.put("ValidityStartDate", getValidityStartDate());
        values.put("FinancialManagementArea", getFinancialManagementArea());
        values.put("Fund", getFund());
        values.put("HierarchyNodeSequence", getHierarchyNodeSequence());
        values.put("HierarchyNodeLevel", getHierarchyNodeLevel());
        values.put("NodeType", getNodeType());
        values.put("HierarchyNodeVal", getHierarchyNodeVal());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("FundHierarchy") ) {
                final Object value = values.remove("FundHierarchy");
                if( (value == null) || (!value.equals(getFundHierarchy())) ) {
                    setFundHierarchy(((String) value));
                }
            }
            if( values.containsKey("HierarchyNode") ) {
                final Object value = values.remove("HierarchyNode");
                if( (value == null) || (!value.equals(getHierarchyNode())) ) {
                    setHierarchyNode(((String) value));
                }
            }
            if( values.containsKey("ValidityEndDate") ) {
                final Object value = values.remove("ValidityEndDate");
                if( (value == null) || (!value.equals(getValidityEndDate())) ) {
                    setValidityEndDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ParentNode") ) {
                final Object value = values.remove("ParentNode");
                if( (value == null) || (!value.equals(getParentNode())) ) {
                    setParentNode(((String) value));
                }
            }
            if( values.containsKey("HierarchyVersion") ) {
                final Object value = values.remove("HierarchyVersion");
                if( (value == null) || (!value.equals(getHierarchyVersion())) ) {
                    setHierarchyVersion(((String) value));
                }
            }
            if( values.containsKey("ValidityStartDate") ) {
                final Object value = values.remove("ValidityStartDate");
                if( (value == null) || (!value.equals(getValidityStartDate())) ) {
                    setValidityStartDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("FinancialManagementArea") ) {
                final Object value = values.remove("FinancialManagementArea");
                if( (value == null) || (!value.equals(getFinancialManagementArea())) ) {
                    setFinancialManagementArea(((String) value));
                }
            }
            if( values.containsKey("Fund") ) {
                final Object value = values.remove("Fund");
                if( (value == null) || (!value.equals(getFund())) ) {
                    setFund(((String) value));
                }
            }
            if( values.containsKey("HierarchyNodeSequence") ) {
                final Object value = values.remove("HierarchyNodeSequence");
                if( (value == null) || (!value.equals(getHierarchyNodeSequence())) ) {
                    setHierarchyNodeSequence(((String) value));
                }
            }
            if( values.containsKey("HierarchyNodeLevel") ) {
                final Object value = values.remove("HierarchyNodeLevel");
                if( (value == null) || (!value.equals(getHierarchyNodeLevel())) ) {
                    setHierarchyNodeLevel(((String) value));
                }
            }
            if( values.containsKey("NodeType") ) {
                final Object value = values.remove("NodeType");
                if( (value == null) || (!value.equals(getNodeType())) ) {
                    setNodeType(((String) value));
                }
            }
            if( values.containsKey("HierarchyNodeVal") ) {
                final Object value = values.remove("HierarchyNodeVal");
                if( (value == null) || (!value.equals(getHierarchyNodeVal())) ) {
                    setHierarchyNodeVal(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_FundCoreHierarchy") ) {
                final Object value = (values).remove("to_FundCoreHierarchy");
                if( value instanceof Map ) {
                    if( toFundCoreHierarchy == null ) {
                        toFundCoreHierarchy = new FundCoreHierarchy();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toFundCoreHierarchy.fromMap(inputMap);
                }
            }
            if( (values).containsKey("to_FundCoreHierarchyNodeText") ) {
                final Object value = (values).remove("to_FundCoreHierarchyNodeText");
                if( value instanceof Iterable ) {
                    if( toFundCoreHierarchyNodeText == null ) {
                        toFundCoreHierarchyNodeText = Lists.newArrayList();
                    } else {
                        toFundCoreHierarchyNodeText = Lists.newArrayList(toFundCoreHierarchyNodeText);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        FundCoreHierarchyNodeText entity;
                        if( toFundCoreHierarchyNodeText.size() > i ) {
                            entity = toFundCoreHierarchyNodeText.get(i);
                        } else {
                            entity = new FundCoreHierarchyNodeText();
                            toFundCoreHierarchyNodeText.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> FundCoreHierNodeField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new FundCoreHierNodeField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> FundCoreHierNodeField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new FundCoreHierNodeField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.FundHierarchyService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toFundCoreHierarchy != null ) {
            (values).put("to_FundCoreHierarchy", toFundCoreHierarchy);
        }
        if( toFundCoreHierarchyNodeText != null ) {
            (values).put("to_FundCoreHierarchyNodeText", toFundCoreHierarchyNodeText);
        }
        return values;
    }

    /**
     * Fetches the <b>FundCoreHierarchy</b> entity (one to one) associated with this entity. This corresponds to the
     * OData navigation property <b>to_FundCoreHierarchy</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>FundCoreHierarchy</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public FundCoreHierarchy fetchFundCoreHierarchy()
    {
        return fetchFieldAsSingle("to_FundCoreHierarchy", FundCoreHierarchy.class);
    }

    /**
     * Retrieval of associated <b>FundCoreHierarchy</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_FundCoreHierarchy</b>.
     * <p>
     * If the navigation property <b>to_FundCoreHierarchy</b> of a queried <b>FundCoreHierNode</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>FundCoreHierarchy</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public FundCoreHierarchy getFundCoreHierarchyOrFetch()
    {
        if( toFundCoreHierarchy == null ) {
            toFundCoreHierarchy = fetchFundCoreHierarchy();
        }
        return toFundCoreHierarchy;
    }

    /**
     * Retrieval of associated <b>FundCoreHierarchy</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_FundCoreHierarchy</b>.
     * <p>
     * If the navigation property for an entity <b>FundCoreHierNode</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_FundCoreHierarchy</b> is already loaded, the result will
     *         contain the <b>FundCoreHierarchy</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<FundCoreHierarchy> getFundCoreHierarchyIfPresent()
    {
        return Option.of(toFundCoreHierarchy);
    }

    /**
     * Overwrites the associated <b>FundCoreHierarchy</b> entity for the loaded navigation property
     * <b>to_FundCoreHierarchy</b>.
     *
     * @param value
     *            New <b>FundCoreHierarchy</b> entity.
     */
    public void setFundCoreHierarchy( final FundCoreHierarchy value )
    {
        toFundCoreHierarchy = value;
    }

    /**
     * Fetches the <b>FundCoreHierarchyNodeText</b> entities (one to many) associated with this entity. This corresponds
     * to the OData navigation property <b>to_FundCoreHierarchyNodeText</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>FundCoreHierarchyNodeText</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<FundCoreHierarchyNodeText> fetchFundCoreHierarchyNodeText()
    {
        return fetchFieldAsList("to_FundCoreHierarchyNodeText", FundCoreHierarchyNodeText.class);
    }

    /**
     * Retrieval of associated <b>FundCoreHierarchyNodeText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_FundCoreHierarchyNodeText</b>.
     * <p>
     * If the navigation property <b>to_FundCoreHierarchyNodeText</b> of a queried <b>FundCoreHierNode</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>FundCoreHierarchyNodeText</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<FundCoreHierarchyNodeText> getFundCoreHierarchyNodeTextOrFetch()
    {
        if( toFundCoreHierarchyNodeText == null ) {
            toFundCoreHierarchyNodeText = fetchFundCoreHierarchyNodeText();
        }
        return toFundCoreHierarchyNodeText;
    }

    /**
     * Retrieval of associated <b>FundCoreHierarchyNodeText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_FundCoreHierarchyNodeText</b>.
     * <p>
     * If the navigation property for an entity <b>FundCoreHierNode</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_FundCoreHierarchyNodeText</b> is already loaded, the
     *         result will contain the <b>FundCoreHierarchyNodeText</b> entities. If not, an <code>Option</code> with
     *         result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<FundCoreHierarchyNodeText>> getFundCoreHierarchyNodeTextIfPresent()
    {
        return Option.of(toFundCoreHierarchyNodeText);
    }

    /**
     * Overwrites the list of associated <b>FundCoreHierarchyNodeText</b> entities for the loaded navigation property
     * <b>to_FundCoreHierarchyNodeText</b>.
     * <p>
     * If the navigation property <b>to_FundCoreHierarchyNodeText</b> of a queried <b>FundCoreHierNode</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>FundCoreHierarchyNodeText</b> entities.
     */
    public void setFundCoreHierarchyNodeText( @Nonnull final List<FundCoreHierarchyNodeText> value )
    {
        if( toFundCoreHierarchyNodeText == null ) {
            toFundCoreHierarchyNodeText = Lists.newArrayList();
        }
        toFundCoreHierarchyNodeText.clear();
        toFundCoreHierarchyNodeText.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>FundCoreHierarchyNodeText</b> entities. This corresponds to the OData
     * navigation property <b>to_FundCoreHierarchyNodeText</b>.
     * <p>
     * If the navigation property <b>to_FundCoreHierarchyNodeText</b> of a queried <b>FundCoreHierNode</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>FundCoreHierarchyNodeText</b> entities.
     */
    public void addFundCoreHierarchyNodeText( FundCoreHierarchyNodeText... entity )
    {
        if( toFundCoreHierarchyNodeText == null ) {
            toFundCoreHierarchyNodeText = Lists.newArrayList();
        }
        toFundCoreHierarchyNodeText.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of FundCoreHierNode instances.
     *
     */
    public final static class FundCoreHierNodeBuilder
    {

        private FundCoreHierarchy toFundCoreHierarchy;
        private List<FundCoreHierarchyNodeText> toFundCoreHierarchyNodeText = Lists.newArrayList();

        private FundCoreHierNode.FundCoreHierNodeBuilder toFundCoreHierarchy( final FundCoreHierarchy value )
        {
            toFundCoreHierarchy = value;
            return this;
        }

        /**
         * Navigation property <b>to_FundCoreHierarchy</b> for <b>FundCoreHierNode</b> to single
         * <b>FundCoreHierarchy</b>.
         *
         * @param value
         *            The FundCoreHierarchy to build this FundCoreHierNode with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public FundCoreHierNode.FundCoreHierNodeBuilder fundCoreHierarchy( final FundCoreHierarchy value )
        {
            return toFundCoreHierarchy(value);
        }

        private FundCoreHierNode.FundCoreHierNodeBuilder toFundCoreHierarchyNodeText(
            final List<FundCoreHierarchyNodeText> value )
        {
            toFundCoreHierarchyNodeText.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_FundCoreHierarchyNodeText</b> for <b>FundCoreHierNode</b> to multiple
         * <b>FundCoreHierarchyNodeText</b>.
         *
         * @param value
         *            The FundCoreHierarchyNodeTexts to build this FundCoreHierNode with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public FundCoreHierNode.FundCoreHierNodeBuilder fundCoreHierarchyNodeText( FundCoreHierarchyNodeText... value )
        {
            return toFundCoreHierarchyNodeText(Lists.newArrayList(value));
        }

    }

}
