/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.fundhierarchy;

import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.fundhierarchy.field.FundCoreHierarchyField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.fundhierarchy.link.FundCoreHierarchyLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.fundhierarchy.selectable.FundCoreHierarchySelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Fund Hierarchy
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>FundCoreHierarchy_Type</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class FundCoreHierarchy extends VdmEntity<FundCoreHierarchy>
{

    /**
     * Selector for all available fields of FundCoreHierarchy.
     *
     */
    public final static FundCoreHierarchySelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 42
     * <p>
     * Original property name from the Odata EDM: <b>FundHierarchy</b>
     * </p>
     *
     * @return Fund Hierarchy
     */
    @Key
    @SerializedName( "FundHierarchy" )
    @JsonProperty( "FundHierarchy" )
    @Nullable
    @ODataField( odataName = "FundHierarchy" )
    private String fundHierarchy;
    /**
     * Use with available fluent helpers to apply the <b>FundHierarchy</b> field to query operations.
     *
     */
    public final static FundCoreHierarchyField<String> FUND_HIERARCHY =
        new FundCoreHierarchyField<String>("FundHierarchy");
    /**
     * (Key Field) Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityEndDate</b>
     * </p>
     *
     * @return Validity End Date
     */
    @Key
    @SerializedName( "ValidityEndDate" )
    @JsonProperty( "ValidityEndDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ValidityEndDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime validityEndDate;
    /**
     * Use with available fluent helpers to apply the <b>ValidityEndDate</b> field to query operations.
     *
     */
    public final static FundCoreHierarchyField<LocalDateTime> VALIDITY_END_DATE =
        new FundCoreHierarchyField<LocalDateTime>("ValidityEndDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityStartDate</b>
     * </p>
     *
     * @return Validity Start Date
     */
    @SerializedName( "ValidityStartDate" )
    @JsonProperty( "ValidityStartDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ValidityStartDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime validityStartDate;
    /**
     * Use with available fluent helpers to apply the <b>ValidityStartDate</b> field to query operations.
     *
     */
    public final static FundCoreHierarchyField<LocalDateTime> VALIDITY_START_DATE =
        new FundCoreHierarchyField<LocalDateTime>("ValidityStartDate");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>FinancialManagementArea</b>
     * </p>
     *
     * @return Financial Management Area
     */
    @SerializedName( "FinancialManagementArea" )
    @JsonProperty( "FinancialManagementArea" )
    @Nullable
    @ODataField( odataName = "FinancialManagementArea" )
    private String financialManagementArea;
    /**
     * Use with available fluent helpers to apply the <b>FinancialManagementArea</b> field to query operations.
     *
     */
    public final static FundCoreHierarchyField<String> FINANCIAL_MANAGEMENT_AREA =
        new FundCoreHierarchyField<String>("FinancialManagementArea");
    /**
     * Navigation property <b>to_FundCoreHierarchyText</b> for <b>FundCoreHierarchy</b> to multiple
     * <b>FundCoreHierarchyText</b>.
     *
     */
    @SerializedName( "to_FundCoreHierarchyText" )
    @JsonProperty( "to_FundCoreHierarchyText" )
    @ODataField( odataName = "to_FundCoreHierarchyText" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<FundCoreHierarchyText> toFundCoreHierarchyText;
    /**
     * Navigation property <b>to_FundCoreHierNode</b> for <b>FundCoreHierarchy</b> to multiple <b>FundCoreHierNode</b>.
     *
     */
    @SerializedName( "to_FundCoreHierNode" )
    @JsonProperty( "to_FundCoreHierNode" )
    @ODataField( odataName = "to_FundCoreHierNode" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<FundCoreHierNode> toFundCoreHierNode;
    /**
     * Use with available fluent helpers to apply the <b>to_FundCoreHierarchyText</b> navigation property to query
     * operations.
     *
     */
    public final static FundCoreHierarchyLink<FundCoreHierarchyText> TO_FUND_CORE_HIERARCHY_TEXT =
        new FundCoreHierarchyLink<FundCoreHierarchyText>("to_FundCoreHierarchyText");
    /**
     * Use with available fluent helpers to apply the <b>to_FundCoreHierNode</b> navigation property to query
     * operations.
     *
     */
    public final static FundCoreHierarchyLink<FundCoreHierNode> TO_FUND_CORE_HIER_NODE =
        new FundCoreHierarchyLink<FundCoreHierNode>("to_FundCoreHierNode");

    @Nonnull
    @Override
    public Class<FundCoreHierarchy> getType()
    {
        return FundCoreHierarchy.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 42
     * <p>
     * Original property name from the Odata EDM: <b>FundHierarchy</b>
     * </p>
     *
     * @param fundHierarchy
     *            Fund Hierarchy
     */
    public void setFundHierarchy( @Nullable final String fundHierarchy )
    {
        rememberChangedField("FundHierarchy", this.fundHierarchy);
        this.fundHierarchy = fundHierarchy;
    }

    /**
     * (Key Field) Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityEndDate</b>
     * </p>
     *
     * @param validityEndDate
     *            Validity End Date
     */
    public void setValidityEndDate( @Nullable final LocalDateTime validityEndDate )
    {
        rememberChangedField("ValidityEndDate", this.validityEndDate);
        this.validityEndDate = validityEndDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityStartDate</b>
     * </p>
     *
     * @param validityStartDate
     *            Validity Start Date
     */
    public void setValidityStartDate( @Nullable final LocalDateTime validityStartDate )
    {
        rememberChangedField("ValidityStartDate", this.validityStartDate);
        this.validityStartDate = validityStartDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>FinancialManagementArea</b>
     * </p>
     *
     * @param financialManagementArea
     *            Financial Management Area
     */
    public void setFinancialManagementArea( @Nullable final String financialManagementArea )
    {
        rememberChangedField("FinancialManagementArea", this.financialManagementArea);
        this.financialManagementArea = financialManagementArea;
    }

    @Override
    protected String getEntityCollection()
    {
        return "FundHierarchy";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("FundHierarchy", getFundHierarchy());
        result.put("ValidityEndDate", getValidityEndDate());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("FundHierarchy", getFundHierarchy());
        values.put("ValidityEndDate", getValidityEndDate());
        values.put("ValidityStartDate", getValidityStartDate());
        values.put("FinancialManagementArea", getFinancialManagementArea());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("FundHierarchy") ) {
                final Object value = values.remove("FundHierarchy");
                if( (value == null) || (!value.equals(getFundHierarchy())) ) {
                    setFundHierarchy(((String) value));
                }
            }
            if( values.containsKey("ValidityEndDate") ) {
                final Object value = values.remove("ValidityEndDate");
                if( (value == null) || (!value.equals(getValidityEndDate())) ) {
                    setValidityEndDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ValidityStartDate") ) {
                final Object value = values.remove("ValidityStartDate");
                if( (value == null) || (!value.equals(getValidityStartDate())) ) {
                    setValidityStartDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("FinancialManagementArea") ) {
                final Object value = values.remove("FinancialManagementArea");
                if( (value == null) || (!value.equals(getFinancialManagementArea())) ) {
                    setFinancialManagementArea(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_FundCoreHierarchyText") ) {
                final Object value = (values).remove("to_FundCoreHierarchyText");
                if( value instanceof Iterable ) {
                    if( toFundCoreHierarchyText == null ) {
                        toFundCoreHierarchyText = Lists.newArrayList();
                    } else {
                        toFundCoreHierarchyText = Lists.newArrayList(toFundCoreHierarchyText);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        FundCoreHierarchyText entity;
                        if( toFundCoreHierarchyText.size() > i ) {
                            entity = toFundCoreHierarchyText.get(i);
                        } else {
                            entity = new FundCoreHierarchyText();
                            toFundCoreHierarchyText.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_FundCoreHierNode") ) {
                final Object value = (values).remove("to_FundCoreHierNode");
                if( value instanceof Iterable ) {
                    if( toFundCoreHierNode == null ) {
                        toFundCoreHierNode = Lists.newArrayList();
                    } else {
                        toFundCoreHierNode = Lists.newArrayList(toFundCoreHierNode);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        FundCoreHierNode entity;
                        if( toFundCoreHierNode.size() > i ) {
                            entity = toFundCoreHierNode.get(i);
                        } else {
                            entity = new FundCoreHierNode();
                            toFundCoreHierNode.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> FundCoreHierarchyField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new FundCoreHierarchyField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> FundCoreHierarchyField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new FundCoreHierarchyField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.FundHierarchyService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toFundCoreHierarchyText != null ) {
            (values).put("to_FundCoreHierarchyText", toFundCoreHierarchyText);
        }
        if( toFundCoreHierNode != null ) {
            (values).put("to_FundCoreHierNode", toFundCoreHierNode);
        }
        return values;
    }

    /**
     * Fetches the <b>FundCoreHierarchyText</b> entities (one to many) associated with this entity. This corresponds to
     * the OData navigation property <b>to_FundCoreHierarchyText</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>FundCoreHierarchyText</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<FundCoreHierarchyText> fetchFundCoreHierarchyText()
    {
        return fetchFieldAsList("to_FundCoreHierarchyText", FundCoreHierarchyText.class);
    }

    /**
     * Retrieval of associated <b>FundCoreHierarchyText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_FundCoreHierarchyText</b>.
     * <p>
     * If the navigation property <b>to_FundCoreHierarchyText</b> of a queried <b>FundCoreHierarchy</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>FundCoreHierarchyText</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<FundCoreHierarchyText> getFundCoreHierarchyTextOrFetch()
    {
        if( toFundCoreHierarchyText == null ) {
            toFundCoreHierarchyText = fetchFundCoreHierarchyText();
        }
        return toFundCoreHierarchyText;
    }

    /**
     * Retrieval of associated <b>FundCoreHierarchyText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_FundCoreHierarchyText</b>.
     * <p>
     * If the navigation property for an entity <b>FundCoreHierarchy</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_FundCoreHierarchyText</b> is already loaded, the result
     *         will contain the <b>FundCoreHierarchyText</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<FundCoreHierarchyText>> getFundCoreHierarchyTextIfPresent()
    {
        return Option.of(toFundCoreHierarchyText);
    }

    /**
     * Overwrites the list of associated <b>FundCoreHierarchyText</b> entities for the loaded navigation property
     * <b>to_FundCoreHierarchyText</b>.
     * <p>
     * If the navigation property <b>to_FundCoreHierarchyText</b> of a queried <b>FundCoreHierarchy</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>FundCoreHierarchyText</b> entities.
     */
    public void setFundCoreHierarchyText( @Nonnull final List<FundCoreHierarchyText> value )
    {
        if( toFundCoreHierarchyText == null ) {
            toFundCoreHierarchyText = Lists.newArrayList();
        }
        toFundCoreHierarchyText.clear();
        toFundCoreHierarchyText.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>FundCoreHierarchyText</b> entities. This corresponds to the OData
     * navigation property <b>to_FundCoreHierarchyText</b>.
     * <p>
     * If the navigation property <b>to_FundCoreHierarchyText</b> of a queried <b>FundCoreHierarchy</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>FundCoreHierarchyText</b> entities.
     */
    public void addFundCoreHierarchyText( FundCoreHierarchyText... entity )
    {
        if( toFundCoreHierarchyText == null ) {
            toFundCoreHierarchyText = Lists.newArrayList();
        }
        toFundCoreHierarchyText.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>FundCoreHierNode</b> entities (one to many) associated with this entity. This corresponds to the
     * OData navigation property <b>to_FundCoreHierNode</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>FundCoreHierNode</b> entities. If no entities are associated
     *         then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<FundCoreHierNode> fetchFundCoreHierNode()
    {
        return fetchFieldAsList("to_FundCoreHierNode", FundCoreHierNode.class);
    }

    /**
     * Retrieval of associated <b>FundCoreHierNode</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_FundCoreHierNode</b>.
     * <p>
     * If the navigation property <b>to_FundCoreHierNode</b> of a queried <b>FundCoreHierarchy</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>FundCoreHierNode</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<FundCoreHierNode> getFundCoreHierNodeOrFetch()
    {
        if( toFundCoreHierNode == null ) {
            toFundCoreHierNode = fetchFundCoreHierNode();
        }
        return toFundCoreHierNode;
    }

    /**
     * Retrieval of associated <b>FundCoreHierNode</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_FundCoreHierNode</b>.
     * <p>
     * If the navigation property for an entity <b>FundCoreHierarchy</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_FundCoreHierNode</b> is already loaded, the result will
     *         contain the <b>FundCoreHierNode</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<FundCoreHierNode>> getFundCoreHierNodeIfPresent()
    {
        return Option.of(toFundCoreHierNode);
    }

    /**
     * Overwrites the list of associated <b>FundCoreHierNode</b> entities for the loaded navigation property
     * <b>to_FundCoreHierNode</b>.
     * <p>
     * If the navigation property <b>to_FundCoreHierNode</b> of a queried <b>FundCoreHierarchy</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>FundCoreHierNode</b> entities.
     */
    public void setFundCoreHierNode( @Nonnull final List<FundCoreHierNode> value )
    {
        if( toFundCoreHierNode == null ) {
            toFundCoreHierNode = Lists.newArrayList();
        }
        toFundCoreHierNode.clear();
        toFundCoreHierNode.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>FundCoreHierNode</b> entities. This corresponds to the OData
     * navigation property <b>to_FundCoreHierNode</b>.
     * <p>
     * If the navigation property <b>to_FundCoreHierNode</b> of a queried <b>FundCoreHierarchy</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>FundCoreHierNode</b> entities.
     */
    public void addFundCoreHierNode( FundCoreHierNode... entity )
    {
        if( toFundCoreHierNode == null ) {
            toFundCoreHierNode = Lists.newArrayList();
        }
        toFundCoreHierNode.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of FundCoreHierarchy instances.
     *
     */
    public final static class FundCoreHierarchyBuilder
    {

        private List<FundCoreHierarchyText> toFundCoreHierarchyText = Lists.newArrayList();
        private List<FundCoreHierNode> toFundCoreHierNode = Lists.newArrayList();

        private FundCoreHierarchy.FundCoreHierarchyBuilder toFundCoreHierarchyText(
            final List<FundCoreHierarchyText> value )
        {
            toFundCoreHierarchyText.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_FundCoreHierarchyText</b> for <b>FundCoreHierarchy</b> to multiple
         * <b>FundCoreHierarchyText</b>.
         *
         * @param value
         *            The FundCoreHierarchyTexts to build this FundCoreHierarchy with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public FundCoreHierarchy.FundCoreHierarchyBuilder fundCoreHierarchyText( FundCoreHierarchyText... value )
        {
            return toFundCoreHierarchyText(Lists.newArrayList(value));
        }

        private FundCoreHierarchy.FundCoreHierarchyBuilder toFundCoreHierNode( final List<FundCoreHierNode> value )
        {
            toFundCoreHierNode.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_FundCoreHierNode</b> for <b>FundCoreHierarchy</b> to multiple
         * <b>FundCoreHierNode</b>.
         *
         * @param value
         *            The FundCoreHierNodes to build this FundCoreHierarchy with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public FundCoreHierarchy.FundCoreHierarchyBuilder fundCoreHierNode( FundCoreHierNode... value )
        {
            return toFundCoreHierNode(Lists.newArrayList(value));
        }

    }

}
