/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.fundhierarchy;

import java.time.LocalDateTime;
import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.fundhierarchy.selectable.FundCoreHierarchySelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.fundhierarchy.FundCoreHierarchy FundCoreHierarchy} entity
 * using key fields. This fluent helper allows methods which modify the underlying query to be called before executing
 * the query itself.
 *
 */
public class FundCoreHierarchyByKeyFluentHelper
    extends
    FluentHelperByKey<FundCoreHierarchyByKeyFluentHelper, FundCoreHierarchy, FundCoreHierarchySelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.fundhierarchy.FundCoreHierarchy FundCoreHierarchy}
     * entity with the provided key field values. To perform execution, call the {@link #executeRequest executeRequest}
     * method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code FundCoreHierarchy}
     * @param servicePath
     *            Service path to be used to fetch a single {@code FundCoreHierarchy}
     * @param validityEndDate
     *            Validity End Date
     *            <p>
     *            Constraints: Not nullable, Precision: 0
     *            </p>
     * @param fundHierarchy
     *            Fund Hierarchy
     *            <p>
     *            Constraints: Not nullable, Maximum length: 42
     *            </p>
     */
    public FundCoreHierarchyByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String fundHierarchy,
        final LocalDateTime validityEndDate )
    {
        super(servicePath, entityCollection);
        this.key.put("FundHierarchy", fundHierarchy);
        this.key.put("ValidityEndDate", validityEndDate);
    }

    @Override
    @Nonnull
    protected Class<FundCoreHierarchy> getEntityClass()
    {
        return FundCoreHierarchy.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
