/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.fundhierarchy.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchFluentHelperBasic;

/**
 * Default implementation of the {@link FundHierarchyServiceBatch} interface exposed in the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.FundHierarchyService FundHierarchyService}, allowing you to
 * create multiple changesets and finally execute the batch request.
 *
 */
public class DefaultFundHierarchyServiceBatch
    extends
    BatchFluentHelperBasic<FundHierarchyServiceBatch, FundHierarchyServiceBatchChangeSet>
    implements
    FundHierarchyServiceBatch
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.FundHierarchyService service;
    @Nonnull
    private final String servicePath;

    /**
     * Creates a new instance of this DefaultFundHierarchyServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultFundHierarchyServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.FundHierarchyService service )
    {
        this(service, com.sap.cloud.sdk.s4hana.datamodel.odata.services.FundHierarchyService.DEFAULT_SERVICE_PATH);
    }

    /**
     * Creates a new instance of this DefaultFundHierarchyServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     * @param servicePath
     *            The custom service path to operate on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultFundHierarchyServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.FundHierarchyService service,
        @Nonnull final String servicePath )
    {
        this.service = service;
        this.servicePath = servicePath;
    }

    @Nonnull
    @Override
    protected String getServicePathForBatchRequest()
    {
        return servicePath;
    }

    @Nonnull
    @Override
    protected DefaultFundHierarchyServiceBatch getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public FundHierarchyServiceBatchChangeSet beginChangeSet()
    {
        return new DefaultFundHierarchyServiceBatchChangeSet(this, service);
    }

}
