/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.fundhierarchy.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchChangeSetFluentHelperBasic;

/**
 * Implementation of the {@link FundHierarchyServiceBatchChangeSet} interface, enabling you to combine multiple
 * operations into one changeset. For further information have a look into the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.FundHierarchyService FundHierarchyService}.
 *
 */
public class DefaultFundHierarchyServiceBatchChangeSet
    extends
    BatchChangeSetFluentHelperBasic<FundHierarchyServiceBatch, FundHierarchyServiceBatchChangeSet>
    implements
    FundHierarchyServiceBatchChangeSet
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.FundHierarchyService service;

    @SuppressWarnings( "deprecation" )
    DefaultFundHierarchyServiceBatchChangeSet(
        @Nonnull final DefaultFundHierarchyServiceBatch batchFluentHelper,
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.FundHierarchyService service )
    {
        super(batchFluentHelper, batchFluentHelper);
        this.service = service;
    }

    @Nonnull
    @Override
    protected DefaultFundHierarchyServiceBatchChangeSet getThis()
    {
        return this;
    }

}
