/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.fundhierarchy.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.fundhierarchy.FundCoreHierNode;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.fundhierarchy.FundCoreHierNode FundCoreHierNode}. This
 * interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.fundhierarchy.field.FundCoreHierNodeField
 * FundCoreHierNodeField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.fundhierarchy.link.FundCoreHierNodeLink
 * FundCoreHierNodeLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.fundhierarchy.FundCoreHierNode#FUND_HIERARCHY
 * FUND_HIERARCHY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.fundhierarchy.FundCoreHierNode#HIERARCHY_NODE
 * HIERARCHY_NODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.fundhierarchy.FundCoreHierNode#VALIDITY_END_DATE
 * VALIDITY_END_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.fundhierarchy.FundCoreHierNode#PARENT_NODE
 * PARENT_NODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.fundhierarchy.FundCoreHierNode#HIERARCHY_VERSION
 * HIERARCHY_VERSION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.fundhierarchy.FundCoreHierNode#VALIDITY_START_DATE
 * VALIDITY_START_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.fundhierarchy.FundCoreHierNode#FINANCIAL_MANAGEMENT_AREA
 * FINANCIAL_MANAGEMENT_AREA}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.fundhierarchy.FundCoreHierNode#FUND FUND}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.fundhierarchy.FundCoreHierNode#HIERARCHY_NODE_SEQUENCE
 * HIERARCHY_NODE_SEQUENCE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.fundhierarchy.FundCoreHierNode#HIERARCHY_NODE_LEVEL
 * HIERARCHY_NODE_LEVEL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.fundhierarchy.FundCoreHierNode#NODE_TYPE
 * NODE_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.fundhierarchy.FundCoreHierNode#HIERARCHY_NODE_VAL
 * HIERARCHY_NODE_VAL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.fundhierarchy.FundCoreHierNode#TO_FUND_CORE_HIERARCHY
 * TO_FUND_CORE_HIERARCHY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.fundhierarchy.FundCoreHierNode#TO_FUND_CORE_HIERARCHY_NODE_TEXT
 * TO_FUND_CORE_HIERARCHY_NODE_TEXT}</li>
 * </ul>
 *
 */
public interface FundCoreHierNodeSelectable extends EntitySelectable<FundCoreHierNode>
{

}
