/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.fundhierarchy.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.fundhierarchy.FundCoreHierarchyNodeText;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.fundhierarchy.FundCoreHierarchyNodeText
 * FundCoreHierarchyNodeText}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.fundhierarchy.field.FundCoreHierarchyNodeTextField
 * FundCoreHierarchyNodeTextField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.fundhierarchy.link.FundCoreHierarchyNodeTextLink
 * FundCoreHierarchyNodeTextLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.fundhierarchy.FundCoreHierarchyNodeText#FUND_HIERARCHY
 * FUND_HIERARCHY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.fundhierarchy.FundCoreHierarchyNodeText#HIERARCHY_NODE
 * HIERARCHY_NODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.fundhierarchy.FundCoreHierarchyNodeText#VALIDITY_END_DATE
 * VALIDITY_END_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.fundhierarchy.FundCoreHierarchyNodeText#LANGUAGE
 * LANGUAGE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.fundhierarchy.FundCoreHierarchyNodeText#HIERARCHY_NODE_TEXT
 * HIERARCHY_NODE_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.fundhierarchy.FundCoreHierarchyNodeText#HIERARCHY_NODE_SHORT_TEXT
 * HIERARCHY_NODE_SHORT_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.fundhierarchy.FundCoreHierarchyNodeText#VALIDITY_START_DATE
 * VALIDITY_START_DATE}</li>
 * </ul>
 *
 */
public interface FundCoreHierarchyNodeTextSelectable extends EntitySelectable<FundCoreHierarchyNodeText>
{

}
