/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccount;

import java.time.ZonedDateTime;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccount.field.GLAccountTextField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccount.link.GLAccountTextOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccount.selectable.GLAccountTextSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * G/L Account in Chart of Accounts Text
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_GLAccountTextType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class GLAccountText extends VdmEntity<GLAccountText>
{

    /**
     * Selector for all available fields of GLAccountText.
     *
     */
    public final static GLAccountTextSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ChartOfAccounts</b>
     * </p>
     *
     * @return Chart of Accounts
     */
    @Key
    @SerializedName( "ChartOfAccounts" )
    @JsonProperty( "ChartOfAccounts" )
    @Nullable
    @ODataField( odataName = "ChartOfAccounts" )
    private String chartOfAccounts;
    /**
     * Use with available fluent helpers to apply the <b>ChartOfAccounts</b> field to query operations.
     *
     */
    public final static GLAccountTextField<String> CHART_OF_ACCOUNTS =
        new GLAccountTextField<String>("ChartOfAccounts");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>GLAccount</b>
     * </p>
     *
     * @return G/L Account Number
     */
    @Key
    @SerializedName( "GLAccount" )
    @JsonProperty( "GLAccount" )
    @Nullable
    @ODataField( odataName = "GLAccount" )
    private String gLAccount;
    /**
     * Use with available fluent helpers to apply the <b>GLAccount</b> field to query operations.
     *
     */
    public final static GLAccountTextField<String> GL_ACCOUNT = new GLAccountTextField<String>("GLAccount");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @return Language Key
     */
    @Key
    @SerializedName( "Language" )
    @JsonProperty( "Language" )
    @Nullable
    @ODataField( odataName = "Language" )
    private String language;
    /**
     * Use with available fluent helpers to apply the <b>Language</b> field to query operations.
     *
     */
    public final static GLAccountTextField<String> LANGUAGE = new GLAccountTextField<String>("Language");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>GLAccountName</b>
     * </p>
     *
     * @return G/L Account Short Text
     */
    @SerializedName( "GLAccountName" )
    @JsonProperty( "GLAccountName" )
    @Nullable
    @ODataField( odataName = "GLAccountName" )
    private String gLAccountName;
    /**
     * Use with available fluent helpers to apply the <b>GLAccountName</b> field to query operations.
     *
     */
    public final static GLAccountTextField<String> GL_ACCOUNT_NAME = new GLAccountTextField<String>("GLAccountName");
    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>GLAccountLongName</b>
     * </p>
     *
     * @return G/L Account Long Text
     */
    @SerializedName( "GLAccountLongName" )
    @JsonProperty( "GLAccountLongName" )
    @Nullable
    @ODataField( odataName = "GLAccountLongName" )
    private String gLAccountLongName;
    /**
     * Use with available fluent helpers to apply the <b>GLAccountLongName</b> field to query operations.
     *
     */
    public final static GLAccountTextField<String> GL_ACCOUNT_LONG_NAME =
        new GLAccountTextField<String>("GLAccountLongName");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDateTime</b>
     * </p>
     *
     * @return UTC Time Stamp in Short Form (YYYYMMDDhhmmss)
     */
    @SerializedName( "LastChangeDateTime" )
    @JsonProperty( "LastChangeDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "LastChangeDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime lastChangeDateTime;
    /**
     * Use with available fluent helpers to apply the <b>LastChangeDateTime</b> field to query operations.
     *
     */
    public final static GLAccountTextField<ZonedDateTime> LAST_CHANGE_DATE_TIME =
        new GLAccountTextField<ZonedDateTime>("LastChangeDateTime");
    /**
     * Navigation property <b>to_GLAccountInChartOfAccounts</b> for <b>GLAccountText</b> to single
     * <b>GLAccountInChartOfAccounts</b>.
     *
     */
    @SerializedName( "to_GLAccountInChartOfAccounts" )
    @JsonProperty( "to_GLAccountInChartOfAccounts" )
    @ODataField( odataName = "to_GLAccountInChartOfAccounts" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private GLAccountInChartOfAccounts toGLAccountInChartOfAccounts;
    /**
     * Use with available fluent helpers to apply the <b>to_GLAccountInChartOfAccounts</b> navigation property to query
     * operations.
     *
     */
    public final static GLAccountTextOneToOneLink<GLAccountInChartOfAccounts> TO_GL_ACCOUNT_IN_CHART_OF_ACCOUNTS =
        new GLAccountTextOneToOneLink<GLAccountInChartOfAccounts>("to_GLAccountInChartOfAccounts");

    @Nonnull
    @Override
    public Class<GLAccountText> getType()
    {
        return GLAccountText.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ChartOfAccounts</b>
     * </p>
     *
     * @param chartOfAccounts
     *            Chart of Accounts
     */
    public void setChartOfAccounts( @Nullable final String chartOfAccounts )
    {
        rememberChangedField("ChartOfAccounts", this.chartOfAccounts);
        this.chartOfAccounts = chartOfAccounts;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>GLAccount</b>
     * </p>
     *
     * @param gLAccount
     *            G/L Account Number
     */
    public void setGLAccount( @Nullable final String gLAccount )
    {
        rememberChangedField("GLAccount", this.gLAccount);
        this.gLAccount = gLAccount;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @param language
     *            Language Key
     */
    public void setLanguage( @Nullable final String language )
    {
        rememberChangedField("Language", this.language);
        this.language = language;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>GLAccountName</b>
     * </p>
     *
     * @param gLAccountName
     *            G/L Account Short Text
     */
    public void setGLAccountName( @Nullable final String gLAccountName )
    {
        rememberChangedField("GLAccountName", this.gLAccountName);
        this.gLAccountName = gLAccountName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>GLAccountLongName</b>
     * </p>
     *
     * @param gLAccountLongName
     *            G/L Account Long Text
     */
    public void setGLAccountLongName( @Nullable final String gLAccountLongName )
    {
        rememberChangedField("GLAccountLongName", this.gLAccountLongName);
        this.gLAccountLongName = gLAccountLongName;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDateTime</b>
     * </p>
     *
     * @param lastChangeDateTime
     *            UTC Time Stamp in Short Form (YYYYMMDDhhmmss)
     */
    public void setLastChangeDateTime( @Nullable final ZonedDateTime lastChangeDateTime )
    {
        rememberChangedField("LastChangeDateTime", this.lastChangeDateTime);
        this.lastChangeDateTime = lastChangeDateTime;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_GLAccountText";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("ChartOfAccounts", getChartOfAccounts());
        result.put("GLAccount", getGLAccount());
        result.put("Language", getLanguage());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("ChartOfAccounts", getChartOfAccounts());
        values.put("GLAccount", getGLAccount());
        values.put("Language", getLanguage());
        values.put("GLAccountName", getGLAccountName());
        values.put("GLAccountLongName", getGLAccountLongName());
        values.put("LastChangeDateTime", getLastChangeDateTime());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("ChartOfAccounts") ) {
                final Object value = values.remove("ChartOfAccounts");
                if( (value == null) || (!value.equals(getChartOfAccounts())) ) {
                    setChartOfAccounts(((String) value));
                }
            }
            if( values.containsKey("GLAccount") ) {
                final Object value = values.remove("GLAccount");
                if( (value == null) || (!value.equals(getGLAccount())) ) {
                    setGLAccount(((String) value));
                }
            }
            if( values.containsKey("Language") ) {
                final Object value = values.remove("Language");
                if( (value == null) || (!value.equals(getLanguage())) ) {
                    setLanguage(((String) value));
                }
            }
            if( values.containsKey("GLAccountName") ) {
                final Object value = values.remove("GLAccountName");
                if( (value == null) || (!value.equals(getGLAccountName())) ) {
                    setGLAccountName(((String) value));
                }
            }
            if( values.containsKey("GLAccountLongName") ) {
                final Object value = values.remove("GLAccountLongName");
                if( (value == null) || (!value.equals(getGLAccountLongName())) ) {
                    setGLAccountLongName(((String) value));
                }
            }
            if( values.containsKey("LastChangeDateTime") ) {
                final Object value = values.remove("LastChangeDateTime");
                if( (value == null) || (!value.equals(getLastChangeDateTime())) ) {
                    setLastChangeDateTime(((ZonedDateTime) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_GLAccountInChartOfAccounts") ) {
                final Object value = (values).remove("to_GLAccountInChartOfAccounts");
                if( value instanceof Map ) {
                    if( toGLAccountInChartOfAccounts == null ) {
                        toGLAccountInChartOfAccounts = new GLAccountInChartOfAccounts();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toGLAccountInChartOfAccounts.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> GLAccountTextField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new GLAccountTextField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> GLAccountTextField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new GLAccountTextField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.GeneralLedgerAccountService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toGLAccountInChartOfAccounts != null ) {
            (values).put("to_GLAccountInChartOfAccounts", toGLAccountInChartOfAccounts);
        }
        return values;
    }

    /**
     * Fetches the <b>GLAccountInChartOfAccounts</b> entity (one to one) associated with this entity. This corresponds
     * to the OData navigation property <b>to_GLAccountInChartOfAccounts</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>GLAccountInChartOfAccounts</b> entity, or {@code null} if an entity is not
     *         associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public GLAccountInChartOfAccounts fetchGLAccountInChartOfAccounts()
    {
        return fetchFieldAsSingle("to_GLAccountInChartOfAccounts", GLAccountInChartOfAccounts.class);
    }

    /**
     * Retrieval of associated <b>GLAccountInChartOfAccounts</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_GLAccountInChartOfAccounts</b>.
     * <p>
     * If the navigation property <b>to_GLAccountInChartOfAccounts</b> of a queried <b>GLAccountText</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>GLAccountInChartOfAccounts</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public GLAccountInChartOfAccounts getGLAccountInChartOfAccountsOrFetch()
    {
        if( toGLAccountInChartOfAccounts == null ) {
            toGLAccountInChartOfAccounts = fetchGLAccountInChartOfAccounts();
        }
        return toGLAccountInChartOfAccounts;
    }

    /**
     * Retrieval of associated <b>GLAccountInChartOfAccounts</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_GLAccountInChartOfAccounts</b>.
     * <p>
     * If the navigation property for an entity <b>GLAccountText</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_GLAccountInChartOfAccounts</b> is already loaded, the
     *         result will contain the <b>GLAccountInChartOfAccounts</b> entity. If not, an <code>Option</code> with
     *         result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<GLAccountInChartOfAccounts> getGLAccountInChartOfAccountsIfPresent()
    {
        return Option.of(toGLAccountInChartOfAccounts);
    }

    /**
     * Overwrites the associated <b>GLAccountInChartOfAccounts</b> entity for the loaded navigation property
     * <b>to_GLAccountInChartOfAccounts</b>.
     *
     * @param value
     *            New <b>GLAccountInChartOfAccounts</b> entity.
     */
    public void setGLAccountInChartOfAccounts( final GLAccountInChartOfAccounts value )
    {
        toGLAccountInChartOfAccounts = value;
    }

    /**
     * Helper class to allow for fluent creation of GLAccountText instances.
     *
     */
    public final static class GLAccountTextBuilder
    {

        private GLAccountInChartOfAccounts toGLAccountInChartOfAccounts;

        private GLAccountText.GLAccountTextBuilder toGLAccountInChartOfAccounts(
            final GLAccountInChartOfAccounts value )
        {
            toGLAccountInChartOfAccounts = value;
            return this;
        }

        /**
         * Navigation property <b>to_GLAccountInChartOfAccounts</b> for <b>GLAccountText</b> to single
         * <b>GLAccountInChartOfAccounts</b>.
         *
         * @param value
         *            The GLAccountInChartOfAccounts to build this GLAccountText with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public GLAccountText.GLAccountTextBuilder glAccountInChartOfAccounts( final GLAccountInChartOfAccounts value )
        {
            return toGLAccountInChartOfAccounts(value);
        }

    }

}
