/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccount.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchFluentHelperBasic;

/**
 * Default implementation of the {@link GeneralLedgerAccountServiceBatch} interface exposed in the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.GeneralLedgerAccountService GeneralLedgerAccountService},
 * allowing you to create multiple changesets and finally execute the batch request.
 *
 */
public class DefaultGeneralLedgerAccountServiceBatch
    extends
    BatchFluentHelperBasic<GeneralLedgerAccountServiceBatch, GeneralLedgerAccountServiceBatchChangeSet>
    implements
    GeneralLedgerAccountServiceBatch
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.GeneralLedgerAccountService service;
    @Nonnull
    private final String servicePath;

    /**
     * Creates a new instance of this DefaultGeneralLedgerAccountServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultGeneralLedgerAccountServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.GeneralLedgerAccountService service )
    {
        this(
            service,
            com.sap.cloud.sdk.s4hana.datamodel.odata.services.GeneralLedgerAccountService.DEFAULT_SERVICE_PATH);
    }

    /**
     * Creates a new instance of this DefaultGeneralLedgerAccountServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     * @param servicePath
     *            The custom service path to operate on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultGeneralLedgerAccountServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.GeneralLedgerAccountService service,
        @Nonnull final String servicePath )
    {
        this.service = service;
        this.servicePath = servicePath;
    }

    @Nonnull
    @Override
    protected String getServicePathForBatchRequest()
    {
        return servicePath;
    }

    @Nonnull
    @Override
    protected DefaultGeneralLedgerAccountServiceBatch getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public GeneralLedgerAccountServiceBatchChangeSet beginChangeSet()
    {
        return new DefaultGeneralLedgerAccountServiceBatchChangeSet(this, service);
    }

}
