/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccount.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccount.GLAccountText;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccount.GLAccountText GLAccountText}. This
 * interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccount.field.GLAccountTextField
 * GLAccountTextField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccount.link.GLAccountTextLink
 * GLAccountTextLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccount.GLAccountText#CHART_OF_ACCOUNTS
 * CHART_OF_ACCOUNTS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccount.GLAccountText#GL_ACCOUNT
 * GL_ACCOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccount.GLAccountText#LANGUAGE
 * LANGUAGE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccount.GLAccountText#GL_ACCOUNT_NAME
 * GL_ACCOUNT_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccount.GLAccountText#GL_ACCOUNT_LONG_NAME
 * GL_ACCOUNT_LONG_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccount.GLAccountText#LAST_CHANGE_DATE_TIME
 * LAST_CHANGE_DATE_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccount.GLAccountText#TO_GL_ACCOUNT_IN_CHART_OF_ACCOUNTS
 * TO_GL_ACCOUNT_IN_CHART_OF_ACCOUNTS}</li>
 * </ul>
 *
 */
public interface GLAccountTextSelectable extends EntitySelectable<GLAccountText>
{

}
