/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.util.Map;
import java.util.UUID;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.field.GLAccountLineItemField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.selectable.GLAccountLineItemSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * API G/L Account Line Item
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>GLAccountLineItemType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class GLAccountLineItem extends VdmEntity<GLAccountLineItem>
{

    /**
     * Selector for all available fields of GLAccountLineItem.
     *
     */
    public final static GLAccountLineItemSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>ID</b>
     * </p>
     *
     * @return The iD contained in this entity.
     */
    @Key
    @SerializedName( "ID" )
    @JsonProperty( "ID" )
    @Nullable
    @ODataField( odataName = "ID" )
    private String iD;
    /**
     * Use with available fluent helpers to apply the <b>ID</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<String> ID = new GLAccountLineItemField<String>("ID");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>SourceLedger</b>
     * </p>
     *
     * @return Source Ledger
     */
    @SerializedName( "SourceLedger" )
    @JsonProperty( "SourceLedger" )
    @Nullable
    @ODataField( odataName = "SourceLedger" )
    private String sourceLedger;
    /**
     * Use with available fluent helpers to apply the <b>SourceLedger</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<String> SOURCE_LEDGER =
        new GLAccountLineItemField<String>("SourceLedger");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCode</b>
     * </p>
     *
     * @return Company Code
     */
    @SerializedName( "CompanyCode" )
    @JsonProperty( "CompanyCode" )
    @Nullable
    @ODataField( odataName = "CompanyCode" )
    private String companyCode;
    /**
     * Use with available fluent helpers to apply the <b>CompanyCode</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<String> COMPANY_CODE = new GLAccountLineItemField<String>("CompanyCode");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>FiscalYear</b>
     * </p>
     *
     * @return Fiscal Year
     */
    @SerializedName( "FiscalYear" )
    @JsonProperty( "FiscalYear" )
    @Nullable
    @ODataField( odataName = "FiscalYear" )
    private String fiscalYear;
    /**
     * Use with available fluent helpers to apply the <b>FiscalYear</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<String> FISCAL_YEAR = new GLAccountLineItemField<String>("FiscalYear");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>AccountingDocument</b>
     * </p>
     *
     * @return Journal Entry
     */
    @SerializedName( "AccountingDocument" )
    @JsonProperty( "AccountingDocument" )
    @Nullable
    @ODataField( odataName = "AccountingDocument" )
    private String accountingDocument;
    /**
     * Use with available fluent helpers to apply the <b>AccountingDocument</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<String> ACCOUNTING_DOCUMENT =
        new GLAccountLineItemField<String>("AccountingDocument");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>LedgerGLLineItem</b>
     * </p>
     *
     * @return Ledger Journal Entry Item
     */
    @SerializedName( "LedgerGLLineItem" )
    @JsonProperty( "LedgerGLLineItem" )
    @Nullable
    @ODataField( odataName = "LedgerGLLineItem" )
    private String ledgerGLLineItem;
    /**
     * Use with available fluent helpers to apply the <b>LedgerGLLineItem</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<String> LEDGER_GL_LINE_ITEM =
        new GLAccountLineItemField<String>("LedgerGLLineItem");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Ledger</b>
     * </p>
     *
     * @return Ledger in General Ledger Accounting
     */
    @SerializedName( "Ledger" )
    @JsonProperty( "Ledger" )
    @Nullable
    @ODataField( odataName = "Ledger" )
    private String ledger;
    /**
     * Use with available fluent helpers to apply the <b>Ledger</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<String> LEDGER = new GLAccountLineItemField<String>("Ledger");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>LedgerFiscalYear</b>
     * </p>
     *
     * @return Fiscal Year of Ledger
     */
    @SerializedName( "LedgerFiscalYear" )
    @JsonProperty( "LedgerFiscalYear" )
    @Nullable
    @ODataField( odataName = "LedgerFiscalYear" )
    private String ledgerFiscalYear;
    /**
     * Use with available fluent helpers to apply the <b>LedgerFiscalYear</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<String> LEDGER_FISCAL_YEAR =
        new GLAccountLineItemField<String>("LedgerFiscalYear");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>GLRecordType</b>
     * </p>
     *
     * @return Record Type
     */
    @SerializedName( "GLRecordType" )
    @JsonProperty( "GLRecordType" )
    @Nullable
    @ODataField( odataName = "GLRecordType" )
    private String gLRecordType;
    /**
     * Use with available fluent helpers to apply the <b>GLRecordType</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<String> GL_RECORD_TYPE =
        new GLAccountLineItemField<String>("GLRecordType");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ControllingArea</b>
     * </p>
     *
     * @return Controlling Area
     */
    @SerializedName( "ControllingArea" )
    @JsonProperty( "ControllingArea" )
    @Nullable
    @ODataField( odataName = "ControllingArea" )
    private String controllingArea;
    /**
     * Use with available fluent helpers to apply the <b>ControllingArea</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<String> CONTROLLING_AREA =
        new GLAccountLineItemField<String>("ControllingArea");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ChartOfAccounts</b>
     * </p>
     *
     * @return Chart of Accounts
     */
    @SerializedName( "ChartOfAccounts" )
    @JsonProperty( "ChartOfAccounts" )
    @Nullable
    @ODataField( odataName = "ChartOfAccounts" )
    private String chartOfAccounts;
    /**
     * Use with available fluent helpers to apply the <b>ChartOfAccounts</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<String> CHART_OF_ACCOUNTS =
        new GLAccountLineItemField<String>("ChartOfAccounts");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>GLAccount</b>
     * </p>
     *
     * @return G/L Account
     */
    @SerializedName( "GLAccount" )
    @JsonProperty( "GLAccount" )
    @Nullable
    @ODataField( odataName = "GLAccount" )
    private String gLAccount;
    /**
     * Use with available fluent helpers to apply the <b>GLAccount</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<String> GL_ACCOUNT = new GLAccountLineItemField<String>("GLAccount");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>FinancialTransactionType</b>
     * </p>
     *
     * @return Financial Transaction Type
     */
    @SerializedName( "FinancialTransactionType" )
    @JsonProperty( "FinancialTransactionType" )
    @Nullable
    @ODataField( odataName = "FinancialTransactionType" )
    private String financialTransactionType;
    /**
     * Use with available fluent helpers to apply the <b>FinancialTransactionType</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<String> FINANCIAL_TRANSACTION_TYPE =
        new GLAccountLineItemField<String>("FinancialTransactionType");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BusinessTransactionType</b>
     * </p>
     *
     * @return Business Transaction Type
     */
    @SerializedName( "BusinessTransactionType" )
    @JsonProperty( "BusinessTransactionType" )
    @Nullable
    @ODataField( odataName = "BusinessTransactionType" )
    private String businessTransactionType;
    /**
     * Use with available fluent helpers to apply the <b>BusinessTransactionType</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<String> BUSINESS_TRANSACTION_TYPE =
        new GLAccountLineItemField<String>("BusinessTransactionType");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ControllingBusTransacType</b>
     * </p>
     *
     * @return CO Business Transaction
     */
    @SerializedName( "ControllingBusTransacType" )
    @JsonProperty( "ControllingBusTransacType" )
    @Nullable
    @ODataField( odataName = "ControllingBusTransacType" )
    private String controllingBusTransacType;
    /**
     * Use with available fluent helpers to apply the <b>ControllingBusTransacType</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<String> CONTROLLING_BUS_TRANSAC_TYPE =
        new GLAccountLineItemField<String>("ControllingBusTransacType");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>ReferenceDocumentType</b>
     * </p>
     *
     * @return Reference Document Type
     */
    @SerializedName( "ReferenceDocumentType" )
    @JsonProperty( "ReferenceDocumentType" )
    @Nullable
    @ODataField( odataName = "ReferenceDocumentType" )
    private String referenceDocumentType;
    /**
     * Use with available fluent helpers to apply the <b>ReferenceDocumentType</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<String> REFERENCE_DOCUMENT_TYPE =
        new GLAccountLineItemField<String>("ReferenceDocumentType");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>LogicalSystem</b>
     * </p>
     *
     * @return Logical System
     */
    @SerializedName( "LogicalSystem" )
    @JsonProperty( "LogicalSystem" )
    @Nullable
    @ODataField( odataName = "LogicalSystem" )
    private String logicalSystem;
    /**
     * Use with available fluent helpers to apply the <b>LogicalSystem</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<String> LOGICAL_SYSTEM =
        new GLAccountLineItemField<String>("LogicalSystem");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ReferenceDocumentContext</b>
     * </p>
     *
     * @return Reference Document Context
     */
    @SerializedName( "ReferenceDocumentContext" )
    @JsonProperty( "ReferenceDocumentContext" )
    @Nullable
    @ODataField( odataName = "ReferenceDocumentContext" )
    private String referenceDocumentContext;
    /**
     * Use with available fluent helpers to apply the <b>ReferenceDocumentContext</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<String> REFERENCE_DOCUMENT_CONTEXT =
        new GLAccountLineItemField<String>("ReferenceDocumentContext");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ReferenceDocument</b>
     * </p>
     *
     * @return Reference document number
     */
    @SerializedName( "ReferenceDocument" )
    @JsonProperty( "ReferenceDocument" )
    @Nullable
    @ODataField( odataName = "ReferenceDocument" )
    private String referenceDocument;
    /**
     * Use with available fluent helpers to apply the <b>ReferenceDocument</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<String> REFERENCE_DOCUMENT =
        new GLAccountLineItemField<String>("ReferenceDocument");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>ReferenceDocumentItem</b>
     * </p>
     *
     * @return Reference Document Item
     */
    @SerializedName( "ReferenceDocumentItem" )
    @JsonProperty( "ReferenceDocumentItem" )
    @Nullable
    @ODataField( odataName = "ReferenceDocumentItem" )
    private String referenceDocumentItem;
    /**
     * Use with available fluent helpers to apply the <b>ReferenceDocumentItem</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<String> REFERENCE_DOCUMENT_ITEM =
        new GLAccountLineItemField<String>("ReferenceDocumentItem");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>ReferenceDocumentItemGroup</b>
     * </p>
     *
     * @return Reference Document Item Group
     */
    @SerializedName( "ReferenceDocumentItemGroup" )
    @JsonProperty( "ReferenceDocumentItemGroup" )
    @Nullable
    @ODataField( odataName = "ReferenceDocumentItemGroup" )
    private String referenceDocumentItemGroup;
    /**
     * Use with available fluent helpers to apply the <b>ReferenceDocumentItemGroup</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<String> REFERENCE_DOCUMENT_ITEM_GROUP =
        new GLAccountLineItemField<String>("ReferenceDocumentItemGroup");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>TransactionSubitem</b>
     * </p>
     *
     * @return Partial Document to be balanced to zero
     */
    @SerializedName( "TransactionSubitem" )
    @JsonProperty( "TransactionSubitem" )
    @Nullable
    @ODataField( odataName = "TransactionSubitem" )
    private String transactionSubitem;
    /**
     * Use with available fluent helpers to apply the <b>TransactionSubitem</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<String> TRANSACTION_SUBITEM =
        new GLAccountLineItemField<String>("TransactionSubitem");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsReversal</b>
     * </p>
     *
     * @return Indicator: Item is Reversing Another Item
     */
    @SerializedName( "IsReversal" )
    @JsonProperty( "IsReversal" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "IsReversal" )
    private Boolean isReversal;
    /**
     * Use with available fluent helpers to apply the <b>IsReversal</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<Boolean> IS_REVERSAL = new GLAccountLineItemField<Boolean>("IsReversal");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsReversed</b>
     * </p>
     *
     * @return Indicator: Item is Reversed
     */
    @SerializedName( "IsReversed" )
    @JsonProperty( "IsReversed" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "IsReversed" )
    private Boolean isReversed;
    /**
     * Use with available fluent helpers to apply the <b>IsReversed</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<Boolean> IS_REVERSED = new GLAccountLineItemField<Boolean>("IsReversed");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ReversalReferenceDocumentCntxt</b>
     * </p>
     *
     * @return Reversal Reference Document Context
     */
    @SerializedName( "ReversalReferenceDocumentCntxt" )
    @JsonProperty( "ReversalReferenceDocumentCntxt" )
    @Nullable
    @ODataField( odataName = "ReversalReferenceDocumentCntxt" )
    private String reversalReferenceDocumentCntxt;
    /**
     * Use with available fluent helpers to apply the <b>ReversalReferenceDocumentCntxt</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<String> REVERSAL_REFERENCE_DOCUMENT_CNTXT =
        new GLAccountLineItemField<String>("ReversalReferenceDocumentCntxt");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ReversalReferenceDocument</b>
     * </p>
     *
     * @return Reversal Reference Document
     */
    @SerializedName( "ReversalReferenceDocument" )
    @JsonProperty( "ReversalReferenceDocument" )
    @Nullable
    @ODataField( odataName = "ReversalReferenceDocument" )
    private String reversalReferenceDocument;
    /**
     * Use with available fluent helpers to apply the <b>ReversalReferenceDocument</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<String> REVERSAL_REFERENCE_DOCUMENT =
        new GLAccountLineItemField<String>("ReversalReferenceDocument");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsSettlement</b>
     * </p>
     *
     * @return Indicator: Item is Settling or Transferring Another Item
     */
    @SerializedName( "IsSettlement" )
    @JsonProperty( "IsSettlement" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "IsSettlement" )
    private Boolean isSettlement;
    /**
     * Use with available fluent helpers to apply the <b>IsSettlement</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<Boolean> IS_SETTLEMENT =
        new GLAccountLineItemField<Boolean>("IsSettlement");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsSettled</b>
     * </p>
     *
     * @return Indicator: Line Item is Settled or Transferred
     */
    @SerializedName( "IsSettled" )
    @JsonProperty( "IsSettled" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "IsSettled" )
    private Boolean isSettled;
    /**
     * Use with available fluent helpers to apply the <b>IsSettled</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<Boolean> IS_SETTLED = new GLAccountLineItemField<Boolean>("IsSettled");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>PredecessorReferenceDocType</b>
     * </p>
     *
     * @return Predecessor Reference Document Type
     */
    @SerializedName( "PredecessorReferenceDocType" )
    @JsonProperty( "PredecessorReferenceDocType" )
    @Nullable
    @ODataField( odataName = "PredecessorReferenceDocType" )
    private String predecessorReferenceDocType;
    /**
     * Use with available fluent helpers to apply the <b>PredecessorReferenceDocType</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<String> PREDECESSOR_REFERENCE_DOC_TYPE =
        new GLAccountLineItemField<String>("PredecessorReferenceDocType");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PredecessorReferenceDocCntxt</b>
     * </p>
     *
     * @return Predecessor Reference Document Context
     */
    @SerializedName( "PredecessorReferenceDocCntxt" )
    @JsonProperty( "PredecessorReferenceDocCntxt" )
    @Nullable
    @ODataField( odataName = "PredecessorReferenceDocCntxt" )
    private String predecessorReferenceDocCntxt;
    /**
     * Use with available fluent helpers to apply the <b>PredecessorReferenceDocCntxt</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<String> PREDECESSOR_REFERENCE_DOC_CNTXT =
        new GLAccountLineItemField<String>("PredecessorReferenceDocCntxt");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PredecessorReferenceDocument</b>
     * </p>
     *
     * @return Predecessor Reference Document
     */
    @SerializedName( "PredecessorReferenceDocument" )
    @JsonProperty( "PredecessorReferenceDocument" )
    @Nullable
    @ODataField( odataName = "PredecessorReferenceDocument" )
    private String predecessorReferenceDocument;
    /**
     * Use with available fluent helpers to apply the <b>PredecessorReferenceDocument</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<String> PREDECESSOR_REFERENCE_DOCUMENT =
        new GLAccountLineItemField<String>("PredecessorReferenceDocument");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>PredecessorReferenceDocItem</b>
     * </p>
     *
     * @return Predecessor Reference Document Item
     */
    @SerializedName( "PredecessorReferenceDocItem" )
    @JsonProperty( "PredecessorReferenceDocItem" )
    @Nullable
    @ODataField( odataName = "PredecessorReferenceDocItem" )
    private String predecessorReferenceDocItem;
    /**
     * Use with available fluent helpers to apply the <b>PredecessorReferenceDocItem</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<String> PREDECESSOR_REFERENCE_DOC_ITEM =
        new GLAccountLineItemField<String>("PredecessorReferenceDocItem");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PrdcssrJournalEntryCompanyCode</b>
     * </p>
     *
     * @return Preceding Journal Entry Company Code
     */
    @SerializedName( "PrdcssrJournalEntryCompanyCode" )
    @JsonProperty( "PrdcssrJournalEntryCompanyCode" )
    @Nullable
    @ODataField( odataName = "PrdcssrJournalEntryCompanyCode" )
    private String prdcssrJournalEntryCompanyCode;
    /**
     * Use with available fluent helpers to apply the <b>PrdcssrJournalEntryCompanyCode</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<String> PRDCSSR_JOURNAL_ENTRY_COMPANY_CODE =
        new GLAccountLineItemField<String>("PrdcssrJournalEntryCompanyCode");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PrdcssrJournalEntryFiscalYear</b>
     * </p>
     *
     * @return Preceding Journal Entry Fiscal Year
     */
    @SerializedName( "PrdcssrJournalEntryFiscalYear" )
    @JsonProperty( "PrdcssrJournalEntryFiscalYear" )
    @Nullable
    @ODataField( odataName = "PrdcssrJournalEntryFiscalYear" )
    private String prdcssrJournalEntryFiscalYear;
    /**
     * Use with available fluent helpers to apply the <b>PrdcssrJournalEntryFiscalYear</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<String> PRDCSSR_JOURNAL_ENTRY_FISCAL_YEAR =
        new GLAccountLineItemField<String>("PrdcssrJournalEntryFiscalYear");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PredecessorJournalEntry</b>
     * </p>
     *
     * @return Preceding Journal Entry Document Number
     */
    @SerializedName( "PredecessorJournalEntry" )
    @JsonProperty( "PredecessorJournalEntry" )
    @Nullable
    @ODataField( odataName = "PredecessorJournalEntry" )
    private String predecessorJournalEntry;
    /**
     * Use with available fluent helpers to apply the <b>PredecessorJournalEntry</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<String> PREDECESSOR_JOURNAL_ENTRY =
        new GLAccountLineItemField<String>("PredecessorJournalEntry");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>PredecessorJournalEntryItem</b>
     * </p>
     *
     * @return Preceding Journal Entry Line Item
     */
    @SerializedName( "PredecessorJournalEntryItem" )
    @JsonProperty( "PredecessorJournalEntryItem" )
    @Nullable
    @ODataField( odataName = "PredecessorJournalEntryItem" )
    private String predecessorJournalEntryItem;
    /**
     * Use with available fluent helpers to apply the <b>PredecessorJournalEntryItem</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<String> PREDECESSOR_JOURNAL_ENTRY_ITEM =
        new GLAccountLineItemField<String>("PredecessorJournalEntryItem");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>SourceReferenceDocumentType</b>
     * </p>
     *
     * @return Source Reference Document Type
     */
    @SerializedName( "SourceReferenceDocumentType" )
    @JsonProperty( "SourceReferenceDocumentType" )
    @Nullable
    @ODataField( odataName = "SourceReferenceDocumentType" )
    private String sourceReferenceDocumentType;
    /**
     * Use with available fluent helpers to apply the <b>SourceReferenceDocumentType</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<String> SOURCE_REFERENCE_DOCUMENT_TYPE =
        new GLAccountLineItemField<String>("SourceReferenceDocumentType");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SourceLogicalSystem</b>
     * </p>
     *
     * @return Source Logical System
     */
    @SerializedName( "SourceLogicalSystem" )
    @JsonProperty( "SourceLogicalSystem" )
    @Nullable
    @ODataField( odataName = "SourceLogicalSystem" )
    private String sourceLogicalSystem;
    /**
     * Use with available fluent helpers to apply the <b>SourceLogicalSystem</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<String> SOURCE_LOGICAL_SYSTEM =
        new GLAccountLineItemField<String>("SourceLogicalSystem");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SourceReferenceDocumentCntxt</b>
     * </p>
     *
     * @return Source Reference Document Context
     */
    @SerializedName( "SourceReferenceDocumentCntxt" )
    @JsonProperty( "SourceReferenceDocumentCntxt" )
    @Nullable
    @ODataField( odataName = "SourceReferenceDocumentCntxt" )
    private String sourceReferenceDocumentCntxt;
    /**
     * Use with available fluent helpers to apply the <b>SourceReferenceDocumentCntxt</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<String> SOURCE_REFERENCE_DOCUMENT_CNTXT =
        new GLAccountLineItemField<String>("SourceReferenceDocumentCntxt");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SourceReferenceDocument</b>
     * </p>
     *
     * @return Source Reference Document
     */
    @SerializedName( "SourceReferenceDocument" )
    @JsonProperty( "SourceReferenceDocument" )
    @Nullable
    @ODataField( odataName = "SourceReferenceDocument" )
    private String sourceReferenceDocument;
    /**
     * Use with available fluent helpers to apply the <b>SourceReferenceDocument</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<String> SOURCE_REFERENCE_DOCUMENT =
        new GLAccountLineItemField<String>("SourceReferenceDocument");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>SourceReferenceDocumentItem</b>
     * </p>
     *
     * @return Source Reference Document Item
     */
    @SerializedName( "SourceReferenceDocumentItem" )
    @JsonProperty( "SourceReferenceDocumentItem" )
    @Nullable
    @ODataField( odataName = "SourceReferenceDocumentItem" )
    private String sourceReferenceDocumentItem;
    /**
     * Use with available fluent helpers to apply the <b>SourceReferenceDocumentItem</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<String> SOURCE_REFERENCE_DOCUMENT_ITEM =
        new GLAccountLineItemField<String>("SourceReferenceDocumentItem");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>SourceReferenceDocSubitem</b>
     * </p>
     *
     * @return Source Reference Document Subitem
     */
    @SerializedName( "SourceReferenceDocSubitem" )
    @JsonProperty( "SourceReferenceDocSubitem" )
    @Nullable
    @ODataField( odataName = "SourceReferenceDocSubitem" )
    private String sourceReferenceDocSubitem;
    /**
     * Use with available fluent helpers to apply the <b>SourceReferenceDocSubitem</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<String> SOURCE_REFERENCE_DOC_SUBITEM =
        new GLAccountLineItemField<String>("SourceReferenceDocSubitem");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsCommitment</b>
     * </p>
     *
     * @return Indicator: Is Commitment
     */
    @SerializedName( "IsCommitment" )
    @JsonProperty( "IsCommitment" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "IsCommitment" )
    private Boolean isCommitment;
    /**
     * Use with available fluent helpers to apply the <b>IsCommitment</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<Boolean> IS_COMMITMENT =
        new GLAccountLineItemField<Boolean>("IsCommitment");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>JrnlEntryItemObsoleteReason</b>
     * </p>
     *
     * @return Journal Entry Item Obsolete Reason
     */
    @SerializedName( "JrnlEntryItemObsoleteReason" )
    @JsonProperty( "JrnlEntryItemObsoleteReason" )
    @Nullable
    @ODataField( odataName = "JrnlEntryItemObsoleteReason" )
    private String jrnlEntryItemObsoleteReason;
    /**
     * Use with available fluent helpers to apply the <b>JrnlEntryItemObsoleteReason</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<String> JRNL_ENTRY_ITEM_OBSOLETE_REASON =
        new GLAccountLineItemField<String>("JrnlEntryItemObsoleteReason");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>JrnlPeriodEndClosingRunLogUUID</b>
     * </p>
     *
     * @return UUID of Financial Closing Run
     */
    @SerializedName( "JrnlPeriodEndClosingRunLogUUID" )
    @JsonProperty( "JrnlPeriodEndClosingRunLogUUID" )
    @Nullable
    @ODataField( odataName = "JrnlPeriodEndClosingRunLogUUID" )
    private UUID jrnlPeriodEndClosingRunLogUUID;
    /**
     * Use with available fluent helpers to apply the <b>JrnlPeriodEndClosingRunLogUUID</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<UUID> JRNL_PERIOD_END_CLOSING_RUN_LOG_UUID =
        new GLAccountLineItemField<UUID>("JrnlPeriodEndClosingRunLogUUID");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CostCenter</b>
     * </p>
     *
     * @return Cost Center
     */
    @SerializedName( "CostCenter" )
    @JsonProperty( "CostCenter" )
    @Nullable
    @ODataField( odataName = "CostCenter" )
    private String costCenter;
    /**
     * Use with available fluent helpers to apply the <b>CostCenter</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<String> COST_CENTER = new GLAccountLineItemField<String>("CostCenter");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ProfitCenter</b>
     * </p>
     *
     * @return Profit Center
     */
    @SerializedName( "ProfitCenter" )
    @JsonProperty( "ProfitCenter" )
    @Nullable
    @ODataField( odataName = "ProfitCenter" )
    private String profitCenter;
    /**
     * Use with available fluent helpers to apply the <b>ProfitCenter</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<String> PROFIT_CENTER =
        new GLAccountLineItemField<String>("ProfitCenter");
    /**
     * Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>FunctionalArea</b>
     * </p>
     *
     * @return Functional Area
     */
    @SerializedName( "FunctionalArea" )
    @JsonProperty( "FunctionalArea" )
    @Nullable
    @ODataField( odataName = "FunctionalArea" )
    private String functionalArea;
    /**
     * Use with available fluent helpers to apply the <b>FunctionalArea</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<String> FUNCTIONAL_AREA =
        new GLAccountLineItemField<String>("FunctionalArea");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BusinessArea</b>
     * </p>
     *
     * @return Business Area
     */
    @SerializedName( "BusinessArea" )
    @JsonProperty( "BusinessArea" )
    @Nullable
    @ODataField( odataName = "BusinessArea" )
    private String businessArea;
    /**
     * Use with available fluent helpers to apply the <b>BusinessArea</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<String> BUSINESS_AREA =
        new GLAccountLineItemField<String>("BusinessArea");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Segment</b>
     * </p>
     *
     * @return Segment for Segmental Reporting
     */
    @SerializedName( "Segment" )
    @JsonProperty( "Segment" )
    @Nullable
    @ODataField( odataName = "Segment" )
    private String segment;
    /**
     * Use with available fluent helpers to apply the <b>Segment</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<String> SEGMENT = new GLAccountLineItemField<String>("Segment");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PartnerCostCenter</b>
     * </p>
     *
     * @return Partner Cost Center
     */
    @SerializedName( "PartnerCostCenter" )
    @JsonProperty( "PartnerCostCenter" )
    @Nullable
    @ODataField( odataName = "PartnerCostCenter" )
    private String partnerCostCenter;
    /**
     * Use with available fluent helpers to apply the <b>PartnerCostCenter</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<String> PARTNER_COST_CENTER =
        new GLAccountLineItemField<String>("PartnerCostCenter");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PartnerProfitCenter</b>
     * </p>
     *
     * @return Partner Profit Center
     */
    @SerializedName( "PartnerProfitCenter" )
    @JsonProperty( "PartnerProfitCenter" )
    @Nullable
    @ODataField( odataName = "PartnerProfitCenter" )
    private String partnerProfitCenter;
    /**
     * Use with available fluent helpers to apply the <b>PartnerProfitCenter</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<String> PARTNER_PROFIT_CENTER =
        new GLAccountLineItemField<String>("PartnerProfitCenter");
    /**
     * Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>PartnerFunctionalArea</b>
     * </p>
     *
     * @return Partner Functional Area
     */
    @SerializedName( "PartnerFunctionalArea" )
    @JsonProperty( "PartnerFunctionalArea" )
    @Nullable
    @ODataField( odataName = "PartnerFunctionalArea" )
    private String partnerFunctionalArea;
    /**
     * Use with available fluent helpers to apply the <b>PartnerFunctionalArea</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<String> PARTNER_FUNCTIONAL_AREA =
        new GLAccountLineItemField<String>("PartnerFunctionalArea");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PartnerBusinessArea</b>
     * </p>
     *
     * @return Partner Business Area
     */
    @SerializedName( "PartnerBusinessArea" )
    @JsonProperty( "PartnerBusinessArea" )
    @Nullable
    @ODataField( odataName = "PartnerBusinessArea" )
    private String partnerBusinessArea;
    /**
     * Use with available fluent helpers to apply the <b>PartnerBusinessArea</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<String> PARTNER_BUSINESS_AREA =
        new GLAccountLineItemField<String>("PartnerBusinessArea");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>PartnerCompany</b>
     * </p>
     *
     * @return Company ID of Trading Partner
     */
    @SerializedName( "PartnerCompany" )
    @JsonProperty( "PartnerCompany" )
    @Nullable
    @ODataField( odataName = "PartnerCompany" )
    private String partnerCompany;
    /**
     * Use with available fluent helpers to apply the <b>PartnerCompany</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<String> PARTNER_COMPANY =
        new GLAccountLineItemField<String>("PartnerCompany");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PartnerSegment</b>
     * </p>
     *
     * @return Partner Segment for Segmental Reporting
     */
    @SerializedName( "PartnerSegment" )
    @JsonProperty( "PartnerSegment" )
    @Nullable
    @ODataField( odataName = "PartnerSegment" )
    private String partnerSegment;
    /**
     * Use with available fluent helpers to apply the <b>PartnerSegment</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<String> PARTNER_SEGMENT =
        new GLAccountLineItemField<String>("PartnerSegment");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>BalanceTransactionCurrency</b>
     * </p>
     *
     * @return Balance Transaction Currency
     */
    @SerializedName( "BalanceTransactionCurrency" )
    @JsonProperty( "BalanceTransactionCurrency" )
    @Nullable
    @ODataField( odataName = "BalanceTransactionCurrency" )
    private String balanceTransactionCurrency;
    /**
     * Use with available fluent helpers to apply the <b>BalanceTransactionCurrency</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<String> BALANCE_TRANSACTION_CURRENCY =
        new GLAccountLineItemField<String>("BalanceTransactionCurrency");
    /**
     * Constraints: Not nullable, Precision: 23, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>AmountInBalanceTransacCrcy</b>
     * </p>
     *
     * @return Amount in Balance Transaction Currency
     */
    @SerializedName( "AmountInBalanceTransacCrcy" )
    @JsonProperty( "AmountInBalanceTransacCrcy" )
    @Nullable
    @ODataField( odataName = "AmountInBalanceTransacCrcy" )
    private BigDecimal amountInBalanceTransacCrcy;
    /**
     * Use with available fluent helpers to apply the <b>AmountInBalanceTransacCrcy</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<BigDecimal> AMOUNT_IN_BALANCE_TRANSAC_CRCY =
        new GLAccountLineItemField<BigDecimal>("AmountInBalanceTransacCrcy");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>TransactionCurrency</b>
     * </p>
     *
     * @return Transaction Currency
     */
    @SerializedName( "TransactionCurrency" )
    @JsonProperty( "TransactionCurrency" )
    @Nullable
    @ODataField( odataName = "TransactionCurrency" )
    private String transactionCurrency;
    /**
     * Use with available fluent helpers to apply the <b>TransactionCurrency</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<String> TRANSACTION_CURRENCY =
        new GLAccountLineItemField<String>("TransactionCurrency");
    /**
     * Constraints: Not nullable, Precision: 23, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>AmountInTransactionCurrency</b>
     * </p>
     *
     * @return Amount in Transaction Currency
     */
    @SerializedName( "AmountInTransactionCurrency" )
    @JsonProperty( "AmountInTransactionCurrency" )
    @Nullable
    @ODataField( odataName = "AmountInTransactionCurrency" )
    private BigDecimal amountInTransactionCurrency;
    /**
     * Use with available fluent helpers to apply the <b>AmountInTransactionCurrency</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<BigDecimal> AMOUNT_IN_TRANSACTION_CURRENCY =
        new GLAccountLineItemField<BigDecimal>("AmountInTransactionCurrency");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCodeCurrency</b>
     * </p>
     *
     * @return Company Code Currency
     */
    @SerializedName( "CompanyCodeCurrency" )
    @JsonProperty( "CompanyCodeCurrency" )
    @Nullable
    @ODataField( odataName = "CompanyCodeCurrency" )
    private String companyCodeCurrency;
    /**
     * Use with available fluent helpers to apply the <b>CompanyCodeCurrency</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<String> COMPANY_CODE_CURRENCY =
        new GLAccountLineItemField<String>("CompanyCodeCurrency");
    /**
     * Constraints: Not nullable, Precision: 23, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>AmountInCompanyCodeCurrency</b>
     * </p>
     *
     * @return Amount in Company Code Currency
     */
    @SerializedName( "AmountInCompanyCodeCurrency" )
    @JsonProperty( "AmountInCompanyCodeCurrency" )
    @Nullable
    @ODataField( odataName = "AmountInCompanyCodeCurrency" )
    private BigDecimal amountInCompanyCodeCurrency;
    /**
     * Use with available fluent helpers to apply the <b>AmountInCompanyCodeCurrency</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<BigDecimal> AMOUNT_IN_COMPANY_CODE_CURRENCY =
        new GLAccountLineItemField<BigDecimal>("AmountInCompanyCodeCurrency");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>GlobalCurrency</b>
     * </p>
     *
     * @return Global Currency
     */
    @SerializedName( "GlobalCurrency" )
    @JsonProperty( "GlobalCurrency" )
    @Nullable
    @ODataField( odataName = "GlobalCurrency" )
    private String globalCurrency;
    /**
     * Use with available fluent helpers to apply the <b>GlobalCurrency</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<String> GLOBAL_CURRENCY =
        new GLAccountLineItemField<String>("GlobalCurrency");
    /**
     * Constraints: Not nullable, Precision: 23, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>AmountInGlobalCurrency</b>
     * </p>
     *
     * @return Amount in Global Currency
     */
    @SerializedName( "AmountInGlobalCurrency" )
    @JsonProperty( "AmountInGlobalCurrency" )
    @Nullable
    @ODataField( odataName = "AmountInGlobalCurrency" )
    private BigDecimal amountInGlobalCurrency;
    /**
     * Use with available fluent helpers to apply the <b>AmountInGlobalCurrency</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<BigDecimal> AMOUNT_IN_GLOBAL_CURRENCY =
        new GLAccountLineItemField<BigDecimal>("AmountInGlobalCurrency");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>FreeDefinedCurrency1</b>
     * </p>
     *
     * @return Freely Defined Currency 1
     */
    @SerializedName( "FreeDefinedCurrency1" )
    @JsonProperty( "FreeDefinedCurrency1" )
    @Nullable
    @ODataField( odataName = "FreeDefinedCurrency1" )
    private String freeDefinedCurrency1;
    /**
     * Use with available fluent helpers to apply the <b>FreeDefinedCurrency1</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<String> FREE_DEFINED_CURRENCY1 =
        new GLAccountLineItemField<String>("FreeDefinedCurrency1");
    /**
     * Constraints: Not nullable, Precision: 23, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>AmountInFreeDefinedCurrency1</b>
     * </p>
     *
     * @return Amount in Freely Defined Currency 1
     */
    @SerializedName( "AmountInFreeDefinedCurrency1" )
    @JsonProperty( "AmountInFreeDefinedCurrency1" )
    @Nullable
    @ODataField( odataName = "AmountInFreeDefinedCurrency1" )
    private BigDecimal amountInFreeDefinedCurrency1;
    /**
     * Use with available fluent helpers to apply the <b>AmountInFreeDefinedCurrency1</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<BigDecimal> AMOUNT_IN_FREE_DEFINED_CURRENCY1 =
        new GLAccountLineItemField<BigDecimal>("AmountInFreeDefinedCurrency1");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>FreeDefinedCurrency2</b>
     * </p>
     *
     * @return Freely Defined Currency 2
     */
    @SerializedName( "FreeDefinedCurrency2" )
    @JsonProperty( "FreeDefinedCurrency2" )
    @Nullable
    @ODataField( odataName = "FreeDefinedCurrency2" )
    private String freeDefinedCurrency2;
    /**
     * Use with available fluent helpers to apply the <b>FreeDefinedCurrency2</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<String> FREE_DEFINED_CURRENCY2 =
        new GLAccountLineItemField<String>("FreeDefinedCurrency2");
    /**
     * Constraints: Not nullable, Precision: 23, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>AmountInFreeDefinedCurrency2</b>
     * </p>
     *
     * @return Amount in Freely Defined Currency 2
     */
    @SerializedName( "AmountInFreeDefinedCurrency2" )
    @JsonProperty( "AmountInFreeDefinedCurrency2" )
    @Nullable
    @ODataField( odataName = "AmountInFreeDefinedCurrency2" )
    private BigDecimal amountInFreeDefinedCurrency2;
    /**
     * Use with available fluent helpers to apply the <b>AmountInFreeDefinedCurrency2</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<BigDecimal> AMOUNT_IN_FREE_DEFINED_CURRENCY2 =
        new GLAccountLineItemField<BigDecimal>("AmountInFreeDefinedCurrency2");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>FreeDefinedCurrency3</b>
     * </p>
     *
     * @return Freely Defined Currency 3
     */
    @SerializedName( "FreeDefinedCurrency3" )
    @JsonProperty( "FreeDefinedCurrency3" )
    @Nullable
    @ODataField( odataName = "FreeDefinedCurrency3" )
    private String freeDefinedCurrency3;
    /**
     * Use with available fluent helpers to apply the <b>FreeDefinedCurrency3</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<String> FREE_DEFINED_CURRENCY3 =
        new GLAccountLineItemField<String>("FreeDefinedCurrency3");
    /**
     * Constraints: Not nullable, Precision: 23, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>AmountInFreeDefinedCurrency3</b>
     * </p>
     *
     * @return Amount in Freely Defined Currency 3
     */
    @SerializedName( "AmountInFreeDefinedCurrency3" )
    @JsonProperty( "AmountInFreeDefinedCurrency3" )
    @Nullable
    @ODataField( odataName = "AmountInFreeDefinedCurrency3" )
    private BigDecimal amountInFreeDefinedCurrency3;
    /**
     * Use with available fluent helpers to apply the <b>AmountInFreeDefinedCurrency3</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<BigDecimal> AMOUNT_IN_FREE_DEFINED_CURRENCY3 =
        new GLAccountLineItemField<BigDecimal>("AmountInFreeDefinedCurrency3");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>FreeDefinedCurrency4</b>
     * </p>
     *
     * @return Freely Defined Currency 4
     */
    @SerializedName( "FreeDefinedCurrency4" )
    @JsonProperty( "FreeDefinedCurrency4" )
    @Nullable
    @ODataField( odataName = "FreeDefinedCurrency4" )
    private String freeDefinedCurrency4;
    /**
     * Use with available fluent helpers to apply the <b>FreeDefinedCurrency4</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<String> FREE_DEFINED_CURRENCY4 =
        new GLAccountLineItemField<String>("FreeDefinedCurrency4");
    /**
     * Constraints: Not nullable, Precision: 23, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>AmountInFreeDefinedCurrency4</b>
     * </p>
     *
     * @return Amount in Freely Defined Currency 4
     */
    @SerializedName( "AmountInFreeDefinedCurrency4" )
    @JsonProperty( "AmountInFreeDefinedCurrency4" )
    @Nullable
    @ODataField( odataName = "AmountInFreeDefinedCurrency4" )
    private BigDecimal amountInFreeDefinedCurrency4;
    /**
     * Use with available fluent helpers to apply the <b>AmountInFreeDefinedCurrency4</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<BigDecimal> AMOUNT_IN_FREE_DEFINED_CURRENCY4 =
        new GLAccountLineItemField<BigDecimal>("AmountInFreeDefinedCurrency4");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>FreeDefinedCurrency5</b>
     * </p>
     *
     * @return Freely Defined Currency 5
     */
    @SerializedName( "FreeDefinedCurrency5" )
    @JsonProperty( "FreeDefinedCurrency5" )
    @Nullable
    @ODataField( odataName = "FreeDefinedCurrency5" )
    private String freeDefinedCurrency5;
    /**
     * Use with available fluent helpers to apply the <b>FreeDefinedCurrency5</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<String> FREE_DEFINED_CURRENCY5 =
        new GLAccountLineItemField<String>("FreeDefinedCurrency5");
    /**
     * Constraints: Not nullable, Precision: 23, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>AmountInFreeDefinedCurrency5</b>
     * </p>
     *
     * @return Amount in Freely Defined Currency 5
     */
    @SerializedName( "AmountInFreeDefinedCurrency5" )
    @JsonProperty( "AmountInFreeDefinedCurrency5" )
    @Nullable
    @ODataField( odataName = "AmountInFreeDefinedCurrency5" )
    private BigDecimal amountInFreeDefinedCurrency5;
    /**
     * Use with available fluent helpers to apply the <b>AmountInFreeDefinedCurrency5</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<BigDecimal> AMOUNT_IN_FREE_DEFINED_CURRENCY5 =
        new GLAccountLineItemField<BigDecimal>("AmountInFreeDefinedCurrency5");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>FreeDefinedCurrency6</b>
     * </p>
     *
     * @return Freely Defined Currency 6
     */
    @SerializedName( "FreeDefinedCurrency6" )
    @JsonProperty( "FreeDefinedCurrency6" )
    @Nullable
    @ODataField( odataName = "FreeDefinedCurrency6" )
    private String freeDefinedCurrency6;
    /**
     * Use with available fluent helpers to apply the <b>FreeDefinedCurrency6</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<String> FREE_DEFINED_CURRENCY6 =
        new GLAccountLineItemField<String>("FreeDefinedCurrency6");
    /**
     * Constraints: Not nullable, Precision: 23, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>AmountInFreeDefinedCurrency6</b>
     * </p>
     *
     * @return Amount in Freely Defined Currency 6
     */
    @SerializedName( "AmountInFreeDefinedCurrency6" )
    @JsonProperty( "AmountInFreeDefinedCurrency6" )
    @Nullable
    @ODataField( odataName = "AmountInFreeDefinedCurrency6" )
    private BigDecimal amountInFreeDefinedCurrency6;
    /**
     * Use with available fluent helpers to apply the <b>AmountInFreeDefinedCurrency6</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<BigDecimal> AMOUNT_IN_FREE_DEFINED_CURRENCY6 =
        new GLAccountLineItemField<BigDecimal>("AmountInFreeDefinedCurrency6");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>FreeDefinedCurrency7</b>
     * </p>
     *
     * @return Freely Defined Currency 7
     */
    @SerializedName( "FreeDefinedCurrency7" )
    @JsonProperty( "FreeDefinedCurrency7" )
    @Nullable
    @ODataField( odataName = "FreeDefinedCurrency7" )
    private String freeDefinedCurrency7;
    /**
     * Use with available fluent helpers to apply the <b>FreeDefinedCurrency7</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<String> FREE_DEFINED_CURRENCY7 =
        new GLAccountLineItemField<String>("FreeDefinedCurrency7");
    /**
     * Constraints: Not nullable, Precision: 23, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>AmountInFreeDefinedCurrency7</b>
     * </p>
     *
     * @return Amount in Freely Defined Currency 7
     */
    @SerializedName( "AmountInFreeDefinedCurrency7" )
    @JsonProperty( "AmountInFreeDefinedCurrency7" )
    @Nullable
    @ODataField( odataName = "AmountInFreeDefinedCurrency7" )
    private BigDecimal amountInFreeDefinedCurrency7;
    /**
     * Use with available fluent helpers to apply the <b>AmountInFreeDefinedCurrency7</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<BigDecimal> AMOUNT_IN_FREE_DEFINED_CURRENCY7 =
        new GLAccountLineItemField<BigDecimal>("AmountInFreeDefinedCurrency7");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>FreeDefinedCurrency8</b>
     * </p>
     *
     * @return Freely Defined Currency 8
     */
    @SerializedName( "FreeDefinedCurrency8" )
    @JsonProperty( "FreeDefinedCurrency8" )
    @Nullable
    @ODataField( odataName = "FreeDefinedCurrency8" )
    private String freeDefinedCurrency8;
    /**
     * Use with available fluent helpers to apply the <b>FreeDefinedCurrency8</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<String> FREE_DEFINED_CURRENCY8 =
        new GLAccountLineItemField<String>("FreeDefinedCurrency8");
    /**
     * Constraints: Not nullable, Precision: 23, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>AmountInFreeDefinedCurrency8</b>
     * </p>
     *
     * @return Amount in Freely Defined Currency 8
     */
    @SerializedName( "AmountInFreeDefinedCurrency8" )
    @JsonProperty( "AmountInFreeDefinedCurrency8" )
    @Nullable
    @ODataField( odataName = "AmountInFreeDefinedCurrency8" )
    private BigDecimal amountInFreeDefinedCurrency8;
    /**
     * Use with available fluent helpers to apply the <b>AmountInFreeDefinedCurrency8</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<BigDecimal> AMOUNT_IN_FREE_DEFINED_CURRENCY8 =
        new GLAccountLineItemField<BigDecimal>("AmountInFreeDefinedCurrency8");
    /**
     * Constraints: Not nullable, Precision: 23, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>FixedAmountInGlobalCrcy</b>
     * </p>
     *
     * @return Fixed Amount in Global Currency
     */
    @SerializedName( "FixedAmountInGlobalCrcy" )
    @JsonProperty( "FixedAmountInGlobalCrcy" )
    @Nullable
    @ODataField( odataName = "FixedAmountInGlobalCrcy" )
    private BigDecimal fixedAmountInGlobalCrcy;
    /**
     * Use with available fluent helpers to apply the <b>FixedAmountInGlobalCrcy</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<BigDecimal> FIXED_AMOUNT_IN_GLOBAL_CRCY =
        new GLAccountLineItemField<BigDecimal>("FixedAmountInGlobalCrcy");
    /**
     * Constraints: Not nullable, Precision: 23, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>GrpValnFixedAmtInGlobCrcy</b>
     * </p>
     *
     * @return Group Valuation Fixed Amount in Global Currency
     */
    @SerializedName( "GrpValnFixedAmtInGlobCrcy" )
    @JsonProperty( "GrpValnFixedAmtInGlobCrcy" )
    @Nullable
    @ODataField( odataName = "GrpValnFixedAmtInGlobCrcy" )
    private BigDecimal grpValnFixedAmtInGlobCrcy;
    /**
     * Use with available fluent helpers to apply the <b>GrpValnFixedAmtInGlobCrcy</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<BigDecimal> GRP_VALN_FIXED_AMT_IN_GLOB_CRCY =
        new GLAccountLineItemField<BigDecimal>("GrpValnFixedAmtInGlobCrcy");
    /**
     * Constraints: Not nullable, Precision: 23, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>PrftCtrValnFxdAmtInGlobCrcy</b>
     * </p>
     *
     * @return Profit Center Valuation Fixed Amount in Global Currency
     */
    @SerializedName( "PrftCtrValnFxdAmtInGlobCrcy" )
    @JsonProperty( "PrftCtrValnFxdAmtInGlobCrcy" )
    @Nullable
    @ODataField( odataName = "PrftCtrValnFxdAmtInGlobCrcy" )
    private BigDecimal prftCtrValnFxdAmtInGlobCrcy;
    /**
     * Use with available fluent helpers to apply the <b>PrftCtrValnFxdAmtInGlobCrcy</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<BigDecimal> PRFT_CTR_VALN_FXD_AMT_IN_GLOB_CRCY =
        new GLAccountLineItemField<BigDecimal>("PrftCtrValnFxdAmtInGlobCrcy");
    /**
     * Constraints: Not nullable, Precision: 23, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>TotalPriceVarcInGlobalCrcy</b>
     * </p>
     *
     * @return Total Price Variance in Global Currency
     */
    @SerializedName( "TotalPriceVarcInGlobalCrcy" )
    @JsonProperty( "TotalPriceVarcInGlobalCrcy" )
    @Nullable
    @ODataField( odataName = "TotalPriceVarcInGlobalCrcy" )
    private BigDecimal totalPriceVarcInGlobalCrcy;
    /**
     * Use with available fluent helpers to apply the <b>TotalPriceVarcInGlobalCrcy</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<BigDecimal> TOTAL_PRICE_VARC_IN_GLOBAL_CRCY =
        new GLAccountLineItemField<BigDecimal>("TotalPriceVarcInGlobalCrcy");
    /**
     * Constraints: Not nullable, Precision: 23, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>GrpValnTotPrcVarcInGlobCrcy</b>
     * </p>
     *
     * @return Group Valuation Total Price Variance in Global Currency
     */
    @SerializedName( "GrpValnTotPrcVarcInGlobCrcy" )
    @JsonProperty( "GrpValnTotPrcVarcInGlobCrcy" )
    @Nullable
    @ODataField( odataName = "GrpValnTotPrcVarcInGlobCrcy" )
    private BigDecimal grpValnTotPrcVarcInGlobCrcy;
    /**
     * Use with available fluent helpers to apply the <b>GrpValnTotPrcVarcInGlobCrcy</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<BigDecimal> GRP_VALN_TOT_PRC_VARC_IN_GLOB_CRCY =
        new GLAccountLineItemField<BigDecimal>("GrpValnTotPrcVarcInGlobCrcy");
    /**
     * Constraints: Not nullable, Precision: 23, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>PrftCtrValnTotPrcVarcInGlbCrcy</b>
     * </p>
     *
     * @return Profit Center Valuation Total Price Variance in Global Cur.
     */
    @SerializedName( "PrftCtrValnTotPrcVarcInGlbCrcy" )
    @JsonProperty( "PrftCtrValnTotPrcVarcInGlbCrcy" )
    @Nullable
    @ODataField( odataName = "PrftCtrValnTotPrcVarcInGlbCrcy" )
    private BigDecimal prftCtrValnTotPrcVarcInGlbCrcy;
    /**
     * Use with available fluent helpers to apply the <b>PrftCtrValnTotPrcVarcInGlbCrcy</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<BigDecimal> PRFT_CTR_VALN_TOT_PRC_VARC_IN_GLB_CRCY =
        new GLAccountLineItemField<BigDecimal>("PrftCtrValnTotPrcVarcInGlbCrcy");
    /**
     * Constraints: Not nullable, Precision: 23, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>FixedPriceVarcInGlobalCrcy</b>
     * </p>
     *
     * @return Fixed Price Variance in Global Currency
     */
    @SerializedName( "FixedPriceVarcInGlobalCrcy" )
    @JsonProperty( "FixedPriceVarcInGlobalCrcy" )
    @Nullable
    @ODataField( odataName = "FixedPriceVarcInGlobalCrcy" )
    private BigDecimal fixedPriceVarcInGlobalCrcy;
    /**
     * Use with available fluent helpers to apply the <b>FixedPriceVarcInGlobalCrcy</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<BigDecimal> FIXED_PRICE_VARC_IN_GLOBAL_CRCY =
        new GLAccountLineItemField<BigDecimal>("FixedPriceVarcInGlobalCrcy");
    /**
     * Constraints: Not nullable, Precision: 23, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>GrpValnFixedPrcVarcInGlobCrcy</b>
     * </p>
     *
     * @return Group Valuation Fixed Price Variance in Global Currency
     */
    @SerializedName( "GrpValnFixedPrcVarcInGlobCrcy" )
    @JsonProperty( "GrpValnFixedPrcVarcInGlobCrcy" )
    @Nullable
    @ODataField( odataName = "GrpValnFixedPrcVarcInGlobCrcy" )
    private BigDecimal grpValnFixedPrcVarcInGlobCrcy;
    /**
     * Use with available fluent helpers to apply the <b>GrpValnFixedPrcVarcInGlobCrcy</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<BigDecimal> GRP_VALN_FIXED_PRC_VARC_IN_GLOB_CRCY =
        new GLAccountLineItemField<BigDecimal>("GrpValnFixedPrcVarcInGlobCrcy");
    /**
     * Constraints: Not nullable, Precision: 23, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>PrftCtrValnFxdPrcVarcInGlbCrcy</b>
     * </p>
     *
     * @return Profit Center Valuation Fixed Price Variance in Global Cur.
     */
    @SerializedName( "PrftCtrValnFxdPrcVarcInGlbCrcy" )
    @JsonProperty( "PrftCtrValnFxdPrcVarcInGlbCrcy" )
    @Nullable
    @ODataField( odataName = "PrftCtrValnFxdPrcVarcInGlbCrcy" )
    private BigDecimal prftCtrValnFxdPrcVarcInGlbCrcy;
    /**
     * Use with available fluent helpers to apply the <b>PrftCtrValnFxdPrcVarcInGlbCrcy</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<BigDecimal> PRFT_CTR_VALN_FXD_PRC_VARC_IN_GLB_CRCY =
        new GLAccountLineItemField<BigDecimal>("PrftCtrValnFxdPrcVarcInGlbCrcy");
    /**
     * Constraints: Not nullable, Precision: 23, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>FixedAmountInCoCodeCrcy</b>
     * </p>
     *
     * @return Fixed Amount in Company Currency
     */
    @SerializedName( "FixedAmountInCoCodeCrcy" )
    @JsonProperty( "FixedAmountInCoCodeCrcy" )
    @Nullable
    @ODataField( odataName = "FixedAmountInCoCodeCrcy" )
    private BigDecimal fixedAmountInCoCodeCrcy;
    /**
     * Use with available fluent helpers to apply the <b>FixedAmountInCoCodeCrcy</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<BigDecimal> FIXED_AMOUNT_IN_CO_CODE_CRCY =
        new GLAccountLineItemField<BigDecimal>("FixedAmountInCoCodeCrcy");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>ControllingObjectCurrency</b>
     * </p>
     *
     * @return CO Object Currency
     */
    @SerializedName( "ControllingObjectCurrency" )
    @JsonProperty( "ControllingObjectCurrency" )
    @Nullable
    @ODataField( odataName = "ControllingObjectCurrency" )
    private String controllingObjectCurrency;
    /**
     * Use with available fluent helpers to apply the <b>ControllingObjectCurrency</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<String> CONTROLLING_OBJECT_CURRENCY =
        new GLAccountLineItemField<String>("ControllingObjectCurrency");
    /**
     * Constraints: Not nullable, Precision: 23, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>AmountInObjectCurrency</b>
     * </p>
     *
     * @return Amount in Object Currency
     */
    @SerializedName( "AmountInObjectCurrency" )
    @JsonProperty( "AmountInObjectCurrency" )
    @Nullable
    @ODataField( odataName = "AmountInObjectCurrency" )
    private BigDecimal amountInObjectCurrency;
    /**
     * Use with available fluent helpers to apply the <b>AmountInObjectCurrency</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<BigDecimal> AMOUNT_IN_OBJECT_CURRENCY =
        new GLAccountLineItemField<BigDecimal>("AmountInObjectCurrency");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BaseUnit</b>
     * </p>
     *
     * @return Base Unit of Measure
     */
    @SerializedName( "BaseUnit" )
    @JsonProperty( "BaseUnit" )
    @Nullable
    @ODataField( odataName = "BaseUnit" )
    private String baseUnit;
    /**
     * Use with available fluent helpers to apply the <b>BaseUnit</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<String> BASE_UNIT = new GLAccountLineItemField<String>("BaseUnit");
    /**
     * Constraints: Not nullable, Precision: 23, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>Quantity</b>
     * </p>
     *
     * @return Quantity
     */
    @SerializedName( "Quantity" )
    @JsonProperty( "Quantity" )
    @Nullable
    @ODataField( odataName = "Quantity" )
    private BigDecimal quantity;
    /**
     * Use with available fluent helpers to apply the <b>Quantity</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<BigDecimal> QUANTITY =
        new GLAccountLineItemField<BigDecimal>("Quantity");
    /**
     * Constraints: Not nullable, Precision: 23, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>FixedQuantity</b>
     * </p>
     *
     * @return Fixed Quantity
     */
    @SerializedName( "FixedQuantity" )
    @JsonProperty( "FixedQuantity" )
    @Nullable
    @ODataField( odataName = "FixedQuantity" )
    private BigDecimal fixedQuantity;
    /**
     * Use with available fluent helpers to apply the <b>FixedQuantity</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<BigDecimal> FIXED_QUANTITY =
        new GLAccountLineItemField<BigDecimal>("FixedQuantity");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>CostSourceUnit</b>
     * </p>
     *
     * @return Cost Source Unit
     */
    @SerializedName( "CostSourceUnit" )
    @JsonProperty( "CostSourceUnit" )
    @Nullable
    @ODataField( odataName = "CostSourceUnit" )
    private String costSourceUnit;
    /**
     * Use with available fluent helpers to apply the <b>CostSourceUnit</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<String> COST_SOURCE_UNIT =
        new GLAccountLineItemField<String>("CostSourceUnit");
    /**
     * Constraints: Not nullable, Precision: 23, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ValuationQuantity</b>
     * </p>
     *
     * @return Valuation Quantity
     */
    @SerializedName( "ValuationQuantity" )
    @JsonProperty( "ValuationQuantity" )
    @Nullable
    @ODataField( odataName = "ValuationQuantity" )
    private BigDecimal valuationQuantity;
    /**
     * Use with available fluent helpers to apply the <b>ValuationQuantity</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<BigDecimal> VALUATION_QUANTITY =
        new GLAccountLineItemField<BigDecimal>("ValuationQuantity");
    /**
     * Constraints: Not nullable, Precision: 23, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ValuationFixedQuantity</b>
     * </p>
     *
     * @return Valuation Fixed Quantity
     */
    @SerializedName( "ValuationFixedQuantity" )
    @JsonProperty( "ValuationFixedQuantity" )
    @Nullable
    @ODataField( odataName = "ValuationFixedQuantity" )
    private BigDecimal valuationFixedQuantity;
    /**
     * Use with available fluent helpers to apply the <b>ValuationFixedQuantity</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<BigDecimal> VALUATION_FIXED_QUANTITY =
        new GLAccountLineItemField<BigDecimal>("ValuationFixedQuantity");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalQuantity1Unit</b>
     * </p>
     *
     * @return Additional Quantity 1 Unit
     */
    @SerializedName( "AdditionalQuantity1Unit" )
    @JsonProperty( "AdditionalQuantity1Unit" )
    @Nullable
    @ODataField( odataName = "AdditionalQuantity1Unit" )
    private String additionalQuantity1Unit;
    /**
     * Use with available fluent helpers to apply the <b>AdditionalQuantity1Unit</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<String> ADDITIONAL_QUANTITY1_UNIT =
        new GLAccountLineItemField<String>("AdditionalQuantity1Unit");
    /**
     * Constraints: Not nullable, Precision: 23, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalQuantity1</b>
     * </p>
     *
     * @return Additional Quantity 1
     */
    @SerializedName( "AdditionalQuantity1" )
    @JsonProperty( "AdditionalQuantity1" )
    @Nullable
    @ODataField( odataName = "AdditionalQuantity1" )
    private BigDecimal additionalQuantity1;
    /**
     * Use with available fluent helpers to apply the <b>AdditionalQuantity1</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<BigDecimal> ADDITIONAL_QUANTITY1 =
        new GLAccountLineItemField<BigDecimal>("AdditionalQuantity1");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalQuantity2Unit</b>
     * </p>
     *
     * @return Additional Quantity 2 Unit
     */
    @SerializedName( "AdditionalQuantity2Unit" )
    @JsonProperty( "AdditionalQuantity2Unit" )
    @Nullable
    @ODataField( odataName = "AdditionalQuantity2Unit" )
    private String additionalQuantity2Unit;
    /**
     * Use with available fluent helpers to apply the <b>AdditionalQuantity2Unit</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<String> ADDITIONAL_QUANTITY2_UNIT =
        new GLAccountLineItemField<String>("AdditionalQuantity2Unit");
    /**
     * Constraints: Not nullable, Precision: 23, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalQuantity2</b>
     * </p>
     *
     * @return Additional Quantity 2
     */
    @SerializedName( "AdditionalQuantity2" )
    @JsonProperty( "AdditionalQuantity2" )
    @Nullable
    @ODataField( odataName = "AdditionalQuantity2" )
    private BigDecimal additionalQuantity2;
    /**
     * Use with available fluent helpers to apply the <b>AdditionalQuantity2</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<BigDecimal> ADDITIONAL_QUANTITY2 =
        new GLAccountLineItemField<BigDecimal>("AdditionalQuantity2");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalQuantity3Unit</b>
     * </p>
     *
     * @return Additional Quantity 3 Unit
     */
    @SerializedName( "AdditionalQuantity3Unit" )
    @JsonProperty( "AdditionalQuantity3Unit" )
    @Nullable
    @ODataField( odataName = "AdditionalQuantity3Unit" )
    private String additionalQuantity3Unit;
    /**
     * Use with available fluent helpers to apply the <b>AdditionalQuantity3Unit</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<String> ADDITIONAL_QUANTITY3_UNIT =
        new GLAccountLineItemField<String>("AdditionalQuantity3Unit");
    /**
     * Constraints: Not nullable, Precision: 23, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalQuantity3</b>
     * </p>
     *
     * @return Additional Quantity 3
     */
    @SerializedName( "AdditionalQuantity3" )
    @JsonProperty( "AdditionalQuantity3" )
    @Nullable
    @ODataField( odataName = "AdditionalQuantity3" )
    private BigDecimal additionalQuantity3;
    /**
     * Use with available fluent helpers to apply the <b>AdditionalQuantity3</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<BigDecimal> ADDITIONAL_QUANTITY3 =
        new GLAccountLineItemField<BigDecimal>("AdditionalQuantity3");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>DebitCreditCode</b>
     * </p>
     *
     * @return Debit/Credit Code
     */
    @SerializedName( "DebitCreditCode" )
    @JsonProperty( "DebitCreditCode" )
    @Nullable
    @ODataField( odataName = "DebitCreditCode" )
    private String debitCreditCode;
    /**
     * Use with available fluent helpers to apply the <b>DebitCreditCode</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<String> DEBIT_CREDIT_CODE =
        new GLAccountLineItemField<String>("DebitCreditCode");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>FiscalPeriod</b>
     * </p>
     *
     * @return Fiscal Period
     */
    @SerializedName( "FiscalPeriod" )
    @JsonProperty( "FiscalPeriod" )
    @Nullable
    @ODataField( odataName = "FiscalPeriod" )
    private String fiscalPeriod;
    /**
     * Use with available fluent helpers to apply the <b>FiscalPeriod</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<String> FISCAL_PERIOD =
        new GLAccountLineItemField<String>("FiscalPeriod");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>FiscalYearVariant</b>
     * </p>
     *
     * @return Fiscal Year Variant
     */
    @SerializedName( "FiscalYearVariant" )
    @JsonProperty( "FiscalYearVariant" )
    @Nullable
    @ODataField( odataName = "FiscalYearVariant" )
    private String fiscalYearVariant;
    /**
     * Use with available fluent helpers to apply the <b>FiscalYearVariant</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<String> FISCAL_YEAR_VARIANT =
        new GLAccountLineItemField<String>("FiscalYearVariant");
    /**
     * Constraints: Not nullable, Maximum length: 7
     * <p>
     * Original property name from the Odata EDM: <b>FiscalYearPeriod</b>
     * </p>
     *
     * @return Fiscal Year Period
     */
    @SerializedName( "FiscalYearPeriod" )
    @JsonProperty( "FiscalYearPeriod" )
    @Nullable
    @ODataField( odataName = "FiscalYearPeriod" )
    private String fiscalYearPeriod;
    /**
     * Use with available fluent helpers to apply the <b>FiscalYearPeriod</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<String> FISCAL_YEAR_PERIOD =
        new GLAccountLineItemField<String>("FiscalYearPeriod");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>PostingDate</b>
     * </p>
     *
     * @return Posting Date
     */
    @SerializedName( "PostingDate" )
    @JsonProperty( "PostingDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "PostingDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime postingDate;
    /**
     * Use with available fluent helpers to apply the <b>PostingDate</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<LocalDateTime> POSTING_DATE =
        new GLAccountLineItemField<LocalDateTime>("PostingDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>DocumentDate</b>
     * </p>
     *
     * @return Journal Entry Date
     */
    @SerializedName( "DocumentDate" )
    @JsonProperty( "DocumentDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "DocumentDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime documentDate;
    /**
     * Use with available fluent helpers to apply the <b>DocumentDate</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<LocalDateTime> DOCUMENT_DATE =
        new GLAccountLineItemField<LocalDateTime>("DocumentDate");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>AccountingDocumentType</b>
     * </p>
     *
     * @return Journal Entry Type
     */
    @SerializedName( "AccountingDocumentType" )
    @JsonProperty( "AccountingDocumentType" )
    @Nullable
    @ODataField( odataName = "AccountingDocumentType" )
    private String accountingDocumentType;
    /**
     * Use with available fluent helpers to apply the <b>AccountingDocumentType</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<String> ACCOUNTING_DOCUMENT_TYPE =
        new GLAccountLineItemField<String>("AccountingDocumentType");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>AccountingDocumentItem</b>
     * </p>
     *
     * @return Journal Entry Posting View Item
     */
    @SerializedName( "AccountingDocumentItem" )
    @JsonProperty( "AccountingDocumentItem" )
    @Nullable
    @ODataField( odataName = "AccountingDocumentItem" )
    private String accountingDocumentItem;
    /**
     * Use with available fluent helpers to apply the <b>AccountingDocumentItem</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<String> ACCOUNTING_DOCUMENT_ITEM =
        new GLAccountLineItemField<String>("AccountingDocumentItem");
    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>AssignmentReference</b>
     * </p>
     *
     * @return Assignment Reference
     */
    @SerializedName( "AssignmentReference" )
    @JsonProperty( "AssignmentReference" )
    @Nullable
    @ODataField( odataName = "AssignmentReference" )
    private String assignmentReference;
    /**
     * Use with available fluent helpers to apply the <b>AssignmentReference</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<String> ASSIGNMENT_REFERENCE =
        new GLAccountLineItemField<String>("AssignmentReference");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>AccountingDocumentCategory</b>
     * </p>
     *
     * @return Journal Entry Category
     */
    @SerializedName( "AccountingDocumentCategory" )
    @JsonProperty( "AccountingDocumentCategory" )
    @Nullable
    @ODataField( odataName = "AccountingDocumentCategory" )
    private String accountingDocumentCategory;
    /**
     * Use with available fluent helpers to apply the <b>AccountingDocumentCategory</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<String> ACCOUNTING_DOCUMENT_CATEGORY =
        new GLAccountLineItemField<String>("AccountingDocumentCategory");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>PostingKey</b>
     * </p>
     *
     * @return Posting Key
     */
    @SerializedName( "PostingKey" )
    @JsonProperty( "PostingKey" )
    @Nullable
    @ODataField( odataName = "PostingKey" )
    private String postingKey;
    /**
     * Use with available fluent helpers to apply the <b>PostingKey</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<String> POSTING_KEY = new GLAccountLineItemField<String>("PostingKey");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>TransactionTypeDetermination</b>
     * </p>
     *
     * @return Transaction Key
     */
    @SerializedName( "TransactionTypeDetermination" )
    @JsonProperty( "TransactionTypeDetermination" )
    @Nullable
    @ODataField( odataName = "TransactionTypeDetermination" )
    private String transactionTypeDetermination;
    /**
     * Use with available fluent helpers to apply the <b>TransactionTypeDetermination</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<String> TRANSACTION_TYPE_DETERMINATION =
        new GLAccountLineItemField<String>("TransactionTypeDetermination");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>SubLedgerAcctLineItemType</b>
     * </p>
     *
     * @return Subledger-Specific Line Item Type
     */
    @SerializedName( "SubLedgerAcctLineItemType" )
    @JsonProperty( "SubLedgerAcctLineItemType" )
    @Nullable
    @ODataField( odataName = "SubLedgerAcctLineItemType" )
    private String subLedgerAcctLineItemType;
    /**
     * Use with available fluent helpers to apply the <b>SubLedgerAcctLineItemType</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<String> SUB_LEDGER_ACCT_LINE_ITEM_TYPE =
        new GLAccountLineItemField<String>("SubLedgerAcctLineItemType");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>AccountingDocCreatedByUser</b>
     * </p>
     *
     * @return User that created the journal entry
     */
    @SerializedName( "AccountingDocCreatedByUser" )
    @JsonProperty( "AccountingDocCreatedByUser" )
    @Nullable
    @ODataField( odataName = "AccountingDocCreatedByUser" )
    private String accountingDocCreatedByUser;
    /**
     * Use with available fluent helpers to apply the <b>AccountingDocCreatedByUser</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<String> ACCOUNTING_DOC_CREATED_BY_USER =
        new GLAccountLineItemField<String>("AccountingDocCreatedByUser");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDateTime</b>
     * </p>
     *
     * @return Time Stamp of Last Change
     */
    @SerializedName( "LastChangeDateTime" )
    @JsonProperty( "LastChangeDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "LastChangeDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime lastChangeDateTime;
    /**
     * Use with available fluent helpers to apply the <b>LastChangeDateTime</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<ZonedDateTime> LAST_CHANGE_DATE_TIME =
        new GLAccountLineItemField<ZonedDateTime>("LastChangeDateTime");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationDateTime</b>
     * </p>
     *
     * @return Time Stamp of Creation
     */
    @SerializedName( "CreationDateTime" )
    @JsonProperty( "CreationDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "CreationDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime creationDateTime;
    /**
     * Use with available fluent helpers to apply the <b>CreationDateTime</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<ZonedDateTime> CREATION_DATE_TIME =
        new GLAccountLineItemField<ZonedDateTime>("CreationDateTime");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationDate</b>
     * </p>
     *
     * @return Creation Date
     */
    @SerializedName( "CreationDate" )
    @JsonProperty( "CreationDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "CreationDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime creationDate;
    /**
     * Use with available fluent helpers to apply the <b>CreationDate</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<LocalDateTime> CREATION_DATE =
        new GLAccountLineItemField<LocalDateTime>("CreationDate");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>EliminationProfitCenter</b>
     * </p>
     *
     * @return Elimination Profit Center
     */
    @SerializedName( "EliminationProfitCenter" )
    @JsonProperty( "EliminationProfitCenter" )
    @Nullable
    @ODataField( odataName = "EliminationProfitCenter" )
    private String eliminationProfitCenter;
    /**
     * Use with available fluent helpers to apply the <b>EliminationProfitCenter</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<String> ELIMINATION_PROFIT_CENTER =
        new GLAccountLineItemField<String>("EliminationProfitCenter");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>OriginObjectType</b>
     * </p>
     *
     * @return Type of Origin Object
     */
    @SerializedName( "OriginObjectType" )
    @JsonProperty( "OriginObjectType" )
    @Nullable
    @ODataField( odataName = "OriginObjectType" )
    private String originObjectType;
    /**
     * Use with available fluent helpers to apply the <b>OriginObjectType</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<String> ORIGIN_OBJECT_TYPE =
        new GLAccountLineItemField<String>("OriginObjectType");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>GLAccountType</b>
     * </p>
     *
     * @return Type of a General Ledger Account
     */
    @SerializedName( "GLAccountType" )
    @JsonProperty( "GLAccountType" )
    @Nullable
    @ODataField( odataName = "GLAccountType" )
    private String gLAccountType;
    /**
     * Use with available fluent helpers to apply the <b>GLAccountType</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<String> GL_ACCOUNT_TYPE =
        new GLAccountLineItemField<String>("GLAccountType");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>AlternativeGLAccount</b>
     * </p>
     *
     * @return Alternative G/L Account Number In Company Code
     */
    @SerializedName( "AlternativeGLAccount" )
    @JsonProperty( "AlternativeGLAccount" )
    @Nullable
    @ODataField( odataName = "AlternativeGLAccount" )
    private String alternativeGLAccount;
    /**
     * Use with available fluent helpers to apply the <b>AlternativeGLAccount</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<String> ALTERNATIVE_GL_ACCOUNT =
        new GLAccountLineItemField<String>("AlternativeGLAccount");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CountryChartOfAccounts</b>
     * </p>
     *
     * @return Alternative Chart of Accounts for Country/Region
     */
    @SerializedName( "CountryChartOfAccounts" )
    @JsonProperty( "CountryChartOfAccounts" )
    @Nullable
    @ODataField( odataName = "CountryChartOfAccounts" )
    private String countryChartOfAccounts;
    /**
     * Use with available fluent helpers to apply the <b>CountryChartOfAccounts</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<String> COUNTRY_CHART_OF_ACCOUNTS =
        new GLAccountLineItemField<String>("CountryChartOfAccounts");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ItemIsSplit</b>
     * </p>
     *
     * @return Item changed by document splitting
     */
    @SerializedName( "ItemIsSplit" )
    @JsonProperty( "ItemIsSplit" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "ItemIsSplit" )
    private Boolean itemIsSplit;
    /**
     * Use with available fluent helpers to apply the <b>ItemIsSplit</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<Boolean> ITEM_IS_SPLIT =
        new GLAccountLineItemField<Boolean>("ItemIsSplit");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>InvoiceReference</b>
     * </p>
     *
     * @return Invoice Reference
     */
    @SerializedName( "InvoiceReference" )
    @JsonProperty( "InvoiceReference" )
    @Nullable
    @ODataField( odataName = "InvoiceReference" )
    private String invoiceReference;
    /**
     * Use with available fluent helpers to apply the <b>InvoiceReference</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<String> INVOICE_REFERENCE =
        new GLAccountLineItemField<String>("InvoiceReference");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>InvoiceReferenceFiscalYear</b>
     * </p>
     *
     * @return Invoice Reference Fiscal Year
     */
    @SerializedName( "InvoiceReferenceFiscalYear" )
    @JsonProperty( "InvoiceReferenceFiscalYear" )
    @Nullable
    @ODataField( odataName = "InvoiceReferenceFiscalYear" )
    private String invoiceReferenceFiscalYear;
    /**
     * Use with available fluent helpers to apply the <b>InvoiceReferenceFiscalYear</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<String> INVOICE_REFERENCE_FISCAL_YEAR =
        new GLAccountLineItemField<String>("InvoiceReferenceFiscalYear");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>FollowOnDocumentType</b>
     * </p>
     *
     * @return Follow-On Document Type
     */
    @SerializedName( "FollowOnDocumentType" )
    @JsonProperty( "FollowOnDocumentType" )
    @Nullable
    @ODataField( odataName = "FollowOnDocumentType" )
    private String followOnDocumentType;
    /**
     * Use with available fluent helpers to apply the <b>FollowOnDocumentType</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<String> FOLLOW_ON_DOCUMENT_TYPE =
        new GLAccountLineItemField<String>("FollowOnDocumentType");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>InvoiceItemReference</b>
     * </p>
     *
     * @return Invoice Item Reference
     */
    @SerializedName( "InvoiceItemReference" )
    @JsonProperty( "InvoiceItemReference" )
    @Nullable
    @ODataField( odataName = "InvoiceItemReference" )
    private String invoiceItemReference;
    /**
     * Use with available fluent helpers to apply the <b>InvoiceItemReference</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<String> INVOICE_ITEM_REFERENCE =
        new GLAccountLineItemField<String>("InvoiceItemReference");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ReferencePurchaseOrderCategory</b>
     * </p>
     *
     * @return Category of Reference Purchase Order
     */
    @SerializedName( "ReferencePurchaseOrderCategory" )
    @JsonProperty( "ReferencePurchaseOrderCategory" )
    @Nullable
    @ODataField( odataName = "ReferencePurchaseOrderCategory" )
    private String referencePurchaseOrderCategory;
    /**
     * Use with available fluent helpers to apply the <b>ReferencePurchaseOrderCategory</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<String> REFERENCE_PURCHASE_ORDER_CATEGORY =
        new GLAccountLineItemField<String>("ReferencePurchaseOrderCategory");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingDocument</b>
     * </p>
     *
     * @return Purchasing Document
     */
    @SerializedName( "PurchasingDocument" )
    @JsonProperty( "PurchasingDocument" )
    @Nullable
    @ODataField( odataName = "PurchasingDocument" )
    private String purchasingDocument;
    /**
     * Use with available fluent helpers to apply the <b>PurchasingDocument</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<String> PURCHASING_DOCUMENT =
        new GLAccountLineItemField<String>("PurchasingDocument");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingDocumentItem</b>
     * </p>
     *
     * @return Purchasing Document Item
     */
    @SerializedName( "PurchasingDocumentItem" )
    @JsonProperty( "PurchasingDocumentItem" )
    @Nullable
    @ODataField( odataName = "PurchasingDocumentItem" )
    private String purchasingDocumentItem;
    /**
     * Use with available fluent helpers to apply the <b>PurchasingDocumentItem</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<String> PURCHASING_DOCUMENT_ITEM =
        new GLAccountLineItemField<String>("PurchasingDocumentItem");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>AccountAssignmentNumber</b>
     * </p>
     *
     * @return Account Assignment Number
     */
    @SerializedName( "AccountAssignmentNumber" )
    @JsonProperty( "AccountAssignmentNumber" )
    @Nullable
    @ODataField( odataName = "AccountAssignmentNumber" )
    private String accountAssignmentNumber;
    /**
     * Use with available fluent helpers to apply the <b>AccountAssignmentNumber</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<String> ACCOUNT_ASSIGNMENT_NUMBER =
        new GLAccountLineItemField<String>("AccountAssignmentNumber");
    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>DocumentItemText</b>
     * </p>
     *
     * @return Item Text
     */
    @SerializedName( "DocumentItemText" )
    @JsonProperty( "DocumentItemText" )
    @Nullable
    @ODataField( odataName = "DocumentItemText" )
    private String documentItemText;
    /**
     * Use with available fluent helpers to apply the <b>DocumentItemText</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<String> DOCUMENT_ITEM_TEXT =
        new GLAccountLineItemField<String>("DocumentItemText");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SalesDocument</b>
     * </p>
     *
     * @return Sales Document
     */
    @SerializedName( "SalesDocument" )
    @JsonProperty( "SalesDocument" )
    @Nullable
    @ODataField( odataName = "SalesDocument" )
    private String salesDocument;
    /**
     * Use with available fluent helpers to apply the <b>SalesDocument</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<String> SALES_DOCUMENT =
        new GLAccountLineItemField<String>("SalesDocument");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>SalesDocumentItem</b>
     * </p>
     *
     * @return Sales Document Item
     */
    @SerializedName( "SalesDocumentItem" )
    @JsonProperty( "SalesDocumentItem" )
    @Nullable
    @ODataField( odataName = "SalesDocumentItem" )
    private String salesDocumentItem;
    /**
     * Use with available fluent helpers to apply the <b>SalesDocumentItem</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<String> SALES_DOCUMENT_ITEM =
        new GLAccountLineItemField<String>("SalesDocumentItem");
    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>Product</b>
     * </p>
     *
     * @return Product Number
     */
    @SerializedName( "Product" )
    @JsonProperty( "Product" )
    @Nullable
    @ODataField( odataName = "Product" )
    private String product;
    /**
     * Use with available fluent helpers to apply the <b>Product</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<String> PRODUCT = new GLAccountLineItemField<String>("Product");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @return Plant
     */
    @SerializedName( "Plant" )
    @JsonProperty( "Plant" )
    @Nullable
    @ODataField( odataName = "Plant" )
    private String plant;
    /**
     * Use with available fluent helpers to apply the <b>Plant</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<String> PLANT = new GLAccountLineItemField<String>("Plant");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Supplier</b>
     * </p>
     *
     * @return Supplier
     */
    @SerializedName( "Supplier" )
    @JsonProperty( "Supplier" )
    @Nullable
    @ODataField( odataName = "Supplier" )
    private String supplier;
    /**
     * Use with available fluent helpers to apply the <b>Supplier</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<String> SUPPLIER = new GLAccountLineItemField<String>("Supplier");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Customer</b>
     * </p>
     *
     * @return Customer Number
     */
    @SerializedName( "Customer" )
    @JsonProperty( "Customer" )
    @Nullable
    @ODataField( odataName = "Customer" )
    private String customer;
    /**
     * Use with available fluent helpers to apply the <b>Customer</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<String> CUSTOMER = new GLAccountLineItemField<String>("Customer");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ServicesRenderedDate</b>
     * </p>
     *
     * @return Date on which services are rendered
     */
    @SerializedName( "ServicesRenderedDate" )
    @JsonProperty( "ServicesRenderedDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ServicesRenderedDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime servicesRenderedDate;
    /**
     * Use with available fluent helpers to apply the <b>ServicesRenderedDate</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<LocalDateTime> SERVICES_RENDERED_DATE =
        new GLAccountLineItemField<LocalDateTime>("ServicesRenderedDate");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ConditionContract</b>
     * </p>
     *
     * @return Condition Contract
     */
    @SerializedName( "ConditionContract" )
    @JsonProperty( "ConditionContract" )
    @Nullable
    @ODataField( odataName = "ConditionContract" )
    private String conditionContract;
    /**
     * Use with available fluent helpers to apply the <b>ConditionContract</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<String> CONDITION_CONTRACT =
        new GLAccountLineItemField<String>("ConditionContract");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>FinancialAccountType</b>
     * </p>
     *
     * @return Account Type
     */
    @SerializedName( "FinancialAccountType" )
    @JsonProperty( "FinancialAccountType" )
    @Nullable
    @ODataField( odataName = "FinancialAccountType" )
    private String financialAccountType;
    /**
     * Use with available fluent helpers to apply the <b>FinancialAccountType</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<String> FINANCIAL_ACCOUNT_TYPE =
        new GLAccountLineItemField<String>("FinancialAccountType");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>SpecialGLCode</b>
     * </p>
     *
     * @return Special G/L Indicator
     */
    @SerializedName( "SpecialGLCode" )
    @JsonProperty( "SpecialGLCode" )
    @Nullable
    @ODataField( odataName = "SpecialGLCode" )
    private String specialGLCode;
    /**
     * Use with available fluent helpers to apply the <b>SpecialGLCode</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<String> SPECIAL_GL_CODE =
        new GLAccountLineItemField<String>("SpecialGLCode");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>TaxCode</b>
     * </p>
     *
     * @return Tax on Sales/Purchases Code
     */
    @SerializedName( "TaxCode" )
    @JsonProperty( "TaxCode" )
    @Nullable
    @ODataField( odataName = "TaxCode" )
    private String taxCode;
    /**
     * Use with available fluent helpers to apply the <b>TaxCode</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<String> TAX_CODE = new GLAccountLineItemField<String>("TaxCode");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>HouseBank</b>
     * </p>
     *
     * @return House Bank Key
     */
    @SerializedName( "HouseBank" )
    @JsonProperty( "HouseBank" )
    @Nullable
    @ODataField( odataName = "HouseBank" )
    private String houseBank;
    /**
     * Use with available fluent helpers to apply the <b>HouseBank</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<String> HOUSE_BANK = new GLAccountLineItemField<String>("HouseBank");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>HouseBankAccount</b>
     * </p>
     *
     * @return House Bank Account
     */
    @SerializedName( "HouseBankAccount" )
    @JsonProperty( "HouseBankAccount" )
    @Nullable
    @ODataField( odataName = "HouseBankAccount" )
    private String houseBankAccount;
    /**
     * Use with available fluent helpers to apply the <b>HouseBankAccount</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<String> HOUSE_BANK_ACCOUNT =
        new GLAccountLineItemField<String>("HouseBankAccount");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>IsOpenItemManaged</b>
     * </p>
     *
     * @return Managed on an Open Item Basis
     */
    @SerializedName( "IsOpenItemManaged" )
    @JsonProperty( "IsOpenItemManaged" )
    @Nullable
    @ODataField( odataName = "IsOpenItemManaged" )
    private String isOpenItemManaged;
    /**
     * Use with available fluent helpers to apply the <b>IsOpenItemManaged</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<String> IS_OPEN_ITEM_MANAGED =
        new GLAccountLineItemField<String>("IsOpenItemManaged");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ClearingDate</b>
     * </p>
     *
     * @return Clearing Date
     */
    @SerializedName( "ClearingDate" )
    @JsonProperty( "ClearingDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ClearingDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime clearingDate;
    /**
     * Use with available fluent helpers to apply the <b>ClearingDate</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<LocalDateTime> CLEARING_DATE =
        new GLAccountLineItemField<LocalDateTime>("ClearingDate");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ClearingAccountingDocument</b>
     * </p>
     *
     * @return Clearing Journal Entry
     */
    @SerializedName( "ClearingAccountingDocument" )
    @JsonProperty( "ClearingAccountingDocument" )
    @Nullable
    @ODataField( odataName = "ClearingAccountingDocument" )
    private String clearingAccountingDocument;
    /**
     * Use with available fluent helpers to apply the <b>ClearingAccountingDocument</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<String> CLEARING_ACCOUNTING_DOCUMENT =
        new GLAccountLineItemField<String>("ClearingAccountingDocument");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ClearingDocFiscalYear</b>
     * </p>
     *
     * @return Fiscal Year of Clearing Journal Entry
     */
    @SerializedName( "ClearingDocFiscalYear" )
    @JsonProperty( "ClearingDocFiscalYear" )
    @Nullable
    @ODataField( odataName = "ClearingDocFiscalYear" )
    private String clearingDocFiscalYear;
    /**
     * Use with available fluent helpers to apply the <b>ClearingDocFiscalYear</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<String> CLEARING_DOC_FISCAL_YEAR =
        new GLAccountLineItemField<String>("ClearingDocFiscalYear");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValueDate</b>
     * </p>
     *
     * @return Value Date
     */
    @SerializedName( "ValueDate" )
    @JsonProperty( "ValueDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ValueDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime valueDate;
    /**
     * Use with available fluent helpers to apply the <b>ValueDate</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<LocalDateTime> VALUE_DATE =
        new GLAccountLineItemField<LocalDateTime>("ValueDate");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>AssetDepreciationArea</b>
     * </p>
     *
     * @return Asset Depreciation Area (Real or Derived)
     */
    @SerializedName( "AssetDepreciationArea" )
    @JsonProperty( "AssetDepreciationArea" )
    @Nullable
    @ODataField( odataName = "AssetDepreciationArea" )
    private String assetDepreciationArea;
    /**
     * Use with available fluent helpers to apply the <b>AssetDepreciationArea</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<String> ASSET_DEPRECIATION_AREA =
        new GLAccountLineItemField<String>("AssetDepreciationArea");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>MasterFixedAsset</b>
     * </p>
     *
     * @return Fixed Asset
     */
    @SerializedName( "MasterFixedAsset" )
    @JsonProperty( "MasterFixedAsset" )
    @Nullable
    @ODataField( odataName = "MasterFixedAsset" )
    private String masterFixedAsset;
    /**
     * Use with available fluent helpers to apply the <b>MasterFixedAsset</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<String> MASTER_FIXED_ASSET =
        new GLAccountLineItemField<String>("MasterFixedAsset");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>FixedAsset</b>
     * </p>
     *
     * @return Asset Subnumber
     */
    @SerializedName( "FixedAsset" )
    @JsonProperty( "FixedAsset" )
    @Nullable
    @ODataField( odataName = "FixedAsset" )
    private String fixedAsset;
    /**
     * Use with available fluent helpers to apply the <b>FixedAsset</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<String> FIXED_ASSET = new GLAccountLineItemField<String>("FixedAsset");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>AssetValueDate</b>
     * </p>
     *
     * @return Asset Value Date
     */
    @SerializedName( "AssetValueDate" )
    @JsonProperty( "AssetValueDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "AssetValueDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime assetValueDate;
    /**
     * Use with available fluent helpers to apply the <b>AssetValueDate</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<LocalDateTime> ASSET_VALUE_DATE =
        new GLAccountLineItemField<LocalDateTime>("AssetValueDate");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>AssetTransactionType</b>
     * </p>
     *
     * @return Asset Transaction Type
     */
    @SerializedName( "AssetTransactionType" )
    @JsonProperty( "AssetTransactionType" )
    @Nullable
    @ODataField( odataName = "AssetTransactionType" )
    private String assetTransactionType;
    /**
     * Use with available fluent helpers to apply the <b>AssetTransactionType</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<String> ASSET_TRANSACTION_TYPE =
        new GLAccountLineItemField<String>("AssetTransactionType");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>AssetAcctTransClassfctn</b>
     * </p>
     *
     * @return Transaction Type Category
     */
    @SerializedName( "AssetAcctTransClassfctn" )
    @JsonProperty( "AssetAcctTransClassfctn" )
    @Nullable
    @ODataField( odataName = "AssetAcctTransClassfctn" )
    private String assetAcctTransClassfctn;
    /**
     * Use with available fluent helpers to apply the <b>AssetAcctTransClassfctn</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<String> ASSET_ACCT_TRANS_CLASSFCTN =
        new GLAccountLineItemField<String>("AssetAcctTransClassfctn");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>DepreciationFiscalPeriod</b>
     * </p>
     *
     * @return Fiscal Period of Depreciation
     */
    @SerializedName( "DepreciationFiscalPeriod" )
    @JsonProperty( "DepreciationFiscalPeriod" )
    @Nullable
    @ODataField( odataName = "DepreciationFiscalPeriod" )
    private String depreciationFiscalPeriod;
    /**
     * Use with available fluent helpers to apply the <b>DepreciationFiscalPeriod</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<String> DEPRECIATION_FISCAL_PERIOD =
        new GLAccountLineItemField<String>("DepreciationFiscalPeriod");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>GroupMasterFixedAsset</b>
     * </p>
     *
     * @return Group Asset
     */
    @SerializedName( "GroupMasterFixedAsset" )
    @JsonProperty( "GroupMasterFixedAsset" )
    @Nullable
    @ODataField( odataName = "GroupMasterFixedAsset" )
    private String groupMasterFixedAsset;
    /**
     * Use with available fluent helpers to apply the <b>GroupMasterFixedAsset</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<String> GROUP_MASTER_FIXED_ASSET =
        new GLAccountLineItemField<String>("GroupMasterFixedAsset");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>GroupFixedAsset</b>
     * </p>
     *
     * @return Group Asset Subnumber
     */
    @SerializedName( "GroupFixedAsset" )
    @JsonProperty( "GroupFixedAsset" )
    @Nullable
    @ODataField( odataName = "GroupFixedAsset" )
    private String groupFixedAsset;
    /**
     * Use with available fluent helpers to apply the <b>GroupFixedAsset</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<String> GROUP_FIXED_ASSET =
        new GLAccountLineItemField<String>("GroupFixedAsset");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>AssetClass</b>
     * </p>
     *
     * @return Asset Class
     */
    @SerializedName( "AssetClass" )
    @JsonProperty( "AssetClass" )
    @Nullable
    @ODataField( odataName = "AssetClass" )
    private String assetClass;
    /**
     * Use with available fluent helpers to apply the <b>AssetClass</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<String> ASSET_CLASS = new GLAccountLineItemField<String>("AssetClass");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CostEstimate</b>
     * </p>
     *
     * @return Cost Estimate
     */
    @SerializedName( "CostEstimate" )
    @JsonProperty( "CostEstimate" )
    @Nullable
    @ODataField( odataName = "CostEstimate" )
    private String costEstimate;
    /**
     * Use with available fluent helpers to apply the <b>CostEstimate</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<String> COST_ESTIMATE =
        new GLAccountLineItemField<String>("CostEstimate");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InventorySpecialStockValnType</b>
     * </p>
     *
     * @return Inventory Special Stock Valuation Type
     */
    @SerializedName( "InventorySpecialStockValnType" )
    @JsonProperty( "InventorySpecialStockValnType" )
    @Nullable
    @ODataField( odataName = "InventorySpecialStockValnType" )
    private String inventorySpecialStockValnType;
    /**
     * Use with available fluent helpers to apply the <b>InventorySpecialStockValnType</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<String> INVENTORY_SPECIAL_STOCK_VALN_TYPE =
        new GLAccountLineItemField<String>("InventorySpecialStockValnType");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InventorySpecialStockType</b>
     * </p>
     *
     * @return Inventory Special Stock Type
     */
    @SerializedName( "InventorySpecialStockType" )
    @JsonProperty( "InventorySpecialStockType" )
    @Nullable
    @ODataField( odataName = "InventorySpecialStockType" )
    private String inventorySpecialStockType;
    /**
     * Use with available fluent helpers to apply the <b>InventorySpecialStockType</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<String> INVENTORY_SPECIAL_STOCK_TYPE =
        new GLAccountLineItemField<String>("InventorySpecialStockType");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>InventorySpclStkSalesDocument</b>
     * </p>
     *
     * @return Inventory Special Stock Sales Document
     */
    @SerializedName( "InventorySpclStkSalesDocument" )
    @JsonProperty( "InventorySpclStkSalesDocument" )
    @Nullable
    @ODataField( odataName = "InventorySpclStkSalesDocument" )
    private String inventorySpclStkSalesDocument;
    /**
     * Use with available fluent helpers to apply the <b>InventorySpclStkSalesDocument</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<String> INVENTORY_SPCL_STK_SALES_DOCUMENT =
        new GLAccountLineItemField<String>("InventorySpclStkSalesDocument");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>InventorySpclStkSalesDocItm</b>
     * </p>
     *
     * @return Inventory Special Stock Sales Document Item
     */
    @SerializedName( "InventorySpclStkSalesDocItm" )
    @JsonProperty( "InventorySpclStkSalesDocItm" )
    @Nullable
    @ODataField( odataName = "InventorySpclStkSalesDocItm" )
    private String inventorySpclStkSalesDocItm;
    /**
     * Use with available fluent helpers to apply the <b>InventorySpclStkSalesDocItm</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<String> INVENTORY_SPCL_STK_SALES_DOC_ITM =
        new GLAccountLineItemField<String>("InventorySpclStkSalesDocItm");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>InvtrySpclStockWBSElmntIntID</b>
     * </p>
     *
     * @return Inventory Special Stock WBS Element Internal ID
     */
    @SerializedName( "InvtrySpclStockWBSElmntIntID" )
    @JsonProperty( "InvtrySpclStockWBSElmntIntID" )
    @Nullable
    @ODataField( odataName = "InvtrySpclStockWBSElmntIntID" )
    private String invtrySpclStockWBSElmntIntID;
    /**
     * Use with available fluent helpers to apply the <b>InvtrySpclStockWBSElmntIntID</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<String> INVTRY_SPCL_STOCK_WBS_ELMNT_INT_ID =
        new GLAccountLineItemField<String>("InvtrySpclStockWBSElmntIntID");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>InventorySpecialStockSupplier</b>
     * </p>
     *
     * @return Supplier of Inventory Special Stock
     */
    @SerializedName( "InventorySpecialStockSupplier" )
    @JsonProperty( "InventorySpecialStockSupplier" )
    @Nullable
    @ODataField( odataName = "InventorySpecialStockSupplier" )
    private String inventorySpecialStockSupplier;
    /**
     * Use with available fluent helpers to apply the <b>InventorySpecialStockSupplier</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<String> INVENTORY_SPECIAL_STOCK_SUPPLIER =
        new GLAccountLineItemField<String>("InventorySpecialStockSupplier");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>InventoryValuationType</b>
     * </p>
     *
     * @return Inventory Valuation Type
     */
    @SerializedName( "InventoryValuationType" )
    @JsonProperty( "InventoryValuationType" )
    @Nullable
    @ODataField( odataName = "InventoryValuationType" )
    private String inventoryValuationType;
    /**
     * Use with available fluent helpers to apply the <b>InventoryValuationType</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<String> INVENTORY_VALUATION_TYPE =
        new GLAccountLineItemField<String>("InventoryValuationType");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ValuationArea</b>
     * </p>
     *
     * @return Valuation Area
     */
    @SerializedName( "ValuationArea" )
    @JsonProperty( "ValuationArea" )
    @Nullable
    @ODataField( odataName = "ValuationArea" )
    private String valuationArea;
    /**
     * Use with available fluent helpers to apply the <b>ValuationArea</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<String> VALUATION_AREA =
        new GLAccountLineItemField<String>("ValuationArea");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CostOriginGroup</b>
     * </p>
     *
     * @return Origin Group as Subdivision of Cost Element
     */
    @SerializedName( "CostOriginGroup" )
    @JsonProperty( "CostOriginGroup" )
    @Nullable
    @ODataField( odataName = "CostOriginGroup" )
    private String costOriginGroup;
    /**
     * Use with available fluent helpers to apply the <b>CostOriginGroup</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<String> COST_ORIGIN_GROUP =
        new GLAccountLineItemField<String>("CostOriginGroup");
    /**
     * Constraints: Not nullable, Maximum length: 22
     * <p>
     * Original property name from the Odata EDM: <b>OriginSenderObject</b>
     * </p>
     *
     * @return Origin Sender Object
     */
    @SerializedName( "OriginSenderObject" )
    @JsonProperty( "OriginSenderObject" )
    @Nullable
    @ODataField( odataName = "OriginSenderObject" )
    private String originSenderObject;
    /**
     * Use with available fluent helpers to apply the <b>OriginSenderObject</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<String> ORIGIN_SENDER_OBJECT =
        new GLAccountLineItemField<String>("OriginSenderObject");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ControllingObjectDebitType</b>
     * </p>
     *
     * @return Controlling Object Debit Type
     */
    @SerializedName( "ControllingObjectDebitType" )
    @JsonProperty( "ControllingObjectDebitType" )
    @Nullable
    @ODataField( odataName = "ControllingObjectDebitType" )
    private String controllingObjectDebitType;
    /**
     * Use with available fluent helpers to apply the <b>ControllingObjectDebitType</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<String> CONTROLLING_OBJECT_DEBIT_TYPE =
        new GLAccountLineItemField<String>("ControllingObjectDebitType");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>QuantityIsIncomplete</b>
     * </p>
     *
     * @return Indicator: Quantity Is Incomplete
     */
    @SerializedName( "QuantityIsIncomplete" )
    @JsonProperty( "QuantityIsIncomplete" )
    @Nullable
    @ODataField( odataName = "QuantityIsIncomplete" )
    private String quantityIsIncomplete;
    /**
     * Use with available fluent helpers to apply the <b>QuantityIsIncomplete</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<String> QUANTITY_IS_INCOMPLETE =
        new GLAccountLineItemField<String>("QuantityIsIncomplete");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>OffsettingAccount</b>
     * </p>
     *
     * @return Offsetting Account
     */
    @SerializedName( "OffsettingAccount" )
    @JsonProperty( "OffsettingAccount" )
    @Nullable
    @ODataField( odataName = "OffsettingAccount" )
    private String offsettingAccount;
    /**
     * Use with available fluent helpers to apply the <b>OffsettingAccount</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<String> OFFSETTING_ACCOUNT =
        new GLAccountLineItemField<String>("OffsettingAccount");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>OffsettingAccountType</b>
     * </p>
     *
     * @return Offsetting Account Type
     */
    @SerializedName( "OffsettingAccountType" )
    @JsonProperty( "OffsettingAccountType" )
    @Nullable
    @ODataField( odataName = "OffsettingAccountType" )
    private String offsettingAccountType;
    /**
     * Use with available fluent helpers to apply the <b>OffsettingAccountType</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<String> OFFSETTING_ACCOUNT_TYPE =
        new GLAccountLineItemField<String>("OffsettingAccountType");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>OffsettingChartOfAccounts</b>
     * </p>
     *
     * @return Offsetting Chart of Accounts
     */
    @SerializedName( "OffsettingChartOfAccounts" )
    @JsonProperty( "OffsettingChartOfAccounts" )
    @Nullable
    @ODataField( odataName = "OffsettingChartOfAccounts" )
    private String offsettingChartOfAccounts;
    /**
     * Use with available fluent helpers to apply the <b>OffsettingChartOfAccounts</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<String> OFFSETTING_CHART_OF_ACCOUNTS =
        new GLAccountLineItemField<String>("OffsettingChartOfAccounts");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>LineItemIsCompleted</b>
     * </p>
     *
     * @return Indicator: Line Item is Completed
     */
    @SerializedName( "LineItemIsCompleted" )
    @JsonProperty( "LineItemIsCompleted" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "LineItemIsCompleted" )
    private Boolean lineItemIsCompleted;
    /**
     * Use with available fluent helpers to apply the <b>LineItemIsCompleted</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<Boolean> LINE_ITEM_IS_COMPLETED =
        new GLAccountLineItemField<Boolean>("LineItemIsCompleted");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>PersonnelNumber</b>
     * </p>
     *
     * @return Personnel Number
     */
    @SerializedName( "PersonnelNumber" )
    @JsonProperty( "PersonnelNumber" )
    @Nullable
    @ODataField( odataName = "PersonnelNumber" )
    private String personnelNumber;
    /**
     * Use with available fluent helpers to apply the <b>PersonnelNumber</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<String> PERSONNEL_NUMBER =
        new GLAccountLineItemField<String>("PersonnelNumber");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ControllingObjectClass</b>
     * </p>
     *
     * @return Controlling Object Class
     */
    @SerializedName( "ControllingObjectClass" )
    @JsonProperty( "ControllingObjectClass" )
    @Nullable
    @ODataField( odataName = "ControllingObjectClass" )
    private String controllingObjectClass;
    /**
     * Use with available fluent helpers to apply the <b>ControllingObjectClass</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<String> CONTROLLING_OBJECT_CLASS =
        new GLAccountLineItemField<String>("ControllingObjectClass");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PartnerCompanyCode</b>
     * </p>
     *
     * @return Partner Company Code
     */
    @SerializedName( "PartnerCompanyCode" )
    @JsonProperty( "PartnerCompanyCode" )
    @Nullable
    @ODataField( odataName = "PartnerCompanyCode" )
    private String partnerCompanyCode;
    /**
     * Use with available fluent helpers to apply the <b>PartnerCompanyCode</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<String> PARTNER_COMPANY_CODE =
        new GLAccountLineItemField<String>("PartnerCompanyCode");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>PartnerControllingObjectClass</b>
     * </p>
     *
     * @return Partner Controlling Object Class
     */
    @SerializedName( "PartnerControllingObjectClass" )
    @JsonProperty( "PartnerControllingObjectClass" )
    @Nullable
    @ODataField( odataName = "PartnerControllingObjectClass" )
    private String partnerControllingObjectClass;
    /**
     * Use with available fluent helpers to apply the <b>PartnerControllingObjectClass</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<String> PARTNER_CONTROLLING_OBJECT_CLASS =
        new GLAccountLineItemField<String>("PartnerControllingObjectClass");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>OriginCostCenter</b>
     * </p>
     *
     * @return Origin Cost Center
     */
    @SerializedName( "OriginCostCenter" )
    @JsonProperty( "OriginCostCenter" )
    @Nullable
    @ODataField( odataName = "OriginCostCenter" )
    private String originCostCenter;
    /**
     * Use with available fluent helpers to apply the <b>OriginCostCenter</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<String> ORIGIN_COST_CENTER =
        new GLAccountLineItemField<String>("OriginCostCenter");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>OriginProfitCenter</b>
     * </p>
     *
     * @return Origin Profit Center
     */
    @SerializedName( "OriginProfitCenter" )
    @JsonProperty( "OriginProfitCenter" )
    @Nullable
    @ODataField( odataName = "OriginProfitCenter" )
    private String originProfitCenter;
    /**
     * Use with available fluent helpers to apply the <b>OriginProfitCenter</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<String> ORIGIN_PROFIT_CENTER =
        new GLAccountLineItemField<String>("OriginProfitCenter");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>OriginCostCtrActivityType</b>
     * </p>
     *
     * @return Origin Cost Center Activity Type
     */
    @SerializedName( "OriginCostCtrActivityType" )
    @JsonProperty( "OriginCostCtrActivityType" )
    @Nullable
    @ODataField( odataName = "OriginCostCtrActivityType" )
    private String originCostCtrActivityType;
    /**
     * Use with available fluent helpers to apply the <b>OriginCostCtrActivityType</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<String> ORIGIN_COST_CTR_ACTIVITY_TYPE =
        new GLAccountLineItemField<String>("OriginCostCtrActivityType");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>AccountAssignment</b>
     * </p>
     *
     * @return Account Assignment
     */
    @SerializedName( "AccountAssignment" )
    @JsonProperty( "AccountAssignment" )
    @Nullable
    @ODataField( odataName = "AccountAssignment" )
    private String accountAssignment;
    /**
     * Use with available fluent helpers to apply the <b>AccountAssignment</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<String> ACCOUNT_ASSIGNMENT =
        new GLAccountLineItemField<String>("AccountAssignment");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>AccountAssignmentType</b>
     * </p>
     *
     * @return Account Assignment Type
     */
    @SerializedName( "AccountAssignmentType" )
    @JsonProperty( "AccountAssignmentType" )
    @Nullable
    @ODataField( odataName = "AccountAssignmentType" )
    private String accountAssignmentType;
    /**
     * Use with available fluent helpers to apply the <b>AccountAssignmentType</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<String> ACCOUNT_ASSIGNMENT_TYPE =
        new GLAccountLineItemField<String>("AccountAssignmentType");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>CostCtrActivityType</b>
     * </p>
     *
     * @return Activity Type
     */
    @SerializedName( "CostCtrActivityType" )
    @JsonProperty( "CostCtrActivityType" )
    @Nullable
    @ODataField( odataName = "CostCtrActivityType" )
    private String costCtrActivityType;
    /**
     * Use with available fluent helpers to apply the <b>CostCtrActivityType</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<String> COST_CTR_ACTIVITY_TYPE =
        new GLAccountLineItemField<String>("CostCtrActivityType");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>OrderID</b>
     * </p>
     *
     * @return Order ID
     */
    @SerializedName( "OrderID" )
    @JsonProperty( "OrderID" )
    @Nullable
    @ODataField( odataName = "OrderID" )
    private String orderID;
    /**
     * Use with available fluent helpers to apply the <b>OrderID</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<String> ORDER_ID = new GLAccountLineItemField<String>("OrderID");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>OrderCategory</b>
     * </p>
     *
     * @return Order Category
     */
    @SerializedName( "OrderCategory" )
    @JsonProperty( "OrderCategory" )
    @Nullable
    @ODataField( odataName = "OrderCategory" )
    private String orderCategory;
    /**
     * Use with available fluent helpers to apply the <b>OrderCategory</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<String> ORDER_CATEGORY =
        new GLAccountLineItemField<String>("OrderCategory");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>WBSElementInternalID</b>
     * </p>
     *
     * @return WBS Element Internal ID
     */
    @SerializedName( "WBSElementInternalID" )
    @JsonProperty( "WBSElementInternalID" )
    @Nullable
    @ODataField( odataName = "WBSElementInternalID" )
    private String wBSElementInternalID;
    /**
     * Use with available fluent helpers to apply the <b>WBSElementInternalID</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<String> WBS_ELEMENT_INTERNAL_ID =
        new GLAccountLineItemField<String>("WBSElementInternalID");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>PartnerWBSElementInternalID</b>
     * </p>
     *
     * @return Partner WBS Element Internal ID
     */
    @SerializedName( "PartnerWBSElementInternalID" )
    @JsonProperty( "PartnerWBSElementInternalID" )
    @Nullable
    @ODataField( odataName = "PartnerWBSElementInternalID" )
    private String partnerWBSElementInternalID;
    /**
     * Use with available fluent helpers to apply the <b>PartnerWBSElementInternalID</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<String> PARTNER_WBS_ELEMENT_INTERNAL_ID =
        new GLAccountLineItemField<String>("PartnerWBSElementInternalID");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>ProjectInternalID</b>
     * </p>
     *
     * @return Project Internal ID
     */
    @SerializedName( "ProjectInternalID" )
    @JsonProperty( "ProjectInternalID" )
    @Nullable
    @ODataField( odataName = "ProjectInternalID" )
    private String projectInternalID;
    /**
     * Use with available fluent helpers to apply the <b>ProjectInternalID</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<String> PROJECT_INTERNAL_ID =
        new GLAccountLineItemField<String>("ProjectInternalID");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>PartnerProjectInternalID</b>
     * </p>
     *
     * @return Partner Project Internal ID
     */
    @SerializedName( "PartnerProjectInternalID" )
    @JsonProperty( "PartnerProjectInternalID" )
    @Nullable
    @ODataField( odataName = "PartnerProjectInternalID" )
    private String partnerProjectInternalID;
    /**
     * Use with available fluent helpers to apply the <b>PartnerProjectInternalID</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<String> PARTNER_PROJECT_INTERNAL_ID =
        new GLAccountLineItemField<String>("PartnerProjectInternalID");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>OperatingConcern</b>
     * </p>
     *
     * @return Operating Concern
     */
    @SerializedName( "OperatingConcern" )
    @JsonProperty( "OperatingConcern" )
    @Nullable
    @ODataField( odataName = "OperatingConcern" )
    private String operatingConcern;
    /**
     * Use with available fluent helpers to apply the <b>OperatingConcern</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<String> OPERATING_CONCERN =
        new GLAccountLineItemField<String>("OperatingConcern");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>ProjectNetwork</b>
     * </p>
     *
     * @return Network Number for Account Assignment
     */
    @SerializedName( "ProjectNetwork" )
    @JsonProperty( "ProjectNetwork" )
    @Nullable
    @ODataField( odataName = "ProjectNetwork" )
    private String projectNetwork;
    /**
     * Use with available fluent helpers to apply the <b>ProjectNetwork</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<String> PROJECT_NETWORK =
        new GLAccountLineItemField<String>("ProjectNetwork");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>BusinessProcess</b>
     * </p>
     *
     * @return Business Process
     */
    @SerializedName( "BusinessProcess" )
    @JsonProperty( "BusinessProcess" )
    @Nullable
    @ODataField( odataName = "BusinessProcess" )
    private String businessProcess;
    /**
     * Use with available fluent helpers to apply the <b>BusinessProcess</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<String> BUSINESS_PROCESS =
        new GLAccountLineItemField<String>("BusinessProcess");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CostObject</b>
     * </p>
     *
     * @return Cost Object
     */
    @SerializedName( "CostObject" )
    @JsonProperty( "CostObject" )
    @Nullable
    @ODataField( odataName = "CostObject" )
    private String costObject;
    /**
     * Use with available fluent helpers to apply the <b>CostObject</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<String> COST_OBJECT = new GLAccountLineItemField<String>("CostObject");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>BillableControl</b>
     * </p>
     *
     * @return Billable Control
     */
    @SerializedName( "BillableControl" )
    @JsonProperty( "BillableControl" )
    @Nullable
    @ODataField( odataName = "BillableControl" )
    private String billableControl;
    /**
     * Use with available fluent helpers to apply the <b>BillableControl</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<String> BILLABLE_CONTROL =
        new GLAccountLineItemField<String>("BillableControl");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CostAnalysisResource</b>
     * </p>
     *
     * @return Cost Analysis Resource
     */
    @SerializedName( "CostAnalysisResource" )
    @JsonProperty( "CostAnalysisResource" )
    @Nullable
    @ODataField( odataName = "CostAnalysisResource" )
    private String costAnalysisResource;
    /**
     * Use with available fluent helpers to apply the <b>CostAnalysisResource</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<String> COST_ANALYSIS_RESOURCE =
        new GLAccountLineItemField<String>("CostAnalysisResource");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CustomerServiceNotification</b>
     * </p>
     *
     * @return Customer Service Notification
     */
    @SerializedName( "CustomerServiceNotification" )
    @JsonProperty( "CustomerServiceNotification" )
    @Nullable
    @ODataField( odataName = "CustomerServiceNotification" )
    private String customerServiceNotification;
    /**
     * Use with available fluent helpers to apply the <b>CustomerServiceNotification</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<String> CUSTOMER_SERVICE_NOTIFICATION =
        new GLAccountLineItemField<String>("CustomerServiceNotification");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ServiceDocumentType</b>
     * </p>
     *
     * @return Service Document Type
     */
    @SerializedName( "ServiceDocumentType" )
    @JsonProperty( "ServiceDocumentType" )
    @Nullable
    @ODataField( odataName = "ServiceDocumentType" )
    private String serviceDocumentType;
    /**
     * Use with available fluent helpers to apply the <b>ServiceDocumentType</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<String> SERVICE_DOCUMENT_TYPE =
        new GLAccountLineItemField<String>("ServiceDocumentType");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ServiceDocument</b>
     * </p>
     *
     * @return Service Document ID
     */
    @SerializedName( "ServiceDocument" )
    @JsonProperty( "ServiceDocument" )
    @Nullable
    @ODataField( odataName = "ServiceDocument" )
    private String serviceDocument;
    /**
     * Use with available fluent helpers to apply the <b>ServiceDocument</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<String> SERVICE_DOCUMENT =
        new GLAccountLineItemField<String>("ServiceDocument");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>ServiceDocumentItem</b>
     * </p>
     *
     * @return Service Document Item ID
     */
    @SerializedName( "ServiceDocumentItem" )
    @JsonProperty( "ServiceDocumentItem" )
    @Nullable
    @ODataField( odataName = "ServiceDocumentItem" )
    private String serviceDocumentItem;
    /**
     * Use with available fluent helpers to apply the <b>ServiceDocumentItem</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<String> SERVICE_DOCUMENT_ITEM =
        new GLAccountLineItemField<String>("ServiceDocumentItem");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PartnerServiceDocumentType</b>
     * </p>
     *
     * @return Partner Service Document Type
     */
    @SerializedName( "PartnerServiceDocumentType" )
    @JsonProperty( "PartnerServiceDocumentType" )
    @Nullable
    @ODataField( odataName = "PartnerServiceDocumentType" )
    private String partnerServiceDocumentType;
    /**
     * Use with available fluent helpers to apply the <b>PartnerServiceDocumentType</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<String> PARTNER_SERVICE_DOCUMENT_TYPE =
        new GLAccountLineItemField<String>("PartnerServiceDocumentType");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PartnerServiceDocument</b>
     * </p>
     *
     * @return Partner Service Document
     */
    @SerializedName( "PartnerServiceDocument" )
    @JsonProperty( "PartnerServiceDocument" )
    @Nullable
    @ODataField( odataName = "PartnerServiceDocument" )
    private String partnerServiceDocument;
    /**
     * Use with available fluent helpers to apply the <b>PartnerServiceDocument</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<String> PARTNER_SERVICE_DOCUMENT =
        new GLAccountLineItemField<String>("PartnerServiceDocument");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>PartnerServiceDocumentItem</b>
     * </p>
     *
     * @return Partner Service Document Item
     */
    @SerializedName( "PartnerServiceDocumentItem" )
    @JsonProperty( "PartnerServiceDocumentItem" )
    @Nullable
    @ODataField( odataName = "PartnerServiceDocumentItem" )
    private String partnerServiceDocumentItem;
    /**
     * Use with available fluent helpers to apply the <b>PartnerServiceDocumentItem</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<String> PARTNER_SERVICE_DOCUMENT_ITEM =
        new GLAccountLineItemField<String>("PartnerServiceDocumentItem");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ServiceContractType</b>
     * </p>
     *
     * @return Service Contract Type
     */
    @SerializedName( "ServiceContractType" )
    @JsonProperty( "ServiceContractType" )
    @Nullable
    @ODataField( odataName = "ServiceContractType" )
    private String serviceContractType;
    /**
     * Use with available fluent helpers to apply the <b>ServiceContractType</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<String> SERVICE_CONTRACT_TYPE =
        new GLAccountLineItemField<String>("ServiceContractType");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ServiceContract</b>
     * </p>
     *
     * @return Service Contract ID
     */
    @SerializedName( "ServiceContract" )
    @JsonProperty( "ServiceContract" )
    @Nullable
    @ODataField( odataName = "ServiceContract" )
    private String serviceContract;
    /**
     * Use with available fluent helpers to apply the <b>ServiceContract</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<String> SERVICE_CONTRACT =
        new GLAccountLineItemField<String>("ServiceContract");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>ServiceContractItem</b>
     * </p>
     *
     * @return Service Contract Item ID
     */
    @SerializedName( "ServiceContractItem" )
    @JsonProperty( "ServiceContractItem" )
    @Nullable
    @ODataField( odataName = "ServiceContractItem" )
    private String serviceContractItem;
    /**
     * Use with available fluent helpers to apply the <b>ServiceContractItem</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<String> SERVICE_CONTRACT_ITEM =
        new GLAccountLineItemField<String>("ServiceContractItem");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>TimeSheetOvertimeCategory</b>
     * </p>
     *
     * @return Overtime Category
     */
    @SerializedName( "TimeSheetOvertimeCategory" )
    @JsonProperty( "TimeSheetOvertimeCategory" )
    @Nullable
    @ODataField( odataName = "TimeSheetOvertimeCategory" )
    private String timeSheetOvertimeCategory;
    /**
     * Use with available fluent helpers to apply the <b>TimeSheetOvertimeCategory</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<String> TIME_SHEET_OVERTIME_CATEGORY =
        new GLAccountLineItemField<String>("TimeSheetOvertimeCategory");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>PartnerAccountAssignment</b>
     * </p>
     *
     * @return Partner Account Assignment
     */
    @SerializedName( "PartnerAccountAssignment" )
    @JsonProperty( "PartnerAccountAssignment" )
    @Nullable
    @ODataField( odataName = "PartnerAccountAssignment" )
    private String partnerAccountAssignment;
    /**
     * Use with available fluent helpers to apply the <b>PartnerAccountAssignment</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<String> PARTNER_ACCOUNT_ASSIGNMENT =
        new GLAccountLineItemField<String>("PartnerAccountAssignment");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>PartnerAccountAssignmentType</b>
     * </p>
     *
     * @return Partner Account Assignment Type
     */
    @SerializedName( "PartnerAccountAssignmentType" )
    @JsonProperty( "PartnerAccountAssignmentType" )
    @Nullable
    @ODataField( odataName = "PartnerAccountAssignmentType" )
    private String partnerAccountAssignmentType;
    /**
     * Use with available fluent helpers to apply the <b>PartnerAccountAssignmentType</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<String> PARTNER_ACCOUNT_ASSIGNMENT_TYPE =
        new GLAccountLineItemField<String>("PartnerAccountAssignmentType");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>PartnerCostCtrActivityType</b>
     * </p>
     *
     * @return Partner Cost Center Activity Type
     */
    @SerializedName( "PartnerCostCtrActivityType" )
    @JsonProperty( "PartnerCostCtrActivityType" )
    @Nullable
    @ODataField( odataName = "PartnerCostCtrActivityType" )
    private String partnerCostCtrActivityType;
    /**
     * Use with available fluent helpers to apply the <b>PartnerCostCtrActivityType</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<String> PARTNER_COST_CTR_ACTIVITY_TYPE =
        new GLAccountLineItemField<String>("PartnerCostCtrActivityType");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>PartnerOrder</b>
     * </p>
     *
     * @return Partner Order
     */
    @SerializedName( "PartnerOrder" )
    @JsonProperty( "PartnerOrder" )
    @Nullable
    @ODataField( odataName = "PartnerOrder" )
    private String partnerOrder;
    /**
     * Use with available fluent helpers to apply the <b>PartnerOrder</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<String> PARTNER_ORDER =
        new GLAccountLineItemField<String>("PartnerOrder");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>PartnerOrderCategory</b>
     * </p>
     *
     * @return Partner Order Category
     */
    @SerializedName( "PartnerOrderCategory" )
    @JsonProperty( "PartnerOrderCategory" )
    @Nullable
    @ODataField( odataName = "PartnerOrderCategory" )
    private String partnerOrderCategory;
    /**
     * Use with available fluent helpers to apply the <b>PartnerOrderCategory</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<String> PARTNER_ORDER_CATEGORY =
        new GLAccountLineItemField<String>("PartnerOrderCategory");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PartnerSalesDocument</b>
     * </p>
     *
     * @return Partner Sales Document
     */
    @SerializedName( "PartnerSalesDocument" )
    @JsonProperty( "PartnerSalesDocument" )
    @Nullable
    @ODataField( odataName = "PartnerSalesDocument" )
    private String partnerSalesDocument;
    /**
     * Use with available fluent helpers to apply the <b>PartnerSalesDocument</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<String> PARTNER_SALES_DOCUMENT =
        new GLAccountLineItemField<String>("PartnerSalesDocument");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>PartnerSalesDocumentItem</b>
     * </p>
     *
     * @return Partner Sales Document Item
     */
    @SerializedName( "PartnerSalesDocumentItem" )
    @JsonProperty( "PartnerSalesDocumentItem" )
    @Nullable
    @ODataField( odataName = "PartnerSalesDocumentItem" )
    private String partnerSalesDocumentItem;
    /**
     * Use with available fluent helpers to apply the <b>PartnerSalesDocumentItem</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<String> PARTNER_SALES_DOCUMENT_ITEM =
        new GLAccountLineItemField<String>("PartnerSalesDocumentItem");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>PartnerProjectNetwork</b>
     * </p>
     *
     * @return Partner Project Network
     */
    @SerializedName( "PartnerProjectNetwork" )
    @JsonProperty( "PartnerProjectNetwork" )
    @Nullable
    @ODataField( odataName = "PartnerProjectNetwork" )
    private String partnerProjectNetwork;
    /**
     * Use with available fluent helpers to apply the <b>PartnerProjectNetwork</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<String> PARTNER_PROJECT_NETWORK =
        new GLAccountLineItemField<String>("PartnerProjectNetwork");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>PartnerBusinessProcess</b>
     * </p>
     *
     * @return Partner Business Process
     */
    @SerializedName( "PartnerBusinessProcess" )
    @JsonProperty( "PartnerBusinessProcess" )
    @Nullable
    @ODataField( odataName = "PartnerBusinessProcess" )
    private String partnerBusinessProcess;
    /**
     * Use with available fluent helpers to apply the <b>PartnerBusinessProcess</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<String> PARTNER_BUSINESS_PROCESS =
        new GLAccountLineItemField<String>("PartnerBusinessProcess");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>PartnerCostObject</b>
     * </p>
     *
     * @return Partner Cost Object
     */
    @SerializedName( "PartnerCostObject" )
    @JsonProperty( "PartnerCostObject" )
    @Nullable
    @ODataField( odataName = "PartnerCostObject" )
    private String partnerCostObject;
    /**
     * Use with available fluent helpers to apply the <b>PartnerCostObject</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<String> PARTNER_COST_OBJECT =
        new GLAccountLineItemField<String>("PartnerCostObject");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ControllingDocumentItem</b>
     * </p>
     *
     * @return Controlling Document Item
     */
    @SerializedName( "ControllingDocumentItem" )
    @JsonProperty( "ControllingDocumentItem" )
    @Nullable
    @ODataField( odataName = "ControllingDocumentItem" )
    private String controllingDocumentItem;
    /**
     * Use with available fluent helpers to apply the <b>ControllingDocumentItem</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<String> CONTROLLING_DOCUMENT_ITEM =
        new GLAccountLineItemField<String>("ControllingDocumentItem");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BillingDocumentType</b>
     * </p>
     *
     * @return Billing Type
     */
    @SerializedName( "BillingDocumentType" )
    @JsonProperty( "BillingDocumentType" )
    @Nullable
    @ODataField( odataName = "BillingDocumentType" )
    private String billingDocumentType;
    /**
     * Use with available fluent helpers to apply the <b>BillingDocumentType</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<String> BILLING_DOCUMENT_TYPE =
        new GLAccountLineItemField<String>("BillingDocumentType");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrganization</b>
     * </p>
     *
     * @return Sales Organization
     */
    @SerializedName( "SalesOrganization" )
    @JsonProperty( "SalesOrganization" )
    @Nullable
    @ODataField( odataName = "SalesOrganization" )
    private String salesOrganization;
    /**
     * Use with available fluent helpers to apply the <b>SalesOrganization</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<String> SALES_ORGANIZATION =
        new GLAccountLineItemField<String>("SalesOrganization");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>DistributionChannel</b>
     * </p>
     *
     * @return Distribution Channel
     */
    @SerializedName( "DistributionChannel" )
    @JsonProperty( "DistributionChannel" )
    @Nullable
    @ODataField( odataName = "DistributionChannel" )
    private String distributionChannel;
    /**
     * Use with available fluent helpers to apply the <b>DistributionChannel</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<String> DISTRIBUTION_CHANNEL =
        new GLAccountLineItemField<String>("DistributionChannel");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>OrganizationDivision</b>
     * </p>
     *
     * @return Division
     */
    @SerializedName( "OrganizationDivision" )
    @JsonProperty( "OrganizationDivision" )
    @Nullable
    @ODataField( odataName = "OrganizationDivision" )
    private String organizationDivision;
    /**
     * Use with available fluent helpers to apply the <b>OrganizationDivision</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<String> ORGANIZATION_DIVISION =
        new GLAccountLineItemField<String>("OrganizationDivision");
    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>SoldProduct</b>
     * </p>
     *
     * @return Product Sold
     */
    @SerializedName( "SoldProduct" )
    @JsonProperty( "SoldProduct" )
    @Nullable
    @ODataField( odataName = "SoldProduct" )
    private String soldProduct;
    /**
     * Use with available fluent helpers to apply the <b>SoldProduct</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<String> SOLD_PRODUCT = new GLAccountLineItemField<String>("SoldProduct");
    /**
     * Constraints: Not nullable, Maximum length: 9
     * <p>
     * Original property name from the Odata EDM: <b>SoldProductGroup</b>
     * </p>
     *
     * @return Product Sold Group
     */
    @SerializedName( "SoldProductGroup" )
    @JsonProperty( "SoldProductGroup" )
    @Nullable
    @ODataField( odataName = "SoldProductGroup" )
    private String soldProductGroup;
    /**
     * Use with available fluent helpers to apply the <b>SoldProductGroup</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<String> SOLD_PRODUCT_GROUP =
        new GLAccountLineItemField<String>("SoldProductGroup");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>CustomerGroup</b>
     * </p>
     *
     * @return Customer Group
     */
    @SerializedName( "CustomerGroup" )
    @JsonProperty( "CustomerGroup" )
    @Nullable
    @ODataField( odataName = "CustomerGroup" )
    private String customerGroup;
    /**
     * Use with available fluent helpers to apply the <b>CustomerGroup</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<String> CUSTOMER_GROUP =
        new GLAccountLineItemField<String>("CustomerGroup");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>CustomerSupplierCountry</b>
     * </p>
     *
     * @return Customer or Supplier Country/Region
     */
    @SerializedName( "CustomerSupplierCountry" )
    @JsonProperty( "CustomerSupplierCountry" )
    @Nullable
    @ODataField( odataName = "CustomerSupplierCountry" )
    private String customerSupplierCountry;
    /**
     * Use with available fluent helpers to apply the <b>CustomerSupplierCountry</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<String> CUSTOMER_SUPPLIER_COUNTRY =
        new GLAccountLineItemField<String>("CustomerSupplierCountry");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CustomerSupplierIndustry</b>
     * </p>
     *
     * @return Customer Supplier Industry
     */
    @SerializedName( "CustomerSupplierIndustry" )
    @JsonProperty( "CustomerSupplierIndustry" )
    @Nullable
    @ODataField( odataName = "CustomerSupplierIndustry" )
    private String customerSupplierIndustry;
    /**
     * Use with available fluent helpers to apply the <b>CustomerSupplierIndustry</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<String> CUSTOMER_SUPPLIER_INDUSTRY =
        new GLAccountLineItemField<String>("CustomerSupplierIndustry");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>SalesDistrict</b>
     * </p>
     *
     * @return Sales District
     */
    @SerializedName( "SalesDistrict" )
    @JsonProperty( "SalesDistrict" )
    @Nullable
    @ODataField( odataName = "SalesDistrict" )
    private String salesDistrict;
    /**
     * Use with available fluent helpers to apply the <b>SalesDistrict</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<String> SALES_DISTRICT =
        new GLAccountLineItemField<String>("SalesDistrict");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BillToParty</b>
     * </p>
     *
     * @return Bill-to Party
     */
    @SerializedName( "BillToParty" )
    @JsonProperty( "BillToParty" )
    @Nullable
    @ODataField( odataName = "BillToParty" )
    private String billToParty;
    /**
     * Use with available fluent helpers to apply the <b>BillToParty</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<String> BILL_TO_PARTY =
        new GLAccountLineItemField<String>("BillToParty");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ShipToParty</b>
     * </p>
     *
     * @return Ship-to Party
     */
    @SerializedName( "ShipToParty" )
    @JsonProperty( "ShipToParty" )
    @Nullable
    @ODataField( odataName = "ShipToParty" )
    private String shipToParty;
    /**
     * Use with available fluent helpers to apply the <b>ShipToParty</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<String> SHIP_TO_PARTY =
        new GLAccountLineItemField<String>("ShipToParty");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CustomerSupplierCorporateGroup</b>
     * </p>
     *
     * @return Customer Supplier Corporate Group
     */
    @SerializedName( "CustomerSupplierCorporateGroup" )
    @JsonProperty( "CustomerSupplierCorporateGroup" )
    @Nullable
    @ODataField( odataName = "CustomerSupplierCorporateGroup" )
    private String customerSupplierCorporateGroup;
    /**
     * Use with available fluent helpers to apply the <b>CustomerSupplierCorporateGroup</b> field to query operations.
     *
     */
    public final static GLAccountLineItemField<String> CUSTOMER_SUPPLIER_CORPORATE_GROUP =
        new GLAccountLineItemField<String>("CustomerSupplierCorporateGroup");

    @Nonnull
    @Override
    public Class<GLAccountLineItem> getType()
    {
        return GLAccountLineItem.class;
    }

    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>ID</b>
     * </p>
     *
     * @param iD
     *            The iD to set.
     */
    public void setID( @Nullable final String iD )
    {
        rememberChangedField("ID", this.iD);
        this.iD = iD;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>SourceLedger</b>
     * </p>
     *
     * @param sourceLedger
     *            Source Ledger
     */
    public void setSourceLedger( @Nullable final String sourceLedger )
    {
        rememberChangedField("SourceLedger", this.sourceLedger);
        this.sourceLedger = sourceLedger;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCode</b>
     * </p>
     *
     * @param companyCode
     *            Company Code
     */
    public void setCompanyCode( @Nullable final String companyCode )
    {
        rememberChangedField("CompanyCode", this.companyCode);
        this.companyCode = companyCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>FiscalYear</b>
     * </p>
     *
     * @param fiscalYear
     *            Fiscal Year
     */
    public void setFiscalYear( @Nullable final String fiscalYear )
    {
        rememberChangedField("FiscalYear", this.fiscalYear);
        this.fiscalYear = fiscalYear;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>AccountingDocument</b>
     * </p>
     *
     * @param accountingDocument
     *            Journal Entry
     */
    public void setAccountingDocument( @Nullable final String accountingDocument )
    {
        rememberChangedField("AccountingDocument", this.accountingDocument);
        this.accountingDocument = accountingDocument;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>LedgerGLLineItem</b>
     * </p>
     *
     * @param ledgerGLLineItem
     *            Ledger Journal Entry Item
     */
    public void setLedgerGLLineItem( @Nullable final String ledgerGLLineItem )
    {
        rememberChangedField("LedgerGLLineItem", this.ledgerGLLineItem);
        this.ledgerGLLineItem = ledgerGLLineItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Ledger</b>
     * </p>
     *
     * @param ledger
     *            Ledger in General Ledger Accounting
     */
    public void setLedger( @Nullable final String ledger )
    {
        rememberChangedField("Ledger", this.ledger);
        this.ledger = ledger;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>LedgerFiscalYear</b>
     * </p>
     *
     * @param ledgerFiscalYear
     *            Fiscal Year of Ledger
     */
    public void setLedgerFiscalYear( @Nullable final String ledgerFiscalYear )
    {
        rememberChangedField("LedgerFiscalYear", this.ledgerFiscalYear);
        this.ledgerFiscalYear = ledgerFiscalYear;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>GLRecordType</b>
     * </p>
     *
     * @param gLRecordType
     *            Record Type
     */
    public void setGLRecordType( @Nullable final String gLRecordType )
    {
        rememberChangedField("GLRecordType", this.gLRecordType);
        this.gLRecordType = gLRecordType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ControllingArea</b>
     * </p>
     *
     * @param controllingArea
     *            Controlling Area
     */
    public void setControllingArea( @Nullable final String controllingArea )
    {
        rememberChangedField("ControllingArea", this.controllingArea);
        this.controllingArea = controllingArea;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ChartOfAccounts</b>
     * </p>
     *
     * @param chartOfAccounts
     *            Chart of Accounts
     */
    public void setChartOfAccounts( @Nullable final String chartOfAccounts )
    {
        rememberChangedField("ChartOfAccounts", this.chartOfAccounts);
        this.chartOfAccounts = chartOfAccounts;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>GLAccount</b>
     * </p>
     *
     * @param gLAccount
     *            G/L Account
     */
    public void setGLAccount( @Nullable final String gLAccount )
    {
        rememberChangedField("GLAccount", this.gLAccount);
        this.gLAccount = gLAccount;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>FinancialTransactionType</b>
     * </p>
     *
     * @param financialTransactionType
     *            Financial Transaction Type
     */
    public void setFinancialTransactionType( @Nullable final String financialTransactionType )
    {
        rememberChangedField("FinancialTransactionType", this.financialTransactionType);
        this.financialTransactionType = financialTransactionType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BusinessTransactionType</b>
     * </p>
     *
     * @param businessTransactionType
     *            Business Transaction Type
     */
    public void setBusinessTransactionType( @Nullable final String businessTransactionType )
    {
        rememberChangedField("BusinessTransactionType", this.businessTransactionType);
        this.businessTransactionType = businessTransactionType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ControllingBusTransacType</b>
     * </p>
     *
     * @param controllingBusTransacType
     *            CO Business Transaction
     */
    public void setControllingBusTransacType( @Nullable final String controllingBusTransacType )
    {
        rememberChangedField("ControllingBusTransacType", this.controllingBusTransacType);
        this.controllingBusTransacType = controllingBusTransacType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>ReferenceDocumentType</b>
     * </p>
     *
     * @param referenceDocumentType
     *            Reference Document Type
     */
    public void setReferenceDocumentType( @Nullable final String referenceDocumentType )
    {
        rememberChangedField("ReferenceDocumentType", this.referenceDocumentType);
        this.referenceDocumentType = referenceDocumentType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>LogicalSystem</b>
     * </p>
     *
     * @param logicalSystem
     *            Logical System
     */
    public void setLogicalSystem( @Nullable final String logicalSystem )
    {
        rememberChangedField("LogicalSystem", this.logicalSystem);
        this.logicalSystem = logicalSystem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ReferenceDocumentContext</b>
     * </p>
     *
     * @param referenceDocumentContext
     *            Reference Document Context
     */
    public void setReferenceDocumentContext( @Nullable final String referenceDocumentContext )
    {
        rememberChangedField("ReferenceDocumentContext", this.referenceDocumentContext);
        this.referenceDocumentContext = referenceDocumentContext;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ReferenceDocument</b>
     * </p>
     *
     * @param referenceDocument
     *            Reference document number
     */
    public void setReferenceDocument( @Nullable final String referenceDocument )
    {
        rememberChangedField("ReferenceDocument", this.referenceDocument);
        this.referenceDocument = referenceDocument;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>ReferenceDocumentItem</b>
     * </p>
     *
     * @param referenceDocumentItem
     *            Reference Document Item
     */
    public void setReferenceDocumentItem( @Nullable final String referenceDocumentItem )
    {
        rememberChangedField("ReferenceDocumentItem", this.referenceDocumentItem);
        this.referenceDocumentItem = referenceDocumentItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>ReferenceDocumentItemGroup</b>
     * </p>
     *
     * @param referenceDocumentItemGroup
     *            Reference Document Item Group
     */
    public void setReferenceDocumentItemGroup( @Nullable final String referenceDocumentItemGroup )
    {
        rememberChangedField("ReferenceDocumentItemGroup", this.referenceDocumentItemGroup);
        this.referenceDocumentItemGroup = referenceDocumentItemGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>TransactionSubitem</b>
     * </p>
     *
     * @param transactionSubitem
     *            Partial Document to be balanced to zero
     */
    public void setTransactionSubitem( @Nullable final String transactionSubitem )
    {
        rememberChangedField("TransactionSubitem", this.transactionSubitem);
        this.transactionSubitem = transactionSubitem;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsReversal</b>
     * </p>
     *
     * @param isReversal
     *            Indicator: Item is Reversing Another Item
     */
    public void setIsReversal( @Nullable final Boolean isReversal )
    {
        rememberChangedField("IsReversal", this.isReversal);
        this.isReversal = isReversal;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsReversed</b>
     * </p>
     *
     * @param isReversed
     *            Indicator: Item is Reversed
     */
    public void setIsReversed( @Nullable final Boolean isReversed )
    {
        rememberChangedField("IsReversed", this.isReversed);
        this.isReversed = isReversed;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ReversalReferenceDocumentCntxt</b>
     * </p>
     *
     * @param reversalReferenceDocumentCntxt
     *            Reversal Reference Document Context
     */
    public void setReversalReferenceDocumentCntxt( @Nullable final String reversalReferenceDocumentCntxt )
    {
        rememberChangedField("ReversalReferenceDocumentCntxt", this.reversalReferenceDocumentCntxt);
        this.reversalReferenceDocumentCntxt = reversalReferenceDocumentCntxt;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ReversalReferenceDocument</b>
     * </p>
     *
     * @param reversalReferenceDocument
     *            Reversal Reference Document
     */
    public void setReversalReferenceDocument( @Nullable final String reversalReferenceDocument )
    {
        rememberChangedField("ReversalReferenceDocument", this.reversalReferenceDocument);
        this.reversalReferenceDocument = reversalReferenceDocument;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsSettlement</b>
     * </p>
     *
     * @param isSettlement
     *            Indicator: Item is Settling or Transferring Another Item
     */
    public void setIsSettlement( @Nullable final Boolean isSettlement )
    {
        rememberChangedField("IsSettlement", this.isSettlement);
        this.isSettlement = isSettlement;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsSettled</b>
     * </p>
     *
     * @param isSettled
     *            Indicator: Line Item is Settled or Transferred
     */
    public void setIsSettled( @Nullable final Boolean isSettled )
    {
        rememberChangedField("IsSettled", this.isSettled);
        this.isSettled = isSettled;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>PredecessorReferenceDocType</b>
     * </p>
     *
     * @param predecessorReferenceDocType
     *            Predecessor Reference Document Type
     */
    public void setPredecessorReferenceDocType( @Nullable final String predecessorReferenceDocType )
    {
        rememberChangedField("PredecessorReferenceDocType", this.predecessorReferenceDocType);
        this.predecessorReferenceDocType = predecessorReferenceDocType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PredecessorReferenceDocCntxt</b>
     * </p>
     *
     * @param predecessorReferenceDocCntxt
     *            Predecessor Reference Document Context
     */
    public void setPredecessorReferenceDocCntxt( @Nullable final String predecessorReferenceDocCntxt )
    {
        rememberChangedField("PredecessorReferenceDocCntxt", this.predecessorReferenceDocCntxt);
        this.predecessorReferenceDocCntxt = predecessorReferenceDocCntxt;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PredecessorReferenceDocument</b>
     * </p>
     *
     * @param predecessorReferenceDocument
     *            Predecessor Reference Document
     */
    public void setPredecessorReferenceDocument( @Nullable final String predecessorReferenceDocument )
    {
        rememberChangedField("PredecessorReferenceDocument", this.predecessorReferenceDocument);
        this.predecessorReferenceDocument = predecessorReferenceDocument;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>PredecessorReferenceDocItem</b>
     * </p>
     *
     * @param predecessorReferenceDocItem
     *            Predecessor Reference Document Item
     */
    public void setPredecessorReferenceDocItem( @Nullable final String predecessorReferenceDocItem )
    {
        rememberChangedField("PredecessorReferenceDocItem", this.predecessorReferenceDocItem);
        this.predecessorReferenceDocItem = predecessorReferenceDocItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PrdcssrJournalEntryCompanyCode</b>
     * </p>
     *
     * @param prdcssrJournalEntryCompanyCode
     *            Preceding Journal Entry Company Code
     */
    public void setPrdcssrJournalEntryCompanyCode( @Nullable final String prdcssrJournalEntryCompanyCode )
    {
        rememberChangedField("PrdcssrJournalEntryCompanyCode", this.prdcssrJournalEntryCompanyCode);
        this.prdcssrJournalEntryCompanyCode = prdcssrJournalEntryCompanyCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PrdcssrJournalEntryFiscalYear</b>
     * </p>
     *
     * @param prdcssrJournalEntryFiscalYear
     *            Preceding Journal Entry Fiscal Year
     */
    public void setPrdcssrJournalEntryFiscalYear( @Nullable final String prdcssrJournalEntryFiscalYear )
    {
        rememberChangedField("PrdcssrJournalEntryFiscalYear", this.prdcssrJournalEntryFiscalYear);
        this.prdcssrJournalEntryFiscalYear = prdcssrJournalEntryFiscalYear;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PredecessorJournalEntry</b>
     * </p>
     *
     * @param predecessorJournalEntry
     *            Preceding Journal Entry Document Number
     */
    public void setPredecessorJournalEntry( @Nullable final String predecessorJournalEntry )
    {
        rememberChangedField("PredecessorJournalEntry", this.predecessorJournalEntry);
        this.predecessorJournalEntry = predecessorJournalEntry;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>PredecessorJournalEntryItem</b>
     * </p>
     *
     * @param predecessorJournalEntryItem
     *            Preceding Journal Entry Line Item
     */
    public void setPredecessorJournalEntryItem( @Nullable final String predecessorJournalEntryItem )
    {
        rememberChangedField("PredecessorJournalEntryItem", this.predecessorJournalEntryItem);
        this.predecessorJournalEntryItem = predecessorJournalEntryItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>SourceReferenceDocumentType</b>
     * </p>
     *
     * @param sourceReferenceDocumentType
     *            Source Reference Document Type
     */
    public void setSourceReferenceDocumentType( @Nullable final String sourceReferenceDocumentType )
    {
        rememberChangedField("SourceReferenceDocumentType", this.sourceReferenceDocumentType);
        this.sourceReferenceDocumentType = sourceReferenceDocumentType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SourceLogicalSystem</b>
     * </p>
     *
     * @param sourceLogicalSystem
     *            Source Logical System
     */
    public void setSourceLogicalSystem( @Nullable final String sourceLogicalSystem )
    {
        rememberChangedField("SourceLogicalSystem", this.sourceLogicalSystem);
        this.sourceLogicalSystem = sourceLogicalSystem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SourceReferenceDocumentCntxt</b>
     * </p>
     *
     * @param sourceReferenceDocumentCntxt
     *            Source Reference Document Context
     */
    public void setSourceReferenceDocumentCntxt( @Nullable final String sourceReferenceDocumentCntxt )
    {
        rememberChangedField("SourceReferenceDocumentCntxt", this.sourceReferenceDocumentCntxt);
        this.sourceReferenceDocumentCntxt = sourceReferenceDocumentCntxt;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SourceReferenceDocument</b>
     * </p>
     *
     * @param sourceReferenceDocument
     *            Source Reference Document
     */
    public void setSourceReferenceDocument( @Nullable final String sourceReferenceDocument )
    {
        rememberChangedField("SourceReferenceDocument", this.sourceReferenceDocument);
        this.sourceReferenceDocument = sourceReferenceDocument;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>SourceReferenceDocumentItem</b>
     * </p>
     *
     * @param sourceReferenceDocumentItem
     *            Source Reference Document Item
     */
    public void setSourceReferenceDocumentItem( @Nullable final String sourceReferenceDocumentItem )
    {
        rememberChangedField("SourceReferenceDocumentItem", this.sourceReferenceDocumentItem);
        this.sourceReferenceDocumentItem = sourceReferenceDocumentItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>SourceReferenceDocSubitem</b>
     * </p>
     *
     * @param sourceReferenceDocSubitem
     *            Source Reference Document Subitem
     */
    public void setSourceReferenceDocSubitem( @Nullable final String sourceReferenceDocSubitem )
    {
        rememberChangedField("SourceReferenceDocSubitem", this.sourceReferenceDocSubitem);
        this.sourceReferenceDocSubitem = sourceReferenceDocSubitem;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsCommitment</b>
     * </p>
     *
     * @param isCommitment
     *            Indicator: Is Commitment
     */
    public void setIsCommitment( @Nullable final Boolean isCommitment )
    {
        rememberChangedField("IsCommitment", this.isCommitment);
        this.isCommitment = isCommitment;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>JrnlEntryItemObsoleteReason</b>
     * </p>
     *
     * @param jrnlEntryItemObsoleteReason
     *            Journal Entry Item Obsolete Reason
     */
    public void setJrnlEntryItemObsoleteReason( @Nullable final String jrnlEntryItemObsoleteReason )
    {
        rememberChangedField("JrnlEntryItemObsoleteReason", this.jrnlEntryItemObsoleteReason);
        this.jrnlEntryItemObsoleteReason = jrnlEntryItemObsoleteReason;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>JrnlPeriodEndClosingRunLogUUID</b>
     * </p>
     *
     * @param jrnlPeriodEndClosingRunLogUUID
     *            UUID of Financial Closing Run
     */
    public void setJrnlPeriodEndClosingRunLogUUID( @Nullable final UUID jrnlPeriodEndClosingRunLogUUID )
    {
        rememberChangedField("JrnlPeriodEndClosingRunLogUUID", this.jrnlPeriodEndClosingRunLogUUID);
        this.jrnlPeriodEndClosingRunLogUUID = jrnlPeriodEndClosingRunLogUUID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CostCenter</b>
     * </p>
     *
     * @param costCenter
     *            Cost Center
     */
    public void setCostCenter( @Nullable final String costCenter )
    {
        rememberChangedField("CostCenter", this.costCenter);
        this.costCenter = costCenter;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ProfitCenter</b>
     * </p>
     *
     * @param profitCenter
     *            Profit Center
     */
    public void setProfitCenter( @Nullable final String profitCenter )
    {
        rememberChangedField("ProfitCenter", this.profitCenter);
        this.profitCenter = profitCenter;
    }

    /**
     * Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>FunctionalArea</b>
     * </p>
     *
     * @param functionalArea
     *            Functional Area
     */
    public void setFunctionalArea( @Nullable final String functionalArea )
    {
        rememberChangedField("FunctionalArea", this.functionalArea);
        this.functionalArea = functionalArea;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BusinessArea</b>
     * </p>
     *
     * @param businessArea
     *            Business Area
     */
    public void setBusinessArea( @Nullable final String businessArea )
    {
        rememberChangedField("BusinessArea", this.businessArea);
        this.businessArea = businessArea;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Segment</b>
     * </p>
     *
     * @param segment
     *            Segment for Segmental Reporting
     */
    public void setSegment( @Nullable final String segment )
    {
        rememberChangedField("Segment", this.segment);
        this.segment = segment;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PartnerCostCenter</b>
     * </p>
     *
     * @param partnerCostCenter
     *            Partner Cost Center
     */
    public void setPartnerCostCenter( @Nullable final String partnerCostCenter )
    {
        rememberChangedField("PartnerCostCenter", this.partnerCostCenter);
        this.partnerCostCenter = partnerCostCenter;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PartnerProfitCenter</b>
     * </p>
     *
     * @param partnerProfitCenter
     *            Partner Profit Center
     */
    public void setPartnerProfitCenter( @Nullable final String partnerProfitCenter )
    {
        rememberChangedField("PartnerProfitCenter", this.partnerProfitCenter);
        this.partnerProfitCenter = partnerProfitCenter;
    }

    /**
     * Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>PartnerFunctionalArea</b>
     * </p>
     *
     * @param partnerFunctionalArea
     *            Partner Functional Area
     */
    public void setPartnerFunctionalArea( @Nullable final String partnerFunctionalArea )
    {
        rememberChangedField("PartnerFunctionalArea", this.partnerFunctionalArea);
        this.partnerFunctionalArea = partnerFunctionalArea;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PartnerBusinessArea</b>
     * </p>
     *
     * @param partnerBusinessArea
     *            Partner Business Area
     */
    public void setPartnerBusinessArea( @Nullable final String partnerBusinessArea )
    {
        rememberChangedField("PartnerBusinessArea", this.partnerBusinessArea);
        this.partnerBusinessArea = partnerBusinessArea;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>PartnerCompany</b>
     * </p>
     *
     * @param partnerCompany
     *            Company ID of Trading Partner
     */
    public void setPartnerCompany( @Nullable final String partnerCompany )
    {
        rememberChangedField("PartnerCompany", this.partnerCompany);
        this.partnerCompany = partnerCompany;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PartnerSegment</b>
     * </p>
     *
     * @param partnerSegment
     *            Partner Segment for Segmental Reporting
     */
    public void setPartnerSegment( @Nullable final String partnerSegment )
    {
        rememberChangedField("PartnerSegment", this.partnerSegment);
        this.partnerSegment = partnerSegment;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>BalanceTransactionCurrency</b>
     * </p>
     *
     * @param balanceTransactionCurrency
     *            Balance Transaction Currency
     */
    public void setBalanceTransactionCurrency( @Nullable final String balanceTransactionCurrency )
    {
        rememberChangedField("BalanceTransactionCurrency", this.balanceTransactionCurrency);
        this.balanceTransactionCurrency = balanceTransactionCurrency;
    }

    /**
     * Constraints: Not nullable, Precision: 23, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>AmountInBalanceTransacCrcy</b>
     * </p>
     *
     * @param amountInBalanceTransacCrcy
     *            Amount in Balance Transaction Currency
     */
    public void setAmountInBalanceTransacCrcy( @Nullable final BigDecimal amountInBalanceTransacCrcy )
    {
        rememberChangedField("AmountInBalanceTransacCrcy", this.amountInBalanceTransacCrcy);
        this.amountInBalanceTransacCrcy = amountInBalanceTransacCrcy;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>TransactionCurrency</b>
     * </p>
     *
     * @param transactionCurrency
     *            Transaction Currency
     */
    public void setTransactionCurrency( @Nullable final String transactionCurrency )
    {
        rememberChangedField("TransactionCurrency", this.transactionCurrency);
        this.transactionCurrency = transactionCurrency;
    }

    /**
     * Constraints: Not nullable, Precision: 23, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>AmountInTransactionCurrency</b>
     * </p>
     *
     * @param amountInTransactionCurrency
     *            Amount in Transaction Currency
     */
    public void setAmountInTransactionCurrency( @Nullable final BigDecimal amountInTransactionCurrency )
    {
        rememberChangedField("AmountInTransactionCurrency", this.amountInTransactionCurrency);
        this.amountInTransactionCurrency = amountInTransactionCurrency;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCodeCurrency</b>
     * </p>
     *
     * @param companyCodeCurrency
     *            Company Code Currency
     */
    public void setCompanyCodeCurrency( @Nullable final String companyCodeCurrency )
    {
        rememberChangedField("CompanyCodeCurrency", this.companyCodeCurrency);
        this.companyCodeCurrency = companyCodeCurrency;
    }

    /**
     * Constraints: Not nullable, Precision: 23, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>AmountInCompanyCodeCurrency</b>
     * </p>
     *
     * @param amountInCompanyCodeCurrency
     *            Amount in Company Code Currency
     */
    public void setAmountInCompanyCodeCurrency( @Nullable final BigDecimal amountInCompanyCodeCurrency )
    {
        rememberChangedField("AmountInCompanyCodeCurrency", this.amountInCompanyCodeCurrency);
        this.amountInCompanyCodeCurrency = amountInCompanyCodeCurrency;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>GlobalCurrency</b>
     * </p>
     *
     * @param globalCurrency
     *            Global Currency
     */
    public void setGlobalCurrency( @Nullable final String globalCurrency )
    {
        rememberChangedField("GlobalCurrency", this.globalCurrency);
        this.globalCurrency = globalCurrency;
    }

    /**
     * Constraints: Not nullable, Precision: 23, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>AmountInGlobalCurrency</b>
     * </p>
     *
     * @param amountInGlobalCurrency
     *            Amount in Global Currency
     */
    public void setAmountInGlobalCurrency( @Nullable final BigDecimal amountInGlobalCurrency )
    {
        rememberChangedField("AmountInGlobalCurrency", this.amountInGlobalCurrency);
        this.amountInGlobalCurrency = amountInGlobalCurrency;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>FreeDefinedCurrency1</b>
     * </p>
     *
     * @param freeDefinedCurrency1
     *            Freely Defined Currency 1
     */
    public void setFreeDefinedCurrency1( @Nullable final String freeDefinedCurrency1 )
    {
        rememberChangedField("FreeDefinedCurrency1", this.freeDefinedCurrency1);
        this.freeDefinedCurrency1 = freeDefinedCurrency1;
    }

    /**
     * Constraints: Not nullable, Precision: 23, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>AmountInFreeDefinedCurrency1</b>
     * </p>
     *
     * @param amountInFreeDefinedCurrency1
     *            Amount in Freely Defined Currency 1
     */
    public void setAmountInFreeDefinedCurrency1( @Nullable final BigDecimal amountInFreeDefinedCurrency1 )
    {
        rememberChangedField("AmountInFreeDefinedCurrency1", this.amountInFreeDefinedCurrency1);
        this.amountInFreeDefinedCurrency1 = amountInFreeDefinedCurrency1;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>FreeDefinedCurrency2</b>
     * </p>
     *
     * @param freeDefinedCurrency2
     *            Freely Defined Currency 2
     */
    public void setFreeDefinedCurrency2( @Nullable final String freeDefinedCurrency2 )
    {
        rememberChangedField("FreeDefinedCurrency2", this.freeDefinedCurrency2);
        this.freeDefinedCurrency2 = freeDefinedCurrency2;
    }

    /**
     * Constraints: Not nullable, Precision: 23, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>AmountInFreeDefinedCurrency2</b>
     * </p>
     *
     * @param amountInFreeDefinedCurrency2
     *            Amount in Freely Defined Currency 2
     */
    public void setAmountInFreeDefinedCurrency2( @Nullable final BigDecimal amountInFreeDefinedCurrency2 )
    {
        rememberChangedField("AmountInFreeDefinedCurrency2", this.amountInFreeDefinedCurrency2);
        this.amountInFreeDefinedCurrency2 = amountInFreeDefinedCurrency2;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>FreeDefinedCurrency3</b>
     * </p>
     *
     * @param freeDefinedCurrency3
     *            Freely Defined Currency 3
     */
    public void setFreeDefinedCurrency3( @Nullable final String freeDefinedCurrency3 )
    {
        rememberChangedField("FreeDefinedCurrency3", this.freeDefinedCurrency3);
        this.freeDefinedCurrency3 = freeDefinedCurrency3;
    }

    /**
     * Constraints: Not nullable, Precision: 23, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>AmountInFreeDefinedCurrency3</b>
     * </p>
     *
     * @param amountInFreeDefinedCurrency3
     *            Amount in Freely Defined Currency 3
     */
    public void setAmountInFreeDefinedCurrency3( @Nullable final BigDecimal amountInFreeDefinedCurrency3 )
    {
        rememberChangedField("AmountInFreeDefinedCurrency3", this.amountInFreeDefinedCurrency3);
        this.amountInFreeDefinedCurrency3 = amountInFreeDefinedCurrency3;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>FreeDefinedCurrency4</b>
     * </p>
     *
     * @param freeDefinedCurrency4
     *            Freely Defined Currency 4
     */
    public void setFreeDefinedCurrency4( @Nullable final String freeDefinedCurrency4 )
    {
        rememberChangedField("FreeDefinedCurrency4", this.freeDefinedCurrency4);
        this.freeDefinedCurrency4 = freeDefinedCurrency4;
    }

    /**
     * Constraints: Not nullable, Precision: 23, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>AmountInFreeDefinedCurrency4</b>
     * </p>
     *
     * @param amountInFreeDefinedCurrency4
     *            Amount in Freely Defined Currency 4
     */
    public void setAmountInFreeDefinedCurrency4( @Nullable final BigDecimal amountInFreeDefinedCurrency4 )
    {
        rememberChangedField("AmountInFreeDefinedCurrency4", this.amountInFreeDefinedCurrency4);
        this.amountInFreeDefinedCurrency4 = amountInFreeDefinedCurrency4;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>FreeDefinedCurrency5</b>
     * </p>
     *
     * @param freeDefinedCurrency5
     *            Freely Defined Currency 5
     */
    public void setFreeDefinedCurrency5( @Nullable final String freeDefinedCurrency5 )
    {
        rememberChangedField("FreeDefinedCurrency5", this.freeDefinedCurrency5);
        this.freeDefinedCurrency5 = freeDefinedCurrency5;
    }

    /**
     * Constraints: Not nullable, Precision: 23, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>AmountInFreeDefinedCurrency5</b>
     * </p>
     *
     * @param amountInFreeDefinedCurrency5
     *            Amount in Freely Defined Currency 5
     */
    public void setAmountInFreeDefinedCurrency5( @Nullable final BigDecimal amountInFreeDefinedCurrency5 )
    {
        rememberChangedField("AmountInFreeDefinedCurrency5", this.amountInFreeDefinedCurrency5);
        this.amountInFreeDefinedCurrency5 = amountInFreeDefinedCurrency5;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>FreeDefinedCurrency6</b>
     * </p>
     *
     * @param freeDefinedCurrency6
     *            Freely Defined Currency 6
     */
    public void setFreeDefinedCurrency6( @Nullable final String freeDefinedCurrency6 )
    {
        rememberChangedField("FreeDefinedCurrency6", this.freeDefinedCurrency6);
        this.freeDefinedCurrency6 = freeDefinedCurrency6;
    }

    /**
     * Constraints: Not nullable, Precision: 23, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>AmountInFreeDefinedCurrency6</b>
     * </p>
     *
     * @param amountInFreeDefinedCurrency6
     *            Amount in Freely Defined Currency 6
     */
    public void setAmountInFreeDefinedCurrency6( @Nullable final BigDecimal amountInFreeDefinedCurrency6 )
    {
        rememberChangedField("AmountInFreeDefinedCurrency6", this.amountInFreeDefinedCurrency6);
        this.amountInFreeDefinedCurrency6 = amountInFreeDefinedCurrency6;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>FreeDefinedCurrency7</b>
     * </p>
     *
     * @param freeDefinedCurrency7
     *            Freely Defined Currency 7
     */
    public void setFreeDefinedCurrency7( @Nullable final String freeDefinedCurrency7 )
    {
        rememberChangedField("FreeDefinedCurrency7", this.freeDefinedCurrency7);
        this.freeDefinedCurrency7 = freeDefinedCurrency7;
    }

    /**
     * Constraints: Not nullable, Precision: 23, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>AmountInFreeDefinedCurrency7</b>
     * </p>
     *
     * @param amountInFreeDefinedCurrency7
     *            Amount in Freely Defined Currency 7
     */
    public void setAmountInFreeDefinedCurrency7( @Nullable final BigDecimal amountInFreeDefinedCurrency7 )
    {
        rememberChangedField("AmountInFreeDefinedCurrency7", this.amountInFreeDefinedCurrency7);
        this.amountInFreeDefinedCurrency7 = amountInFreeDefinedCurrency7;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>FreeDefinedCurrency8</b>
     * </p>
     *
     * @param freeDefinedCurrency8
     *            Freely Defined Currency 8
     */
    public void setFreeDefinedCurrency8( @Nullable final String freeDefinedCurrency8 )
    {
        rememberChangedField("FreeDefinedCurrency8", this.freeDefinedCurrency8);
        this.freeDefinedCurrency8 = freeDefinedCurrency8;
    }

    /**
     * Constraints: Not nullable, Precision: 23, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>AmountInFreeDefinedCurrency8</b>
     * </p>
     *
     * @param amountInFreeDefinedCurrency8
     *            Amount in Freely Defined Currency 8
     */
    public void setAmountInFreeDefinedCurrency8( @Nullable final BigDecimal amountInFreeDefinedCurrency8 )
    {
        rememberChangedField("AmountInFreeDefinedCurrency8", this.amountInFreeDefinedCurrency8);
        this.amountInFreeDefinedCurrency8 = amountInFreeDefinedCurrency8;
    }

    /**
     * Constraints: Not nullable, Precision: 23, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>FixedAmountInGlobalCrcy</b>
     * </p>
     *
     * @param fixedAmountInGlobalCrcy
     *            Fixed Amount in Global Currency
     */
    public void setFixedAmountInGlobalCrcy( @Nullable final BigDecimal fixedAmountInGlobalCrcy )
    {
        rememberChangedField("FixedAmountInGlobalCrcy", this.fixedAmountInGlobalCrcy);
        this.fixedAmountInGlobalCrcy = fixedAmountInGlobalCrcy;
    }

    /**
     * Constraints: Not nullable, Precision: 23, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>GrpValnFixedAmtInGlobCrcy</b>
     * </p>
     *
     * @param grpValnFixedAmtInGlobCrcy
     *            Group Valuation Fixed Amount in Global Currency
     */
    public void setGrpValnFixedAmtInGlobCrcy( @Nullable final BigDecimal grpValnFixedAmtInGlobCrcy )
    {
        rememberChangedField("GrpValnFixedAmtInGlobCrcy", this.grpValnFixedAmtInGlobCrcy);
        this.grpValnFixedAmtInGlobCrcy = grpValnFixedAmtInGlobCrcy;
    }

    /**
     * Constraints: Not nullable, Precision: 23, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>PrftCtrValnFxdAmtInGlobCrcy</b>
     * </p>
     *
     * @param prftCtrValnFxdAmtInGlobCrcy
     *            Profit Center Valuation Fixed Amount in Global Currency
     */
    public void setPrftCtrValnFxdAmtInGlobCrcy( @Nullable final BigDecimal prftCtrValnFxdAmtInGlobCrcy )
    {
        rememberChangedField("PrftCtrValnFxdAmtInGlobCrcy", this.prftCtrValnFxdAmtInGlobCrcy);
        this.prftCtrValnFxdAmtInGlobCrcy = prftCtrValnFxdAmtInGlobCrcy;
    }

    /**
     * Constraints: Not nullable, Precision: 23, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>TotalPriceVarcInGlobalCrcy</b>
     * </p>
     *
     * @param totalPriceVarcInGlobalCrcy
     *            Total Price Variance in Global Currency
     */
    public void setTotalPriceVarcInGlobalCrcy( @Nullable final BigDecimal totalPriceVarcInGlobalCrcy )
    {
        rememberChangedField("TotalPriceVarcInGlobalCrcy", this.totalPriceVarcInGlobalCrcy);
        this.totalPriceVarcInGlobalCrcy = totalPriceVarcInGlobalCrcy;
    }

    /**
     * Constraints: Not nullable, Precision: 23, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>GrpValnTotPrcVarcInGlobCrcy</b>
     * </p>
     *
     * @param grpValnTotPrcVarcInGlobCrcy
     *            Group Valuation Total Price Variance in Global Currency
     */
    public void setGrpValnTotPrcVarcInGlobCrcy( @Nullable final BigDecimal grpValnTotPrcVarcInGlobCrcy )
    {
        rememberChangedField("GrpValnTotPrcVarcInGlobCrcy", this.grpValnTotPrcVarcInGlobCrcy);
        this.grpValnTotPrcVarcInGlobCrcy = grpValnTotPrcVarcInGlobCrcy;
    }

    /**
     * Constraints: Not nullable, Precision: 23, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>PrftCtrValnTotPrcVarcInGlbCrcy</b>
     * </p>
     *
     * @param prftCtrValnTotPrcVarcInGlbCrcy
     *            Profit Center Valuation Total Price Variance in Global Cur.
     */
    public void setPrftCtrValnTotPrcVarcInGlbCrcy( @Nullable final BigDecimal prftCtrValnTotPrcVarcInGlbCrcy )
    {
        rememberChangedField("PrftCtrValnTotPrcVarcInGlbCrcy", this.prftCtrValnTotPrcVarcInGlbCrcy);
        this.prftCtrValnTotPrcVarcInGlbCrcy = prftCtrValnTotPrcVarcInGlbCrcy;
    }

    /**
     * Constraints: Not nullable, Precision: 23, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>FixedPriceVarcInGlobalCrcy</b>
     * </p>
     *
     * @param fixedPriceVarcInGlobalCrcy
     *            Fixed Price Variance in Global Currency
     */
    public void setFixedPriceVarcInGlobalCrcy( @Nullable final BigDecimal fixedPriceVarcInGlobalCrcy )
    {
        rememberChangedField("FixedPriceVarcInGlobalCrcy", this.fixedPriceVarcInGlobalCrcy);
        this.fixedPriceVarcInGlobalCrcy = fixedPriceVarcInGlobalCrcy;
    }

    /**
     * Constraints: Not nullable, Precision: 23, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>GrpValnFixedPrcVarcInGlobCrcy</b>
     * </p>
     *
     * @param grpValnFixedPrcVarcInGlobCrcy
     *            Group Valuation Fixed Price Variance in Global Currency
     */
    public void setGrpValnFixedPrcVarcInGlobCrcy( @Nullable final BigDecimal grpValnFixedPrcVarcInGlobCrcy )
    {
        rememberChangedField("GrpValnFixedPrcVarcInGlobCrcy", this.grpValnFixedPrcVarcInGlobCrcy);
        this.grpValnFixedPrcVarcInGlobCrcy = grpValnFixedPrcVarcInGlobCrcy;
    }

    /**
     * Constraints: Not nullable, Precision: 23, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>PrftCtrValnFxdPrcVarcInGlbCrcy</b>
     * </p>
     *
     * @param prftCtrValnFxdPrcVarcInGlbCrcy
     *            Profit Center Valuation Fixed Price Variance in Global Cur.
     */
    public void setPrftCtrValnFxdPrcVarcInGlbCrcy( @Nullable final BigDecimal prftCtrValnFxdPrcVarcInGlbCrcy )
    {
        rememberChangedField("PrftCtrValnFxdPrcVarcInGlbCrcy", this.prftCtrValnFxdPrcVarcInGlbCrcy);
        this.prftCtrValnFxdPrcVarcInGlbCrcy = prftCtrValnFxdPrcVarcInGlbCrcy;
    }

    /**
     * Constraints: Not nullable, Precision: 23, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>FixedAmountInCoCodeCrcy</b>
     * </p>
     *
     * @param fixedAmountInCoCodeCrcy
     *            Fixed Amount in Company Currency
     */
    public void setFixedAmountInCoCodeCrcy( @Nullable final BigDecimal fixedAmountInCoCodeCrcy )
    {
        rememberChangedField("FixedAmountInCoCodeCrcy", this.fixedAmountInCoCodeCrcy);
        this.fixedAmountInCoCodeCrcy = fixedAmountInCoCodeCrcy;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>ControllingObjectCurrency</b>
     * </p>
     *
     * @param controllingObjectCurrency
     *            CO Object Currency
     */
    public void setControllingObjectCurrency( @Nullable final String controllingObjectCurrency )
    {
        rememberChangedField("ControllingObjectCurrency", this.controllingObjectCurrency);
        this.controllingObjectCurrency = controllingObjectCurrency;
    }

    /**
     * Constraints: Not nullable, Precision: 23, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>AmountInObjectCurrency</b>
     * </p>
     *
     * @param amountInObjectCurrency
     *            Amount in Object Currency
     */
    public void setAmountInObjectCurrency( @Nullable final BigDecimal amountInObjectCurrency )
    {
        rememberChangedField("AmountInObjectCurrency", this.amountInObjectCurrency);
        this.amountInObjectCurrency = amountInObjectCurrency;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BaseUnit</b>
     * </p>
     *
     * @param baseUnit
     *            Base Unit of Measure
     */
    public void setBaseUnit( @Nullable final String baseUnit )
    {
        rememberChangedField("BaseUnit", this.baseUnit);
        this.baseUnit = baseUnit;
    }

    /**
     * Constraints: Not nullable, Precision: 23, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>Quantity</b>
     * </p>
     *
     * @param quantity
     *            Quantity
     */
    public void setQuantity( @Nullable final BigDecimal quantity )
    {
        rememberChangedField("Quantity", this.quantity);
        this.quantity = quantity;
    }

    /**
     * Constraints: Not nullable, Precision: 23, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>FixedQuantity</b>
     * </p>
     *
     * @param fixedQuantity
     *            Fixed Quantity
     */
    public void setFixedQuantity( @Nullable final BigDecimal fixedQuantity )
    {
        rememberChangedField("FixedQuantity", this.fixedQuantity);
        this.fixedQuantity = fixedQuantity;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>CostSourceUnit</b>
     * </p>
     *
     * @param costSourceUnit
     *            Cost Source Unit
     */
    public void setCostSourceUnit( @Nullable final String costSourceUnit )
    {
        rememberChangedField("CostSourceUnit", this.costSourceUnit);
        this.costSourceUnit = costSourceUnit;
    }

    /**
     * Constraints: Not nullable, Precision: 23, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ValuationQuantity</b>
     * </p>
     *
     * @param valuationQuantity
     *            Valuation Quantity
     */
    public void setValuationQuantity( @Nullable final BigDecimal valuationQuantity )
    {
        rememberChangedField("ValuationQuantity", this.valuationQuantity);
        this.valuationQuantity = valuationQuantity;
    }

    /**
     * Constraints: Not nullable, Precision: 23, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ValuationFixedQuantity</b>
     * </p>
     *
     * @param valuationFixedQuantity
     *            Valuation Fixed Quantity
     */
    public void setValuationFixedQuantity( @Nullable final BigDecimal valuationFixedQuantity )
    {
        rememberChangedField("ValuationFixedQuantity", this.valuationFixedQuantity);
        this.valuationFixedQuantity = valuationFixedQuantity;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalQuantity1Unit</b>
     * </p>
     *
     * @param additionalQuantity1Unit
     *            Additional Quantity 1 Unit
     */
    public void setAdditionalQuantity1Unit( @Nullable final String additionalQuantity1Unit )
    {
        rememberChangedField("AdditionalQuantity1Unit", this.additionalQuantity1Unit);
        this.additionalQuantity1Unit = additionalQuantity1Unit;
    }

    /**
     * Constraints: Not nullable, Precision: 23, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalQuantity1</b>
     * </p>
     *
     * @param additionalQuantity1
     *            Additional Quantity 1
     */
    public void setAdditionalQuantity1( @Nullable final BigDecimal additionalQuantity1 )
    {
        rememberChangedField("AdditionalQuantity1", this.additionalQuantity1);
        this.additionalQuantity1 = additionalQuantity1;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalQuantity2Unit</b>
     * </p>
     *
     * @param additionalQuantity2Unit
     *            Additional Quantity 2 Unit
     */
    public void setAdditionalQuantity2Unit( @Nullable final String additionalQuantity2Unit )
    {
        rememberChangedField("AdditionalQuantity2Unit", this.additionalQuantity2Unit);
        this.additionalQuantity2Unit = additionalQuantity2Unit;
    }

    /**
     * Constraints: Not nullable, Precision: 23, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalQuantity2</b>
     * </p>
     *
     * @param additionalQuantity2
     *            Additional Quantity 2
     */
    public void setAdditionalQuantity2( @Nullable final BigDecimal additionalQuantity2 )
    {
        rememberChangedField("AdditionalQuantity2", this.additionalQuantity2);
        this.additionalQuantity2 = additionalQuantity2;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalQuantity3Unit</b>
     * </p>
     *
     * @param additionalQuantity3Unit
     *            Additional Quantity 3 Unit
     */
    public void setAdditionalQuantity3Unit( @Nullable final String additionalQuantity3Unit )
    {
        rememberChangedField("AdditionalQuantity3Unit", this.additionalQuantity3Unit);
        this.additionalQuantity3Unit = additionalQuantity3Unit;
    }

    /**
     * Constraints: Not nullable, Precision: 23, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalQuantity3</b>
     * </p>
     *
     * @param additionalQuantity3
     *            Additional Quantity 3
     */
    public void setAdditionalQuantity3( @Nullable final BigDecimal additionalQuantity3 )
    {
        rememberChangedField("AdditionalQuantity3", this.additionalQuantity3);
        this.additionalQuantity3 = additionalQuantity3;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>DebitCreditCode</b>
     * </p>
     *
     * @param debitCreditCode
     *            Debit/Credit Code
     */
    public void setDebitCreditCode( @Nullable final String debitCreditCode )
    {
        rememberChangedField("DebitCreditCode", this.debitCreditCode);
        this.debitCreditCode = debitCreditCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>FiscalPeriod</b>
     * </p>
     *
     * @param fiscalPeriod
     *            Fiscal Period
     */
    public void setFiscalPeriod( @Nullable final String fiscalPeriod )
    {
        rememberChangedField("FiscalPeriod", this.fiscalPeriod);
        this.fiscalPeriod = fiscalPeriod;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>FiscalYearVariant</b>
     * </p>
     *
     * @param fiscalYearVariant
     *            Fiscal Year Variant
     */
    public void setFiscalYearVariant( @Nullable final String fiscalYearVariant )
    {
        rememberChangedField("FiscalYearVariant", this.fiscalYearVariant);
        this.fiscalYearVariant = fiscalYearVariant;
    }

    /**
     * Constraints: Not nullable, Maximum length: 7
     * <p>
     * Original property name from the Odata EDM: <b>FiscalYearPeriod</b>
     * </p>
     *
     * @param fiscalYearPeriod
     *            Fiscal Year Period
     */
    public void setFiscalYearPeriod( @Nullable final String fiscalYearPeriod )
    {
        rememberChangedField("FiscalYearPeriod", this.fiscalYearPeriod);
        this.fiscalYearPeriod = fiscalYearPeriod;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>PostingDate</b>
     * </p>
     *
     * @param postingDate
     *            Posting Date
     */
    public void setPostingDate( @Nullable final LocalDateTime postingDate )
    {
        rememberChangedField("PostingDate", this.postingDate);
        this.postingDate = postingDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>DocumentDate</b>
     * </p>
     *
     * @param documentDate
     *            Journal Entry Date
     */
    public void setDocumentDate( @Nullable final LocalDateTime documentDate )
    {
        rememberChangedField("DocumentDate", this.documentDate);
        this.documentDate = documentDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>AccountingDocumentType</b>
     * </p>
     *
     * @param accountingDocumentType
     *            Journal Entry Type
     */
    public void setAccountingDocumentType( @Nullable final String accountingDocumentType )
    {
        rememberChangedField("AccountingDocumentType", this.accountingDocumentType);
        this.accountingDocumentType = accountingDocumentType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>AccountingDocumentItem</b>
     * </p>
     *
     * @param accountingDocumentItem
     *            Journal Entry Posting View Item
     */
    public void setAccountingDocumentItem( @Nullable final String accountingDocumentItem )
    {
        rememberChangedField("AccountingDocumentItem", this.accountingDocumentItem);
        this.accountingDocumentItem = accountingDocumentItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>AssignmentReference</b>
     * </p>
     *
     * @param assignmentReference
     *            Assignment Reference
     */
    public void setAssignmentReference( @Nullable final String assignmentReference )
    {
        rememberChangedField("AssignmentReference", this.assignmentReference);
        this.assignmentReference = assignmentReference;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>AccountingDocumentCategory</b>
     * </p>
     *
     * @param accountingDocumentCategory
     *            Journal Entry Category
     */
    public void setAccountingDocumentCategory( @Nullable final String accountingDocumentCategory )
    {
        rememberChangedField("AccountingDocumentCategory", this.accountingDocumentCategory);
        this.accountingDocumentCategory = accountingDocumentCategory;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>PostingKey</b>
     * </p>
     *
     * @param postingKey
     *            Posting Key
     */
    public void setPostingKey( @Nullable final String postingKey )
    {
        rememberChangedField("PostingKey", this.postingKey);
        this.postingKey = postingKey;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>TransactionTypeDetermination</b>
     * </p>
     *
     * @param transactionTypeDetermination
     *            Transaction Key
     */
    public void setTransactionTypeDetermination( @Nullable final String transactionTypeDetermination )
    {
        rememberChangedField("TransactionTypeDetermination", this.transactionTypeDetermination);
        this.transactionTypeDetermination = transactionTypeDetermination;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>SubLedgerAcctLineItemType</b>
     * </p>
     *
     * @param subLedgerAcctLineItemType
     *            Subledger-Specific Line Item Type
     */
    public void setSubLedgerAcctLineItemType( @Nullable final String subLedgerAcctLineItemType )
    {
        rememberChangedField("SubLedgerAcctLineItemType", this.subLedgerAcctLineItemType);
        this.subLedgerAcctLineItemType = subLedgerAcctLineItemType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>AccountingDocCreatedByUser</b>
     * </p>
     *
     * @param accountingDocCreatedByUser
     *            User that created the journal entry
     */
    public void setAccountingDocCreatedByUser( @Nullable final String accountingDocCreatedByUser )
    {
        rememberChangedField("AccountingDocCreatedByUser", this.accountingDocCreatedByUser);
        this.accountingDocCreatedByUser = accountingDocCreatedByUser;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDateTime</b>
     * </p>
     *
     * @param lastChangeDateTime
     *            Time Stamp of Last Change
     */
    public void setLastChangeDateTime( @Nullable final ZonedDateTime lastChangeDateTime )
    {
        rememberChangedField("LastChangeDateTime", this.lastChangeDateTime);
        this.lastChangeDateTime = lastChangeDateTime;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationDateTime</b>
     * </p>
     *
     * @param creationDateTime
     *            Time Stamp of Creation
     */
    public void setCreationDateTime( @Nullable final ZonedDateTime creationDateTime )
    {
        rememberChangedField("CreationDateTime", this.creationDateTime);
        this.creationDateTime = creationDateTime;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationDate</b>
     * </p>
     *
     * @param creationDate
     *            Creation Date
     */
    public void setCreationDate( @Nullable final LocalDateTime creationDate )
    {
        rememberChangedField("CreationDate", this.creationDate);
        this.creationDate = creationDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>EliminationProfitCenter</b>
     * </p>
     *
     * @param eliminationProfitCenter
     *            Elimination Profit Center
     */
    public void setEliminationProfitCenter( @Nullable final String eliminationProfitCenter )
    {
        rememberChangedField("EliminationProfitCenter", this.eliminationProfitCenter);
        this.eliminationProfitCenter = eliminationProfitCenter;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>OriginObjectType</b>
     * </p>
     *
     * @param originObjectType
     *            Type of Origin Object
     */
    public void setOriginObjectType( @Nullable final String originObjectType )
    {
        rememberChangedField("OriginObjectType", this.originObjectType);
        this.originObjectType = originObjectType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>GLAccountType</b>
     * </p>
     *
     * @param gLAccountType
     *            Type of a General Ledger Account
     */
    public void setGLAccountType( @Nullable final String gLAccountType )
    {
        rememberChangedField("GLAccountType", this.gLAccountType);
        this.gLAccountType = gLAccountType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>AlternativeGLAccount</b>
     * </p>
     *
     * @param alternativeGLAccount
     *            Alternative G/L Account Number In Company Code
     */
    public void setAlternativeGLAccount( @Nullable final String alternativeGLAccount )
    {
        rememberChangedField("AlternativeGLAccount", this.alternativeGLAccount);
        this.alternativeGLAccount = alternativeGLAccount;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CountryChartOfAccounts</b>
     * </p>
     *
     * @param countryChartOfAccounts
     *            Alternative Chart of Accounts for Country/Region
     */
    public void setCountryChartOfAccounts( @Nullable final String countryChartOfAccounts )
    {
        rememberChangedField("CountryChartOfAccounts", this.countryChartOfAccounts);
        this.countryChartOfAccounts = countryChartOfAccounts;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ItemIsSplit</b>
     * </p>
     *
     * @param itemIsSplit
     *            Item changed by document splitting
     */
    public void setItemIsSplit( @Nullable final Boolean itemIsSplit )
    {
        rememberChangedField("ItemIsSplit", this.itemIsSplit);
        this.itemIsSplit = itemIsSplit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>InvoiceReference</b>
     * </p>
     *
     * @param invoiceReference
     *            Invoice Reference
     */
    public void setInvoiceReference( @Nullable final String invoiceReference )
    {
        rememberChangedField("InvoiceReference", this.invoiceReference);
        this.invoiceReference = invoiceReference;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>InvoiceReferenceFiscalYear</b>
     * </p>
     *
     * @param invoiceReferenceFiscalYear
     *            Invoice Reference Fiscal Year
     */
    public void setInvoiceReferenceFiscalYear( @Nullable final String invoiceReferenceFiscalYear )
    {
        rememberChangedField("InvoiceReferenceFiscalYear", this.invoiceReferenceFiscalYear);
        this.invoiceReferenceFiscalYear = invoiceReferenceFiscalYear;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>FollowOnDocumentType</b>
     * </p>
     *
     * @param followOnDocumentType
     *            Follow-On Document Type
     */
    public void setFollowOnDocumentType( @Nullable final String followOnDocumentType )
    {
        rememberChangedField("FollowOnDocumentType", this.followOnDocumentType);
        this.followOnDocumentType = followOnDocumentType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>InvoiceItemReference</b>
     * </p>
     *
     * @param invoiceItemReference
     *            Invoice Item Reference
     */
    public void setInvoiceItemReference( @Nullable final String invoiceItemReference )
    {
        rememberChangedField("InvoiceItemReference", this.invoiceItemReference);
        this.invoiceItemReference = invoiceItemReference;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ReferencePurchaseOrderCategory</b>
     * </p>
     *
     * @param referencePurchaseOrderCategory
     *            Category of Reference Purchase Order
     */
    public void setReferencePurchaseOrderCategory( @Nullable final String referencePurchaseOrderCategory )
    {
        rememberChangedField("ReferencePurchaseOrderCategory", this.referencePurchaseOrderCategory);
        this.referencePurchaseOrderCategory = referencePurchaseOrderCategory;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingDocument</b>
     * </p>
     *
     * @param purchasingDocument
     *            Purchasing Document
     */
    public void setPurchasingDocument( @Nullable final String purchasingDocument )
    {
        rememberChangedField("PurchasingDocument", this.purchasingDocument);
        this.purchasingDocument = purchasingDocument;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingDocumentItem</b>
     * </p>
     *
     * @param purchasingDocumentItem
     *            Purchasing Document Item
     */
    public void setPurchasingDocumentItem( @Nullable final String purchasingDocumentItem )
    {
        rememberChangedField("PurchasingDocumentItem", this.purchasingDocumentItem);
        this.purchasingDocumentItem = purchasingDocumentItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>AccountAssignmentNumber</b>
     * </p>
     *
     * @param accountAssignmentNumber
     *            Account Assignment Number
     */
    public void setAccountAssignmentNumber( @Nullable final String accountAssignmentNumber )
    {
        rememberChangedField("AccountAssignmentNumber", this.accountAssignmentNumber);
        this.accountAssignmentNumber = accountAssignmentNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>DocumentItemText</b>
     * </p>
     *
     * @param documentItemText
     *            Item Text
     */
    public void setDocumentItemText( @Nullable final String documentItemText )
    {
        rememberChangedField("DocumentItemText", this.documentItemText);
        this.documentItemText = documentItemText;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SalesDocument</b>
     * </p>
     *
     * @param salesDocument
     *            Sales Document
     */
    public void setSalesDocument( @Nullable final String salesDocument )
    {
        rememberChangedField("SalesDocument", this.salesDocument);
        this.salesDocument = salesDocument;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>SalesDocumentItem</b>
     * </p>
     *
     * @param salesDocumentItem
     *            Sales Document Item
     */
    public void setSalesDocumentItem( @Nullable final String salesDocumentItem )
    {
        rememberChangedField("SalesDocumentItem", this.salesDocumentItem);
        this.salesDocumentItem = salesDocumentItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>Product</b>
     * </p>
     *
     * @param product
     *            Product Number
     */
    public void setProduct( @Nullable final String product )
    {
        rememberChangedField("Product", this.product);
        this.product = product;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @param plant
     *            Plant
     */
    public void setPlant( @Nullable final String plant )
    {
        rememberChangedField("Plant", this.plant);
        this.plant = plant;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Supplier</b>
     * </p>
     *
     * @param supplier
     *            Supplier
     */
    public void setSupplier( @Nullable final String supplier )
    {
        rememberChangedField("Supplier", this.supplier);
        this.supplier = supplier;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Customer</b>
     * </p>
     *
     * @param customer
     *            Customer Number
     */
    public void setCustomer( @Nullable final String customer )
    {
        rememberChangedField("Customer", this.customer);
        this.customer = customer;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ServicesRenderedDate</b>
     * </p>
     *
     * @param servicesRenderedDate
     *            Date on which services are rendered
     */
    public void setServicesRenderedDate( @Nullable final LocalDateTime servicesRenderedDate )
    {
        rememberChangedField("ServicesRenderedDate", this.servicesRenderedDate);
        this.servicesRenderedDate = servicesRenderedDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ConditionContract</b>
     * </p>
     *
     * @param conditionContract
     *            Condition Contract
     */
    public void setConditionContract( @Nullable final String conditionContract )
    {
        rememberChangedField("ConditionContract", this.conditionContract);
        this.conditionContract = conditionContract;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>FinancialAccountType</b>
     * </p>
     *
     * @param financialAccountType
     *            Account Type
     */
    public void setFinancialAccountType( @Nullable final String financialAccountType )
    {
        rememberChangedField("FinancialAccountType", this.financialAccountType);
        this.financialAccountType = financialAccountType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>SpecialGLCode</b>
     * </p>
     *
     * @param specialGLCode
     *            Special G/L Indicator
     */
    public void setSpecialGLCode( @Nullable final String specialGLCode )
    {
        rememberChangedField("SpecialGLCode", this.specialGLCode);
        this.specialGLCode = specialGLCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>TaxCode</b>
     * </p>
     *
     * @param taxCode
     *            Tax on Sales/Purchases Code
     */
    public void setTaxCode( @Nullable final String taxCode )
    {
        rememberChangedField("TaxCode", this.taxCode);
        this.taxCode = taxCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>HouseBank</b>
     * </p>
     *
     * @param houseBank
     *            House Bank Key
     */
    public void setHouseBank( @Nullable final String houseBank )
    {
        rememberChangedField("HouseBank", this.houseBank);
        this.houseBank = houseBank;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>HouseBankAccount</b>
     * </p>
     *
     * @param houseBankAccount
     *            House Bank Account
     */
    public void setHouseBankAccount( @Nullable final String houseBankAccount )
    {
        rememberChangedField("HouseBankAccount", this.houseBankAccount);
        this.houseBankAccount = houseBankAccount;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>IsOpenItemManaged</b>
     * </p>
     *
     * @param isOpenItemManaged
     *            Managed on an Open Item Basis
     */
    public void setIsOpenItemManaged( @Nullable final String isOpenItemManaged )
    {
        rememberChangedField("IsOpenItemManaged", this.isOpenItemManaged);
        this.isOpenItemManaged = isOpenItemManaged;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ClearingDate</b>
     * </p>
     *
     * @param clearingDate
     *            Clearing Date
     */
    public void setClearingDate( @Nullable final LocalDateTime clearingDate )
    {
        rememberChangedField("ClearingDate", this.clearingDate);
        this.clearingDate = clearingDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ClearingAccountingDocument</b>
     * </p>
     *
     * @param clearingAccountingDocument
     *            Clearing Journal Entry
     */
    public void setClearingAccountingDocument( @Nullable final String clearingAccountingDocument )
    {
        rememberChangedField("ClearingAccountingDocument", this.clearingAccountingDocument);
        this.clearingAccountingDocument = clearingAccountingDocument;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ClearingDocFiscalYear</b>
     * </p>
     *
     * @param clearingDocFiscalYear
     *            Fiscal Year of Clearing Journal Entry
     */
    public void setClearingDocFiscalYear( @Nullable final String clearingDocFiscalYear )
    {
        rememberChangedField("ClearingDocFiscalYear", this.clearingDocFiscalYear);
        this.clearingDocFiscalYear = clearingDocFiscalYear;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValueDate</b>
     * </p>
     *
     * @param valueDate
     *            Value Date
     */
    public void setValueDate( @Nullable final LocalDateTime valueDate )
    {
        rememberChangedField("ValueDate", this.valueDate);
        this.valueDate = valueDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>AssetDepreciationArea</b>
     * </p>
     *
     * @param assetDepreciationArea
     *            Asset Depreciation Area (Real or Derived)
     */
    public void setAssetDepreciationArea( @Nullable final String assetDepreciationArea )
    {
        rememberChangedField("AssetDepreciationArea", this.assetDepreciationArea);
        this.assetDepreciationArea = assetDepreciationArea;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>MasterFixedAsset</b>
     * </p>
     *
     * @param masterFixedAsset
     *            Fixed Asset
     */
    public void setMasterFixedAsset( @Nullable final String masterFixedAsset )
    {
        rememberChangedField("MasterFixedAsset", this.masterFixedAsset);
        this.masterFixedAsset = masterFixedAsset;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>FixedAsset</b>
     * </p>
     *
     * @param fixedAsset
     *            Asset Subnumber
     */
    public void setFixedAsset( @Nullable final String fixedAsset )
    {
        rememberChangedField("FixedAsset", this.fixedAsset);
        this.fixedAsset = fixedAsset;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>AssetValueDate</b>
     * </p>
     *
     * @param assetValueDate
     *            Asset Value Date
     */
    public void setAssetValueDate( @Nullable final LocalDateTime assetValueDate )
    {
        rememberChangedField("AssetValueDate", this.assetValueDate);
        this.assetValueDate = assetValueDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>AssetTransactionType</b>
     * </p>
     *
     * @param assetTransactionType
     *            Asset Transaction Type
     */
    public void setAssetTransactionType( @Nullable final String assetTransactionType )
    {
        rememberChangedField("AssetTransactionType", this.assetTransactionType);
        this.assetTransactionType = assetTransactionType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>AssetAcctTransClassfctn</b>
     * </p>
     *
     * @param assetAcctTransClassfctn
     *            Transaction Type Category
     */
    public void setAssetAcctTransClassfctn( @Nullable final String assetAcctTransClassfctn )
    {
        rememberChangedField("AssetAcctTransClassfctn", this.assetAcctTransClassfctn);
        this.assetAcctTransClassfctn = assetAcctTransClassfctn;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>DepreciationFiscalPeriod</b>
     * </p>
     *
     * @param depreciationFiscalPeriod
     *            Fiscal Period of Depreciation
     */
    public void setDepreciationFiscalPeriod( @Nullable final String depreciationFiscalPeriod )
    {
        rememberChangedField("DepreciationFiscalPeriod", this.depreciationFiscalPeriod);
        this.depreciationFiscalPeriod = depreciationFiscalPeriod;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>GroupMasterFixedAsset</b>
     * </p>
     *
     * @param groupMasterFixedAsset
     *            Group Asset
     */
    public void setGroupMasterFixedAsset( @Nullable final String groupMasterFixedAsset )
    {
        rememberChangedField("GroupMasterFixedAsset", this.groupMasterFixedAsset);
        this.groupMasterFixedAsset = groupMasterFixedAsset;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>GroupFixedAsset</b>
     * </p>
     *
     * @param groupFixedAsset
     *            Group Asset Subnumber
     */
    public void setGroupFixedAsset( @Nullable final String groupFixedAsset )
    {
        rememberChangedField("GroupFixedAsset", this.groupFixedAsset);
        this.groupFixedAsset = groupFixedAsset;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>AssetClass</b>
     * </p>
     *
     * @param assetClass
     *            Asset Class
     */
    public void setAssetClass( @Nullable final String assetClass )
    {
        rememberChangedField("AssetClass", this.assetClass);
        this.assetClass = assetClass;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CostEstimate</b>
     * </p>
     *
     * @param costEstimate
     *            Cost Estimate
     */
    public void setCostEstimate( @Nullable final String costEstimate )
    {
        rememberChangedField("CostEstimate", this.costEstimate);
        this.costEstimate = costEstimate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InventorySpecialStockValnType</b>
     * </p>
     *
     * @param inventorySpecialStockValnType
     *            Inventory Special Stock Valuation Type
     */
    public void setInventorySpecialStockValnType( @Nullable final String inventorySpecialStockValnType )
    {
        rememberChangedField("InventorySpecialStockValnType", this.inventorySpecialStockValnType);
        this.inventorySpecialStockValnType = inventorySpecialStockValnType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InventorySpecialStockType</b>
     * </p>
     *
     * @param inventorySpecialStockType
     *            Inventory Special Stock Type
     */
    public void setInventorySpecialStockType( @Nullable final String inventorySpecialStockType )
    {
        rememberChangedField("InventorySpecialStockType", this.inventorySpecialStockType);
        this.inventorySpecialStockType = inventorySpecialStockType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>InventorySpclStkSalesDocument</b>
     * </p>
     *
     * @param inventorySpclStkSalesDocument
     *            Inventory Special Stock Sales Document
     */
    public void setInventorySpclStkSalesDocument( @Nullable final String inventorySpclStkSalesDocument )
    {
        rememberChangedField("InventorySpclStkSalesDocument", this.inventorySpclStkSalesDocument);
        this.inventorySpclStkSalesDocument = inventorySpclStkSalesDocument;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>InventorySpclStkSalesDocItm</b>
     * </p>
     *
     * @param inventorySpclStkSalesDocItm
     *            Inventory Special Stock Sales Document Item
     */
    public void setInventorySpclStkSalesDocItm( @Nullable final String inventorySpclStkSalesDocItm )
    {
        rememberChangedField("InventorySpclStkSalesDocItm", this.inventorySpclStkSalesDocItm);
        this.inventorySpclStkSalesDocItm = inventorySpclStkSalesDocItm;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>InvtrySpclStockWBSElmntIntID</b>
     * </p>
     *
     * @param invtrySpclStockWBSElmntIntID
     *            Inventory Special Stock WBS Element Internal ID
     */
    public void setInvtrySpclStockWBSElmntIntID( @Nullable final String invtrySpclStockWBSElmntIntID )
    {
        rememberChangedField("InvtrySpclStockWBSElmntIntID", this.invtrySpclStockWBSElmntIntID);
        this.invtrySpclStockWBSElmntIntID = invtrySpclStockWBSElmntIntID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>InventorySpecialStockSupplier</b>
     * </p>
     *
     * @param inventorySpecialStockSupplier
     *            Supplier of Inventory Special Stock
     */
    public void setInventorySpecialStockSupplier( @Nullable final String inventorySpecialStockSupplier )
    {
        rememberChangedField("InventorySpecialStockSupplier", this.inventorySpecialStockSupplier);
        this.inventorySpecialStockSupplier = inventorySpecialStockSupplier;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>InventoryValuationType</b>
     * </p>
     *
     * @param inventoryValuationType
     *            Inventory Valuation Type
     */
    public void setInventoryValuationType( @Nullable final String inventoryValuationType )
    {
        rememberChangedField("InventoryValuationType", this.inventoryValuationType);
        this.inventoryValuationType = inventoryValuationType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ValuationArea</b>
     * </p>
     *
     * @param valuationArea
     *            Valuation Area
     */
    public void setValuationArea( @Nullable final String valuationArea )
    {
        rememberChangedField("ValuationArea", this.valuationArea);
        this.valuationArea = valuationArea;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CostOriginGroup</b>
     * </p>
     *
     * @param costOriginGroup
     *            Origin Group as Subdivision of Cost Element
     */
    public void setCostOriginGroup( @Nullable final String costOriginGroup )
    {
        rememberChangedField("CostOriginGroup", this.costOriginGroup);
        this.costOriginGroup = costOriginGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 22
     * <p>
     * Original property name from the Odata EDM: <b>OriginSenderObject</b>
     * </p>
     *
     * @param originSenderObject
     *            Origin Sender Object
     */
    public void setOriginSenderObject( @Nullable final String originSenderObject )
    {
        rememberChangedField("OriginSenderObject", this.originSenderObject);
        this.originSenderObject = originSenderObject;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ControllingObjectDebitType</b>
     * </p>
     *
     * @param controllingObjectDebitType
     *            Controlling Object Debit Type
     */
    public void setControllingObjectDebitType( @Nullable final String controllingObjectDebitType )
    {
        rememberChangedField("ControllingObjectDebitType", this.controllingObjectDebitType);
        this.controllingObjectDebitType = controllingObjectDebitType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>QuantityIsIncomplete</b>
     * </p>
     *
     * @param quantityIsIncomplete
     *            Indicator: Quantity Is Incomplete
     */
    public void setQuantityIsIncomplete( @Nullable final String quantityIsIncomplete )
    {
        rememberChangedField("QuantityIsIncomplete", this.quantityIsIncomplete);
        this.quantityIsIncomplete = quantityIsIncomplete;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>OffsettingAccount</b>
     * </p>
     *
     * @param offsettingAccount
     *            Offsetting Account
     */
    public void setOffsettingAccount( @Nullable final String offsettingAccount )
    {
        rememberChangedField("OffsettingAccount", this.offsettingAccount);
        this.offsettingAccount = offsettingAccount;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>OffsettingAccountType</b>
     * </p>
     *
     * @param offsettingAccountType
     *            Offsetting Account Type
     */
    public void setOffsettingAccountType( @Nullable final String offsettingAccountType )
    {
        rememberChangedField("OffsettingAccountType", this.offsettingAccountType);
        this.offsettingAccountType = offsettingAccountType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>OffsettingChartOfAccounts</b>
     * </p>
     *
     * @param offsettingChartOfAccounts
     *            Offsetting Chart of Accounts
     */
    public void setOffsettingChartOfAccounts( @Nullable final String offsettingChartOfAccounts )
    {
        rememberChangedField("OffsettingChartOfAccounts", this.offsettingChartOfAccounts);
        this.offsettingChartOfAccounts = offsettingChartOfAccounts;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>LineItemIsCompleted</b>
     * </p>
     *
     * @param lineItemIsCompleted
     *            Indicator: Line Item is Completed
     */
    public void setLineItemIsCompleted( @Nullable final Boolean lineItemIsCompleted )
    {
        rememberChangedField("LineItemIsCompleted", this.lineItemIsCompleted);
        this.lineItemIsCompleted = lineItemIsCompleted;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>PersonnelNumber</b>
     * </p>
     *
     * @param personnelNumber
     *            Personnel Number
     */
    public void setPersonnelNumber( @Nullable final String personnelNumber )
    {
        rememberChangedField("PersonnelNumber", this.personnelNumber);
        this.personnelNumber = personnelNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ControllingObjectClass</b>
     * </p>
     *
     * @param controllingObjectClass
     *            Controlling Object Class
     */
    public void setControllingObjectClass( @Nullable final String controllingObjectClass )
    {
        rememberChangedField("ControllingObjectClass", this.controllingObjectClass);
        this.controllingObjectClass = controllingObjectClass;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PartnerCompanyCode</b>
     * </p>
     *
     * @param partnerCompanyCode
     *            Partner Company Code
     */
    public void setPartnerCompanyCode( @Nullable final String partnerCompanyCode )
    {
        rememberChangedField("PartnerCompanyCode", this.partnerCompanyCode);
        this.partnerCompanyCode = partnerCompanyCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>PartnerControllingObjectClass</b>
     * </p>
     *
     * @param partnerControllingObjectClass
     *            Partner Controlling Object Class
     */
    public void setPartnerControllingObjectClass( @Nullable final String partnerControllingObjectClass )
    {
        rememberChangedField("PartnerControllingObjectClass", this.partnerControllingObjectClass);
        this.partnerControllingObjectClass = partnerControllingObjectClass;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>OriginCostCenter</b>
     * </p>
     *
     * @param originCostCenter
     *            Origin Cost Center
     */
    public void setOriginCostCenter( @Nullable final String originCostCenter )
    {
        rememberChangedField("OriginCostCenter", this.originCostCenter);
        this.originCostCenter = originCostCenter;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>OriginProfitCenter</b>
     * </p>
     *
     * @param originProfitCenter
     *            Origin Profit Center
     */
    public void setOriginProfitCenter( @Nullable final String originProfitCenter )
    {
        rememberChangedField("OriginProfitCenter", this.originProfitCenter);
        this.originProfitCenter = originProfitCenter;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>OriginCostCtrActivityType</b>
     * </p>
     *
     * @param originCostCtrActivityType
     *            Origin Cost Center Activity Type
     */
    public void setOriginCostCtrActivityType( @Nullable final String originCostCtrActivityType )
    {
        rememberChangedField("OriginCostCtrActivityType", this.originCostCtrActivityType);
        this.originCostCtrActivityType = originCostCtrActivityType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>AccountAssignment</b>
     * </p>
     *
     * @param accountAssignment
     *            Account Assignment
     */
    public void setAccountAssignment( @Nullable final String accountAssignment )
    {
        rememberChangedField("AccountAssignment", this.accountAssignment);
        this.accountAssignment = accountAssignment;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>AccountAssignmentType</b>
     * </p>
     *
     * @param accountAssignmentType
     *            Account Assignment Type
     */
    public void setAccountAssignmentType( @Nullable final String accountAssignmentType )
    {
        rememberChangedField("AccountAssignmentType", this.accountAssignmentType);
        this.accountAssignmentType = accountAssignmentType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>CostCtrActivityType</b>
     * </p>
     *
     * @param costCtrActivityType
     *            Activity Type
     */
    public void setCostCtrActivityType( @Nullable final String costCtrActivityType )
    {
        rememberChangedField("CostCtrActivityType", this.costCtrActivityType);
        this.costCtrActivityType = costCtrActivityType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>OrderID</b>
     * </p>
     *
     * @param orderID
     *            Order ID
     */
    public void setOrderID( @Nullable final String orderID )
    {
        rememberChangedField("OrderID", this.orderID);
        this.orderID = orderID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>OrderCategory</b>
     * </p>
     *
     * @param orderCategory
     *            Order Category
     */
    public void setOrderCategory( @Nullable final String orderCategory )
    {
        rememberChangedField("OrderCategory", this.orderCategory);
        this.orderCategory = orderCategory;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>WBSElementInternalID</b>
     * </p>
     *
     * @param wBSElementInternalID
     *            WBS Element Internal ID
     */
    public void setWBSElementInternalID( @Nullable final String wBSElementInternalID )
    {
        rememberChangedField("WBSElementInternalID", this.wBSElementInternalID);
        this.wBSElementInternalID = wBSElementInternalID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>PartnerWBSElementInternalID</b>
     * </p>
     *
     * @param partnerWBSElementInternalID
     *            Partner WBS Element Internal ID
     */
    public void setPartnerWBSElementInternalID( @Nullable final String partnerWBSElementInternalID )
    {
        rememberChangedField("PartnerWBSElementInternalID", this.partnerWBSElementInternalID);
        this.partnerWBSElementInternalID = partnerWBSElementInternalID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>ProjectInternalID</b>
     * </p>
     *
     * @param projectInternalID
     *            Project Internal ID
     */
    public void setProjectInternalID( @Nullable final String projectInternalID )
    {
        rememberChangedField("ProjectInternalID", this.projectInternalID);
        this.projectInternalID = projectInternalID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>PartnerProjectInternalID</b>
     * </p>
     *
     * @param partnerProjectInternalID
     *            Partner Project Internal ID
     */
    public void setPartnerProjectInternalID( @Nullable final String partnerProjectInternalID )
    {
        rememberChangedField("PartnerProjectInternalID", this.partnerProjectInternalID);
        this.partnerProjectInternalID = partnerProjectInternalID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>OperatingConcern</b>
     * </p>
     *
     * @param operatingConcern
     *            Operating Concern
     */
    public void setOperatingConcern( @Nullable final String operatingConcern )
    {
        rememberChangedField("OperatingConcern", this.operatingConcern);
        this.operatingConcern = operatingConcern;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>ProjectNetwork</b>
     * </p>
     *
     * @param projectNetwork
     *            Network Number for Account Assignment
     */
    public void setProjectNetwork( @Nullable final String projectNetwork )
    {
        rememberChangedField("ProjectNetwork", this.projectNetwork);
        this.projectNetwork = projectNetwork;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>BusinessProcess</b>
     * </p>
     *
     * @param businessProcess
     *            Business Process
     */
    public void setBusinessProcess( @Nullable final String businessProcess )
    {
        rememberChangedField("BusinessProcess", this.businessProcess);
        this.businessProcess = businessProcess;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CostObject</b>
     * </p>
     *
     * @param costObject
     *            Cost Object
     */
    public void setCostObject( @Nullable final String costObject )
    {
        rememberChangedField("CostObject", this.costObject);
        this.costObject = costObject;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>BillableControl</b>
     * </p>
     *
     * @param billableControl
     *            Billable Control
     */
    public void setBillableControl( @Nullable final String billableControl )
    {
        rememberChangedField("BillableControl", this.billableControl);
        this.billableControl = billableControl;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CostAnalysisResource</b>
     * </p>
     *
     * @param costAnalysisResource
     *            Cost Analysis Resource
     */
    public void setCostAnalysisResource( @Nullable final String costAnalysisResource )
    {
        rememberChangedField("CostAnalysisResource", this.costAnalysisResource);
        this.costAnalysisResource = costAnalysisResource;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CustomerServiceNotification</b>
     * </p>
     *
     * @param customerServiceNotification
     *            Customer Service Notification
     */
    public void setCustomerServiceNotification( @Nullable final String customerServiceNotification )
    {
        rememberChangedField("CustomerServiceNotification", this.customerServiceNotification);
        this.customerServiceNotification = customerServiceNotification;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ServiceDocumentType</b>
     * </p>
     *
     * @param serviceDocumentType
     *            Service Document Type
     */
    public void setServiceDocumentType( @Nullable final String serviceDocumentType )
    {
        rememberChangedField("ServiceDocumentType", this.serviceDocumentType);
        this.serviceDocumentType = serviceDocumentType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ServiceDocument</b>
     * </p>
     *
     * @param serviceDocument
     *            Service Document ID
     */
    public void setServiceDocument( @Nullable final String serviceDocument )
    {
        rememberChangedField("ServiceDocument", this.serviceDocument);
        this.serviceDocument = serviceDocument;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>ServiceDocumentItem</b>
     * </p>
     *
     * @param serviceDocumentItem
     *            Service Document Item ID
     */
    public void setServiceDocumentItem( @Nullable final String serviceDocumentItem )
    {
        rememberChangedField("ServiceDocumentItem", this.serviceDocumentItem);
        this.serviceDocumentItem = serviceDocumentItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PartnerServiceDocumentType</b>
     * </p>
     *
     * @param partnerServiceDocumentType
     *            Partner Service Document Type
     */
    public void setPartnerServiceDocumentType( @Nullable final String partnerServiceDocumentType )
    {
        rememberChangedField("PartnerServiceDocumentType", this.partnerServiceDocumentType);
        this.partnerServiceDocumentType = partnerServiceDocumentType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PartnerServiceDocument</b>
     * </p>
     *
     * @param partnerServiceDocument
     *            Partner Service Document
     */
    public void setPartnerServiceDocument( @Nullable final String partnerServiceDocument )
    {
        rememberChangedField("PartnerServiceDocument", this.partnerServiceDocument);
        this.partnerServiceDocument = partnerServiceDocument;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>PartnerServiceDocumentItem</b>
     * </p>
     *
     * @param partnerServiceDocumentItem
     *            Partner Service Document Item
     */
    public void setPartnerServiceDocumentItem( @Nullable final String partnerServiceDocumentItem )
    {
        rememberChangedField("PartnerServiceDocumentItem", this.partnerServiceDocumentItem);
        this.partnerServiceDocumentItem = partnerServiceDocumentItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ServiceContractType</b>
     * </p>
     *
     * @param serviceContractType
     *            Service Contract Type
     */
    public void setServiceContractType( @Nullable final String serviceContractType )
    {
        rememberChangedField("ServiceContractType", this.serviceContractType);
        this.serviceContractType = serviceContractType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ServiceContract</b>
     * </p>
     *
     * @param serviceContract
     *            Service Contract ID
     */
    public void setServiceContract( @Nullable final String serviceContract )
    {
        rememberChangedField("ServiceContract", this.serviceContract);
        this.serviceContract = serviceContract;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>ServiceContractItem</b>
     * </p>
     *
     * @param serviceContractItem
     *            Service Contract Item ID
     */
    public void setServiceContractItem( @Nullable final String serviceContractItem )
    {
        rememberChangedField("ServiceContractItem", this.serviceContractItem);
        this.serviceContractItem = serviceContractItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>TimeSheetOvertimeCategory</b>
     * </p>
     *
     * @param timeSheetOvertimeCategory
     *            Overtime Category
     */
    public void setTimeSheetOvertimeCategory( @Nullable final String timeSheetOvertimeCategory )
    {
        rememberChangedField("TimeSheetOvertimeCategory", this.timeSheetOvertimeCategory);
        this.timeSheetOvertimeCategory = timeSheetOvertimeCategory;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>PartnerAccountAssignment</b>
     * </p>
     *
     * @param partnerAccountAssignment
     *            Partner Account Assignment
     */
    public void setPartnerAccountAssignment( @Nullable final String partnerAccountAssignment )
    {
        rememberChangedField("PartnerAccountAssignment", this.partnerAccountAssignment);
        this.partnerAccountAssignment = partnerAccountAssignment;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>PartnerAccountAssignmentType</b>
     * </p>
     *
     * @param partnerAccountAssignmentType
     *            Partner Account Assignment Type
     */
    public void setPartnerAccountAssignmentType( @Nullable final String partnerAccountAssignmentType )
    {
        rememberChangedField("PartnerAccountAssignmentType", this.partnerAccountAssignmentType);
        this.partnerAccountAssignmentType = partnerAccountAssignmentType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>PartnerCostCtrActivityType</b>
     * </p>
     *
     * @param partnerCostCtrActivityType
     *            Partner Cost Center Activity Type
     */
    public void setPartnerCostCtrActivityType( @Nullable final String partnerCostCtrActivityType )
    {
        rememberChangedField("PartnerCostCtrActivityType", this.partnerCostCtrActivityType);
        this.partnerCostCtrActivityType = partnerCostCtrActivityType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>PartnerOrder</b>
     * </p>
     *
     * @param partnerOrder
     *            Partner Order
     */
    public void setPartnerOrder( @Nullable final String partnerOrder )
    {
        rememberChangedField("PartnerOrder", this.partnerOrder);
        this.partnerOrder = partnerOrder;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>PartnerOrderCategory</b>
     * </p>
     *
     * @param partnerOrderCategory
     *            Partner Order Category
     */
    public void setPartnerOrderCategory( @Nullable final String partnerOrderCategory )
    {
        rememberChangedField("PartnerOrderCategory", this.partnerOrderCategory);
        this.partnerOrderCategory = partnerOrderCategory;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PartnerSalesDocument</b>
     * </p>
     *
     * @param partnerSalesDocument
     *            Partner Sales Document
     */
    public void setPartnerSalesDocument( @Nullable final String partnerSalesDocument )
    {
        rememberChangedField("PartnerSalesDocument", this.partnerSalesDocument);
        this.partnerSalesDocument = partnerSalesDocument;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>PartnerSalesDocumentItem</b>
     * </p>
     *
     * @param partnerSalesDocumentItem
     *            Partner Sales Document Item
     */
    public void setPartnerSalesDocumentItem( @Nullable final String partnerSalesDocumentItem )
    {
        rememberChangedField("PartnerSalesDocumentItem", this.partnerSalesDocumentItem);
        this.partnerSalesDocumentItem = partnerSalesDocumentItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>PartnerProjectNetwork</b>
     * </p>
     *
     * @param partnerProjectNetwork
     *            Partner Project Network
     */
    public void setPartnerProjectNetwork( @Nullable final String partnerProjectNetwork )
    {
        rememberChangedField("PartnerProjectNetwork", this.partnerProjectNetwork);
        this.partnerProjectNetwork = partnerProjectNetwork;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>PartnerBusinessProcess</b>
     * </p>
     *
     * @param partnerBusinessProcess
     *            Partner Business Process
     */
    public void setPartnerBusinessProcess( @Nullable final String partnerBusinessProcess )
    {
        rememberChangedField("PartnerBusinessProcess", this.partnerBusinessProcess);
        this.partnerBusinessProcess = partnerBusinessProcess;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>PartnerCostObject</b>
     * </p>
     *
     * @param partnerCostObject
     *            Partner Cost Object
     */
    public void setPartnerCostObject( @Nullable final String partnerCostObject )
    {
        rememberChangedField("PartnerCostObject", this.partnerCostObject);
        this.partnerCostObject = partnerCostObject;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ControllingDocumentItem</b>
     * </p>
     *
     * @param controllingDocumentItem
     *            Controlling Document Item
     */
    public void setControllingDocumentItem( @Nullable final String controllingDocumentItem )
    {
        rememberChangedField("ControllingDocumentItem", this.controllingDocumentItem);
        this.controllingDocumentItem = controllingDocumentItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BillingDocumentType</b>
     * </p>
     *
     * @param billingDocumentType
     *            Billing Type
     */
    public void setBillingDocumentType( @Nullable final String billingDocumentType )
    {
        rememberChangedField("BillingDocumentType", this.billingDocumentType);
        this.billingDocumentType = billingDocumentType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrganization</b>
     * </p>
     *
     * @param salesOrganization
     *            Sales Organization
     */
    public void setSalesOrganization( @Nullable final String salesOrganization )
    {
        rememberChangedField("SalesOrganization", this.salesOrganization);
        this.salesOrganization = salesOrganization;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>DistributionChannel</b>
     * </p>
     *
     * @param distributionChannel
     *            Distribution Channel
     */
    public void setDistributionChannel( @Nullable final String distributionChannel )
    {
        rememberChangedField("DistributionChannel", this.distributionChannel);
        this.distributionChannel = distributionChannel;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>OrganizationDivision</b>
     * </p>
     *
     * @param organizationDivision
     *            Division
     */
    public void setOrganizationDivision( @Nullable final String organizationDivision )
    {
        rememberChangedField("OrganizationDivision", this.organizationDivision);
        this.organizationDivision = organizationDivision;
    }

    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>SoldProduct</b>
     * </p>
     *
     * @param soldProduct
     *            Product Sold
     */
    public void setSoldProduct( @Nullable final String soldProduct )
    {
        rememberChangedField("SoldProduct", this.soldProduct);
        this.soldProduct = soldProduct;
    }

    /**
     * Constraints: Not nullable, Maximum length: 9
     * <p>
     * Original property name from the Odata EDM: <b>SoldProductGroup</b>
     * </p>
     *
     * @param soldProductGroup
     *            Product Sold Group
     */
    public void setSoldProductGroup( @Nullable final String soldProductGroup )
    {
        rememberChangedField("SoldProductGroup", this.soldProductGroup);
        this.soldProductGroup = soldProductGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>CustomerGroup</b>
     * </p>
     *
     * @param customerGroup
     *            Customer Group
     */
    public void setCustomerGroup( @Nullable final String customerGroup )
    {
        rememberChangedField("CustomerGroup", this.customerGroup);
        this.customerGroup = customerGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>CustomerSupplierCountry</b>
     * </p>
     *
     * @param customerSupplierCountry
     *            Customer or Supplier Country/Region
     */
    public void setCustomerSupplierCountry( @Nullable final String customerSupplierCountry )
    {
        rememberChangedField("CustomerSupplierCountry", this.customerSupplierCountry);
        this.customerSupplierCountry = customerSupplierCountry;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CustomerSupplierIndustry</b>
     * </p>
     *
     * @param customerSupplierIndustry
     *            Customer Supplier Industry
     */
    public void setCustomerSupplierIndustry( @Nullable final String customerSupplierIndustry )
    {
        rememberChangedField("CustomerSupplierIndustry", this.customerSupplierIndustry);
        this.customerSupplierIndustry = customerSupplierIndustry;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>SalesDistrict</b>
     * </p>
     *
     * @param salesDistrict
     *            Sales District
     */
    public void setSalesDistrict( @Nullable final String salesDistrict )
    {
        rememberChangedField("SalesDistrict", this.salesDistrict);
        this.salesDistrict = salesDistrict;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BillToParty</b>
     * </p>
     *
     * @param billToParty
     *            Bill-to Party
     */
    public void setBillToParty( @Nullable final String billToParty )
    {
        rememberChangedField("BillToParty", this.billToParty);
        this.billToParty = billToParty;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ShipToParty</b>
     * </p>
     *
     * @param shipToParty
     *            Ship-to Party
     */
    public void setShipToParty( @Nullable final String shipToParty )
    {
        rememberChangedField("ShipToParty", this.shipToParty);
        this.shipToParty = shipToParty;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CustomerSupplierCorporateGroup</b>
     * </p>
     *
     * @param customerSupplierCorporateGroup
     *            Customer Supplier Corporate Group
     */
    public void setCustomerSupplierCorporateGroup( @Nullable final String customerSupplierCorporateGroup )
    {
        rememberChangedField("CustomerSupplierCorporateGroup", this.customerSupplierCorporateGroup);
        this.customerSupplierCorporateGroup = customerSupplierCorporateGroup;
    }

    @Override
    protected String getEntityCollection()
    {
        return "GLAccountLineItem";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("ID", getID());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("ID", getID());
        values.put("SourceLedger", getSourceLedger());
        values.put("CompanyCode", getCompanyCode());
        values.put("FiscalYear", getFiscalYear());
        values.put("AccountingDocument", getAccountingDocument());
        values.put("LedgerGLLineItem", getLedgerGLLineItem());
        values.put("Ledger", getLedger());
        values.put("LedgerFiscalYear", getLedgerFiscalYear());
        values.put("GLRecordType", getGLRecordType());
        values.put("ControllingArea", getControllingArea());
        values.put("ChartOfAccounts", getChartOfAccounts());
        values.put("GLAccount", getGLAccount());
        values.put("FinancialTransactionType", getFinancialTransactionType());
        values.put("BusinessTransactionType", getBusinessTransactionType());
        values.put("ControllingBusTransacType", getControllingBusTransacType());
        values.put("ReferenceDocumentType", getReferenceDocumentType());
        values.put("LogicalSystem", getLogicalSystem());
        values.put("ReferenceDocumentContext", getReferenceDocumentContext());
        values.put("ReferenceDocument", getReferenceDocument());
        values.put("ReferenceDocumentItem", getReferenceDocumentItem());
        values.put("ReferenceDocumentItemGroup", getReferenceDocumentItemGroup());
        values.put("TransactionSubitem", getTransactionSubitem());
        values.put("IsReversal", getIsReversal());
        values.put("IsReversed", getIsReversed());
        values.put("ReversalReferenceDocumentCntxt", getReversalReferenceDocumentCntxt());
        values.put("ReversalReferenceDocument", getReversalReferenceDocument());
        values.put("IsSettlement", getIsSettlement());
        values.put("IsSettled", getIsSettled());
        values.put("PredecessorReferenceDocType", getPredecessorReferenceDocType());
        values.put("PredecessorReferenceDocCntxt", getPredecessorReferenceDocCntxt());
        values.put("PredecessorReferenceDocument", getPredecessorReferenceDocument());
        values.put("PredecessorReferenceDocItem", getPredecessorReferenceDocItem());
        values.put("PrdcssrJournalEntryCompanyCode", getPrdcssrJournalEntryCompanyCode());
        values.put("PrdcssrJournalEntryFiscalYear", getPrdcssrJournalEntryFiscalYear());
        values.put("PredecessorJournalEntry", getPredecessorJournalEntry());
        values.put("PredecessorJournalEntryItem", getPredecessorJournalEntryItem());
        values.put("SourceReferenceDocumentType", getSourceReferenceDocumentType());
        values.put("SourceLogicalSystem", getSourceLogicalSystem());
        values.put("SourceReferenceDocumentCntxt", getSourceReferenceDocumentCntxt());
        values.put("SourceReferenceDocument", getSourceReferenceDocument());
        values.put("SourceReferenceDocumentItem", getSourceReferenceDocumentItem());
        values.put("SourceReferenceDocSubitem", getSourceReferenceDocSubitem());
        values.put("IsCommitment", getIsCommitment());
        values.put("JrnlEntryItemObsoleteReason", getJrnlEntryItemObsoleteReason());
        values.put("JrnlPeriodEndClosingRunLogUUID", getJrnlPeriodEndClosingRunLogUUID());
        values.put("CostCenter", getCostCenter());
        values.put("ProfitCenter", getProfitCenter());
        values.put("FunctionalArea", getFunctionalArea());
        values.put("BusinessArea", getBusinessArea());
        values.put("Segment", getSegment());
        values.put("PartnerCostCenter", getPartnerCostCenter());
        values.put("PartnerProfitCenter", getPartnerProfitCenter());
        values.put("PartnerFunctionalArea", getPartnerFunctionalArea());
        values.put("PartnerBusinessArea", getPartnerBusinessArea());
        values.put("PartnerCompany", getPartnerCompany());
        values.put("PartnerSegment", getPartnerSegment());
        values.put("BalanceTransactionCurrency", getBalanceTransactionCurrency());
        values.put("AmountInBalanceTransacCrcy", getAmountInBalanceTransacCrcy());
        values.put("TransactionCurrency", getTransactionCurrency());
        values.put("AmountInTransactionCurrency", getAmountInTransactionCurrency());
        values.put("CompanyCodeCurrency", getCompanyCodeCurrency());
        values.put("AmountInCompanyCodeCurrency", getAmountInCompanyCodeCurrency());
        values.put("GlobalCurrency", getGlobalCurrency());
        values.put("AmountInGlobalCurrency", getAmountInGlobalCurrency());
        values.put("FreeDefinedCurrency1", getFreeDefinedCurrency1());
        values.put("AmountInFreeDefinedCurrency1", getAmountInFreeDefinedCurrency1());
        values.put("FreeDefinedCurrency2", getFreeDefinedCurrency2());
        values.put("AmountInFreeDefinedCurrency2", getAmountInFreeDefinedCurrency2());
        values.put("FreeDefinedCurrency3", getFreeDefinedCurrency3());
        values.put("AmountInFreeDefinedCurrency3", getAmountInFreeDefinedCurrency3());
        values.put("FreeDefinedCurrency4", getFreeDefinedCurrency4());
        values.put("AmountInFreeDefinedCurrency4", getAmountInFreeDefinedCurrency4());
        values.put("FreeDefinedCurrency5", getFreeDefinedCurrency5());
        values.put("AmountInFreeDefinedCurrency5", getAmountInFreeDefinedCurrency5());
        values.put("FreeDefinedCurrency6", getFreeDefinedCurrency6());
        values.put("AmountInFreeDefinedCurrency6", getAmountInFreeDefinedCurrency6());
        values.put("FreeDefinedCurrency7", getFreeDefinedCurrency7());
        values.put("AmountInFreeDefinedCurrency7", getAmountInFreeDefinedCurrency7());
        values.put("FreeDefinedCurrency8", getFreeDefinedCurrency8());
        values.put("AmountInFreeDefinedCurrency8", getAmountInFreeDefinedCurrency8());
        values.put("FixedAmountInGlobalCrcy", getFixedAmountInGlobalCrcy());
        values.put("GrpValnFixedAmtInGlobCrcy", getGrpValnFixedAmtInGlobCrcy());
        values.put("PrftCtrValnFxdAmtInGlobCrcy", getPrftCtrValnFxdAmtInGlobCrcy());
        values.put("TotalPriceVarcInGlobalCrcy", getTotalPriceVarcInGlobalCrcy());
        values.put("GrpValnTotPrcVarcInGlobCrcy", getGrpValnTotPrcVarcInGlobCrcy());
        values.put("PrftCtrValnTotPrcVarcInGlbCrcy", getPrftCtrValnTotPrcVarcInGlbCrcy());
        values.put("FixedPriceVarcInGlobalCrcy", getFixedPriceVarcInGlobalCrcy());
        values.put("GrpValnFixedPrcVarcInGlobCrcy", getGrpValnFixedPrcVarcInGlobCrcy());
        values.put("PrftCtrValnFxdPrcVarcInGlbCrcy", getPrftCtrValnFxdPrcVarcInGlbCrcy());
        values.put("FixedAmountInCoCodeCrcy", getFixedAmountInCoCodeCrcy());
        values.put("ControllingObjectCurrency", getControllingObjectCurrency());
        values.put("AmountInObjectCurrency", getAmountInObjectCurrency());
        values.put("BaseUnit", getBaseUnit());
        values.put("Quantity", getQuantity());
        values.put("FixedQuantity", getFixedQuantity());
        values.put("CostSourceUnit", getCostSourceUnit());
        values.put("ValuationQuantity", getValuationQuantity());
        values.put("ValuationFixedQuantity", getValuationFixedQuantity());
        values.put("AdditionalQuantity1Unit", getAdditionalQuantity1Unit());
        values.put("AdditionalQuantity1", getAdditionalQuantity1());
        values.put("AdditionalQuantity2Unit", getAdditionalQuantity2Unit());
        values.put("AdditionalQuantity2", getAdditionalQuantity2());
        values.put("AdditionalQuantity3Unit", getAdditionalQuantity3Unit());
        values.put("AdditionalQuantity3", getAdditionalQuantity3());
        values.put("DebitCreditCode", getDebitCreditCode());
        values.put("FiscalPeriod", getFiscalPeriod());
        values.put("FiscalYearVariant", getFiscalYearVariant());
        values.put("FiscalYearPeriod", getFiscalYearPeriod());
        values.put("PostingDate", getPostingDate());
        values.put("DocumentDate", getDocumentDate());
        values.put("AccountingDocumentType", getAccountingDocumentType());
        values.put("AccountingDocumentItem", getAccountingDocumentItem());
        values.put("AssignmentReference", getAssignmentReference());
        values.put("AccountingDocumentCategory", getAccountingDocumentCategory());
        values.put("PostingKey", getPostingKey());
        values.put("TransactionTypeDetermination", getTransactionTypeDetermination());
        values.put("SubLedgerAcctLineItemType", getSubLedgerAcctLineItemType());
        values.put("AccountingDocCreatedByUser", getAccountingDocCreatedByUser());
        values.put("LastChangeDateTime", getLastChangeDateTime());
        values.put("CreationDateTime", getCreationDateTime());
        values.put("CreationDate", getCreationDate());
        values.put("EliminationProfitCenter", getEliminationProfitCenter());
        values.put("OriginObjectType", getOriginObjectType());
        values.put("GLAccountType", getGLAccountType());
        values.put("AlternativeGLAccount", getAlternativeGLAccount());
        values.put("CountryChartOfAccounts", getCountryChartOfAccounts());
        values.put("ItemIsSplit", getItemIsSplit());
        values.put("InvoiceReference", getInvoiceReference());
        values.put("InvoiceReferenceFiscalYear", getInvoiceReferenceFiscalYear());
        values.put("FollowOnDocumentType", getFollowOnDocumentType());
        values.put("InvoiceItemReference", getInvoiceItemReference());
        values.put("ReferencePurchaseOrderCategory", getReferencePurchaseOrderCategory());
        values.put("PurchasingDocument", getPurchasingDocument());
        values.put("PurchasingDocumentItem", getPurchasingDocumentItem());
        values.put("AccountAssignmentNumber", getAccountAssignmentNumber());
        values.put("DocumentItemText", getDocumentItemText());
        values.put("SalesDocument", getSalesDocument());
        values.put("SalesDocumentItem", getSalesDocumentItem());
        values.put("Product", getProduct());
        values.put("Plant", getPlant());
        values.put("Supplier", getSupplier());
        values.put("Customer", getCustomer());
        values.put("ServicesRenderedDate", getServicesRenderedDate());
        values.put("ConditionContract", getConditionContract());
        values.put("FinancialAccountType", getFinancialAccountType());
        values.put("SpecialGLCode", getSpecialGLCode());
        values.put("TaxCode", getTaxCode());
        values.put("HouseBank", getHouseBank());
        values.put("HouseBankAccount", getHouseBankAccount());
        values.put("IsOpenItemManaged", getIsOpenItemManaged());
        values.put("ClearingDate", getClearingDate());
        values.put("ClearingAccountingDocument", getClearingAccountingDocument());
        values.put("ClearingDocFiscalYear", getClearingDocFiscalYear());
        values.put("ValueDate", getValueDate());
        values.put("AssetDepreciationArea", getAssetDepreciationArea());
        values.put("MasterFixedAsset", getMasterFixedAsset());
        values.put("FixedAsset", getFixedAsset());
        values.put("AssetValueDate", getAssetValueDate());
        values.put("AssetTransactionType", getAssetTransactionType());
        values.put("AssetAcctTransClassfctn", getAssetAcctTransClassfctn());
        values.put("DepreciationFiscalPeriod", getDepreciationFiscalPeriod());
        values.put("GroupMasterFixedAsset", getGroupMasterFixedAsset());
        values.put("GroupFixedAsset", getGroupFixedAsset());
        values.put("AssetClass", getAssetClass());
        values.put("CostEstimate", getCostEstimate());
        values.put("InventorySpecialStockValnType", getInventorySpecialStockValnType());
        values.put("InventorySpecialStockType", getInventorySpecialStockType());
        values.put("InventorySpclStkSalesDocument", getInventorySpclStkSalesDocument());
        values.put("InventorySpclStkSalesDocItm", getInventorySpclStkSalesDocItm());
        values.put("InvtrySpclStockWBSElmntIntID", getInvtrySpclStockWBSElmntIntID());
        values.put("InventorySpecialStockSupplier", getInventorySpecialStockSupplier());
        values.put("InventoryValuationType", getInventoryValuationType());
        values.put("ValuationArea", getValuationArea());
        values.put("CostOriginGroup", getCostOriginGroup());
        values.put("OriginSenderObject", getOriginSenderObject());
        values.put("ControllingObjectDebitType", getControllingObjectDebitType());
        values.put("QuantityIsIncomplete", getQuantityIsIncomplete());
        values.put("OffsettingAccount", getOffsettingAccount());
        values.put("OffsettingAccountType", getOffsettingAccountType());
        values.put("OffsettingChartOfAccounts", getOffsettingChartOfAccounts());
        values.put("LineItemIsCompleted", getLineItemIsCompleted());
        values.put("PersonnelNumber", getPersonnelNumber());
        values.put("ControllingObjectClass", getControllingObjectClass());
        values.put("PartnerCompanyCode", getPartnerCompanyCode());
        values.put("PartnerControllingObjectClass", getPartnerControllingObjectClass());
        values.put("OriginCostCenter", getOriginCostCenter());
        values.put("OriginProfitCenter", getOriginProfitCenter());
        values.put("OriginCostCtrActivityType", getOriginCostCtrActivityType());
        values.put("AccountAssignment", getAccountAssignment());
        values.put("AccountAssignmentType", getAccountAssignmentType());
        values.put("CostCtrActivityType", getCostCtrActivityType());
        values.put("OrderID", getOrderID());
        values.put("OrderCategory", getOrderCategory());
        values.put("WBSElementInternalID", getWBSElementInternalID());
        values.put("PartnerWBSElementInternalID", getPartnerWBSElementInternalID());
        values.put("ProjectInternalID", getProjectInternalID());
        values.put("PartnerProjectInternalID", getPartnerProjectInternalID());
        values.put("OperatingConcern", getOperatingConcern());
        values.put("ProjectNetwork", getProjectNetwork());
        values.put("BusinessProcess", getBusinessProcess());
        values.put("CostObject", getCostObject());
        values.put("BillableControl", getBillableControl());
        values.put("CostAnalysisResource", getCostAnalysisResource());
        values.put("CustomerServiceNotification", getCustomerServiceNotification());
        values.put("ServiceDocumentType", getServiceDocumentType());
        values.put("ServiceDocument", getServiceDocument());
        values.put("ServiceDocumentItem", getServiceDocumentItem());
        values.put("PartnerServiceDocumentType", getPartnerServiceDocumentType());
        values.put("PartnerServiceDocument", getPartnerServiceDocument());
        values.put("PartnerServiceDocumentItem", getPartnerServiceDocumentItem());
        values.put("ServiceContractType", getServiceContractType());
        values.put("ServiceContract", getServiceContract());
        values.put("ServiceContractItem", getServiceContractItem());
        values.put("TimeSheetOvertimeCategory", getTimeSheetOvertimeCategory());
        values.put("PartnerAccountAssignment", getPartnerAccountAssignment());
        values.put("PartnerAccountAssignmentType", getPartnerAccountAssignmentType());
        values.put("PartnerCostCtrActivityType", getPartnerCostCtrActivityType());
        values.put("PartnerOrder", getPartnerOrder());
        values.put("PartnerOrderCategory", getPartnerOrderCategory());
        values.put("PartnerSalesDocument", getPartnerSalesDocument());
        values.put("PartnerSalesDocumentItem", getPartnerSalesDocumentItem());
        values.put("PartnerProjectNetwork", getPartnerProjectNetwork());
        values.put("PartnerBusinessProcess", getPartnerBusinessProcess());
        values.put("PartnerCostObject", getPartnerCostObject());
        values.put("ControllingDocumentItem", getControllingDocumentItem());
        values.put("BillingDocumentType", getBillingDocumentType());
        values.put("SalesOrganization", getSalesOrganization());
        values.put("DistributionChannel", getDistributionChannel());
        values.put("OrganizationDivision", getOrganizationDivision());
        values.put("SoldProduct", getSoldProduct());
        values.put("SoldProductGroup", getSoldProductGroup());
        values.put("CustomerGroup", getCustomerGroup());
        values.put("CustomerSupplierCountry", getCustomerSupplierCountry());
        values.put("CustomerSupplierIndustry", getCustomerSupplierIndustry());
        values.put("SalesDistrict", getSalesDistrict());
        values.put("BillToParty", getBillToParty());
        values.put("ShipToParty", getShipToParty());
        values.put("CustomerSupplierCorporateGroup", getCustomerSupplierCorporateGroup());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("ID") ) {
                final Object value = values.remove("ID");
                if( (value == null) || (!value.equals(getID())) ) {
                    setID(((String) value));
                }
            }
            if( values.containsKey("SourceLedger") ) {
                final Object value = values.remove("SourceLedger");
                if( (value == null) || (!value.equals(getSourceLedger())) ) {
                    setSourceLedger(((String) value));
                }
            }
            if( values.containsKey("CompanyCode") ) {
                final Object value = values.remove("CompanyCode");
                if( (value == null) || (!value.equals(getCompanyCode())) ) {
                    setCompanyCode(((String) value));
                }
            }
            if( values.containsKey("FiscalYear") ) {
                final Object value = values.remove("FiscalYear");
                if( (value == null) || (!value.equals(getFiscalYear())) ) {
                    setFiscalYear(((String) value));
                }
            }
            if( values.containsKey("AccountingDocument") ) {
                final Object value = values.remove("AccountingDocument");
                if( (value == null) || (!value.equals(getAccountingDocument())) ) {
                    setAccountingDocument(((String) value));
                }
            }
            if( values.containsKey("LedgerGLLineItem") ) {
                final Object value = values.remove("LedgerGLLineItem");
                if( (value == null) || (!value.equals(getLedgerGLLineItem())) ) {
                    setLedgerGLLineItem(((String) value));
                }
            }
            if( values.containsKey("Ledger") ) {
                final Object value = values.remove("Ledger");
                if( (value == null) || (!value.equals(getLedger())) ) {
                    setLedger(((String) value));
                }
            }
            if( values.containsKey("LedgerFiscalYear") ) {
                final Object value = values.remove("LedgerFiscalYear");
                if( (value == null) || (!value.equals(getLedgerFiscalYear())) ) {
                    setLedgerFiscalYear(((String) value));
                }
            }
            if( values.containsKey("GLRecordType") ) {
                final Object value = values.remove("GLRecordType");
                if( (value == null) || (!value.equals(getGLRecordType())) ) {
                    setGLRecordType(((String) value));
                }
            }
            if( values.containsKey("ControllingArea") ) {
                final Object value = values.remove("ControllingArea");
                if( (value == null) || (!value.equals(getControllingArea())) ) {
                    setControllingArea(((String) value));
                }
            }
            if( values.containsKey("ChartOfAccounts") ) {
                final Object value = values.remove("ChartOfAccounts");
                if( (value == null) || (!value.equals(getChartOfAccounts())) ) {
                    setChartOfAccounts(((String) value));
                }
            }
            if( values.containsKey("GLAccount") ) {
                final Object value = values.remove("GLAccount");
                if( (value == null) || (!value.equals(getGLAccount())) ) {
                    setGLAccount(((String) value));
                }
            }
            if( values.containsKey("FinancialTransactionType") ) {
                final Object value = values.remove("FinancialTransactionType");
                if( (value == null) || (!value.equals(getFinancialTransactionType())) ) {
                    setFinancialTransactionType(((String) value));
                }
            }
            if( values.containsKey("BusinessTransactionType") ) {
                final Object value = values.remove("BusinessTransactionType");
                if( (value == null) || (!value.equals(getBusinessTransactionType())) ) {
                    setBusinessTransactionType(((String) value));
                }
            }
            if( values.containsKey("ControllingBusTransacType") ) {
                final Object value = values.remove("ControllingBusTransacType");
                if( (value == null) || (!value.equals(getControllingBusTransacType())) ) {
                    setControllingBusTransacType(((String) value));
                }
            }
            if( values.containsKey("ReferenceDocumentType") ) {
                final Object value = values.remove("ReferenceDocumentType");
                if( (value == null) || (!value.equals(getReferenceDocumentType())) ) {
                    setReferenceDocumentType(((String) value));
                }
            }
            if( values.containsKey("LogicalSystem") ) {
                final Object value = values.remove("LogicalSystem");
                if( (value == null) || (!value.equals(getLogicalSystem())) ) {
                    setLogicalSystem(((String) value));
                }
            }
            if( values.containsKey("ReferenceDocumentContext") ) {
                final Object value = values.remove("ReferenceDocumentContext");
                if( (value == null) || (!value.equals(getReferenceDocumentContext())) ) {
                    setReferenceDocumentContext(((String) value));
                }
            }
            if( values.containsKey("ReferenceDocument") ) {
                final Object value = values.remove("ReferenceDocument");
                if( (value == null) || (!value.equals(getReferenceDocument())) ) {
                    setReferenceDocument(((String) value));
                }
            }
            if( values.containsKey("ReferenceDocumentItem") ) {
                final Object value = values.remove("ReferenceDocumentItem");
                if( (value == null) || (!value.equals(getReferenceDocumentItem())) ) {
                    setReferenceDocumentItem(((String) value));
                }
            }
            if( values.containsKey("ReferenceDocumentItemGroup") ) {
                final Object value = values.remove("ReferenceDocumentItemGroup");
                if( (value == null) || (!value.equals(getReferenceDocumentItemGroup())) ) {
                    setReferenceDocumentItemGroup(((String) value));
                }
            }
            if( values.containsKey("TransactionSubitem") ) {
                final Object value = values.remove("TransactionSubitem");
                if( (value == null) || (!value.equals(getTransactionSubitem())) ) {
                    setTransactionSubitem(((String) value));
                }
            }
            if( values.containsKey("IsReversal") ) {
                final Object value = values.remove("IsReversal");
                if( (value == null) || (!value.equals(getIsReversal())) ) {
                    setIsReversal(((Boolean) value));
                }
            }
            if( values.containsKey("IsReversed") ) {
                final Object value = values.remove("IsReversed");
                if( (value == null) || (!value.equals(getIsReversed())) ) {
                    setIsReversed(((Boolean) value));
                }
            }
            if( values.containsKey("ReversalReferenceDocumentCntxt") ) {
                final Object value = values.remove("ReversalReferenceDocumentCntxt");
                if( (value == null) || (!value.equals(getReversalReferenceDocumentCntxt())) ) {
                    setReversalReferenceDocumentCntxt(((String) value));
                }
            }
            if( values.containsKey("ReversalReferenceDocument") ) {
                final Object value = values.remove("ReversalReferenceDocument");
                if( (value == null) || (!value.equals(getReversalReferenceDocument())) ) {
                    setReversalReferenceDocument(((String) value));
                }
            }
            if( values.containsKey("IsSettlement") ) {
                final Object value = values.remove("IsSettlement");
                if( (value == null) || (!value.equals(getIsSettlement())) ) {
                    setIsSettlement(((Boolean) value));
                }
            }
            if( values.containsKey("IsSettled") ) {
                final Object value = values.remove("IsSettled");
                if( (value == null) || (!value.equals(getIsSettled())) ) {
                    setIsSettled(((Boolean) value));
                }
            }
            if( values.containsKey("PredecessorReferenceDocType") ) {
                final Object value = values.remove("PredecessorReferenceDocType");
                if( (value == null) || (!value.equals(getPredecessorReferenceDocType())) ) {
                    setPredecessorReferenceDocType(((String) value));
                }
            }
            if( values.containsKey("PredecessorReferenceDocCntxt") ) {
                final Object value = values.remove("PredecessorReferenceDocCntxt");
                if( (value == null) || (!value.equals(getPredecessorReferenceDocCntxt())) ) {
                    setPredecessorReferenceDocCntxt(((String) value));
                }
            }
            if( values.containsKey("PredecessorReferenceDocument") ) {
                final Object value = values.remove("PredecessorReferenceDocument");
                if( (value == null) || (!value.equals(getPredecessorReferenceDocument())) ) {
                    setPredecessorReferenceDocument(((String) value));
                }
            }
            if( values.containsKey("PredecessorReferenceDocItem") ) {
                final Object value = values.remove("PredecessorReferenceDocItem");
                if( (value == null) || (!value.equals(getPredecessorReferenceDocItem())) ) {
                    setPredecessorReferenceDocItem(((String) value));
                }
            }
            if( values.containsKey("PrdcssrJournalEntryCompanyCode") ) {
                final Object value = values.remove("PrdcssrJournalEntryCompanyCode");
                if( (value == null) || (!value.equals(getPrdcssrJournalEntryCompanyCode())) ) {
                    setPrdcssrJournalEntryCompanyCode(((String) value));
                }
            }
            if( values.containsKey("PrdcssrJournalEntryFiscalYear") ) {
                final Object value = values.remove("PrdcssrJournalEntryFiscalYear");
                if( (value == null) || (!value.equals(getPrdcssrJournalEntryFiscalYear())) ) {
                    setPrdcssrJournalEntryFiscalYear(((String) value));
                }
            }
            if( values.containsKey("PredecessorJournalEntry") ) {
                final Object value = values.remove("PredecessorJournalEntry");
                if( (value == null) || (!value.equals(getPredecessorJournalEntry())) ) {
                    setPredecessorJournalEntry(((String) value));
                }
            }
            if( values.containsKey("PredecessorJournalEntryItem") ) {
                final Object value = values.remove("PredecessorJournalEntryItem");
                if( (value == null) || (!value.equals(getPredecessorJournalEntryItem())) ) {
                    setPredecessorJournalEntryItem(((String) value));
                }
            }
            if( values.containsKey("SourceReferenceDocumentType") ) {
                final Object value = values.remove("SourceReferenceDocumentType");
                if( (value == null) || (!value.equals(getSourceReferenceDocumentType())) ) {
                    setSourceReferenceDocumentType(((String) value));
                }
            }
            if( values.containsKey("SourceLogicalSystem") ) {
                final Object value = values.remove("SourceLogicalSystem");
                if( (value == null) || (!value.equals(getSourceLogicalSystem())) ) {
                    setSourceLogicalSystem(((String) value));
                }
            }
            if( values.containsKey("SourceReferenceDocumentCntxt") ) {
                final Object value = values.remove("SourceReferenceDocumentCntxt");
                if( (value == null) || (!value.equals(getSourceReferenceDocumentCntxt())) ) {
                    setSourceReferenceDocumentCntxt(((String) value));
                }
            }
            if( values.containsKey("SourceReferenceDocument") ) {
                final Object value = values.remove("SourceReferenceDocument");
                if( (value == null) || (!value.equals(getSourceReferenceDocument())) ) {
                    setSourceReferenceDocument(((String) value));
                }
            }
            if( values.containsKey("SourceReferenceDocumentItem") ) {
                final Object value = values.remove("SourceReferenceDocumentItem");
                if( (value == null) || (!value.equals(getSourceReferenceDocumentItem())) ) {
                    setSourceReferenceDocumentItem(((String) value));
                }
            }
            if( values.containsKey("SourceReferenceDocSubitem") ) {
                final Object value = values.remove("SourceReferenceDocSubitem");
                if( (value == null) || (!value.equals(getSourceReferenceDocSubitem())) ) {
                    setSourceReferenceDocSubitem(((String) value));
                }
            }
            if( values.containsKey("IsCommitment") ) {
                final Object value = values.remove("IsCommitment");
                if( (value == null) || (!value.equals(getIsCommitment())) ) {
                    setIsCommitment(((Boolean) value));
                }
            }
            if( values.containsKey("JrnlEntryItemObsoleteReason") ) {
                final Object value = values.remove("JrnlEntryItemObsoleteReason");
                if( (value == null) || (!value.equals(getJrnlEntryItemObsoleteReason())) ) {
                    setJrnlEntryItemObsoleteReason(((String) value));
                }
            }
            if( values.containsKey("JrnlPeriodEndClosingRunLogUUID") ) {
                final Object value = values.remove("JrnlPeriodEndClosingRunLogUUID");
                if( (value == null) || (!value.equals(getJrnlPeriodEndClosingRunLogUUID())) ) {
                    setJrnlPeriodEndClosingRunLogUUID(((UUID) value));
                }
            }
            if( values.containsKey("CostCenter") ) {
                final Object value = values.remove("CostCenter");
                if( (value == null) || (!value.equals(getCostCenter())) ) {
                    setCostCenter(((String) value));
                }
            }
            if( values.containsKey("ProfitCenter") ) {
                final Object value = values.remove("ProfitCenter");
                if( (value == null) || (!value.equals(getProfitCenter())) ) {
                    setProfitCenter(((String) value));
                }
            }
            if( values.containsKey("FunctionalArea") ) {
                final Object value = values.remove("FunctionalArea");
                if( (value == null) || (!value.equals(getFunctionalArea())) ) {
                    setFunctionalArea(((String) value));
                }
            }
            if( values.containsKey("BusinessArea") ) {
                final Object value = values.remove("BusinessArea");
                if( (value == null) || (!value.equals(getBusinessArea())) ) {
                    setBusinessArea(((String) value));
                }
            }
            if( values.containsKey("Segment") ) {
                final Object value = values.remove("Segment");
                if( (value == null) || (!value.equals(getSegment())) ) {
                    setSegment(((String) value));
                }
            }
            if( values.containsKey("PartnerCostCenter") ) {
                final Object value = values.remove("PartnerCostCenter");
                if( (value == null) || (!value.equals(getPartnerCostCenter())) ) {
                    setPartnerCostCenter(((String) value));
                }
            }
            if( values.containsKey("PartnerProfitCenter") ) {
                final Object value = values.remove("PartnerProfitCenter");
                if( (value == null) || (!value.equals(getPartnerProfitCenter())) ) {
                    setPartnerProfitCenter(((String) value));
                }
            }
            if( values.containsKey("PartnerFunctionalArea") ) {
                final Object value = values.remove("PartnerFunctionalArea");
                if( (value == null) || (!value.equals(getPartnerFunctionalArea())) ) {
                    setPartnerFunctionalArea(((String) value));
                }
            }
            if( values.containsKey("PartnerBusinessArea") ) {
                final Object value = values.remove("PartnerBusinessArea");
                if( (value == null) || (!value.equals(getPartnerBusinessArea())) ) {
                    setPartnerBusinessArea(((String) value));
                }
            }
            if( values.containsKey("PartnerCompany") ) {
                final Object value = values.remove("PartnerCompany");
                if( (value == null) || (!value.equals(getPartnerCompany())) ) {
                    setPartnerCompany(((String) value));
                }
            }
            if( values.containsKey("PartnerSegment") ) {
                final Object value = values.remove("PartnerSegment");
                if( (value == null) || (!value.equals(getPartnerSegment())) ) {
                    setPartnerSegment(((String) value));
                }
            }
            if( values.containsKey("BalanceTransactionCurrency") ) {
                final Object value = values.remove("BalanceTransactionCurrency");
                if( (value == null) || (!value.equals(getBalanceTransactionCurrency())) ) {
                    setBalanceTransactionCurrency(((String) value));
                }
            }
            if( values.containsKey("AmountInBalanceTransacCrcy") ) {
                final Object value = values.remove("AmountInBalanceTransacCrcy");
                if( (value == null) || (!value.equals(getAmountInBalanceTransacCrcy())) ) {
                    setAmountInBalanceTransacCrcy(((BigDecimal) value));
                }
            }
            if( values.containsKey("TransactionCurrency") ) {
                final Object value = values.remove("TransactionCurrency");
                if( (value == null) || (!value.equals(getTransactionCurrency())) ) {
                    setTransactionCurrency(((String) value));
                }
            }
            if( values.containsKey("AmountInTransactionCurrency") ) {
                final Object value = values.remove("AmountInTransactionCurrency");
                if( (value == null) || (!value.equals(getAmountInTransactionCurrency())) ) {
                    setAmountInTransactionCurrency(((BigDecimal) value));
                }
            }
            if( values.containsKey("CompanyCodeCurrency") ) {
                final Object value = values.remove("CompanyCodeCurrency");
                if( (value == null) || (!value.equals(getCompanyCodeCurrency())) ) {
                    setCompanyCodeCurrency(((String) value));
                }
            }
            if( values.containsKey("AmountInCompanyCodeCurrency") ) {
                final Object value = values.remove("AmountInCompanyCodeCurrency");
                if( (value == null) || (!value.equals(getAmountInCompanyCodeCurrency())) ) {
                    setAmountInCompanyCodeCurrency(((BigDecimal) value));
                }
            }
            if( values.containsKey("GlobalCurrency") ) {
                final Object value = values.remove("GlobalCurrency");
                if( (value == null) || (!value.equals(getGlobalCurrency())) ) {
                    setGlobalCurrency(((String) value));
                }
            }
            if( values.containsKey("AmountInGlobalCurrency") ) {
                final Object value = values.remove("AmountInGlobalCurrency");
                if( (value == null) || (!value.equals(getAmountInGlobalCurrency())) ) {
                    setAmountInGlobalCurrency(((BigDecimal) value));
                }
            }
            if( values.containsKey("FreeDefinedCurrency1") ) {
                final Object value = values.remove("FreeDefinedCurrency1");
                if( (value == null) || (!value.equals(getFreeDefinedCurrency1())) ) {
                    setFreeDefinedCurrency1(((String) value));
                }
            }
            if( values.containsKey("AmountInFreeDefinedCurrency1") ) {
                final Object value = values.remove("AmountInFreeDefinedCurrency1");
                if( (value == null) || (!value.equals(getAmountInFreeDefinedCurrency1())) ) {
                    setAmountInFreeDefinedCurrency1(((BigDecimal) value));
                }
            }
            if( values.containsKey("FreeDefinedCurrency2") ) {
                final Object value = values.remove("FreeDefinedCurrency2");
                if( (value == null) || (!value.equals(getFreeDefinedCurrency2())) ) {
                    setFreeDefinedCurrency2(((String) value));
                }
            }
            if( values.containsKey("AmountInFreeDefinedCurrency2") ) {
                final Object value = values.remove("AmountInFreeDefinedCurrency2");
                if( (value == null) || (!value.equals(getAmountInFreeDefinedCurrency2())) ) {
                    setAmountInFreeDefinedCurrency2(((BigDecimal) value));
                }
            }
            if( values.containsKey("FreeDefinedCurrency3") ) {
                final Object value = values.remove("FreeDefinedCurrency3");
                if( (value == null) || (!value.equals(getFreeDefinedCurrency3())) ) {
                    setFreeDefinedCurrency3(((String) value));
                }
            }
            if( values.containsKey("AmountInFreeDefinedCurrency3") ) {
                final Object value = values.remove("AmountInFreeDefinedCurrency3");
                if( (value == null) || (!value.equals(getAmountInFreeDefinedCurrency3())) ) {
                    setAmountInFreeDefinedCurrency3(((BigDecimal) value));
                }
            }
            if( values.containsKey("FreeDefinedCurrency4") ) {
                final Object value = values.remove("FreeDefinedCurrency4");
                if( (value == null) || (!value.equals(getFreeDefinedCurrency4())) ) {
                    setFreeDefinedCurrency4(((String) value));
                }
            }
            if( values.containsKey("AmountInFreeDefinedCurrency4") ) {
                final Object value = values.remove("AmountInFreeDefinedCurrency4");
                if( (value == null) || (!value.equals(getAmountInFreeDefinedCurrency4())) ) {
                    setAmountInFreeDefinedCurrency4(((BigDecimal) value));
                }
            }
            if( values.containsKey("FreeDefinedCurrency5") ) {
                final Object value = values.remove("FreeDefinedCurrency5");
                if( (value == null) || (!value.equals(getFreeDefinedCurrency5())) ) {
                    setFreeDefinedCurrency5(((String) value));
                }
            }
            if( values.containsKey("AmountInFreeDefinedCurrency5") ) {
                final Object value = values.remove("AmountInFreeDefinedCurrency5");
                if( (value == null) || (!value.equals(getAmountInFreeDefinedCurrency5())) ) {
                    setAmountInFreeDefinedCurrency5(((BigDecimal) value));
                }
            }
            if( values.containsKey("FreeDefinedCurrency6") ) {
                final Object value = values.remove("FreeDefinedCurrency6");
                if( (value == null) || (!value.equals(getFreeDefinedCurrency6())) ) {
                    setFreeDefinedCurrency6(((String) value));
                }
            }
            if( values.containsKey("AmountInFreeDefinedCurrency6") ) {
                final Object value = values.remove("AmountInFreeDefinedCurrency6");
                if( (value == null) || (!value.equals(getAmountInFreeDefinedCurrency6())) ) {
                    setAmountInFreeDefinedCurrency6(((BigDecimal) value));
                }
            }
            if( values.containsKey("FreeDefinedCurrency7") ) {
                final Object value = values.remove("FreeDefinedCurrency7");
                if( (value == null) || (!value.equals(getFreeDefinedCurrency7())) ) {
                    setFreeDefinedCurrency7(((String) value));
                }
            }
            if( values.containsKey("AmountInFreeDefinedCurrency7") ) {
                final Object value = values.remove("AmountInFreeDefinedCurrency7");
                if( (value == null) || (!value.equals(getAmountInFreeDefinedCurrency7())) ) {
                    setAmountInFreeDefinedCurrency7(((BigDecimal) value));
                }
            }
            if( values.containsKey("FreeDefinedCurrency8") ) {
                final Object value = values.remove("FreeDefinedCurrency8");
                if( (value == null) || (!value.equals(getFreeDefinedCurrency8())) ) {
                    setFreeDefinedCurrency8(((String) value));
                }
            }
            if( values.containsKey("AmountInFreeDefinedCurrency8") ) {
                final Object value = values.remove("AmountInFreeDefinedCurrency8");
                if( (value == null) || (!value.equals(getAmountInFreeDefinedCurrency8())) ) {
                    setAmountInFreeDefinedCurrency8(((BigDecimal) value));
                }
            }
            if( values.containsKey("FixedAmountInGlobalCrcy") ) {
                final Object value = values.remove("FixedAmountInGlobalCrcy");
                if( (value == null) || (!value.equals(getFixedAmountInGlobalCrcy())) ) {
                    setFixedAmountInGlobalCrcy(((BigDecimal) value));
                }
            }
            if( values.containsKey("GrpValnFixedAmtInGlobCrcy") ) {
                final Object value = values.remove("GrpValnFixedAmtInGlobCrcy");
                if( (value == null) || (!value.equals(getGrpValnFixedAmtInGlobCrcy())) ) {
                    setGrpValnFixedAmtInGlobCrcy(((BigDecimal) value));
                }
            }
            if( values.containsKey("PrftCtrValnFxdAmtInGlobCrcy") ) {
                final Object value = values.remove("PrftCtrValnFxdAmtInGlobCrcy");
                if( (value == null) || (!value.equals(getPrftCtrValnFxdAmtInGlobCrcy())) ) {
                    setPrftCtrValnFxdAmtInGlobCrcy(((BigDecimal) value));
                }
            }
            if( values.containsKey("TotalPriceVarcInGlobalCrcy") ) {
                final Object value = values.remove("TotalPriceVarcInGlobalCrcy");
                if( (value == null) || (!value.equals(getTotalPriceVarcInGlobalCrcy())) ) {
                    setTotalPriceVarcInGlobalCrcy(((BigDecimal) value));
                }
            }
            if( values.containsKey("GrpValnTotPrcVarcInGlobCrcy") ) {
                final Object value = values.remove("GrpValnTotPrcVarcInGlobCrcy");
                if( (value == null) || (!value.equals(getGrpValnTotPrcVarcInGlobCrcy())) ) {
                    setGrpValnTotPrcVarcInGlobCrcy(((BigDecimal) value));
                }
            }
            if( values.containsKey("PrftCtrValnTotPrcVarcInGlbCrcy") ) {
                final Object value = values.remove("PrftCtrValnTotPrcVarcInGlbCrcy");
                if( (value == null) || (!value.equals(getPrftCtrValnTotPrcVarcInGlbCrcy())) ) {
                    setPrftCtrValnTotPrcVarcInGlbCrcy(((BigDecimal) value));
                }
            }
            if( values.containsKey("FixedPriceVarcInGlobalCrcy") ) {
                final Object value = values.remove("FixedPriceVarcInGlobalCrcy");
                if( (value == null) || (!value.equals(getFixedPriceVarcInGlobalCrcy())) ) {
                    setFixedPriceVarcInGlobalCrcy(((BigDecimal) value));
                }
            }
            if( values.containsKey("GrpValnFixedPrcVarcInGlobCrcy") ) {
                final Object value = values.remove("GrpValnFixedPrcVarcInGlobCrcy");
                if( (value == null) || (!value.equals(getGrpValnFixedPrcVarcInGlobCrcy())) ) {
                    setGrpValnFixedPrcVarcInGlobCrcy(((BigDecimal) value));
                }
            }
            if( values.containsKey("PrftCtrValnFxdPrcVarcInGlbCrcy") ) {
                final Object value = values.remove("PrftCtrValnFxdPrcVarcInGlbCrcy");
                if( (value == null) || (!value.equals(getPrftCtrValnFxdPrcVarcInGlbCrcy())) ) {
                    setPrftCtrValnFxdPrcVarcInGlbCrcy(((BigDecimal) value));
                }
            }
            if( values.containsKey("FixedAmountInCoCodeCrcy") ) {
                final Object value = values.remove("FixedAmountInCoCodeCrcy");
                if( (value == null) || (!value.equals(getFixedAmountInCoCodeCrcy())) ) {
                    setFixedAmountInCoCodeCrcy(((BigDecimal) value));
                }
            }
            if( values.containsKey("ControllingObjectCurrency") ) {
                final Object value = values.remove("ControllingObjectCurrency");
                if( (value == null) || (!value.equals(getControllingObjectCurrency())) ) {
                    setControllingObjectCurrency(((String) value));
                }
            }
            if( values.containsKey("AmountInObjectCurrency") ) {
                final Object value = values.remove("AmountInObjectCurrency");
                if( (value == null) || (!value.equals(getAmountInObjectCurrency())) ) {
                    setAmountInObjectCurrency(((BigDecimal) value));
                }
            }
            if( values.containsKey("BaseUnit") ) {
                final Object value = values.remove("BaseUnit");
                if( (value == null) || (!value.equals(getBaseUnit())) ) {
                    setBaseUnit(((String) value));
                }
            }
            if( values.containsKey("Quantity") ) {
                final Object value = values.remove("Quantity");
                if( (value == null) || (!value.equals(getQuantity())) ) {
                    setQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("FixedQuantity") ) {
                final Object value = values.remove("FixedQuantity");
                if( (value == null) || (!value.equals(getFixedQuantity())) ) {
                    setFixedQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("CostSourceUnit") ) {
                final Object value = values.remove("CostSourceUnit");
                if( (value == null) || (!value.equals(getCostSourceUnit())) ) {
                    setCostSourceUnit(((String) value));
                }
            }
            if( values.containsKey("ValuationQuantity") ) {
                final Object value = values.remove("ValuationQuantity");
                if( (value == null) || (!value.equals(getValuationQuantity())) ) {
                    setValuationQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("ValuationFixedQuantity") ) {
                final Object value = values.remove("ValuationFixedQuantity");
                if( (value == null) || (!value.equals(getValuationFixedQuantity())) ) {
                    setValuationFixedQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("AdditionalQuantity1Unit") ) {
                final Object value = values.remove("AdditionalQuantity1Unit");
                if( (value == null) || (!value.equals(getAdditionalQuantity1Unit())) ) {
                    setAdditionalQuantity1Unit(((String) value));
                }
            }
            if( values.containsKey("AdditionalQuantity1") ) {
                final Object value = values.remove("AdditionalQuantity1");
                if( (value == null) || (!value.equals(getAdditionalQuantity1())) ) {
                    setAdditionalQuantity1(((BigDecimal) value));
                }
            }
            if( values.containsKey("AdditionalQuantity2Unit") ) {
                final Object value = values.remove("AdditionalQuantity2Unit");
                if( (value == null) || (!value.equals(getAdditionalQuantity2Unit())) ) {
                    setAdditionalQuantity2Unit(((String) value));
                }
            }
            if( values.containsKey("AdditionalQuantity2") ) {
                final Object value = values.remove("AdditionalQuantity2");
                if( (value == null) || (!value.equals(getAdditionalQuantity2())) ) {
                    setAdditionalQuantity2(((BigDecimal) value));
                }
            }
            if( values.containsKey("AdditionalQuantity3Unit") ) {
                final Object value = values.remove("AdditionalQuantity3Unit");
                if( (value == null) || (!value.equals(getAdditionalQuantity3Unit())) ) {
                    setAdditionalQuantity3Unit(((String) value));
                }
            }
            if( values.containsKey("AdditionalQuantity3") ) {
                final Object value = values.remove("AdditionalQuantity3");
                if( (value == null) || (!value.equals(getAdditionalQuantity3())) ) {
                    setAdditionalQuantity3(((BigDecimal) value));
                }
            }
            if( values.containsKey("DebitCreditCode") ) {
                final Object value = values.remove("DebitCreditCode");
                if( (value == null) || (!value.equals(getDebitCreditCode())) ) {
                    setDebitCreditCode(((String) value));
                }
            }
            if( values.containsKey("FiscalPeriod") ) {
                final Object value = values.remove("FiscalPeriod");
                if( (value == null) || (!value.equals(getFiscalPeriod())) ) {
                    setFiscalPeriod(((String) value));
                }
            }
            if( values.containsKey("FiscalYearVariant") ) {
                final Object value = values.remove("FiscalYearVariant");
                if( (value == null) || (!value.equals(getFiscalYearVariant())) ) {
                    setFiscalYearVariant(((String) value));
                }
            }
            if( values.containsKey("FiscalYearPeriod") ) {
                final Object value = values.remove("FiscalYearPeriod");
                if( (value == null) || (!value.equals(getFiscalYearPeriod())) ) {
                    setFiscalYearPeriod(((String) value));
                }
            }
            if( values.containsKey("PostingDate") ) {
                final Object value = values.remove("PostingDate");
                if( (value == null) || (!value.equals(getPostingDate())) ) {
                    setPostingDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("DocumentDate") ) {
                final Object value = values.remove("DocumentDate");
                if( (value == null) || (!value.equals(getDocumentDate())) ) {
                    setDocumentDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("AccountingDocumentType") ) {
                final Object value = values.remove("AccountingDocumentType");
                if( (value == null) || (!value.equals(getAccountingDocumentType())) ) {
                    setAccountingDocumentType(((String) value));
                }
            }
            if( values.containsKey("AccountingDocumentItem") ) {
                final Object value = values.remove("AccountingDocumentItem");
                if( (value == null) || (!value.equals(getAccountingDocumentItem())) ) {
                    setAccountingDocumentItem(((String) value));
                }
            }
            if( values.containsKey("AssignmentReference") ) {
                final Object value = values.remove("AssignmentReference");
                if( (value == null) || (!value.equals(getAssignmentReference())) ) {
                    setAssignmentReference(((String) value));
                }
            }
            if( values.containsKey("AccountingDocumentCategory") ) {
                final Object value = values.remove("AccountingDocumentCategory");
                if( (value == null) || (!value.equals(getAccountingDocumentCategory())) ) {
                    setAccountingDocumentCategory(((String) value));
                }
            }
            if( values.containsKey("PostingKey") ) {
                final Object value = values.remove("PostingKey");
                if( (value == null) || (!value.equals(getPostingKey())) ) {
                    setPostingKey(((String) value));
                }
            }
            if( values.containsKey("TransactionTypeDetermination") ) {
                final Object value = values.remove("TransactionTypeDetermination");
                if( (value == null) || (!value.equals(getTransactionTypeDetermination())) ) {
                    setTransactionTypeDetermination(((String) value));
                }
            }
            if( values.containsKey("SubLedgerAcctLineItemType") ) {
                final Object value = values.remove("SubLedgerAcctLineItemType");
                if( (value == null) || (!value.equals(getSubLedgerAcctLineItemType())) ) {
                    setSubLedgerAcctLineItemType(((String) value));
                }
            }
            if( values.containsKey("AccountingDocCreatedByUser") ) {
                final Object value = values.remove("AccountingDocCreatedByUser");
                if( (value == null) || (!value.equals(getAccountingDocCreatedByUser())) ) {
                    setAccountingDocCreatedByUser(((String) value));
                }
            }
            if( values.containsKey("LastChangeDateTime") ) {
                final Object value = values.remove("LastChangeDateTime");
                if( (value == null) || (!value.equals(getLastChangeDateTime())) ) {
                    setLastChangeDateTime(((ZonedDateTime) value));
                }
            }
            if( values.containsKey("CreationDateTime") ) {
                final Object value = values.remove("CreationDateTime");
                if( (value == null) || (!value.equals(getCreationDateTime())) ) {
                    setCreationDateTime(((ZonedDateTime) value));
                }
            }
            if( values.containsKey("CreationDate") ) {
                final Object value = values.remove("CreationDate");
                if( (value == null) || (!value.equals(getCreationDate())) ) {
                    setCreationDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("EliminationProfitCenter") ) {
                final Object value = values.remove("EliminationProfitCenter");
                if( (value == null) || (!value.equals(getEliminationProfitCenter())) ) {
                    setEliminationProfitCenter(((String) value));
                }
            }
            if( values.containsKey("OriginObjectType") ) {
                final Object value = values.remove("OriginObjectType");
                if( (value == null) || (!value.equals(getOriginObjectType())) ) {
                    setOriginObjectType(((String) value));
                }
            }
            if( values.containsKey("GLAccountType") ) {
                final Object value = values.remove("GLAccountType");
                if( (value == null) || (!value.equals(getGLAccountType())) ) {
                    setGLAccountType(((String) value));
                }
            }
            if( values.containsKey("AlternativeGLAccount") ) {
                final Object value = values.remove("AlternativeGLAccount");
                if( (value == null) || (!value.equals(getAlternativeGLAccount())) ) {
                    setAlternativeGLAccount(((String) value));
                }
            }
            if( values.containsKey("CountryChartOfAccounts") ) {
                final Object value = values.remove("CountryChartOfAccounts");
                if( (value == null) || (!value.equals(getCountryChartOfAccounts())) ) {
                    setCountryChartOfAccounts(((String) value));
                }
            }
            if( values.containsKey("ItemIsSplit") ) {
                final Object value = values.remove("ItemIsSplit");
                if( (value == null) || (!value.equals(getItemIsSplit())) ) {
                    setItemIsSplit(((Boolean) value));
                }
            }
            if( values.containsKey("InvoiceReference") ) {
                final Object value = values.remove("InvoiceReference");
                if( (value == null) || (!value.equals(getInvoiceReference())) ) {
                    setInvoiceReference(((String) value));
                }
            }
            if( values.containsKey("InvoiceReferenceFiscalYear") ) {
                final Object value = values.remove("InvoiceReferenceFiscalYear");
                if( (value == null) || (!value.equals(getInvoiceReferenceFiscalYear())) ) {
                    setInvoiceReferenceFiscalYear(((String) value));
                }
            }
            if( values.containsKey("FollowOnDocumentType") ) {
                final Object value = values.remove("FollowOnDocumentType");
                if( (value == null) || (!value.equals(getFollowOnDocumentType())) ) {
                    setFollowOnDocumentType(((String) value));
                }
            }
            if( values.containsKey("InvoiceItemReference") ) {
                final Object value = values.remove("InvoiceItemReference");
                if( (value == null) || (!value.equals(getInvoiceItemReference())) ) {
                    setInvoiceItemReference(((String) value));
                }
            }
            if( values.containsKey("ReferencePurchaseOrderCategory") ) {
                final Object value = values.remove("ReferencePurchaseOrderCategory");
                if( (value == null) || (!value.equals(getReferencePurchaseOrderCategory())) ) {
                    setReferencePurchaseOrderCategory(((String) value));
                }
            }
            if( values.containsKey("PurchasingDocument") ) {
                final Object value = values.remove("PurchasingDocument");
                if( (value == null) || (!value.equals(getPurchasingDocument())) ) {
                    setPurchasingDocument(((String) value));
                }
            }
            if( values.containsKey("PurchasingDocumentItem") ) {
                final Object value = values.remove("PurchasingDocumentItem");
                if( (value == null) || (!value.equals(getPurchasingDocumentItem())) ) {
                    setPurchasingDocumentItem(((String) value));
                }
            }
            if( values.containsKey("AccountAssignmentNumber") ) {
                final Object value = values.remove("AccountAssignmentNumber");
                if( (value == null) || (!value.equals(getAccountAssignmentNumber())) ) {
                    setAccountAssignmentNumber(((String) value));
                }
            }
            if( values.containsKey("DocumentItemText") ) {
                final Object value = values.remove("DocumentItemText");
                if( (value == null) || (!value.equals(getDocumentItemText())) ) {
                    setDocumentItemText(((String) value));
                }
            }
            if( values.containsKey("SalesDocument") ) {
                final Object value = values.remove("SalesDocument");
                if( (value == null) || (!value.equals(getSalesDocument())) ) {
                    setSalesDocument(((String) value));
                }
            }
            if( values.containsKey("SalesDocumentItem") ) {
                final Object value = values.remove("SalesDocumentItem");
                if( (value == null) || (!value.equals(getSalesDocumentItem())) ) {
                    setSalesDocumentItem(((String) value));
                }
            }
            if( values.containsKey("Product") ) {
                final Object value = values.remove("Product");
                if( (value == null) || (!value.equals(getProduct())) ) {
                    setProduct(((String) value));
                }
            }
            if( values.containsKey("Plant") ) {
                final Object value = values.remove("Plant");
                if( (value == null) || (!value.equals(getPlant())) ) {
                    setPlant(((String) value));
                }
            }
            if( values.containsKey("Supplier") ) {
                final Object value = values.remove("Supplier");
                if( (value == null) || (!value.equals(getSupplier())) ) {
                    setSupplier(((String) value));
                }
            }
            if( values.containsKey("Customer") ) {
                final Object value = values.remove("Customer");
                if( (value == null) || (!value.equals(getCustomer())) ) {
                    setCustomer(((String) value));
                }
            }
            if( values.containsKey("ServicesRenderedDate") ) {
                final Object value = values.remove("ServicesRenderedDate");
                if( (value == null) || (!value.equals(getServicesRenderedDate())) ) {
                    setServicesRenderedDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ConditionContract") ) {
                final Object value = values.remove("ConditionContract");
                if( (value == null) || (!value.equals(getConditionContract())) ) {
                    setConditionContract(((String) value));
                }
            }
            if( values.containsKey("FinancialAccountType") ) {
                final Object value = values.remove("FinancialAccountType");
                if( (value == null) || (!value.equals(getFinancialAccountType())) ) {
                    setFinancialAccountType(((String) value));
                }
            }
            if( values.containsKey("SpecialGLCode") ) {
                final Object value = values.remove("SpecialGLCode");
                if( (value == null) || (!value.equals(getSpecialGLCode())) ) {
                    setSpecialGLCode(((String) value));
                }
            }
            if( values.containsKey("TaxCode") ) {
                final Object value = values.remove("TaxCode");
                if( (value == null) || (!value.equals(getTaxCode())) ) {
                    setTaxCode(((String) value));
                }
            }
            if( values.containsKey("HouseBank") ) {
                final Object value = values.remove("HouseBank");
                if( (value == null) || (!value.equals(getHouseBank())) ) {
                    setHouseBank(((String) value));
                }
            }
            if( values.containsKey("HouseBankAccount") ) {
                final Object value = values.remove("HouseBankAccount");
                if( (value == null) || (!value.equals(getHouseBankAccount())) ) {
                    setHouseBankAccount(((String) value));
                }
            }
            if( values.containsKey("IsOpenItemManaged") ) {
                final Object value = values.remove("IsOpenItemManaged");
                if( (value == null) || (!value.equals(getIsOpenItemManaged())) ) {
                    setIsOpenItemManaged(((String) value));
                }
            }
            if( values.containsKey("ClearingDate") ) {
                final Object value = values.remove("ClearingDate");
                if( (value == null) || (!value.equals(getClearingDate())) ) {
                    setClearingDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ClearingAccountingDocument") ) {
                final Object value = values.remove("ClearingAccountingDocument");
                if( (value == null) || (!value.equals(getClearingAccountingDocument())) ) {
                    setClearingAccountingDocument(((String) value));
                }
            }
            if( values.containsKey("ClearingDocFiscalYear") ) {
                final Object value = values.remove("ClearingDocFiscalYear");
                if( (value == null) || (!value.equals(getClearingDocFiscalYear())) ) {
                    setClearingDocFiscalYear(((String) value));
                }
            }
            if( values.containsKey("ValueDate") ) {
                final Object value = values.remove("ValueDate");
                if( (value == null) || (!value.equals(getValueDate())) ) {
                    setValueDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("AssetDepreciationArea") ) {
                final Object value = values.remove("AssetDepreciationArea");
                if( (value == null) || (!value.equals(getAssetDepreciationArea())) ) {
                    setAssetDepreciationArea(((String) value));
                }
            }
            if( values.containsKey("MasterFixedAsset") ) {
                final Object value = values.remove("MasterFixedAsset");
                if( (value == null) || (!value.equals(getMasterFixedAsset())) ) {
                    setMasterFixedAsset(((String) value));
                }
            }
            if( values.containsKey("FixedAsset") ) {
                final Object value = values.remove("FixedAsset");
                if( (value == null) || (!value.equals(getFixedAsset())) ) {
                    setFixedAsset(((String) value));
                }
            }
            if( values.containsKey("AssetValueDate") ) {
                final Object value = values.remove("AssetValueDate");
                if( (value == null) || (!value.equals(getAssetValueDate())) ) {
                    setAssetValueDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("AssetTransactionType") ) {
                final Object value = values.remove("AssetTransactionType");
                if( (value == null) || (!value.equals(getAssetTransactionType())) ) {
                    setAssetTransactionType(((String) value));
                }
            }
            if( values.containsKey("AssetAcctTransClassfctn") ) {
                final Object value = values.remove("AssetAcctTransClassfctn");
                if( (value == null) || (!value.equals(getAssetAcctTransClassfctn())) ) {
                    setAssetAcctTransClassfctn(((String) value));
                }
            }
            if( values.containsKey("DepreciationFiscalPeriod") ) {
                final Object value = values.remove("DepreciationFiscalPeriod");
                if( (value == null) || (!value.equals(getDepreciationFiscalPeriod())) ) {
                    setDepreciationFiscalPeriod(((String) value));
                }
            }
            if( values.containsKey("GroupMasterFixedAsset") ) {
                final Object value = values.remove("GroupMasterFixedAsset");
                if( (value == null) || (!value.equals(getGroupMasterFixedAsset())) ) {
                    setGroupMasterFixedAsset(((String) value));
                }
            }
            if( values.containsKey("GroupFixedAsset") ) {
                final Object value = values.remove("GroupFixedAsset");
                if( (value == null) || (!value.equals(getGroupFixedAsset())) ) {
                    setGroupFixedAsset(((String) value));
                }
            }
            if( values.containsKey("AssetClass") ) {
                final Object value = values.remove("AssetClass");
                if( (value == null) || (!value.equals(getAssetClass())) ) {
                    setAssetClass(((String) value));
                }
            }
            if( values.containsKey("CostEstimate") ) {
                final Object value = values.remove("CostEstimate");
                if( (value == null) || (!value.equals(getCostEstimate())) ) {
                    setCostEstimate(((String) value));
                }
            }
            if( values.containsKey("InventorySpecialStockValnType") ) {
                final Object value = values.remove("InventorySpecialStockValnType");
                if( (value == null) || (!value.equals(getInventorySpecialStockValnType())) ) {
                    setInventorySpecialStockValnType(((String) value));
                }
            }
            if( values.containsKey("InventorySpecialStockType") ) {
                final Object value = values.remove("InventorySpecialStockType");
                if( (value == null) || (!value.equals(getInventorySpecialStockType())) ) {
                    setInventorySpecialStockType(((String) value));
                }
            }
            if( values.containsKey("InventorySpclStkSalesDocument") ) {
                final Object value = values.remove("InventorySpclStkSalesDocument");
                if( (value == null) || (!value.equals(getInventorySpclStkSalesDocument())) ) {
                    setInventorySpclStkSalesDocument(((String) value));
                }
            }
            if( values.containsKey("InventorySpclStkSalesDocItm") ) {
                final Object value = values.remove("InventorySpclStkSalesDocItm");
                if( (value == null) || (!value.equals(getInventorySpclStkSalesDocItm())) ) {
                    setInventorySpclStkSalesDocItm(((String) value));
                }
            }
            if( values.containsKey("InvtrySpclStockWBSElmntIntID") ) {
                final Object value = values.remove("InvtrySpclStockWBSElmntIntID");
                if( (value == null) || (!value.equals(getInvtrySpclStockWBSElmntIntID())) ) {
                    setInvtrySpclStockWBSElmntIntID(((String) value));
                }
            }
            if( values.containsKey("InventorySpecialStockSupplier") ) {
                final Object value = values.remove("InventorySpecialStockSupplier");
                if( (value == null) || (!value.equals(getInventorySpecialStockSupplier())) ) {
                    setInventorySpecialStockSupplier(((String) value));
                }
            }
            if( values.containsKey("InventoryValuationType") ) {
                final Object value = values.remove("InventoryValuationType");
                if( (value == null) || (!value.equals(getInventoryValuationType())) ) {
                    setInventoryValuationType(((String) value));
                }
            }
            if( values.containsKey("ValuationArea") ) {
                final Object value = values.remove("ValuationArea");
                if( (value == null) || (!value.equals(getValuationArea())) ) {
                    setValuationArea(((String) value));
                }
            }
            if( values.containsKey("CostOriginGroup") ) {
                final Object value = values.remove("CostOriginGroup");
                if( (value == null) || (!value.equals(getCostOriginGroup())) ) {
                    setCostOriginGroup(((String) value));
                }
            }
            if( values.containsKey("OriginSenderObject") ) {
                final Object value = values.remove("OriginSenderObject");
                if( (value == null) || (!value.equals(getOriginSenderObject())) ) {
                    setOriginSenderObject(((String) value));
                }
            }
            if( values.containsKey("ControllingObjectDebitType") ) {
                final Object value = values.remove("ControllingObjectDebitType");
                if( (value == null) || (!value.equals(getControllingObjectDebitType())) ) {
                    setControllingObjectDebitType(((String) value));
                }
            }
            if( values.containsKey("QuantityIsIncomplete") ) {
                final Object value = values.remove("QuantityIsIncomplete");
                if( (value == null) || (!value.equals(getQuantityIsIncomplete())) ) {
                    setQuantityIsIncomplete(((String) value));
                }
            }
            if( values.containsKey("OffsettingAccount") ) {
                final Object value = values.remove("OffsettingAccount");
                if( (value == null) || (!value.equals(getOffsettingAccount())) ) {
                    setOffsettingAccount(((String) value));
                }
            }
            if( values.containsKey("OffsettingAccountType") ) {
                final Object value = values.remove("OffsettingAccountType");
                if( (value == null) || (!value.equals(getOffsettingAccountType())) ) {
                    setOffsettingAccountType(((String) value));
                }
            }
            if( values.containsKey("OffsettingChartOfAccounts") ) {
                final Object value = values.remove("OffsettingChartOfAccounts");
                if( (value == null) || (!value.equals(getOffsettingChartOfAccounts())) ) {
                    setOffsettingChartOfAccounts(((String) value));
                }
            }
            if( values.containsKey("LineItemIsCompleted") ) {
                final Object value = values.remove("LineItemIsCompleted");
                if( (value == null) || (!value.equals(getLineItemIsCompleted())) ) {
                    setLineItemIsCompleted(((Boolean) value));
                }
            }
            if( values.containsKey("PersonnelNumber") ) {
                final Object value = values.remove("PersonnelNumber");
                if( (value == null) || (!value.equals(getPersonnelNumber())) ) {
                    setPersonnelNumber(((String) value));
                }
            }
            if( values.containsKey("ControllingObjectClass") ) {
                final Object value = values.remove("ControllingObjectClass");
                if( (value == null) || (!value.equals(getControllingObjectClass())) ) {
                    setControllingObjectClass(((String) value));
                }
            }
            if( values.containsKey("PartnerCompanyCode") ) {
                final Object value = values.remove("PartnerCompanyCode");
                if( (value == null) || (!value.equals(getPartnerCompanyCode())) ) {
                    setPartnerCompanyCode(((String) value));
                }
            }
            if( values.containsKey("PartnerControllingObjectClass") ) {
                final Object value = values.remove("PartnerControllingObjectClass");
                if( (value == null) || (!value.equals(getPartnerControllingObjectClass())) ) {
                    setPartnerControllingObjectClass(((String) value));
                }
            }
            if( values.containsKey("OriginCostCenter") ) {
                final Object value = values.remove("OriginCostCenter");
                if( (value == null) || (!value.equals(getOriginCostCenter())) ) {
                    setOriginCostCenter(((String) value));
                }
            }
            if( values.containsKey("OriginProfitCenter") ) {
                final Object value = values.remove("OriginProfitCenter");
                if( (value == null) || (!value.equals(getOriginProfitCenter())) ) {
                    setOriginProfitCenter(((String) value));
                }
            }
            if( values.containsKey("OriginCostCtrActivityType") ) {
                final Object value = values.remove("OriginCostCtrActivityType");
                if( (value == null) || (!value.equals(getOriginCostCtrActivityType())) ) {
                    setOriginCostCtrActivityType(((String) value));
                }
            }
            if( values.containsKey("AccountAssignment") ) {
                final Object value = values.remove("AccountAssignment");
                if( (value == null) || (!value.equals(getAccountAssignment())) ) {
                    setAccountAssignment(((String) value));
                }
            }
            if( values.containsKey("AccountAssignmentType") ) {
                final Object value = values.remove("AccountAssignmentType");
                if( (value == null) || (!value.equals(getAccountAssignmentType())) ) {
                    setAccountAssignmentType(((String) value));
                }
            }
            if( values.containsKey("CostCtrActivityType") ) {
                final Object value = values.remove("CostCtrActivityType");
                if( (value == null) || (!value.equals(getCostCtrActivityType())) ) {
                    setCostCtrActivityType(((String) value));
                }
            }
            if( values.containsKey("OrderID") ) {
                final Object value = values.remove("OrderID");
                if( (value == null) || (!value.equals(getOrderID())) ) {
                    setOrderID(((String) value));
                }
            }
            if( values.containsKey("OrderCategory") ) {
                final Object value = values.remove("OrderCategory");
                if( (value == null) || (!value.equals(getOrderCategory())) ) {
                    setOrderCategory(((String) value));
                }
            }
            if( values.containsKey("WBSElementInternalID") ) {
                final Object value = values.remove("WBSElementInternalID");
                if( (value == null) || (!value.equals(getWBSElementInternalID())) ) {
                    setWBSElementInternalID(((String) value));
                }
            }
            if( values.containsKey("PartnerWBSElementInternalID") ) {
                final Object value = values.remove("PartnerWBSElementInternalID");
                if( (value == null) || (!value.equals(getPartnerWBSElementInternalID())) ) {
                    setPartnerWBSElementInternalID(((String) value));
                }
            }
            if( values.containsKey("ProjectInternalID") ) {
                final Object value = values.remove("ProjectInternalID");
                if( (value == null) || (!value.equals(getProjectInternalID())) ) {
                    setProjectInternalID(((String) value));
                }
            }
            if( values.containsKey("PartnerProjectInternalID") ) {
                final Object value = values.remove("PartnerProjectInternalID");
                if( (value == null) || (!value.equals(getPartnerProjectInternalID())) ) {
                    setPartnerProjectInternalID(((String) value));
                }
            }
            if( values.containsKey("OperatingConcern") ) {
                final Object value = values.remove("OperatingConcern");
                if( (value == null) || (!value.equals(getOperatingConcern())) ) {
                    setOperatingConcern(((String) value));
                }
            }
            if( values.containsKey("ProjectNetwork") ) {
                final Object value = values.remove("ProjectNetwork");
                if( (value == null) || (!value.equals(getProjectNetwork())) ) {
                    setProjectNetwork(((String) value));
                }
            }
            if( values.containsKey("BusinessProcess") ) {
                final Object value = values.remove("BusinessProcess");
                if( (value == null) || (!value.equals(getBusinessProcess())) ) {
                    setBusinessProcess(((String) value));
                }
            }
            if( values.containsKey("CostObject") ) {
                final Object value = values.remove("CostObject");
                if( (value == null) || (!value.equals(getCostObject())) ) {
                    setCostObject(((String) value));
                }
            }
            if( values.containsKey("BillableControl") ) {
                final Object value = values.remove("BillableControl");
                if( (value == null) || (!value.equals(getBillableControl())) ) {
                    setBillableControl(((String) value));
                }
            }
            if( values.containsKey("CostAnalysisResource") ) {
                final Object value = values.remove("CostAnalysisResource");
                if( (value == null) || (!value.equals(getCostAnalysisResource())) ) {
                    setCostAnalysisResource(((String) value));
                }
            }
            if( values.containsKey("CustomerServiceNotification") ) {
                final Object value = values.remove("CustomerServiceNotification");
                if( (value == null) || (!value.equals(getCustomerServiceNotification())) ) {
                    setCustomerServiceNotification(((String) value));
                }
            }
            if( values.containsKey("ServiceDocumentType") ) {
                final Object value = values.remove("ServiceDocumentType");
                if( (value == null) || (!value.equals(getServiceDocumentType())) ) {
                    setServiceDocumentType(((String) value));
                }
            }
            if( values.containsKey("ServiceDocument") ) {
                final Object value = values.remove("ServiceDocument");
                if( (value == null) || (!value.equals(getServiceDocument())) ) {
                    setServiceDocument(((String) value));
                }
            }
            if( values.containsKey("ServiceDocumentItem") ) {
                final Object value = values.remove("ServiceDocumentItem");
                if( (value == null) || (!value.equals(getServiceDocumentItem())) ) {
                    setServiceDocumentItem(((String) value));
                }
            }
            if( values.containsKey("PartnerServiceDocumentType") ) {
                final Object value = values.remove("PartnerServiceDocumentType");
                if( (value == null) || (!value.equals(getPartnerServiceDocumentType())) ) {
                    setPartnerServiceDocumentType(((String) value));
                }
            }
            if( values.containsKey("PartnerServiceDocument") ) {
                final Object value = values.remove("PartnerServiceDocument");
                if( (value == null) || (!value.equals(getPartnerServiceDocument())) ) {
                    setPartnerServiceDocument(((String) value));
                }
            }
            if( values.containsKey("PartnerServiceDocumentItem") ) {
                final Object value = values.remove("PartnerServiceDocumentItem");
                if( (value == null) || (!value.equals(getPartnerServiceDocumentItem())) ) {
                    setPartnerServiceDocumentItem(((String) value));
                }
            }
            if( values.containsKey("ServiceContractType") ) {
                final Object value = values.remove("ServiceContractType");
                if( (value == null) || (!value.equals(getServiceContractType())) ) {
                    setServiceContractType(((String) value));
                }
            }
            if( values.containsKey("ServiceContract") ) {
                final Object value = values.remove("ServiceContract");
                if( (value == null) || (!value.equals(getServiceContract())) ) {
                    setServiceContract(((String) value));
                }
            }
            if( values.containsKey("ServiceContractItem") ) {
                final Object value = values.remove("ServiceContractItem");
                if( (value == null) || (!value.equals(getServiceContractItem())) ) {
                    setServiceContractItem(((String) value));
                }
            }
            if( values.containsKey("TimeSheetOvertimeCategory") ) {
                final Object value = values.remove("TimeSheetOvertimeCategory");
                if( (value == null) || (!value.equals(getTimeSheetOvertimeCategory())) ) {
                    setTimeSheetOvertimeCategory(((String) value));
                }
            }
            if( values.containsKey("PartnerAccountAssignment") ) {
                final Object value = values.remove("PartnerAccountAssignment");
                if( (value == null) || (!value.equals(getPartnerAccountAssignment())) ) {
                    setPartnerAccountAssignment(((String) value));
                }
            }
            if( values.containsKey("PartnerAccountAssignmentType") ) {
                final Object value = values.remove("PartnerAccountAssignmentType");
                if( (value == null) || (!value.equals(getPartnerAccountAssignmentType())) ) {
                    setPartnerAccountAssignmentType(((String) value));
                }
            }
            if( values.containsKey("PartnerCostCtrActivityType") ) {
                final Object value = values.remove("PartnerCostCtrActivityType");
                if( (value == null) || (!value.equals(getPartnerCostCtrActivityType())) ) {
                    setPartnerCostCtrActivityType(((String) value));
                }
            }
            if( values.containsKey("PartnerOrder") ) {
                final Object value = values.remove("PartnerOrder");
                if( (value == null) || (!value.equals(getPartnerOrder())) ) {
                    setPartnerOrder(((String) value));
                }
            }
            if( values.containsKey("PartnerOrderCategory") ) {
                final Object value = values.remove("PartnerOrderCategory");
                if( (value == null) || (!value.equals(getPartnerOrderCategory())) ) {
                    setPartnerOrderCategory(((String) value));
                }
            }
            if( values.containsKey("PartnerSalesDocument") ) {
                final Object value = values.remove("PartnerSalesDocument");
                if( (value == null) || (!value.equals(getPartnerSalesDocument())) ) {
                    setPartnerSalesDocument(((String) value));
                }
            }
            if( values.containsKey("PartnerSalesDocumentItem") ) {
                final Object value = values.remove("PartnerSalesDocumentItem");
                if( (value == null) || (!value.equals(getPartnerSalesDocumentItem())) ) {
                    setPartnerSalesDocumentItem(((String) value));
                }
            }
            if( values.containsKey("PartnerProjectNetwork") ) {
                final Object value = values.remove("PartnerProjectNetwork");
                if( (value == null) || (!value.equals(getPartnerProjectNetwork())) ) {
                    setPartnerProjectNetwork(((String) value));
                }
            }
            if( values.containsKey("PartnerBusinessProcess") ) {
                final Object value = values.remove("PartnerBusinessProcess");
                if( (value == null) || (!value.equals(getPartnerBusinessProcess())) ) {
                    setPartnerBusinessProcess(((String) value));
                }
            }
            if( values.containsKey("PartnerCostObject") ) {
                final Object value = values.remove("PartnerCostObject");
                if( (value == null) || (!value.equals(getPartnerCostObject())) ) {
                    setPartnerCostObject(((String) value));
                }
            }
            if( values.containsKey("ControllingDocumentItem") ) {
                final Object value = values.remove("ControllingDocumentItem");
                if( (value == null) || (!value.equals(getControllingDocumentItem())) ) {
                    setControllingDocumentItem(((String) value));
                }
            }
            if( values.containsKey("BillingDocumentType") ) {
                final Object value = values.remove("BillingDocumentType");
                if( (value == null) || (!value.equals(getBillingDocumentType())) ) {
                    setBillingDocumentType(((String) value));
                }
            }
            if( values.containsKey("SalesOrganization") ) {
                final Object value = values.remove("SalesOrganization");
                if( (value == null) || (!value.equals(getSalesOrganization())) ) {
                    setSalesOrganization(((String) value));
                }
            }
            if( values.containsKey("DistributionChannel") ) {
                final Object value = values.remove("DistributionChannel");
                if( (value == null) || (!value.equals(getDistributionChannel())) ) {
                    setDistributionChannel(((String) value));
                }
            }
            if( values.containsKey("OrganizationDivision") ) {
                final Object value = values.remove("OrganizationDivision");
                if( (value == null) || (!value.equals(getOrganizationDivision())) ) {
                    setOrganizationDivision(((String) value));
                }
            }
            if( values.containsKey("SoldProduct") ) {
                final Object value = values.remove("SoldProduct");
                if( (value == null) || (!value.equals(getSoldProduct())) ) {
                    setSoldProduct(((String) value));
                }
            }
            if( values.containsKey("SoldProductGroup") ) {
                final Object value = values.remove("SoldProductGroup");
                if( (value == null) || (!value.equals(getSoldProductGroup())) ) {
                    setSoldProductGroup(((String) value));
                }
            }
            if( values.containsKey("CustomerGroup") ) {
                final Object value = values.remove("CustomerGroup");
                if( (value == null) || (!value.equals(getCustomerGroup())) ) {
                    setCustomerGroup(((String) value));
                }
            }
            if( values.containsKey("CustomerSupplierCountry") ) {
                final Object value = values.remove("CustomerSupplierCountry");
                if( (value == null) || (!value.equals(getCustomerSupplierCountry())) ) {
                    setCustomerSupplierCountry(((String) value));
                }
            }
            if( values.containsKey("CustomerSupplierIndustry") ) {
                final Object value = values.remove("CustomerSupplierIndustry");
                if( (value == null) || (!value.equals(getCustomerSupplierIndustry())) ) {
                    setCustomerSupplierIndustry(((String) value));
                }
            }
            if( values.containsKey("SalesDistrict") ) {
                final Object value = values.remove("SalesDistrict");
                if( (value == null) || (!value.equals(getSalesDistrict())) ) {
                    setSalesDistrict(((String) value));
                }
            }
            if( values.containsKey("BillToParty") ) {
                final Object value = values.remove("BillToParty");
                if( (value == null) || (!value.equals(getBillToParty())) ) {
                    setBillToParty(((String) value));
                }
            }
            if( values.containsKey("ShipToParty") ) {
                final Object value = values.remove("ShipToParty");
                if( (value == null) || (!value.equals(getShipToParty())) ) {
                    setShipToParty(((String) value));
                }
            }
            if( values.containsKey("CustomerSupplierCorporateGroup") ) {
                final Object value = values.remove("CustomerSupplierCorporateGroup");
                if( (value == null) || (!value.equals(getCustomerSupplierCorporateGroup())) ) {
                    setCustomerSupplierCorporateGroup(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> GLAccountLineItemField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new GLAccountLineItemField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> GLAccountLineItemField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new GLAccountLineItemField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.GeneralLedgerAccountLineItemService.DEFAULT_SERVICE_PATH);
    }

}
