/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchFluentHelperBasic;

/**
 * Default implementation of the {@link GeneralLedgerAccountLineItemServiceBatch} interface exposed in the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.GeneralLedgerAccountLineItemService
 * GeneralLedgerAccountLineItemService}, allowing you to create multiple changesets and finally execute the batch
 * request.
 *
 */
public class DefaultGeneralLedgerAccountLineItemServiceBatch
    extends
    BatchFluentHelperBasic<GeneralLedgerAccountLineItemServiceBatch, GeneralLedgerAccountLineItemServiceBatchChangeSet>
    implements
    GeneralLedgerAccountLineItemServiceBatch
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.GeneralLedgerAccountLineItemService service;
    @Nonnull
    private final String servicePath;

    /**
     * Creates a new instance of this DefaultGeneralLedgerAccountLineItemServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultGeneralLedgerAccountLineItemServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.GeneralLedgerAccountLineItemService service )
    {
        this(
            service,
            com.sap.cloud.sdk.s4hana.datamodel.odata.services.GeneralLedgerAccountLineItemService.DEFAULT_SERVICE_PATH);
    }

    /**
     * Creates a new instance of this DefaultGeneralLedgerAccountLineItemServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     * @param servicePath
     *            The custom service path to operate on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultGeneralLedgerAccountLineItemServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.GeneralLedgerAccountLineItemService service,
        @Nonnull final String servicePath )
    {
        this.service = service;
        this.servicePath = servicePath;
    }

    @Nonnull
    @Override
    protected String getServicePathForBatchRequest()
    {
        return servicePath;
    }

    @Nonnull
    @Override
    protected DefaultGeneralLedgerAccountLineItemServiceBatch getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public GeneralLedgerAccountLineItemServiceBatchChangeSet beginChangeSet()
    {
        return new DefaultGeneralLedgerAccountLineItemServiceBatchChangeSet(this, service);
    }

}
