/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchChangeSetFluentHelperBasic;

/**
 * Implementation of the {@link GeneralLedgerAccountLineItemServiceBatchChangeSet} interface, enabling you to combine
 * multiple operations into one changeset. For further information have a look into the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.GeneralLedgerAccountLineItemService
 * GeneralLedgerAccountLineItemService}.
 *
 */
public class DefaultGeneralLedgerAccountLineItemServiceBatchChangeSet
    extends
    BatchChangeSetFluentHelperBasic<GeneralLedgerAccountLineItemServiceBatch, GeneralLedgerAccountLineItemServiceBatchChangeSet>
    implements
    GeneralLedgerAccountLineItemServiceBatchChangeSet
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.GeneralLedgerAccountLineItemService service;

    @SuppressWarnings( "deprecation" )
    DefaultGeneralLedgerAccountLineItemServiceBatchChangeSet(
        @Nonnull final DefaultGeneralLedgerAccountLineItemServiceBatch batchFluentHelper,
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.GeneralLedgerAccountLineItemService service )
    {
        super(batchFluentHelper, batchFluentHelper);
        this.service = service;
    }

    @Nonnull
    @Override
    protected DefaultGeneralLedgerAccountLineItemServiceBatchChangeSet getThis()
    {
        return this;
    }

}
