/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem
 * GLAccountLineItem}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.field.GLAccountLineItemField
 * GLAccountLineItemField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.link.GLAccountLineItemLink
 * GLAccountLineItemLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#ID
 * ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#SOURCE_LEDGER
 * SOURCE_LEDGER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#COMPANY_CODE
 * COMPANY_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#FISCAL_YEAR
 * FISCAL_YEAR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#ACCOUNTING_DOCUMENT
 * ACCOUNTING_DOCUMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#LEDGER_GL_LINE_ITEM
 * LEDGER_GL_LINE_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#LEDGER
 * LEDGER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#LEDGER_FISCAL_YEAR
 * LEDGER_FISCAL_YEAR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#GL_RECORD_TYPE
 * GL_RECORD_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#CONTROLLING_AREA
 * CONTROLLING_AREA}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#CHART_OF_ACCOUNTS
 * CHART_OF_ACCOUNTS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#GL_ACCOUNT
 * GL_ACCOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#FINANCIAL_TRANSACTION_TYPE
 * FINANCIAL_TRANSACTION_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#BUSINESS_TRANSACTION_TYPE
 * BUSINESS_TRANSACTION_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#CONTROLLING_BUS_TRANSAC_TYPE
 * CONTROLLING_BUS_TRANSAC_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#REFERENCE_DOCUMENT_TYPE
 * REFERENCE_DOCUMENT_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#LOGICAL_SYSTEM
 * LOGICAL_SYSTEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#REFERENCE_DOCUMENT_CONTEXT
 * REFERENCE_DOCUMENT_CONTEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#REFERENCE_DOCUMENT
 * REFERENCE_DOCUMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#REFERENCE_DOCUMENT_ITEM
 * REFERENCE_DOCUMENT_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#REFERENCE_DOCUMENT_ITEM_GROUP
 * REFERENCE_DOCUMENT_ITEM_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#TRANSACTION_SUBITEM
 * TRANSACTION_SUBITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#IS_REVERSAL
 * IS_REVERSAL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#IS_REVERSED
 * IS_REVERSED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#REVERSAL_REFERENCE_DOCUMENT_CNTXT
 * REVERSAL_REFERENCE_DOCUMENT_CNTXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#REVERSAL_REFERENCE_DOCUMENT
 * REVERSAL_REFERENCE_DOCUMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#IS_SETTLEMENT
 * IS_SETTLEMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#IS_SETTLED
 * IS_SETTLED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#PREDECESSOR_REFERENCE_DOC_TYPE
 * PREDECESSOR_REFERENCE_DOC_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#PREDECESSOR_REFERENCE_DOC_CNTXT
 * PREDECESSOR_REFERENCE_DOC_CNTXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#PREDECESSOR_REFERENCE_DOCUMENT
 * PREDECESSOR_REFERENCE_DOCUMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#PREDECESSOR_REFERENCE_DOC_ITEM
 * PREDECESSOR_REFERENCE_DOC_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#PRDCSSR_JOURNAL_ENTRY_COMPANY_CODE
 * PRDCSSR_JOURNAL_ENTRY_COMPANY_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#PRDCSSR_JOURNAL_ENTRY_FISCAL_YEAR
 * PRDCSSR_JOURNAL_ENTRY_FISCAL_YEAR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#PREDECESSOR_JOURNAL_ENTRY
 * PREDECESSOR_JOURNAL_ENTRY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#PREDECESSOR_JOURNAL_ENTRY_ITEM
 * PREDECESSOR_JOURNAL_ENTRY_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#SOURCE_REFERENCE_DOCUMENT_TYPE
 * SOURCE_REFERENCE_DOCUMENT_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#SOURCE_LOGICAL_SYSTEM
 * SOURCE_LOGICAL_SYSTEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#SOURCE_REFERENCE_DOCUMENT_CNTXT
 * SOURCE_REFERENCE_DOCUMENT_CNTXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#SOURCE_REFERENCE_DOCUMENT
 * SOURCE_REFERENCE_DOCUMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#SOURCE_REFERENCE_DOCUMENT_ITEM
 * SOURCE_REFERENCE_DOCUMENT_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#SOURCE_REFERENCE_DOC_SUBITEM
 * SOURCE_REFERENCE_DOC_SUBITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#IS_COMMITMENT
 * IS_COMMITMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#JRNL_ENTRY_ITEM_OBSOLETE_REASON
 * JRNL_ENTRY_ITEM_OBSOLETE_REASON}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#JRNL_PERIOD_END_CLOSING_RUN_LOG_UUID
 * JRNL_PERIOD_END_CLOSING_RUN_LOG_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#COST_CENTER
 * COST_CENTER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#PROFIT_CENTER
 * PROFIT_CENTER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#FUNCTIONAL_AREA
 * FUNCTIONAL_AREA}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#BUSINESS_AREA
 * BUSINESS_AREA}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#SEGMENT
 * SEGMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#PARTNER_COST_CENTER
 * PARTNER_COST_CENTER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#PARTNER_PROFIT_CENTER
 * PARTNER_PROFIT_CENTER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#PARTNER_FUNCTIONAL_AREA
 * PARTNER_FUNCTIONAL_AREA}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#PARTNER_BUSINESS_AREA
 * PARTNER_BUSINESS_AREA}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#PARTNER_COMPANY
 * PARTNER_COMPANY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#PARTNER_SEGMENT
 * PARTNER_SEGMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#BALANCE_TRANSACTION_CURRENCY
 * BALANCE_TRANSACTION_CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#AMOUNT_IN_BALANCE_TRANSAC_CRCY
 * AMOUNT_IN_BALANCE_TRANSAC_CRCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#TRANSACTION_CURRENCY
 * TRANSACTION_CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#AMOUNT_IN_TRANSACTION_CURRENCY
 * AMOUNT_IN_TRANSACTION_CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#COMPANY_CODE_CURRENCY
 * COMPANY_CODE_CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#AMOUNT_IN_COMPANY_CODE_CURRENCY
 * AMOUNT_IN_COMPANY_CODE_CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#GLOBAL_CURRENCY
 * GLOBAL_CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#AMOUNT_IN_GLOBAL_CURRENCY
 * AMOUNT_IN_GLOBAL_CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#FREE_DEFINED_CURRENCY1
 * FREE_DEFINED_CURRENCY1}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#AMOUNT_IN_FREE_DEFINED_CURRENCY1
 * AMOUNT_IN_FREE_DEFINED_CURRENCY1}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#FREE_DEFINED_CURRENCY2
 * FREE_DEFINED_CURRENCY2}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#AMOUNT_IN_FREE_DEFINED_CURRENCY2
 * AMOUNT_IN_FREE_DEFINED_CURRENCY2}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#FREE_DEFINED_CURRENCY3
 * FREE_DEFINED_CURRENCY3}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#AMOUNT_IN_FREE_DEFINED_CURRENCY3
 * AMOUNT_IN_FREE_DEFINED_CURRENCY3}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#FREE_DEFINED_CURRENCY4
 * FREE_DEFINED_CURRENCY4}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#AMOUNT_IN_FREE_DEFINED_CURRENCY4
 * AMOUNT_IN_FREE_DEFINED_CURRENCY4}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#FREE_DEFINED_CURRENCY5
 * FREE_DEFINED_CURRENCY5}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#AMOUNT_IN_FREE_DEFINED_CURRENCY5
 * AMOUNT_IN_FREE_DEFINED_CURRENCY5}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#FREE_DEFINED_CURRENCY6
 * FREE_DEFINED_CURRENCY6}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#AMOUNT_IN_FREE_DEFINED_CURRENCY6
 * AMOUNT_IN_FREE_DEFINED_CURRENCY6}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#FREE_DEFINED_CURRENCY7
 * FREE_DEFINED_CURRENCY7}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#AMOUNT_IN_FREE_DEFINED_CURRENCY7
 * AMOUNT_IN_FREE_DEFINED_CURRENCY7}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#FREE_DEFINED_CURRENCY8
 * FREE_DEFINED_CURRENCY8}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#AMOUNT_IN_FREE_DEFINED_CURRENCY8
 * AMOUNT_IN_FREE_DEFINED_CURRENCY8}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#FIXED_AMOUNT_IN_GLOBAL_CRCY
 * FIXED_AMOUNT_IN_GLOBAL_CRCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#GRP_VALN_FIXED_AMT_IN_GLOB_CRCY
 * GRP_VALN_FIXED_AMT_IN_GLOB_CRCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#PRFT_CTR_VALN_FXD_AMT_IN_GLOB_CRCY
 * PRFT_CTR_VALN_FXD_AMT_IN_GLOB_CRCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#TOTAL_PRICE_VARC_IN_GLOBAL_CRCY
 * TOTAL_PRICE_VARC_IN_GLOBAL_CRCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#GRP_VALN_TOT_PRC_VARC_IN_GLOB_CRCY
 * GRP_VALN_TOT_PRC_VARC_IN_GLOB_CRCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#PRFT_CTR_VALN_TOT_PRC_VARC_IN_GLB_CRCY
 * PRFT_CTR_VALN_TOT_PRC_VARC_IN_GLB_CRCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#FIXED_PRICE_VARC_IN_GLOBAL_CRCY
 * FIXED_PRICE_VARC_IN_GLOBAL_CRCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#GRP_VALN_FIXED_PRC_VARC_IN_GLOB_CRCY
 * GRP_VALN_FIXED_PRC_VARC_IN_GLOB_CRCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#PRFT_CTR_VALN_FXD_PRC_VARC_IN_GLB_CRCY
 * PRFT_CTR_VALN_FXD_PRC_VARC_IN_GLB_CRCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#FIXED_AMOUNT_IN_CO_CODE_CRCY
 * FIXED_AMOUNT_IN_CO_CODE_CRCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#CONTROLLING_OBJECT_CURRENCY
 * CONTROLLING_OBJECT_CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#AMOUNT_IN_OBJECT_CURRENCY
 * AMOUNT_IN_OBJECT_CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#BASE_UNIT
 * BASE_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#QUANTITY
 * QUANTITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#FIXED_QUANTITY
 * FIXED_QUANTITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#COST_SOURCE_UNIT
 * COST_SOURCE_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#VALUATION_QUANTITY
 * VALUATION_QUANTITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#VALUATION_FIXED_QUANTITY
 * VALUATION_FIXED_QUANTITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#ADDITIONAL_QUANTITY1_UNIT
 * ADDITIONAL_QUANTITY1_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#ADDITIONAL_QUANTITY1
 * ADDITIONAL_QUANTITY1}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#ADDITIONAL_QUANTITY2_UNIT
 * ADDITIONAL_QUANTITY2_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#ADDITIONAL_QUANTITY2
 * ADDITIONAL_QUANTITY2}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#ADDITIONAL_QUANTITY3_UNIT
 * ADDITIONAL_QUANTITY3_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#ADDITIONAL_QUANTITY3
 * ADDITIONAL_QUANTITY3}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#DEBIT_CREDIT_CODE
 * DEBIT_CREDIT_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#FISCAL_PERIOD
 * FISCAL_PERIOD}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#FISCAL_YEAR_VARIANT
 * FISCAL_YEAR_VARIANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#FISCAL_YEAR_PERIOD
 * FISCAL_YEAR_PERIOD}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#POSTING_DATE
 * POSTING_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#DOCUMENT_DATE
 * DOCUMENT_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#ACCOUNTING_DOCUMENT_TYPE
 * ACCOUNTING_DOCUMENT_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#ACCOUNTING_DOCUMENT_ITEM
 * ACCOUNTING_DOCUMENT_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#ASSIGNMENT_REFERENCE
 * ASSIGNMENT_REFERENCE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#ACCOUNTING_DOCUMENT_CATEGORY
 * ACCOUNTING_DOCUMENT_CATEGORY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#POSTING_KEY
 * POSTING_KEY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#TRANSACTION_TYPE_DETERMINATION
 * TRANSACTION_TYPE_DETERMINATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#SUB_LEDGER_ACCT_LINE_ITEM_TYPE
 * SUB_LEDGER_ACCT_LINE_ITEM_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#ACCOUNTING_DOC_CREATED_BY_USER
 * ACCOUNTING_DOC_CREATED_BY_USER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#LAST_CHANGE_DATE_TIME
 * LAST_CHANGE_DATE_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#CREATION_DATE_TIME
 * CREATION_DATE_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#CREATION_DATE
 * CREATION_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#ELIMINATION_PROFIT_CENTER
 * ELIMINATION_PROFIT_CENTER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#ORIGIN_OBJECT_TYPE
 * ORIGIN_OBJECT_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#GL_ACCOUNT_TYPE
 * GL_ACCOUNT_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#ALTERNATIVE_GL_ACCOUNT
 * ALTERNATIVE_GL_ACCOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#COUNTRY_CHART_OF_ACCOUNTS
 * COUNTRY_CHART_OF_ACCOUNTS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#ITEM_IS_SPLIT
 * ITEM_IS_SPLIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#INVOICE_REFERENCE
 * INVOICE_REFERENCE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#INVOICE_REFERENCE_FISCAL_YEAR
 * INVOICE_REFERENCE_FISCAL_YEAR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#FOLLOW_ON_DOCUMENT_TYPE
 * FOLLOW_ON_DOCUMENT_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#INVOICE_ITEM_REFERENCE
 * INVOICE_ITEM_REFERENCE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#REFERENCE_PURCHASE_ORDER_CATEGORY
 * REFERENCE_PURCHASE_ORDER_CATEGORY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#PURCHASING_DOCUMENT
 * PURCHASING_DOCUMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#PURCHASING_DOCUMENT_ITEM
 * PURCHASING_DOCUMENT_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#ACCOUNT_ASSIGNMENT_NUMBER
 * ACCOUNT_ASSIGNMENT_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#DOCUMENT_ITEM_TEXT
 * DOCUMENT_ITEM_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#SALES_DOCUMENT
 * SALES_DOCUMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#SALES_DOCUMENT_ITEM
 * SALES_DOCUMENT_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#PRODUCT
 * PRODUCT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#PLANT
 * PLANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#SUPPLIER
 * SUPPLIER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#CUSTOMER
 * CUSTOMER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#SERVICES_RENDERED_DATE
 * SERVICES_RENDERED_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#CONDITION_CONTRACT
 * CONDITION_CONTRACT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#FINANCIAL_ACCOUNT_TYPE
 * FINANCIAL_ACCOUNT_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#SPECIAL_GL_CODE
 * SPECIAL_GL_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#TAX_CODE
 * TAX_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#HOUSE_BANK
 * HOUSE_BANK}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#HOUSE_BANK_ACCOUNT
 * HOUSE_BANK_ACCOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#IS_OPEN_ITEM_MANAGED
 * IS_OPEN_ITEM_MANAGED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#CLEARING_DATE
 * CLEARING_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#CLEARING_ACCOUNTING_DOCUMENT
 * CLEARING_ACCOUNTING_DOCUMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#CLEARING_DOC_FISCAL_YEAR
 * CLEARING_DOC_FISCAL_YEAR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#VALUE_DATE
 * VALUE_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#ASSET_DEPRECIATION_AREA
 * ASSET_DEPRECIATION_AREA}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#MASTER_FIXED_ASSET
 * MASTER_FIXED_ASSET}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#FIXED_ASSET
 * FIXED_ASSET}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#ASSET_VALUE_DATE
 * ASSET_VALUE_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#ASSET_TRANSACTION_TYPE
 * ASSET_TRANSACTION_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#ASSET_ACCT_TRANS_CLASSFCTN
 * ASSET_ACCT_TRANS_CLASSFCTN}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#DEPRECIATION_FISCAL_PERIOD
 * DEPRECIATION_FISCAL_PERIOD}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#GROUP_MASTER_FIXED_ASSET
 * GROUP_MASTER_FIXED_ASSET}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#GROUP_FIXED_ASSET
 * GROUP_FIXED_ASSET}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#ASSET_CLASS
 * ASSET_CLASS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#COST_ESTIMATE
 * COST_ESTIMATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#INVENTORY_SPECIAL_STOCK_VALN_TYPE
 * INVENTORY_SPECIAL_STOCK_VALN_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#INVENTORY_SPECIAL_STOCK_TYPE
 * INVENTORY_SPECIAL_STOCK_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#INVENTORY_SPCL_STK_SALES_DOCUMENT
 * INVENTORY_SPCL_STK_SALES_DOCUMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#INVENTORY_SPCL_STK_SALES_DOC_ITM
 * INVENTORY_SPCL_STK_SALES_DOC_ITM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#INVTRY_SPCL_STOCK_WBS_ELMNT_INT_ID
 * INVTRY_SPCL_STOCK_WBS_ELMNT_INT_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#INVENTORY_SPECIAL_STOCK_SUPPLIER
 * INVENTORY_SPECIAL_STOCK_SUPPLIER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#INVENTORY_VALUATION_TYPE
 * INVENTORY_VALUATION_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#VALUATION_AREA
 * VALUATION_AREA}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#COST_ORIGIN_GROUP
 * COST_ORIGIN_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#ORIGIN_SENDER_OBJECT
 * ORIGIN_SENDER_OBJECT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#CONTROLLING_OBJECT_DEBIT_TYPE
 * CONTROLLING_OBJECT_DEBIT_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#QUANTITY_IS_INCOMPLETE
 * QUANTITY_IS_INCOMPLETE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#OFFSETTING_ACCOUNT
 * OFFSETTING_ACCOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#OFFSETTING_ACCOUNT_TYPE
 * OFFSETTING_ACCOUNT_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#OFFSETTING_CHART_OF_ACCOUNTS
 * OFFSETTING_CHART_OF_ACCOUNTS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#LINE_ITEM_IS_COMPLETED
 * LINE_ITEM_IS_COMPLETED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#PERSONNEL_NUMBER
 * PERSONNEL_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#CONTROLLING_OBJECT_CLASS
 * CONTROLLING_OBJECT_CLASS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#PARTNER_COMPANY_CODE
 * PARTNER_COMPANY_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#PARTNER_CONTROLLING_OBJECT_CLASS
 * PARTNER_CONTROLLING_OBJECT_CLASS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#ORIGIN_COST_CENTER
 * ORIGIN_COST_CENTER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#ORIGIN_PROFIT_CENTER
 * ORIGIN_PROFIT_CENTER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#ORIGIN_COST_CTR_ACTIVITY_TYPE
 * ORIGIN_COST_CTR_ACTIVITY_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#ACCOUNT_ASSIGNMENT
 * ACCOUNT_ASSIGNMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#ACCOUNT_ASSIGNMENT_TYPE
 * ACCOUNT_ASSIGNMENT_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#COST_CTR_ACTIVITY_TYPE
 * COST_CTR_ACTIVITY_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#ORDER_ID
 * ORDER_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#ORDER_CATEGORY
 * ORDER_CATEGORY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#WBS_ELEMENT_INTERNAL_ID
 * WBS_ELEMENT_INTERNAL_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#PARTNER_WBS_ELEMENT_INTERNAL_ID
 * PARTNER_WBS_ELEMENT_INTERNAL_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#PROJECT_INTERNAL_ID
 * PROJECT_INTERNAL_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#PARTNER_PROJECT_INTERNAL_ID
 * PARTNER_PROJECT_INTERNAL_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#OPERATING_CONCERN
 * OPERATING_CONCERN}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#PROJECT_NETWORK
 * PROJECT_NETWORK}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#BUSINESS_PROCESS
 * BUSINESS_PROCESS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#COST_OBJECT
 * COST_OBJECT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#BILLABLE_CONTROL
 * BILLABLE_CONTROL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#COST_ANALYSIS_RESOURCE
 * COST_ANALYSIS_RESOURCE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#CUSTOMER_SERVICE_NOTIFICATION
 * CUSTOMER_SERVICE_NOTIFICATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#SERVICE_DOCUMENT_TYPE
 * SERVICE_DOCUMENT_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#SERVICE_DOCUMENT
 * SERVICE_DOCUMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#SERVICE_DOCUMENT_ITEM
 * SERVICE_DOCUMENT_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#PARTNER_SERVICE_DOCUMENT_TYPE
 * PARTNER_SERVICE_DOCUMENT_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#PARTNER_SERVICE_DOCUMENT
 * PARTNER_SERVICE_DOCUMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#PARTNER_SERVICE_DOCUMENT_ITEM
 * PARTNER_SERVICE_DOCUMENT_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#SERVICE_CONTRACT_TYPE
 * SERVICE_CONTRACT_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#SERVICE_CONTRACT
 * SERVICE_CONTRACT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#SERVICE_CONTRACT_ITEM
 * SERVICE_CONTRACT_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#TIME_SHEET_OVERTIME_CATEGORY
 * TIME_SHEET_OVERTIME_CATEGORY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#PARTNER_ACCOUNT_ASSIGNMENT
 * PARTNER_ACCOUNT_ASSIGNMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#PARTNER_ACCOUNT_ASSIGNMENT_TYPE
 * PARTNER_ACCOUNT_ASSIGNMENT_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#PARTNER_COST_CTR_ACTIVITY_TYPE
 * PARTNER_COST_CTR_ACTIVITY_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#PARTNER_ORDER
 * PARTNER_ORDER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#PARTNER_ORDER_CATEGORY
 * PARTNER_ORDER_CATEGORY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#PARTNER_SALES_DOCUMENT
 * PARTNER_SALES_DOCUMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#PARTNER_SALES_DOCUMENT_ITEM
 * PARTNER_SALES_DOCUMENT_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#PARTNER_PROJECT_NETWORK
 * PARTNER_PROJECT_NETWORK}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#PARTNER_BUSINESS_PROCESS
 * PARTNER_BUSINESS_PROCESS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#PARTNER_COST_OBJECT
 * PARTNER_COST_OBJECT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#CONTROLLING_DOCUMENT_ITEM
 * CONTROLLING_DOCUMENT_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#BILLING_DOCUMENT_TYPE
 * BILLING_DOCUMENT_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#SALES_ORGANIZATION
 * SALES_ORGANIZATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#DISTRIBUTION_CHANNEL
 * DISTRIBUTION_CHANNEL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#ORGANIZATION_DIVISION
 * ORGANIZATION_DIVISION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#SOLD_PRODUCT
 * SOLD_PRODUCT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#SOLD_PRODUCT_GROUP
 * SOLD_PRODUCT_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#CUSTOMER_GROUP
 * CUSTOMER_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#CUSTOMER_SUPPLIER_COUNTRY
 * CUSTOMER_SUPPLIER_COUNTRY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#CUSTOMER_SUPPLIER_INDUSTRY
 * CUSTOMER_SUPPLIER_INDUSTRY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#SALES_DISTRICT
 * SALES_DISTRICT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#BILL_TO_PARTY
 * BILL_TO_PARTY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#SHIP_TO_PARTY
 * SHIP_TO_PARTY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.generalledgeraccountlineitem.GLAccountLineItem#CUSTOMER_SUPPLIER_CORPORATE_GROUP
 * CUSTOMER_SUPPLIER_CORPORATE_GROUP}</li>
 * </ul>
 *
 */
public interface GLAccountLineItemSelectable extends EntitySelectable<GLAccountLineItem>
{

}
