/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.goldentaxinterfacecustomertype.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchChangeSetFluentHelperBasic;

/**
 * Implementation of the {@link GoldenTaxInterfaceCustomerTypeServiceBatchChangeSet} interface, enabling you to combine
 * multiple operations into one changeset. For further information have a look into the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.GoldenTaxInterfaceCustomerTypeService
 * GoldenTaxInterfaceCustomerTypeService}.
 *
 */
public class DefaultGoldenTaxInterfaceCustomerTypeServiceBatchChangeSet
    extends
    BatchChangeSetFluentHelperBasic<GoldenTaxInterfaceCustomerTypeServiceBatch, GoldenTaxInterfaceCustomerTypeServiceBatchChangeSet>
    implements
    GoldenTaxInterfaceCustomerTypeServiceBatchChangeSet
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.GoldenTaxInterfaceCustomerTypeService service;

    @SuppressWarnings( "deprecation" )
    DefaultGoldenTaxInterfaceCustomerTypeServiceBatchChangeSet(
        @Nonnull final DefaultGoldenTaxInterfaceCustomerTypeServiceBatch batchFluentHelper,
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.GoldenTaxInterfaceCustomerTypeService service )
    {
        super(batchFluentHelper, batchFluentHelper);
        this.service = service;
    }

    @Nonnull
    @Override
    protected DefaultGoldenTaxInterfaceCustomerTypeServiceBatchChangeSet getThis()
    {
        return this;
    }

}
