/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.goldentaxinterfacecustomertype.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.goldentaxinterfacecustomertype.GTICustomer;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.goldentaxinterfacecustomertype.GTICustomer GTICustomer}.
 * This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.goldentaxinterfacecustomertype.field.GTICustomerField
 * GTICustomerField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.goldentaxinterfacecustomertype.link.GTICustomerLink
 * GTICustomerLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.goldentaxinterfacecustomertype.GTICustomer#CUSTOMER
 * CUSTOMER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.goldentaxinterfacecustomertype.GTICustomer#CUSTOMER_TYPE
 * CUSTOMER_TYPE}</li>
 * </ul>
 *
 */
public interface GTICustomerSelectable extends EntitySelectable<GTICustomer>
{

}
