/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant;

import java.time.LocalDateTime;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.field.GrantBdgtValidityLinkField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.link.GrantBdgtValidityLinkOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.selectable.GrantBdgtValidityLinkSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Budget Validity of Grant
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>GrantBdgtValidityLink_Type</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class GrantBdgtValidityLink extends VdmEntity<GrantBdgtValidityLink>
{

    /**
     * Selector for all available fields of GrantBdgtValidityLink.
     *
     */
    public final static GrantBdgtValidityLinkSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>GrantID</b>
     * </p>
     *
     * @return Grant
     */
    @Key
    @SerializedName( "GrantID" )
    @JsonProperty( "GrantID" )
    @Nullable
    @ODataField( odataName = "GrantID" )
    private String grantID;
    /**
     * Use with available fluent helpers to apply the <b>GrantID</b> field to query operations.
     *
     */
    public final static GrantBdgtValidityLinkField<String> GRANT_ID = new GrantBdgtValidityLinkField<String>("GrantID");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>GranteeMgmtBdgtPhase</b>
     * </p>
     *
     * @return Budget Phase
     */
    @Key
    @SerializedName( "GranteeMgmtBdgtPhase" )
    @JsonProperty( "GranteeMgmtBdgtPhase" )
    @Nullable
    @ODataField( odataName = "GranteeMgmtBdgtPhase" )
    private String granteeMgmtBdgtPhase;
    /**
     * Use with available fluent helpers to apply the <b>GranteeMgmtBdgtPhase</b> field to query operations.
     *
     */
    public final static GrantBdgtValidityLinkField<String> GRANTEE_MGMT_BDGT_PHASE =
        new GrantBdgtValidityLinkField<String>("GranteeMgmtBdgtPhase");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>GranteeMgmtBudgetStatus</b>
     * </p>
     *
     * @return Budget Status: Unreleased/Released
     */
    @Key
    @SerializedName( "GranteeMgmtBudgetStatus" )
    @JsonProperty( "GranteeMgmtBudgetStatus" )
    @Nullable
    @ODataField( odataName = "GranteeMgmtBudgetStatus" )
    private String granteeMgmtBudgetStatus;
    /**
     * Use with available fluent helpers to apply the <b>GranteeMgmtBudgetStatus</b> field to query operations.
     *
     */
    public final static GrantBdgtValidityLinkField<String> GRANTEE_MGMT_BUDGET_STATUS =
        new GrantBdgtValidityLinkField<String>("GranteeMgmtBudgetStatus");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>GteeMBudgetValidityNumber</b>
     * </p>
     *
     * @return Budget Validity Number
     */
    @Key
    @SerializedName( "GteeMBudgetValidityNumber" )
    @JsonProperty( "GteeMBudgetValidityNumber" )
    @Nullable
    @ODataField( odataName = "GteeMBudgetValidityNumber" )
    private String gteeMBudgetValidityNumber;
    /**
     * Use with available fluent helpers to apply the <b>GteeMBudgetValidityNumber</b> field to query operations.
     *
     */
    public final static GrantBdgtValidityLinkField<String> GTEE_M_BUDGET_VALIDITY_NUMBER =
        new GrantBdgtValidityLinkField<String>("GteeMBudgetValidityNumber");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityStartDate</b>
     * </p>
     *
     * @return Valid-from Date
     */
    @SerializedName( "ValidityStartDate" )
    @JsonProperty( "ValidityStartDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ValidityStartDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime validityStartDate;
    /**
     * Use with available fluent helpers to apply the <b>ValidityStartDate</b> field to query operations.
     *
     */
    public final static GrantBdgtValidityLinkField<LocalDateTime> VALIDITY_START_DATE =
        new GrantBdgtValidityLinkField<LocalDateTime>("ValidityStartDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityEndDate</b>
     * </p>
     *
     * @return Valid-to Date
     */
    @SerializedName( "ValidityEndDate" )
    @JsonProperty( "ValidityEndDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ValidityEndDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime validityEndDate;
    /**
     * Use with available fluent helpers to apply the <b>ValidityEndDate</b> field to query operations.
     *
     */
    public final static GrantBdgtValidityLinkField<LocalDateTime> VALIDITY_END_DATE =
        new GrantBdgtValidityLinkField<LocalDateTime>("ValidityEndDate");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SponsorFiscalYear</b>
     * </p>
     *
     * @return Fiscal Year for Sponsor
     */
    @SerializedName( "SponsorFiscalYear" )
    @JsonProperty( "SponsorFiscalYear" )
    @Nullable
    @ODataField( odataName = "SponsorFiscalYear" )
    private String sponsorFiscalYear;
    /**
     * Use with available fluent helpers to apply the <b>SponsorFiscalYear</b> field to query operations.
     *
     */
    public final static GrantBdgtValidityLinkField<String> SPONSOR_FISCAL_YEAR =
        new GrantBdgtValidityLinkField<String>("SponsorFiscalYear");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>GranteeFiscalYear</b>
     * </p>
     *
     * @return Fiscal Year for Grantee Organization
     */
    @SerializedName( "GranteeFiscalYear" )
    @JsonProperty( "GranteeFiscalYear" )
    @Nullable
    @ODataField( odataName = "GranteeFiscalYear" )
    private String granteeFiscalYear;
    /**
     * Use with available fluent helpers to apply the <b>GranteeFiscalYear</b> field to query operations.
     *
     */
    public final static GrantBdgtValidityLinkField<String> GRANTEE_FISCAL_YEAR =
        new GrantBdgtValidityLinkField<String>("GranteeFiscalYear");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>GteeMBudgetBlock</b>
     * </p>
     *
     * @return Block a Budget Validity Period
     */
    @SerializedName( "GteeMBudgetBlock" )
    @JsonProperty( "GteeMBudgetBlock" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "GteeMBudgetBlock" )
    private Boolean gteeMBudgetBlock;
    /**
     * Use with available fluent helpers to apply the <b>GteeMBudgetBlock</b> field to query operations.
     *
     */
    public final static GrantBdgtValidityLinkField<Boolean> GTEE_M_BUDGET_BLOCK =
        new GrantBdgtValidityLinkField<Boolean>("GteeMBudgetBlock");
    /**
     * Navigation property <b>to_Grant</b> for <b>GrantBdgtValidityLink</b> to single <b>GrantCore</b>.
     *
     */
    @SerializedName( "to_Grant" )
    @JsonProperty( "to_Grant" )
    @ODataField( odataName = "to_Grant" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private GrantCore toGrant;
    /**
     * Use with available fluent helpers to apply the <b>to_Grant</b> navigation property to query operations.
     *
     */
    public final static GrantBdgtValidityLinkOneToOneLink<GrantCore> TO_GRANT =
        new GrantBdgtValidityLinkOneToOneLink<GrantCore>("to_Grant");

    @Nonnull
    @Override
    public Class<GrantBdgtValidityLink> getType()
    {
        return GrantBdgtValidityLink.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>GrantID</b>
     * </p>
     *
     * @param grantID
     *            Grant
     */
    public void setGrantID( @Nullable final String grantID )
    {
        rememberChangedField("GrantID", this.grantID);
        this.grantID = grantID;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>GranteeMgmtBdgtPhase</b>
     * </p>
     *
     * @param granteeMgmtBdgtPhase
     *            Budget Phase
     */
    public void setGranteeMgmtBdgtPhase( @Nullable final String granteeMgmtBdgtPhase )
    {
        rememberChangedField("GranteeMgmtBdgtPhase", this.granteeMgmtBdgtPhase);
        this.granteeMgmtBdgtPhase = granteeMgmtBdgtPhase;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>GranteeMgmtBudgetStatus</b>
     * </p>
     *
     * @param granteeMgmtBudgetStatus
     *            Budget Status: Unreleased/Released
     */
    public void setGranteeMgmtBudgetStatus( @Nullable final String granteeMgmtBudgetStatus )
    {
        rememberChangedField("GranteeMgmtBudgetStatus", this.granteeMgmtBudgetStatus);
        this.granteeMgmtBudgetStatus = granteeMgmtBudgetStatus;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>GteeMBudgetValidityNumber</b>
     * </p>
     *
     * @param gteeMBudgetValidityNumber
     *            Budget Validity Number
     */
    public void setGteeMBudgetValidityNumber( @Nullable final String gteeMBudgetValidityNumber )
    {
        rememberChangedField("GteeMBudgetValidityNumber", this.gteeMBudgetValidityNumber);
        this.gteeMBudgetValidityNumber = gteeMBudgetValidityNumber;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityStartDate</b>
     * </p>
     *
     * @param validityStartDate
     *            Valid-from Date
     */
    public void setValidityStartDate( @Nullable final LocalDateTime validityStartDate )
    {
        rememberChangedField("ValidityStartDate", this.validityStartDate);
        this.validityStartDate = validityStartDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityEndDate</b>
     * </p>
     *
     * @param validityEndDate
     *            Valid-to Date
     */
    public void setValidityEndDate( @Nullable final LocalDateTime validityEndDate )
    {
        rememberChangedField("ValidityEndDate", this.validityEndDate);
        this.validityEndDate = validityEndDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SponsorFiscalYear</b>
     * </p>
     *
     * @param sponsorFiscalYear
     *            Fiscal Year for Sponsor
     */
    public void setSponsorFiscalYear( @Nullable final String sponsorFiscalYear )
    {
        rememberChangedField("SponsorFiscalYear", this.sponsorFiscalYear);
        this.sponsorFiscalYear = sponsorFiscalYear;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>GranteeFiscalYear</b>
     * </p>
     *
     * @param granteeFiscalYear
     *            Fiscal Year for Grantee Organization
     */
    public void setGranteeFiscalYear( @Nullable final String granteeFiscalYear )
    {
        rememberChangedField("GranteeFiscalYear", this.granteeFiscalYear);
        this.granteeFiscalYear = granteeFiscalYear;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>GteeMBudgetBlock</b>
     * </p>
     *
     * @param gteeMBudgetBlock
     *            Block a Budget Validity Period
     */
    public void setGteeMBudgetBlock( @Nullable final Boolean gteeMBudgetBlock )
    {
        rememberChangedField("GteeMBudgetBlock", this.gteeMBudgetBlock);
        this.gteeMBudgetBlock = gteeMBudgetBlock;
    }

    @Override
    protected String getEntityCollection()
    {
        return "GrantBdgtValidityLink";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("GrantID", getGrantID());
        result.put("GranteeMgmtBdgtPhase", getGranteeMgmtBdgtPhase());
        result.put("GranteeMgmtBudgetStatus", getGranteeMgmtBudgetStatus());
        result.put("GteeMBudgetValidityNumber", getGteeMBudgetValidityNumber());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("GrantID", getGrantID());
        values.put("GranteeMgmtBdgtPhase", getGranteeMgmtBdgtPhase());
        values.put("GranteeMgmtBudgetStatus", getGranteeMgmtBudgetStatus());
        values.put("GteeMBudgetValidityNumber", getGteeMBudgetValidityNumber());
        values.put("ValidityStartDate", getValidityStartDate());
        values.put("ValidityEndDate", getValidityEndDate());
        values.put("SponsorFiscalYear", getSponsorFiscalYear());
        values.put("GranteeFiscalYear", getGranteeFiscalYear());
        values.put("GteeMBudgetBlock", getGteeMBudgetBlock());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("GrantID") ) {
                final Object value = values.remove("GrantID");
                if( (value == null) || (!value.equals(getGrantID())) ) {
                    setGrantID(((String) value));
                }
            }
            if( values.containsKey("GranteeMgmtBdgtPhase") ) {
                final Object value = values.remove("GranteeMgmtBdgtPhase");
                if( (value == null) || (!value.equals(getGranteeMgmtBdgtPhase())) ) {
                    setGranteeMgmtBdgtPhase(((String) value));
                }
            }
            if( values.containsKey("GranteeMgmtBudgetStatus") ) {
                final Object value = values.remove("GranteeMgmtBudgetStatus");
                if( (value == null) || (!value.equals(getGranteeMgmtBudgetStatus())) ) {
                    setGranteeMgmtBudgetStatus(((String) value));
                }
            }
            if( values.containsKey("GteeMBudgetValidityNumber") ) {
                final Object value = values.remove("GteeMBudgetValidityNumber");
                if( (value == null) || (!value.equals(getGteeMBudgetValidityNumber())) ) {
                    setGteeMBudgetValidityNumber(((String) value));
                }
            }
            if( values.containsKey("ValidityStartDate") ) {
                final Object value = values.remove("ValidityStartDate");
                if( (value == null) || (!value.equals(getValidityStartDate())) ) {
                    setValidityStartDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ValidityEndDate") ) {
                final Object value = values.remove("ValidityEndDate");
                if( (value == null) || (!value.equals(getValidityEndDate())) ) {
                    setValidityEndDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("SponsorFiscalYear") ) {
                final Object value = values.remove("SponsorFiscalYear");
                if( (value == null) || (!value.equals(getSponsorFiscalYear())) ) {
                    setSponsorFiscalYear(((String) value));
                }
            }
            if( values.containsKey("GranteeFiscalYear") ) {
                final Object value = values.remove("GranteeFiscalYear");
                if( (value == null) || (!value.equals(getGranteeFiscalYear())) ) {
                    setGranteeFiscalYear(((String) value));
                }
            }
            if( values.containsKey("GteeMBudgetBlock") ) {
                final Object value = values.remove("GteeMBudgetBlock");
                if( (value == null) || (!value.equals(getGteeMBudgetBlock())) ) {
                    setGteeMBudgetBlock(((Boolean) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_Grant") ) {
                final Object value = (values).remove("to_Grant");
                if( value instanceof Map ) {
                    if( toGrant == null ) {
                        toGrant = new GrantCore();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toGrant.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> GrantBdgtValidityLinkField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new GrantBdgtValidityLinkField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> GrantBdgtValidityLinkField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new GrantBdgtValidityLinkField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.GrantService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toGrant != null ) {
            (values).put("to_Grant", toGrant);
        }
        return values;
    }

    /**
     * Fetches the <b>GrantCore</b> entity (one to one) associated with this entity. This corresponds to the OData
     * navigation property <b>to_Grant</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>GrantCore</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public GrantCore fetchGrant()
    {
        return fetchFieldAsSingle("to_Grant", GrantCore.class);
    }

    /**
     * Retrieval of associated <b>GrantCore</b> entity (one to one). This corresponds to the OData navigation property
     * <b>to_Grant</b>.
     * <p>
     * If the navigation property <b>to_Grant</b> of a queried <b>GrantBdgtValidityLink</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>GrantCore</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public GrantCore getGrantOrFetch()
    {
        if( toGrant == null ) {
            toGrant = fetchGrant();
        }
        return toGrant;
    }

    /**
     * Retrieval of associated <b>GrantCore</b> entity (one to one). This corresponds to the OData navigation property
     * <b>to_Grant</b>.
     * <p>
     * If the navigation property for an entity <b>GrantBdgtValidityLink</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_Grant</b> is already loaded, the result will contain the
     *         <b>GrantCore</b> entity. If not, an <code>Option</code> with result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<GrantCore> getGrantIfPresent()
    {
        return Option.of(toGrant);
    }

    /**
     * Overwrites the associated <b>GrantCore</b> entity for the loaded navigation property <b>to_Grant</b>.
     *
     * @param value
     *            New <b>GrantCore</b> entity.
     */
    public void setGrant( final GrantCore value )
    {
        toGrant = value;
    }

    /**
     * Helper class to allow for fluent creation of GrantBdgtValidityLink instances.
     *
     */
    public final static class GrantBdgtValidityLinkBuilder
    {

        private GrantCore toGrant;

        private GrantBdgtValidityLink.GrantBdgtValidityLinkBuilder toGrant( final GrantCore value )
        {
            toGrant = value;
            return this;
        }

        /**
         * Navigation property <b>to_Grant</b> for <b>GrantBdgtValidityLink</b> to single <b>GrantCore</b>.
         *
         * @param value
         *            The GrantCore to build this GrantBdgtValidityLink with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public GrantBdgtValidityLink.GrantBdgtValidityLinkBuilder grant( final GrantCore value )
        {
            return toGrant(value);
        }

    }

}
