/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.selectable.GrantBdgtValidityLinkSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantBdgtValidityLink GrantBdgtValidityLink} entity
 * using key fields. This fluent helper allows methods which modify the underlying query to be called before executing
 * the query itself.
 *
 */
public class GrantBdgtValidityLinkByKeyFluentHelper
    extends
    FluentHelperByKey<GrantBdgtValidityLinkByKeyFluentHelper, GrantBdgtValidityLink, GrantBdgtValidityLinkSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantBdgtValidityLink GrantBdgtValidityLink}
     * entity with the provided key field values. To perform execution, call the {@link #executeRequest executeRequest}
     * method on the fluent helper object.
     *
     * @param granteeMgmtBudgetStatus
     *            Budget Status: Unreleased/Released
     *            <p>
     *            Constraints: Not nullable, Maximum length: 1
     *            </p>
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code GrantBdgtValidityLink}
     * @param grantID
     *            Grant
     *            <p>
     *            Constraints: Not nullable, Maximum length: 20
     *            </p>
     * @param granteeMgmtBdgtPhase
     *            Budget Phase
     *            <p>
     *            Constraints: Not nullable, Maximum length: 1
     *            </p>
     * @param servicePath
     *            Service path to be used to fetch a single {@code GrantBdgtValidityLink}
     * @param gteeMBudgetValidityNumber
     *            Budget Validity Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 3
     *            </p>
     */
    public GrantBdgtValidityLinkByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String grantID,
        final String granteeMgmtBdgtPhase,
        final String granteeMgmtBudgetStatus,
        final String gteeMBudgetValidityNumber )
    {
        super(servicePath, entityCollection);
        this.key.put("GrantID", grantID);
        this.key.put("GranteeMgmtBdgtPhase", granteeMgmtBdgtPhase);
        this.key.put("GranteeMgmtBudgetStatus", granteeMgmtBudgetStatus);
        this.key.put("GteeMBudgetValidityNumber", gteeMBudgetValidityNumber);
    }

    @Override
    @Nonnull
    protected Class<GrantBdgtValidityLink> getEntityClass()
    {
        return GrantBdgtValidityLink.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
