/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.field.GrantCoreField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.link.GrantCoreLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.selectable.GrantCoreSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Grant
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>GrantCore_Type</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class GrantCore extends VdmEntity<GrantCore>
{

    /**
     * Selector for all available fields of GrantCore.
     *
     */
    public final static GrantCoreSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>GrantID</b>
     * </p>
     *
     * @return Grant
     */
    @Key
    @SerializedName( "GrantID" )
    @JsonProperty( "GrantID" )
    @Nullable
    @ODataField( odataName = "GrantID" )
    private String grantID;
    /**
     * Use with available fluent helpers to apply the <b>GrantID</b> field to query operations.
     *
     */
    public final static GrantCoreField<String> GRANT_ID = new GrantCoreField<String>("GrantID");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCode</b>
     * </p>
     *
     * @return Company Code
     */
    @SerializedName( "CompanyCode" )
    @JsonProperty( "CompanyCode" )
    @Nullable
    @ODataField( odataName = "CompanyCode" )
    private String companyCode;
    /**
     * Use with available fluent helpers to apply the <b>CompanyCode</b> field to query operations.
     *
     */
    public final static GrantCoreField<String> COMPANY_CODE = new GrantCoreField<String>("CompanyCode");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>GrantAuthznGrp</b>
     * </p>
     *
     * @return Grants Management: Authorization Groups
     */
    @SerializedName( "GrantAuthznGrp" )
    @JsonProperty( "GrantAuthznGrp" )
    @Nullable
    @ODataField( odataName = "GrantAuthznGrp" )
    private String grantAuthznGrp;
    /**
     * Use with available fluent helpers to apply the <b>GrantAuthznGrp</b> field to query operations.
     *
     */
    public final static GrantCoreField<String> GRANT_AUTHZN_GRP = new GrantCoreField<String>("GrantAuthznGrp");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityStartDate</b>
     * </p>
     *
     * @return Valid-from Date
     */
    @SerializedName( "ValidityStartDate" )
    @JsonProperty( "ValidityStartDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ValidityStartDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime validityStartDate;
    /**
     * Use with available fluent helpers to apply the <b>ValidityStartDate</b> field to query operations.
     *
     */
    public final static GrantCoreField<LocalDateTime> VALIDITY_START_DATE =
        new GrantCoreField<LocalDateTime>("ValidityStartDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityEndDate</b>
     * </p>
     *
     * @return Valid-to Date
     */
    @SerializedName( "ValidityEndDate" )
    @JsonProperty( "ValidityEndDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ValidityEndDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime validityEndDate;
    /**
     * Use with available fluent helpers to apply the <b>ValidityEndDate</b> field to query operations.
     *
     */
    public final static GrantCoreField<LocalDateTime> VALIDITY_END_DATE =
        new GrantCoreField<LocalDateTime>("ValidityEndDate");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>GrantName</b>
     * </p>
     *
     * @return Short Description of the Grant
     */
    @SerializedName( "GrantName" )
    @JsonProperty( "GrantName" )
    @Nullable
    @ODataField( odataName = "GrantName" )
    private String grantName;
    /**
     * Use with available fluent helpers to apply the <b>GrantName</b> field to query operations.
     *
     */
    public final static GrantCoreField<String> GRANT_NAME = new GrantCoreField<String>("GrantName");
    /**
     * Constraints: Not nullable, Maximum length: 80
     * <p>
     * Original property name from the Odata EDM: <b>GrantDescription</b>
     * </p>
     *
     * @return Descriptive Text
     */
    @SerializedName( "GrantDescription" )
    @JsonProperty( "GrantDescription" )
    @Nullable
    @ODataField( odataName = "GrantDescription" )
    private String grantDescription;
    /**
     * Use with available fluent helpers to apply the <b>GrantDescription</b> field to query operations.
     *
     */
    public final static GrantCoreField<String> GRANT_DESCRIPTION = new GrantCoreField<String>("GrantDescription");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>GrantIsNotRelevantGrant</b>
     * </p>
     *
     * @return Identify the Not Relevant Grant
     */
    @SerializedName( "GrantIsNotRelevantGrant" )
    @JsonProperty( "GrantIsNotRelevantGrant" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "GrantIsNotRelevantGrant" )
    private Boolean grantIsNotRelevantGrant;
    /**
     * Use with available fluent helpers to apply the <b>GrantIsNotRelevantGrant</b> field to query operations.
     *
     */
    public final static GrantCoreField<Boolean> GRANT_IS_NOT_RELEVANT_GRANT =
        new GrantCoreField<Boolean>("GrantIsNotRelevantGrant");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>GranteeMgmtSponsor</b>
     * </p>
     *
     * @return Grant Sponsor
     */
    @SerializedName( "GranteeMgmtSponsor" )
    @JsonProperty( "GranteeMgmtSponsor" )
    @Nullable
    @ODataField( odataName = "GranteeMgmtSponsor" )
    private String granteeMgmtSponsor;
    /**
     * Use with available fluent helpers to apply the <b>GranteeMgmtSponsor</b> field to query operations.
     *
     */
    public final static GrantCoreField<String> GRANTEE_MGMT_SPONSOR = new GrantCoreField<String>("GranteeMgmtSponsor");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>GrantLfcycStatusForAuthzn</b>
     * </p>
     *
     * @return GM Lifecycle Status for Auth Grp
     */
    @SerializedName( "GrantLfcycStatusForAuthzn" )
    @JsonProperty( "GrantLfcycStatusForAuthzn" )
    @Nullable
    @ODataField( odataName = "GrantLfcycStatusForAuthzn" )
    private String grantLfcycStatusForAuthzn;
    /**
     * Use with available fluent helpers to apply the <b>GrantLfcycStatusForAuthzn</b> field to query operations.
     *
     */
    public final static GrantCoreField<String> GRANT_LFCYC_STATUS_FOR_AUTHZN =
        new GrantCoreField<String>("GrantLfcycStatusForAuthzn");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>GrantType</b>
     * </p>
     *
     * @return Grant Type
     */
    @SerializedName( "GrantType" )
    @JsonProperty( "GrantType" )
    @Nullable
    @ODataField( odataName = "GrantType" )
    private String grantType;
    /**
     * Use with available fluent helpers to apply the <b>GrantType</b> field to query operations.
     *
     */
    public final static GrantCoreField<String> GRANT_TYPE = new GrantCoreField<String>("GrantType");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>GrantIsBlockedForPosting</b>
     * </p>
     *
     * @return Blocking Indicator
     */
    @SerializedName( "GrantIsBlockedForPosting" )
    @JsonProperty( "GrantIsBlockedForPosting" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "GrantIsBlockedForPosting" )
    private Boolean grantIsBlockedForPosting;
    /**
     * Use with available fluent helpers to apply the <b>GrantIsBlockedForPosting</b> field to query operations.
     *
     */
    public final static GrantCoreField<Boolean> GRANT_IS_BLOCKED_FOR_POSTING =
        new GrantCoreField<Boolean>("GrantIsBlockedForPosting");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>GrantCurrency</b>
     * </p>
     *
     * @return Grant currency
     */
    @SerializedName( "GrantCurrency" )
    @JsonProperty( "GrantCurrency" )
    @Nullable
    @ODataField( odataName = "GrantCurrency" )
    private String grantCurrency;
    /**
     * Use with available fluent helpers to apply the <b>GrantCurrency</b> field to query operations.
     *
     */
    public final static GrantCoreField<String> GRANT_CURRENCY = new GrantCoreField<String>("GrantCurrency");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>GrantTotalAmountInGrantCrcy</b>
     * </p>
     *
     * @return Total Grant Value in Sponsor Currency
     */
    @SerializedName( "GrantTotalAmountInGrantCrcy" )
    @JsonProperty( "GrantTotalAmountInGrantCrcy" )
    @Nullable
    @ODataField( odataName = "GrantTotalAmountInGrantCrcy" )
    private BigDecimal grantTotalAmountInGrantCrcy;
    /**
     * Use with available fluent helpers to apply the <b>GrantTotalAmountInGrantCrcy</b> field to query operations.
     *
     */
    public final static GrantCoreField<BigDecimal> GRANT_TOTAL_AMOUNT_IN_GRANT_CRCY =
        new GrantCoreField<BigDecimal>("GrantTotalAmountInGrantCrcy");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>GteeMIndrctCostShrngRule</b>
     * </p>
     *
     * @return Rule for Determining Indirect Costs
     */
    @SerializedName( "GteeMIndrctCostShrngRule" )
    @JsonProperty( "GteeMIndrctCostShrngRule" )
    @Nullable
    @ODataField( odataName = "GteeMIndrctCostShrngRule" )
    private String gteeMIndrctCostShrngRule;
    /**
     * Use with available fluent helpers to apply the <b>GteeMIndrctCostShrngRule</b> field to query operations.
     *
     */
    public final static GrantCoreField<String> GTEE_M_INDRCT_COST_SHRNG_RULE =
        new GrantCoreField<String>("GteeMIndrctCostShrngRule");
    /**
     * Constraints: Not nullable, Precision: 6, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>GteeMIndirectCostRateInPercent</b>
     * </p>
     *
     * @return Cloud Edition Only: Percentage for Indirect Costs
     */
    @SerializedName( "GteeMIndirectCostRateInPercent" )
    @JsonProperty( "GteeMIndirectCostRateInPercent" )
    @Nullable
    @ODataField( odataName = "GteeMIndirectCostRateInPercent" )
    private BigDecimal gteeMIndirectCostRateInPercent;
    /**
     * Use with available fluent helpers to apply the <b>GteeMIndirectCostRateInPercent</b> field to query operations.
     *
     */
    public final static GrantCoreField<BigDecimal> GTEE_M_INDIRECT_COST_RATE_IN_PERCENT =
        new GrantCoreField<BigDecimal>("GteeMIndirectCostRateInPercent");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>GrantLifecycleStatus</b>
     * </p>
     *
     * @return Lifecycle Status
     */
    @SerializedName( "GrantLifecycleStatus" )
    @JsonProperty( "GrantLifecycleStatus" )
    @Nullable
    @ODataField( odataName = "GrantLifecycleStatus" )
    private String grantLifecycleStatus;
    /**
     * Use with available fluent helpers to apply the <b>GrantLifecycleStatus</b> field to query operations.
     *
     */
    public final static GrantCoreField<String> GRANT_LIFECYCLE_STATUS =
        new GrantCoreField<String>("GrantLifecycleStatus");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>Criticality</b>
     * </p>
     *
     * @return Criticality
     */
    @SerializedName( "Criticality" )
    @JsonProperty( "Criticality" )
    @Nullable
    @ODataField( odataName = "Criticality" )
    private Short criticality;
    /**
     * Use with available fluent helpers to apply the <b>Criticality</b> field to query operations.
     *
     */
    public final static GrantCoreField<Short> CRITICALITY = new GrantCoreField<Short>("Criticality");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>GrantStatusProfile</b>
     * </p>
     *
     * @return Status profile for the user states attached to system states
     */
    @SerializedName( "GrantStatusProfile" )
    @JsonProperty( "GrantStatusProfile" )
    @Nullable
    @ODataField( odataName = "GrantStatusProfile" )
    private String grantStatusProfile;
    /**
     * Use with available fluent helpers to apply the <b>GrantStatusProfile</b> field to query operations.
     *
     */
    public final static GrantCoreField<String> GRANT_STATUS_PROFILE = new GrantCoreField<String>("GrantStatusProfile");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>GrantUserStatus</b>
     * </p>
     *
     * @return User Status
     */
    @SerializedName( "GrantUserStatus" )
    @JsonProperty( "GrantUserStatus" )
    @Nullable
    @ODataField( odataName = "GrantUserStatus" )
    private String grantUserStatus;
    /**
     * Use with available fluent helpers to apply the <b>GrantUserStatus</b> field to query operations.
     *
     */
    public final static GrantCoreField<String> GRANT_USER_STATUS = new GrantCoreField<String>("GrantUserStatus");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>GranteeMgmtCostSharingRule</b>
     * </p>
     *
     * @return Rule for Determining Cost Sharing Requirements
     */
    @SerializedName( "GranteeMgmtCostSharingRule" )
    @JsonProperty( "GranteeMgmtCostSharingRule" )
    @Nullable
    @ODataField( odataName = "GranteeMgmtCostSharingRule" )
    private String granteeMgmtCostSharingRule;
    /**
     * Use with available fluent helpers to apply the <b>GranteeMgmtCostSharingRule</b> field to query operations.
     *
     */
    public final static GrantCoreField<String> GRANTEE_MGMT_COST_SHARING_RULE =
        new GrantCoreField<String>("GranteeMgmtCostSharingRule");
    /**
     * Constraints: Not nullable, Precision: 7, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>GteeMCostSharingOverallRate</b>
     * </p>
     *
     * @return Overall Cost Sharing Rate for Grant
     */
    @SerializedName( "GteeMCostSharingOverallRate" )
    @JsonProperty( "GteeMCostSharingOverallRate" )
    @Nullable
    @ODataField( odataName = "GteeMCostSharingOverallRate" )
    private BigDecimal gteeMCostSharingOverallRate;
    /**
     * Use with available fluent helpers to apply the <b>GteeMCostSharingOverallRate</b> field to query operations.
     *
     */
    public final static GrantCoreField<BigDecimal> GTEE_M_COST_SHARING_OVERALL_RATE =
        new GrantCoreField<BigDecimal>("GteeMCostSharingOverallRate");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>GranteeMgmtBillingRule</b>
     * </p>
     *
     * @return Rule Used as a Basis for Billing
     */
    @SerializedName( "GranteeMgmtBillingRule" )
    @JsonProperty( "GranteeMgmtBillingRule" )
    @Nullable
    @ODataField( odataName = "GranteeMgmtBillingRule" )
    private String granteeMgmtBillingRule;
    /**
     * Use with available fluent helpers to apply the <b>GranteeMgmtBillingRule</b> field to query operations.
     *
     */
    public final static GrantCoreField<String> GRANTEE_MGMT_BILLING_RULE =
        new GrantCoreField<String>("GranteeMgmtBillingRule");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>PreAwardPstgIsAllowedForGrant</b>
     * </p>
     *
     * @return Pre-award cost control
     */
    @SerializedName( "PreAwardPstgIsAllowedForGrant" )
    @JsonProperty( "PreAwardPstgIsAllowedForGrant" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "PreAwardPstgIsAllowedForGrant" )
    private Boolean preAwardPstgIsAllowedForGrant;
    /**
     * Use with available fluent helpers to apply the <b>PreAwardPstgIsAllowedForGrant</b> field to query operations.
     *
     */
    public final static GrantCoreField<Boolean> PRE_AWARD_PSTG_IS_ALLOWED_FOR_GRANT =
        new GrantCoreField<Boolean>("PreAwardPstgIsAllowedForGrant");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>GrantFiscalYearVariant</b>
     * </p>
     *
     * @return Fiscal year variant of grant
     */
    @SerializedName( "GrantFiscalYearVariant" )
    @JsonProperty( "GrantFiscalYearVariant" )
    @Nullable
    @ODataField( odataName = "GrantFiscalYearVariant" )
    private String grantFiscalYearVariant;
    /**
     * Use with available fluent helpers to apply the <b>GrantFiscalYearVariant</b> field to query operations.
     *
     */
    public final static GrantCoreField<String> GRANT_FISCAL_YEAR_VARIANT =
        new GrantCoreField<String>("GrantFiscalYearVariant");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>GteeMTimeSliceSplittingRule</b>
     * </p>
     *
     * @return Rule Used to Split Time Intervals Between Fiscal Years
     */
    @SerializedName( "GteeMTimeSliceSplittingRule" )
    @JsonProperty( "GteeMTimeSliceSplittingRule" )
    @Nullable
    @ODataField( odataName = "GteeMTimeSliceSplittingRule" )
    private String gteeMTimeSliceSplittingRule;
    /**
     * Use with available fluent helpers to apply the <b>GteeMTimeSliceSplittingRule</b> field to query operations.
     *
     */
    public final static GrantCoreField<String> GTEE_M_TIME_SLICE_SPLITTING_RULE =
        new GrantCoreField<String>("GteeMTimeSliceSplittingRule");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CostCenter</b>
     * </p>
     *
     * @return Cost Center
     */
    @SerializedName( "CostCenter" )
    @JsonProperty( "CostCenter" )
    @Nullable
    @ODataField( odataName = "CostCenter" )
    private String costCenter;
    /**
     * Use with available fluent helpers to apply the <b>CostCenter</b> field to query operations.
     *
     */
    public final static GrantCoreField<String> COST_CENTER = new GrantCoreField<String>("CostCenter");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ControllingArea</b>
     * </p>
     *
     * @return Controlling Area
     */
    @SerializedName( "ControllingArea" )
    @JsonProperty( "ControllingArea" )
    @Nullable
    @ODataField( odataName = "ControllingArea" )
    private String controllingArea;
    /**
     * Use with available fluent helpers to apply the <b>ControllingArea</b> field to query operations.
     *
     */
    public final static GrantCoreField<String> CONTROLLING_AREA = new GrantCoreField<String>("ControllingArea");
    /**
     * Constraints: Not nullable, Maximum length: 21
     * <p>
     * Original property name from the Odata EDM: <b>GrantValidityPeriod</b>
     * </p>
     *
     * @return Grant Validity Period
     */
    @SerializedName( "GrantValidityPeriod" )
    @JsonProperty( "GrantValidityPeriod" )
    @Nullable
    @ODataField( odataName = "GrantValidityPeriod" )
    private String grantValidityPeriod;
    /**
     * Use with available fluent helpers to apply the <b>GrantValidityPeriod</b> field to query operations.
     *
     */
    public final static GrantCoreField<String> GRANT_VALIDITY_PERIOD =
        new GrantCoreField<String>("GrantValidityPeriod");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>GrantBlockedByWorkflow</b>
     * </p>
     *
     * @return GM Blocks grant editing pending approval
     */
    @SerializedName( "GrantBlockedByWorkflow" )
    @JsonProperty( "GrantBlockedByWorkflow" )
    @Nullable
    @ODataField( odataName = "GrantBlockedByWorkflow" )
    private String grantBlockedByWorkflow;
    /**
     * Use with available fluent helpers to apply the <b>GrantBlockedByWorkflow</b> field to query operations.
     *
     */
    public final static GrantCoreField<String> GRANT_BLOCKED_BY_WORKFLOW =
        new GrantCoreField<String>("GrantBlockedByWorkflow");
    /**
     * Navigation property <b>to_GrantBdgtValidityLink</b> for <b>GrantCore</b> to multiple
     * <b>GrantBdgtValidityLink</b>.
     *
     */
    @SerializedName( "to_GrantBdgtValidityLink" )
    @JsonProperty( "to_GrantBdgtValidityLink" )
    @ODataField( odataName = "to_GrantBdgtValidityLink" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<GrantBdgtValidityLink> toGrantBdgtValidityLink;
    /**
     * Navigation property <b>to_GrantCostSharingLink</b> for <b>GrantCore</b> to multiple <b>GrantCostSharingLink</b>.
     *
     */
    @SerializedName( "to_GrantCostSharingLink" )
    @JsonProperty( "to_GrantCostSharingLink" )
    @ODataField( odataName = "to_GrantCostSharingLink" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<GrantCostSharingLink> toGrantCostSharingLink;
    /**
     * Navigation property <b>to_GrantFundsLink</b> for <b>GrantCore</b> to multiple <b>GrantFundsLink</b>.
     *
     */
    @SerializedName( "to_GrantFundsLink" )
    @JsonProperty( "to_GrantFundsLink" )
    @ODataField( odataName = "to_GrantFundsLink" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<GrantFundsLink> toGrantFundsLink;
    /**
     * Navigation property <b>to_GrantObjOvrHeadCostCapLink</b> for <b>GrantCore</b> to multiple
     * <b>GrantObjOvrHeadCostCapLink</b>.
     *
     */
    @SerializedName( "to_GrantObjOvrHeadCostCapLink" )
    @JsonProperty( "to_GrantObjOvrHeadCostCapLink" )
    @ODataField( odataName = "to_GrantObjOvrHeadCostCapLink" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<GrantObjOvrHeadCostCapLink> toGrantObjOvrHeadCostCapLink;
    /**
     * Navigation property <b>to_GrantOverHeadCostCapLink</b> for <b>GrantCore</b> to multiple
     * <b>GrantOverHeadCostCapLink</b>.
     *
     */
    @SerializedName( "to_GrantOverHeadCostCapLink" )
    @JsonProperty( "to_GrantOverHeadCostCapLink" )
    @ODataField( odataName = "to_GrantOverHeadCostCapLink" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<GrantOverHeadCostCapLink> toGrantOverHeadCostCapLink;
    /**
     * Navigation property <b>to_GrantOverHeadCostLink</b> for <b>GrantCore</b> to multiple
     * <b>GrantOverHeadCostLink</b>.
     *
     */
    @SerializedName( "to_GrantOverHeadCostLink" )
    @JsonProperty( "to_GrantOverHeadCostLink" )
    @ODataField( odataName = "to_GrantOverHeadCostLink" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<GrantOverHeadCostLink> toGrantOverHeadCostLink;
    /**
     * Navigation property <b>to_GrantSponsoredClassesLink</b> for <b>GrantCore</b> to multiple
     * <b>GrantSponsoredClassesLink</b>.
     *
     */
    @SerializedName( "to_GrantSponsoredClassesLink" )
    @JsonProperty( "to_GrantSponsoredClassesLink" )
    @ODataField( odataName = "to_GrantSponsoredClassesLink" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<GrantSponsoredClassesLink> toGrantSponsoredClassesLink;
    /**
     * Navigation property <b>to_GrantSponsoredProgramsLink</b> for <b>GrantCore</b> to multiple
     * <b>GrantSponsoredProgramsLink</b>.
     *
     */
    @SerializedName( "to_GrantSponsoredProgramsLink" )
    @JsonProperty( "to_GrantSponsoredProgramsLink" )
    @ODataField( odataName = "to_GrantSponsoredProgramsLink" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<GrantSponsoredProgramsLink> toGrantSponsoredProgramsLink;
    /**
     * Navigation property <b>to_Text</b> for <b>GrantCore</b> to multiple <b>GrantCoreText</b>.
     *
     */
    @SerializedName( "to_Text" )
    @JsonProperty( "to_Text" )
    @ODataField( odataName = "to_Text" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<GrantCoreText> toText;
    /**
     * Use with available fluent helpers to apply the <b>to_GrantBdgtValidityLink</b> navigation property to query
     * operations.
     *
     */
    public final static GrantCoreLink<GrantBdgtValidityLink> TO_GRANT_BDGT_VALIDITY_LINK =
        new GrantCoreLink<GrantBdgtValidityLink>("to_GrantBdgtValidityLink");
    /**
     * Use with available fluent helpers to apply the <b>to_GrantCostSharingLink</b> navigation property to query
     * operations.
     *
     */
    public final static GrantCoreLink<GrantCostSharingLink> TO_GRANT_COST_SHARING_LINK =
        new GrantCoreLink<GrantCostSharingLink>("to_GrantCostSharingLink");
    /**
     * Use with available fluent helpers to apply the <b>to_GrantFundsLink</b> navigation property to query operations.
     *
     */
    public final static GrantCoreLink<GrantFundsLink> TO_GRANT_FUNDS_LINK =
        new GrantCoreLink<GrantFundsLink>("to_GrantFundsLink");
    /**
     * Use with available fluent helpers to apply the <b>to_GrantObjOvrHeadCostCapLink</b> navigation property to query
     * operations.
     *
     */
    public final static GrantCoreLink<GrantObjOvrHeadCostCapLink> TO_GRANT_OBJ_OVR_HEAD_COST_CAP_LINK =
        new GrantCoreLink<GrantObjOvrHeadCostCapLink>("to_GrantObjOvrHeadCostCapLink");
    /**
     * Use with available fluent helpers to apply the <b>to_GrantOverHeadCostCapLink</b> navigation property to query
     * operations.
     *
     */
    public final static GrantCoreLink<GrantOverHeadCostCapLink> TO_GRANT_OVER_HEAD_COST_CAP_LINK =
        new GrantCoreLink<GrantOverHeadCostCapLink>("to_GrantOverHeadCostCapLink");
    /**
     * Use with available fluent helpers to apply the <b>to_GrantOverHeadCostLink</b> navigation property to query
     * operations.
     *
     */
    public final static GrantCoreLink<GrantOverHeadCostLink> TO_GRANT_OVER_HEAD_COST_LINK =
        new GrantCoreLink<GrantOverHeadCostLink>("to_GrantOverHeadCostLink");
    /**
     * Use with available fluent helpers to apply the <b>to_GrantSponsoredClassesLink</b> navigation property to query
     * operations.
     *
     */
    public final static GrantCoreLink<GrantSponsoredClassesLink> TO_GRANT_SPONSORED_CLASSES_LINK =
        new GrantCoreLink<GrantSponsoredClassesLink>("to_GrantSponsoredClassesLink");
    /**
     * Use with available fluent helpers to apply the <b>to_GrantSponsoredProgramsLink</b> navigation property to query
     * operations.
     *
     */
    public final static GrantCoreLink<GrantSponsoredProgramsLink> TO_GRANT_SPONSORED_PROGRAMS_LINK =
        new GrantCoreLink<GrantSponsoredProgramsLink>("to_GrantSponsoredProgramsLink");
    /**
     * Use with available fluent helpers to apply the <b>to_Text</b> navigation property to query operations.
     *
     */
    public final static GrantCoreLink<GrantCoreText> TO_TEXT = new GrantCoreLink<GrantCoreText>("to_Text");

    @Nonnull
    @Override
    public Class<GrantCore> getType()
    {
        return GrantCore.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>GrantID</b>
     * </p>
     *
     * @param grantID
     *            Grant
     */
    public void setGrantID( @Nullable final String grantID )
    {
        rememberChangedField("GrantID", this.grantID);
        this.grantID = grantID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCode</b>
     * </p>
     *
     * @param companyCode
     *            Company Code
     */
    public void setCompanyCode( @Nullable final String companyCode )
    {
        rememberChangedField("CompanyCode", this.companyCode);
        this.companyCode = companyCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>GrantAuthznGrp</b>
     * </p>
     *
     * @param grantAuthznGrp
     *            Grants Management: Authorization Groups
     */
    public void setGrantAuthznGrp( @Nullable final String grantAuthznGrp )
    {
        rememberChangedField("GrantAuthznGrp", this.grantAuthznGrp);
        this.grantAuthznGrp = grantAuthznGrp;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityStartDate</b>
     * </p>
     *
     * @param validityStartDate
     *            Valid-from Date
     */
    public void setValidityStartDate( @Nullable final LocalDateTime validityStartDate )
    {
        rememberChangedField("ValidityStartDate", this.validityStartDate);
        this.validityStartDate = validityStartDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityEndDate</b>
     * </p>
     *
     * @param validityEndDate
     *            Valid-to Date
     */
    public void setValidityEndDate( @Nullable final LocalDateTime validityEndDate )
    {
        rememberChangedField("ValidityEndDate", this.validityEndDate);
        this.validityEndDate = validityEndDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>GrantName</b>
     * </p>
     *
     * @param grantName
     *            Short Description of the Grant
     */
    public void setGrantName( @Nullable final String grantName )
    {
        rememberChangedField("GrantName", this.grantName);
        this.grantName = grantName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 80
     * <p>
     * Original property name from the Odata EDM: <b>GrantDescription</b>
     * </p>
     *
     * @param grantDescription
     *            Descriptive Text
     */
    public void setGrantDescription( @Nullable final String grantDescription )
    {
        rememberChangedField("GrantDescription", this.grantDescription);
        this.grantDescription = grantDescription;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>GrantIsNotRelevantGrant</b>
     * </p>
     *
     * @param grantIsNotRelevantGrant
     *            Identify the Not Relevant Grant
     */
    public void setGrantIsNotRelevantGrant( @Nullable final Boolean grantIsNotRelevantGrant )
    {
        rememberChangedField("GrantIsNotRelevantGrant", this.grantIsNotRelevantGrant);
        this.grantIsNotRelevantGrant = grantIsNotRelevantGrant;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>GranteeMgmtSponsor</b>
     * </p>
     *
     * @param granteeMgmtSponsor
     *            Grant Sponsor
     */
    public void setGranteeMgmtSponsor( @Nullable final String granteeMgmtSponsor )
    {
        rememberChangedField("GranteeMgmtSponsor", this.granteeMgmtSponsor);
        this.granteeMgmtSponsor = granteeMgmtSponsor;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>GrantLfcycStatusForAuthzn</b>
     * </p>
     *
     * @param grantLfcycStatusForAuthzn
     *            GM Lifecycle Status for Auth Grp
     */
    public void setGrantLfcycStatusForAuthzn( @Nullable final String grantLfcycStatusForAuthzn )
    {
        rememberChangedField("GrantLfcycStatusForAuthzn", this.grantLfcycStatusForAuthzn);
        this.grantLfcycStatusForAuthzn = grantLfcycStatusForAuthzn;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>GrantType</b>
     * </p>
     *
     * @param grantType
     *            Grant Type
     */
    public void setGrantType( @Nullable final String grantType )
    {
        rememberChangedField("GrantType", this.grantType);
        this.grantType = grantType;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>GrantIsBlockedForPosting</b>
     * </p>
     *
     * @param grantIsBlockedForPosting
     *            Blocking Indicator
     */
    public void setGrantIsBlockedForPosting( @Nullable final Boolean grantIsBlockedForPosting )
    {
        rememberChangedField("GrantIsBlockedForPosting", this.grantIsBlockedForPosting);
        this.grantIsBlockedForPosting = grantIsBlockedForPosting;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>GrantCurrency</b>
     * </p>
     *
     * @param grantCurrency
     *            Grant currency
     */
    public void setGrantCurrency( @Nullable final String grantCurrency )
    {
        rememberChangedField("GrantCurrency", this.grantCurrency);
        this.grantCurrency = grantCurrency;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>GrantTotalAmountInGrantCrcy</b>
     * </p>
     *
     * @param grantTotalAmountInGrantCrcy
     *            Total Grant Value in Sponsor Currency
     */
    public void setGrantTotalAmountInGrantCrcy( @Nullable final BigDecimal grantTotalAmountInGrantCrcy )
    {
        rememberChangedField("GrantTotalAmountInGrantCrcy", this.grantTotalAmountInGrantCrcy);
        this.grantTotalAmountInGrantCrcy = grantTotalAmountInGrantCrcy;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>GteeMIndrctCostShrngRule</b>
     * </p>
     *
     * @param gteeMIndrctCostShrngRule
     *            Rule for Determining Indirect Costs
     */
    public void setGteeMIndrctCostShrngRule( @Nullable final String gteeMIndrctCostShrngRule )
    {
        rememberChangedField("GteeMIndrctCostShrngRule", this.gteeMIndrctCostShrngRule);
        this.gteeMIndrctCostShrngRule = gteeMIndrctCostShrngRule;
    }

    /**
     * Constraints: Not nullable, Precision: 6, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>GteeMIndirectCostRateInPercent</b>
     * </p>
     *
     * @param gteeMIndirectCostRateInPercent
     *            Cloud Edition Only: Percentage for Indirect Costs
     */
    public void setGteeMIndirectCostRateInPercent( @Nullable final BigDecimal gteeMIndirectCostRateInPercent )
    {
        rememberChangedField("GteeMIndirectCostRateInPercent", this.gteeMIndirectCostRateInPercent);
        this.gteeMIndirectCostRateInPercent = gteeMIndirectCostRateInPercent;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>GrantLifecycleStatus</b>
     * </p>
     *
     * @param grantLifecycleStatus
     *            Lifecycle Status
     */
    public void setGrantLifecycleStatus( @Nullable final String grantLifecycleStatus )
    {
        rememberChangedField("GrantLifecycleStatus", this.grantLifecycleStatus);
        this.grantLifecycleStatus = grantLifecycleStatus;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>Criticality</b>
     * </p>
     *
     * @param criticality
     *            Criticality
     */
    public void setCriticality( @Nullable final Short criticality )
    {
        rememberChangedField("Criticality", this.criticality);
        this.criticality = criticality;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>GrantStatusProfile</b>
     * </p>
     *
     * @param grantStatusProfile
     *            Status profile for the user states attached to system states
     */
    public void setGrantStatusProfile( @Nullable final String grantStatusProfile )
    {
        rememberChangedField("GrantStatusProfile", this.grantStatusProfile);
        this.grantStatusProfile = grantStatusProfile;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>GrantUserStatus</b>
     * </p>
     *
     * @param grantUserStatus
     *            User Status
     */
    public void setGrantUserStatus( @Nullable final String grantUserStatus )
    {
        rememberChangedField("GrantUserStatus", this.grantUserStatus);
        this.grantUserStatus = grantUserStatus;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>GranteeMgmtCostSharingRule</b>
     * </p>
     *
     * @param granteeMgmtCostSharingRule
     *            Rule for Determining Cost Sharing Requirements
     */
    public void setGranteeMgmtCostSharingRule( @Nullable final String granteeMgmtCostSharingRule )
    {
        rememberChangedField("GranteeMgmtCostSharingRule", this.granteeMgmtCostSharingRule);
        this.granteeMgmtCostSharingRule = granteeMgmtCostSharingRule;
    }

    /**
     * Constraints: Not nullable, Precision: 7, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>GteeMCostSharingOverallRate</b>
     * </p>
     *
     * @param gteeMCostSharingOverallRate
     *            Overall Cost Sharing Rate for Grant
     */
    public void setGteeMCostSharingOverallRate( @Nullable final BigDecimal gteeMCostSharingOverallRate )
    {
        rememberChangedField("GteeMCostSharingOverallRate", this.gteeMCostSharingOverallRate);
        this.gteeMCostSharingOverallRate = gteeMCostSharingOverallRate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>GranteeMgmtBillingRule</b>
     * </p>
     *
     * @param granteeMgmtBillingRule
     *            Rule Used as a Basis for Billing
     */
    public void setGranteeMgmtBillingRule( @Nullable final String granteeMgmtBillingRule )
    {
        rememberChangedField("GranteeMgmtBillingRule", this.granteeMgmtBillingRule);
        this.granteeMgmtBillingRule = granteeMgmtBillingRule;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>PreAwardPstgIsAllowedForGrant</b>
     * </p>
     *
     * @param preAwardPstgIsAllowedForGrant
     *            Pre-award cost control
     */
    public void setPreAwardPstgIsAllowedForGrant( @Nullable final Boolean preAwardPstgIsAllowedForGrant )
    {
        rememberChangedField("PreAwardPstgIsAllowedForGrant", this.preAwardPstgIsAllowedForGrant);
        this.preAwardPstgIsAllowedForGrant = preAwardPstgIsAllowedForGrant;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>GrantFiscalYearVariant</b>
     * </p>
     *
     * @param grantFiscalYearVariant
     *            Fiscal year variant of grant
     */
    public void setGrantFiscalYearVariant( @Nullable final String grantFiscalYearVariant )
    {
        rememberChangedField("GrantFiscalYearVariant", this.grantFiscalYearVariant);
        this.grantFiscalYearVariant = grantFiscalYearVariant;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>GteeMTimeSliceSplittingRule</b>
     * </p>
     *
     * @param gteeMTimeSliceSplittingRule
     *            Rule Used to Split Time Intervals Between Fiscal Years
     */
    public void setGteeMTimeSliceSplittingRule( @Nullable final String gteeMTimeSliceSplittingRule )
    {
        rememberChangedField("GteeMTimeSliceSplittingRule", this.gteeMTimeSliceSplittingRule);
        this.gteeMTimeSliceSplittingRule = gteeMTimeSliceSplittingRule;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CostCenter</b>
     * </p>
     *
     * @param costCenter
     *            Cost Center
     */
    public void setCostCenter( @Nullable final String costCenter )
    {
        rememberChangedField("CostCenter", this.costCenter);
        this.costCenter = costCenter;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ControllingArea</b>
     * </p>
     *
     * @param controllingArea
     *            Controlling Area
     */
    public void setControllingArea( @Nullable final String controllingArea )
    {
        rememberChangedField("ControllingArea", this.controllingArea);
        this.controllingArea = controllingArea;
    }

    /**
     * Constraints: Not nullable, Maximum length: 21
     * <p>
     * Original property name from the Odata EDM: <b>GrantValidityPeriod</b>
     * </p>
     *
     * @param grantValidityPeriod
     *            Grant Validity Period
     */
    public void setGrantValidityPeriod( @Nullable final String grantValidityPeriod )
    {
        rememberChangedField("GrantValidityPeriod", this.grantValidityPeriod);
        this.grantValidityPeriod = grantValidityPeriod;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>GrantBlockedByWorkflow</b>
     * </p>
     *
     * @param grantBlockedByWorkflow
     *            GM Blocks grant editing pending approval
     */
    public void setGrantBlockedByWorkflow( @Nullable final String grantBlockedByWorkflow )
    {
        rememberChangedField("GrantBlockedByWorkflow", this.grantBlockedByWorkflow);
        this.grantBlockedByWorkflow = grantBlockedByWorkflow;
    }

    @Override
    protected String getEntityCollection()
    {
        return "Grant";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("GrantID", getGrantID());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("GrantID", getGrantID());
        values.put("CompanyCode", getCompanyCode());
        values.put("GrantAuthznGrp", getGrantAuthznGrp());
        values.put("ValidityStartDate", getValidityStartDate());
        values.put("ValidityEndDate", getValidityEndDate());
        values.put("GrantName", getGrantName());
        values.put("GrantDescription", getGrantDescription());
        values.put("GrantIsNotRelevantGrant", getGrantIsNotRelevantGrant());
        values.put("GranteeMgmtSponsor", getGranteeMgmtSponsor());
        values.put("GrantLfcycStatusForAuthzn", getGrantLfcycStatusForAuthzn());
        values.put("GrantType", getGrantType());
        values.put("GrantIsBlockedForPosting", getGrantIsBlockedForPosting());
        values.put("GrantCurrency", getGrantCurrency());
        values.put("GrantTotalAmountInGrantCrcy", getGrantTotalAmountInGrantCrcy());
        values.put("GteeMIndrctCostShrngRule", getGteeMIndrctCostShrngRule());
        values.put("GteeMIndirectCostRateInPercent", getGteeMIndirectCostRateInPercent());
        values.put("GrantLifecycleStatus", getGrantLifecycleStatus());
        values.put("Criticality", getCriticality());
        values.put("GrantStatusProfile", getGrantStatusProfile());
        values.put("GrantUserStatus", getGrantUserStatus());
        values.put("GranteeMgmtCostSharingRule", getGranteeMgmtCostSharingRule());
        values.put("GteeMCostSharingOverallRate", getGteeMCostSharingOverallRate());
        values.put("GranteeMgmtBillingRule", getGranteeMgmtBillingRule());
        values.put("PreAwardPstgIsAllowedForGrant", getPreAwardPstgIsAllowedForGrant());
        values.put("GrantFiscalYearVariant", getGrantFiscalYearVariant());
        values.put("GteeMTimeSliceSplittingRule", getGteeMTimeSliceSplittingRule());
        values.put("CostCenter", getCostCenter());
        values.put("ControllingArea", getControllingArea());
        values.put("GrantValidityPeriod", getGrantValidityPeriod());
        values.put("GrantBlockedByWorkflow", getGrantBlockedByWorkflow());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("GrantID") ) {
                final Object value = values.remove("GrantID");
                if( (value == null) || (!value.equals(getGrantID())) ) {
                    setGrantID(((String) value));
                }
            }
            if( values.containsKey("CompanyCode") ) {
                final Object value = values.remove("CompanyCode");
                if( (value == null) || (!value.equals(getCompanyCode())) ) {
                    setCompanyCode(((String) value));
                }
            }
            if( values.containsKey("GrantAuthznGrp") ) {
                final Object value = values.remove("GrantAuthznGrp");
                if( (value == null) || (!value.equals(getGrantAuthznGrp())) ) {
                    setGrantAuthznGrp(((String) value));
                }
            }
            if( values.containsKey("ValidityStartDate") ) {
                final Object value = values.remove("ValidityStartDate");
                if( (value == null) || (!value.equals(getValidityStartDate())) ) {
                    setValidityStartDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ValidityEndDate") ) {
                final Object value = values.remove("ValidityEndDate");
                if( (value == null) || (!value.equals(getValidityEndDate())) ) {
                    setValidityEndDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("GrantName") ) {
                final Object value = values.remove("GrantName");
                if( (value == null) || (!value.equals(getGrantName())) ) {
                    setGrantName(((String) value));
                }
            }
            if( values.containsKey("GrantDescription") ) {
                final Object value = values.remove("GrantDescription");
                if( (value == null) || (!value.equals(getGrantDescription())) ) {
                    setGrantDescription(((String) value));
                }
            }
            if( values.containsKey("GrantIsNotRelevantGrant") ) {
                final Object value = values.remove("GrantIsNotRelevantGrant");
                if( (value == null) || (!value.equals(getGrantIsNotRelevantGrant())) ) {
                    setGrantIsNotRelevantGrant(((Boolean) value));
                }
            }
            if( values.containsKey("GranteeMgmtSponsor") ) {
                final Object value = values.remove("GranteeMgmtSponsor");
                if( (value == null) || (!value.equals(getGranteeMgmtSponsor())) ) {
                    setGranteeMgmtSponsor(((String) value));
                }
            }
            if( values.containsKey("GrantLfcycStatusForAuthzn") ) {
                final Object value = values.remove("GrantLfcycStatusForAuthzn");
                if( (value == null) || (!value.equals(getGrantLfcycStatusForAuthzn())) ) {
                    setGrantLfcycStatusForAuthzn(((String) value));
                }
            }
            if( values.containsKey("GrantType") ) {
                final Object value = values.remove("GrantType");
                if( (value == null) || (!value.equals(getGrantType())) ) {
                    setGrantType(((String) value));
                }
            }
            if( values.containsKey("GrantIsBlockedForPosting") ) {
                final Object value = values.remove("GrantIsBlockedForPosting");
                if( (value == null) || (!value.equals(getGrantIsBlockedForPosting())) ) {
                    setGrantIsBlockedForPosting(((Boolean) value));
                }
            }
            if( values.containsKey("GrantCurrency") ) {
                final Object value = values.remove("GrantCurrency");
                if( (value == null) || (!value.equals(getGrantCurrency())) ) {
                    setGrantCurrency(((String) value));
                }
            }
            if( values.containsKey("GrantTotalAmountInGrantCrcy") ) {
                final Object value = values.remove("GrantTotalAmountInGrantCrcy");
                if( (value == null) || (!value.equals(getGrantTotalAmountInGrantCrcy())) ) {
                    setGrantTotalAmountInGrantCrcy(((BigDecimal) value));
                }
            }
            if( values.containsKey("GteeMIndrctCostShrngRule") ) {
                final Object value = values.remove("GteeMIndrctCostShrngRule");
                if( (value == null) || (!value.equals(getGteeMIndrctCostShrngRule())) ) {
                    setGteeMIndrctCostShrngRule(((String) value));
                }
            }
            if( values.containsKey("GteeMIndirectCostRateInPercent") ) {
                final Object value = values.remove("GteeMIndirectCostRateInPercent");
                if( (value == null) || (!value.equals(getGteeMIndirectCostRateInPercent())) ) {
                    setGteeMIndirectCostRateInPercent(((BigDecimal) value));
                }
            }
            if( values.containsKey("GrantLifecycleStatus") ) {
                final Object value = values.remove("GrantLifecycleStatus");
                if( (value == null) || (!value.equals(getGrantLifecycleStatus())) ) {
                    setGrantLifecycleStatus(((String) value));
                }
            }
            if( values.containsKey("Criticality") ) {
                final Object value = values.remove("Criticality");
                if( (value == null) || (!value.equals(getCriticality())) ) {
                    setCriticality(((Short) value));
                }
            }
            if( values.containsKey("GrantStatusProfile") ) {
                final Object value = values.remove("GrantStatusProfile");
                if( (value == null) || (!value.equals(getGrantStatusProfile())) ) {
                    setGrantStatusProfile(((String) value));
                }
            }
            if( values.containsKey("GrantUserStatus") ) {
                final Object value = values.remove("GrantUserStatus");
                if( (value == null) || (!value.equals(getGrantUserStatus())) ) {
                    setGrantUserStatus(((String) value));
                }
            }
            if( values.containsKey("GranteeMgmtCostSharingRule") ) {
                final Object value = values.remove("GranteeMgmtCostSharingRule");
                if( (value == null) || (!value.equals(getGranteeMgmtCostSharingRule())) ) {
                    setGranteeMgmtCostSharingRule(((String) value));
                }
            }
            if( values.containsKey("GteeMCostSharingOverallRate") ) {
                final Object value = values.remove("GteeMCostSharingOverallRate");
                if( (value == null) || (!value.equals(getGteeMCostSharingOverallRate())) ) {
                    setGteeMCostSharingOverallRate(((BigDecimal) value));
                }
            }
            if( values.containsKey("GranteeMgmtBillingRule") ) {
                final Object value = values.remove("GranteeMgmtBillingRule");
                if( (value == null) || (!value.equals(getGranteeMgmtBillingRule())) ) {
                    setGranteeMgmtBillingRule(((String) value));
                }
            }
            if( values.containsKey("PreAwardPstgIsAllowedForGrant") ) {
                final Object value = values.remove("PreAwardPstgIsAllowedForGrant");
                if( (value == null) || (!value.equals(getPreAwardPstgIsAllowedForGrant())) ) {
                    setPreAwardPstgIsAllowedForGrant(((Boolean) value));
                }
            }
            if( values.containsKey("GrantFiscalYearVariant") ) {
                final Object value = values.remove("GrantFiscalYearVariant");
                if( (value == null) || (!value.equals(getGrantFiscalYearVariant())) ) {
                    setGrantFiscalYearVariant(((String) value));
                }
            }
            if( values.containsKey("GteeMTimeSliceSplittingRule") ) {
                final Object value = values.remove("GteeMTimeSliceSplittingRule");
                if( (value == null) || (!value.equals(getGteeMTimeSliceSplittingRule())) ) {
                    setGteeMTimeSliceSplittingRule(((String) value));
                }
            }
            if( values.containsKey("CostCenter") ) {
                final Object value = values.remove("CostCenter");
                if( (value == null) || (!value.equals(getCostCenter())) ) {
                    setCostCenter(((String) value));
                }
            }
            if( values.containsKey("ControllingArea") ) {
                final Object value = values.remove("ControllingArea");
                if( (value == null) || (!value.equals(getControllingArea())) ) {
                    setControllingArea(((String) value));
                }
            }
            if( values.containsKey("GrantValidityPeriod") ) {
                final Object value = values.remove("GrantValidityPeriod");
                if( (value == null) || (!value.equals(getGrantValidityPeriod())) ) {
                    setGrantValidityPeriod(((String) value));
                }
            }
            if( values.containsKey("GrantBlockedByWorkflow") ) {
                final Object value = values.remove("GrantBlockedByWorkflow");
                if( (value == null) || (!value.equals(getGrantBlockedByWorkflow())) ) {
                    setGrantBlockedByWorkflow(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_GrantBdgtValidityLink") ) {
                final Object value = (values).remove("to_GrantBdgtValidityLink");
                if( value instanceof Iterable ) {
                    if( toGrantBdgtValidityLink == null ) {
                        toGrantBdgtValidityLink = Lists.newArrayList();
                    } else {
                        toGrantBdgtValidityLink = Lists.newArrayList(toGrantBdgtValidityLink);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        GrantBdgtValidityLink entity;
                        if( toGrantBdgtValidityLink.size() > i ) {
                            entity = toGrantBdgtValidityLink.get(i);
                        } else {
                            entity = new GrantBdgtValidityLink();
                            toGrantBdgtValidityLink.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_GrantCostSharingLink") ) {
                final Object value = (values).remove("to_GrantCostSharingLink");
                if( value instanceof Iterable ) {
                    if( toGrantCostSharingLink == null ) {
                        toGrantCostSharingLink = Lists.newArrayList();
                    } else {
                        toGrantCostSharingLink = Lists.newArrayList(toGrantCostSharingLink);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        GrantCostSharingLink entity;
                        if( toGrantCostSharingLink.size() > i ) {
                            entity = toGrantCostSharingLink.get(i);
                        } else {
                            entity = new GrantCostSharingLink();
                            toGrantCostSharingLink.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_GrantFundsLink") ) {
                final Object value = (values).remove("to_GrantFundsLink");
                if( value instanceof Iterable ) {
                    if( toGrantFundsLink == null ) {
                        toGrantFundsLink = Lists.newArrayList();
                    } else {
                        toGrantFundsLink = Lists.newArrayList(toGrantFundsLink);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        GrantFundsLink entity;
                        if( toGrantFundsLink.size() > i ) {
                            entity = toGrantFundsLink.get(i);
                        } else {
                            entity = new GrantFundsLink();
                            toGrantFundsLink.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_GrantObjOvrHeadCostCapLink") ) {
                final Object value = (values).remove("to_GrantObjOvrHeadCostCapLink");
                if( value instanceof Iterable ) {
                    if( toGrantObjOvrHeadCostCapLink == null ) {
                        toGrantObjOvrHeadCostCapLink = Lists.newArrayList();
                    } else {
                        toGrantObjOvrHeadCostCapLink = Lists.newArrayList(toGrantObjOvrHeadCostCapLink);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        GrantObjOvrHeadCostCapLink entity;
                        if( toGrantObjOvrHeadCostCapLink.size() > i ) {
                            entity = toGrantObjOvrHeadCostCapLink.get(i);
                        } else {
                            entity = new GrantObjOvrHeadCostCapLink();
                            toGrantObjOvrHeadCostCapLink.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_GrantOverHeadCostCapLink") ) {
                final Object value = (values).remove("to_GrantOverHeadCostCapLink");
                if( value instanceof Iterable ) {
                    if( toGrantOverHeadCostCapLink == null ) {
                        toGrantOverHeadCostCapLink = Lists.newArrayList();
                    } else {
                        toGrantOverHeadCostCapLink = Lists.newArrayList(toGrantOverHeadCostCapLink);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        GrantOverHeadCostCapLink entity;
                        if( toGrantOverHeadCostCapLink.size() > i ) {
                            entity = toGrantOverHeadCostCapLink.get(i);
                        } else {
                            entity = new GrantOverHeadCostCapLink();
                            toGrantOverHeadCostCapLink.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_GrantOverHeadCostLink") ) {
                final Object value = (values).remove("to_GrantOverHeadCostLink");
                if( value instanceof Iterable ) {
                    if( toGrantOverHeadCostLink == null ) {
                        toGrantOverHeadCostLink = Lists.newArrayList();
                    } else {
                        toGrantOverHeadCostLink = Lists.newArrayList(toGrantOverHeadCostLink);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        GrantOverHeadCostLink entity;
                        if( toGrantOverHeadCostLink.size() > i ) {
                            entity = toGrantOverHeadCostLink.get(i);
                        } else {
                            entity = new GrantOverHeadCostLink();
                            toGrantOverHeadCostLink.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_GrantSponsoredClassesLink") ) {
                final Object value = (values).remove("to_GrantSponsoredClassesLink");
                if( value instanceof Iterable ) {
                    if( toGrantSponsoredClassesLink == null ) {
                        toGrantSponsoredClassesLink = Lists.newArrayList();
                    } else {
                        toGrantSponsoredClassesLink = Lists.newArrayList(toGrantSponsoredClassesLink);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        GrantSponsoredClassesLink entity;
                        if( toGrantSponsoredClassesLink.size() > i ) {
                            entity = toGrantSponsoredClassesLink.get(i);
                        } else {
                            entity = new GrantSponsoredClassesLink();
                            toGrantSponsoredClassesLink.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_GrantSponsoredProgramsLink") ) {
                final Object value = (values).remove("to_GrantSponsoredProgramsLink");
                if( value instanceof Iterable ) {
                    if( toGrantSponsoredProgramsLink == null ) {
                        toGrantSponsoredProgramsLink = Lists.newArrayList();
                    } else {
                        toGrantSponsoredProgramsLink = Lists.newArrayList(toGrantSponsoredProgramsLink);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        GrantSponsoredProgramsLink entity;
                        if( toGrantSponsoredProgramsLink.size() > i ) {
                            entity = toGrantSponsoredProgramsLink.get(i);
                        } else {
                            entity = new GrantSponsoredProgramsLink();
                            toGrantSponsoredProgramsLink.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_Text") ) {
                final Object value = (values).remove("to_Text");
                if( value instanceof Iterable ) {
                    if( toText == null ) {
                        toText = Lists.newArrayList();
                    } else {
                        toText = Lists.newArrayList(toText);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        GrantCoreText entity;
                        if( toText.size() > i ) {
                            entity = toText.get(i);
                        } else {
                            entity = new GrantCoreText();
                            toText.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> GrantCoreField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new GrantCoreField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> GrantCoreField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new GrantCoreField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.GrantService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toGrantBdgtValidityLink != null ) {
            (values).put("to_GrantBdgtValidityLink", toGrantBdgtValidityLink);
        }
        if( toGrantCostSharingLink != null ) {
            (values).put("to_GrantCostSharingLink", toGrantCostSharingLink);
        }
        if( toGrantFundsLink != null ) {
            (values).put("to_GrantFundsLink", toGrantFundsLink);
        }
        if( toGrantObjOvrHeadCostCapLink != null ) {
            (values).put("to_GrantObjOvrHeadCostCapLink", toGrantObjOvrHeadCostCapLink);
        }
        if( toGrantOverHeadCostCapLink != null ) {
            (values).put("to_GrantOverHeadCostCapLink", toGrantOverHeadCostCapLink);
        }
        if( toGrantOverHeadCostLink != null ) {
            (values).put("to_GrantOverHeadCostLink", toGrantOverHeadCostLink);
        }
        if( toGrantSponsoredClassesLink != null ) {
            (values).put("to_GrantSponsoredClassesLink", toGrantSponsoredClassesLink);
        }
        if( toGrantSponsoredProgramsLink != null ) {
            (values).put("to_GrantSponsoredProgramsLink", toGrantSponsoredProgramsLink);
        }
        if( toText != null ) {
            (values).put("to_Text", toText);
        }
        return values;
    }

    /**
     * Fetches the <b>GrantBdgtValidityLink</b> entities (one to many) associated with this entity. This corresponds to
     * the OData navigation property <b>to_GrantBdgtValidityLink</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>GrantBdgtValidityLink</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<GrantBdgtValidityLink> fetchGrantBdgtValidityLink()
    {
        return fetchFieldAsList("to_GrantBdgtValidityLink", GrantBdgtValidityLink.class);
    }

    /**
     * Retrieval of associated <b>GrantBdgtValidityLink</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_GrantBdgtValidityLink</b>.
     * <p>
     * If the navigation property <b>to_GrantBdgtValidityLink</b> of a queried <b>GrantCore</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>GrantBdgtValidityLink</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<GrantBdgtValidityLink> getGrantBdgtValidityLinkOrFetch()
    {
        if( toGrantBdgtValidityLink == null ) {
            toGrantBdgtValidityLink = fetchGrantBdgtValidityLink();
        }
        return toGrantBdgtValidityLink;
    }

    /**
     * Retrieval of associated <b>GrantBdgtValidityLink</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_GrantBdgtValidityLink</b>.
     * <p>
     * If the navigation property for an entity <b>GrantCore</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_GrantBdgtValidityLink</b> is already loaded, the result
     *         will contain the <b>GrantBdgtValidityLink</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<GrantBdgtValidityLink>> getGrantBdgtValidityLinkIfPresent()
    {
        return Option.of(toGrantBdgtValidityLink);
    }

    /**
     * Overwrites the list of associated <b>GrantBdgtValidityLink</b> entities for the loaded navigation property
     * <b>to_GrantBdgtValidityLink</b>.
     * <p>
     * If the navigation property <b>to_GrantBdgtValidityLink</b> of a queried <b>GrantCore</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>GrantBdgtValidityLink</b> entities.
     */
    public void setGrantBdgtValidityLink( @Nonnull final List<GrantBdgtValidityLink> value )
    {
        if( toGrantBdgtValidityLink == null ) {
            toGrantBdgtValidityLink = Lists.newArrayList();
        }
        toGrantBdgtValidityLink.clear();
        toGrantBdgtValidityLink.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>GrantBdgtValidityLink</b> entities. This corresponds to the OData
     * navigation property <b>to_GrantBdgtValidityLink</b>.
     * <p>
     * If the navigation property <b>to_GrantBdgtValidityLink</b> of a queried <b>GrantCore</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>GrantBdgtValidityLink</b> entities.
     */
    public void addGrantBdgtValidityLink( GrantBdgtValidityLink... entity )
    {
        if( toGrantBdgtValidityLink == null ) {
            toGrantBdgtValidityLink = Lists.newArrayList();
        }
        toGrantBdgtValidityLink.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>GrantCostSharingLink</b> entities (one to many) associated with this entity. This corresponds to
     * the OData navigation property <b>to_GrantCostSharingLink</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>GrantCostSharingLink</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<GrantCostSharingLink> fetchGrantCostSharingLink()
    {
        return fetchFieldAsList("to_GrantCostSharingLink", GrantCostSharingLink.class);
    }

    /**
     * Retrieval of associated <b>GrantCostSharingLink</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_GrantCostSharingLink</b>.
     * <p>
     * If the navigation property <b>to_GrantCostSharingLink</b> of a queried <b>GrantCore</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>GrantCostSharingLink</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<GrantCostSharingLink> getGrantCostSharingLinkOrFetch()
    {
        if( toGrantCostSharingLink == null ) {
            toGrantCostSharingLink = fetchGrantCostSharingLink();
        }
        return toGrantCostSharingLink;
    }

    /**
     * Retrieval of associated <b>GrantCostSharingLink</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_GrantCostSharingLink</b>.
     * <p>
     * If the navigation property for an entity <b>GrantCore</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_GrantCostSharingLink</b> is already loaded, the result
     *         will contain the <b>GrantCostSharingLink</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<GrantCostSharingLink>> getGrantCostSharingLinkIfPresent()
    {
        return Option.of(toGrantCostSharingLink);
    }

    /**
     * Overwrites the list of associated <b>GrantCostSharingLink</b> entities for the loaded navigation property
     * <b>to_GrantCostSharingLink</b>.
     * <p>
     * If the navigation property <b>to_GrantCostSharingLink</b> of a queried <b>GrantCore</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>GrantCostSharingLink</b> entities.
     */
    public void setGrantCostSharingLink( @Nonnull final List<GrantCostSharingLink> value )
    {
        if( toGrantCostSharingLink == null ) {
            toGrantCostSharingLink = Lists.newArrayList();
        }
        toGrantCostSharingLink.clear();
        toGrantCostSharingLink.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>GrantCostSharingLink</b> entities. This corresponds to the OData
     * navigation property <b>to_GrantCostSharingLink</b>.
     * <p>
     * If the navigation property <b>to_GrantCostSharingLink</b> of a queried <b>GrantCore</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>GrantCostSharingLink</b> entities.
     */
    public void addGrantCostSharingLink( GrantCostSharingLink... entity )
    {
        if( toGrantCostSharingLink == null ) {
            toGrantCostSharingLink = Lists.newArrayList();
        }
        toGrantCostSharingLink.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>GrantFundsLink</b> entities (one to many) associated with this entity. This corresponds to the
     * OData navigation property <b>to_GrantFundsLink</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>GrantFundsLink</b> entities. If no entities are associated then
     *         an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<GrantFundsLink> fetchGrantFundsLink()
    {
        return fetchFieldAsList("to_GrantFundsLink", GrantFundsLink.class);
    }

    /**
     * Retrieval of associated <b>GrantFundsLink</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_GrantFundsLink</b>.
     * <p>
     * If the navigation property <b>to_GrantFundsLink</b> of a queried <b>GrantCore</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>GrantFundsLink</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<GrantFundsLink> getGrantFundsLinkOrFetch()
    {
        if( toGrantFundsLink == null ) {
            toGrantFundsLink = fetchGrantFundsLink();
        }
        return toGrantFundsLink;
    }

    /**
     * Retrieval of associated <b>GrantFundsLink</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_GrantFundsLink</b>.
     * <p>
     * If the navigation property for an entity <b>GrantCore</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_GrantFundsLink</b> is already loaded, the result will
     *         contain the <b>GrantFundsLink</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<GrantFundsLink>> getGrantFundsLinkIfPresent()
    {
        return Option.of(toGrantFundsLink);
    }

    /**
     * Overwrites the list of associated <b>GrantFundsLink</b> entities for the loaded navigation property
     * <b>to_GrantFundsLink</b>.
     * <p>
     * If the navigation property <b>to_GrantFundsLink</b> of a queried <b>GrantCore</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>GrantFundsLink</b> entities.
     */
    public void setGrantFundsLink( @Nonnull final List<GrantFundsLink> value )
    {
        if( toGrantFundsLink == null ) {
            toGrantFundsLink = Lists.newArrayList();
        }
        toGrantFundsLink.clear();
        toGrantFundsLink.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>GrantFundsLink</b> entities. This corresponds to the OData navigation
     * property <b>to_GrantFundsLink</b>.
     * <p>
     * If the navigation property <b>to_GrantFundsLink</b> of a queried <b>GrantCore</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>GrantFundsLink</b> entities.
     */
    public void addGrantFundsLink( GrantFundsLink... entity )
    {
        if( toGrantFundsLink == null ) {
            toGrantFundsLink = Lists.newArrayList();
        }
        toGrantFundsLink.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>GrantObjOvrHeadCostCapLink</b> entities (one to many) associated with this entity. This
     * corresponds to the OData navigation property <b>to_GrantObjOvrHeadCostCapLink</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>GrantObjOvrHeadCostCapLink</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<GrantObjOvrHeadCostCapLink> fetchGrantObjOvrHeadCostCapLink()
    {
        return fetchFieldAsList("to_GrantObjOvrHeadCostCapLink", GrantObjOvrHeadCostCapLink.class);
    }

    /**
     * Retrieval of associated <b>GrantObjOvrHeadCostCapLink</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_GrantObjOvrHeadCostCapLink</b>.
     * <p>
     * If the navigation property <b>to_GrantObjOvrHeadCostCapLink</b> of a queried <b>GrantCore</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>GrantObjOvrHeadCostCapLink</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<GrantObjOvrHeadCostCapLink> getGrantObjOvrHeadCostCapLinkOrFetch()
    {
        if( toGrantObjOvrHeadCostCapLink == null ) {
            toGrantObjOvrHeadCostCapLink = fetchGrantObjOvrHeadCostCapLink();
        }
        return toGrantObjOvrHeadCostCapLink;
    }

    /**
     * Retrieval of associated <b>GrantObjOvrHeadCostCapLink</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_GrantObjOvrHeadCostCapLink</b>.
     * <p>
     * If the navigation property for an entity <b>GrantCore</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_GrantObjOvrHeadCostCapLink</b> is already loaded, the
     *         result will contain the <b>GrantObjOvrHeadCostCapLink</b> entities. If not, an <code>Option</code> with
     *         result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<GrantObjOvrHeadCostCapLink>> getGrantObjOvrHeadCostCapLinkIfPresent()
    {
        return Option.of(toGrantObjOvrHeadCostCapLink);
    }

    /**
     * Overwrites the list of associated <b>GrantObjOvrHeadCostCapLink</b> entities for the loaded navigation property
     * <b>to_GrantObjOvrHeadCostCapLink</b>.
     * <p>
     * If the navigation property <b>to_GrantObjOvrHeadCostCapLink</b> of a queried <b>GrantCore</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>GrantObjOvrHeadCostCapLink</b> entities.
     */
    public void setGrantObjOvrHeadCostCapLink( @Nonnull final List<GrantObjOvrHeadCostCapLink> value )
    {
        if( toGrantObjOvrHeadCostCapLink == null ) {
            toGrantObjOvrHeadCostCapLink = Lists.newArrayList();
        }
        toGrantObjOvrHeadCostCapLink.clear();
        toGrantObjOvrHeadCostCapLink.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>GrantObjOvrHeadCostCapLink</b> entities. This corresponds to the OData
     * navigation property <b>to_GrantObjOvrHeadCostCapLink</b>.
     * <p>
     * If the navigation property <b>to_GrantObjOvrHeadCostCapLink</b> of a queried <b>GrantCore</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>GrantObjOvrHeadCostCapLink</b> entities.
     */
    public void addGrantObjOvrHeadCostCapLink( GrantObjOvrHeadCostCapLink... entity )
    {
        if( toGrantObjOvrHeadCostCapLink == null ) {
            toGrantObjOvrHeadCostCapLink = Lists.newArrayList();
        }
        toGrantObjOvrHeadCostCapLink.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>GrantOverHeadCostCapLink</b> entities (one to many) associated with this entity. This corresponds
     * to the OData navigation property <b>to_GrantOverHeadCostCapLink</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>GrantOverHeadCostCapLink</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<GrantOverHeadCostCapLink> fetchGrantOverHeadCostCapLink()
    {
        return fetchFieldAsList("to_GrantOverHeadCostCapLink", GrantOverHeadCostCapLink.class);
    }

    /**
     * Retrieval of associated <b>GrantOverHeadCostCapLink</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_GrantOverHeadCostCapLink</b>.
     * <p>
     * If the navigation property <b>to_GrantOverHeadCostCapLink</b> of a queried <b>GrantCore</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>GrantOverHeadCostCapLink</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<GrantOverHeadCostCapLink> getGrantOverHeadCostCapLinkOrFetch()
    {
        if( toGrantOverHeadCostCapLink == null ) {
            toGrantOverHeadCostCapLink = fetchGrantOverHeadCostCapLink();
        }
        return toGrantOverHeadCostCapLink;
    }

    /**
     * Retrieval of associated <b>GrantOverHeadCostCapLink</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_GrantOverHeadCostCapLink</b>.
     * <p>
     * If the navigation property for an entity <b>GrantCore</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_GrantOverHeadCostCapLink</b> is already loaded, the
     *         result will contain the <b>GrantOverHeadCostCapLink</b> entities. If not, an <code>Option</code> with
     *         result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<GrantOverHeadCostCapLink>> getGrantOverHeadCostCapLinkIfPresent()
    {
        return Option.of(toGrantOverHeadCostCapLink);
    }

    /**
     * Overwrites the list of associated <b>GrantOverHeadCostCapLink</b> entities for the loaded navigation property
     * <b>to_GrantOverHeadCostCapLink</b>.
     * <p>
     * If the navigation property <b>to_GrantOverHeadCostCapLink</b> of a queried <b>GrantCore</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>GrantOverHeadCostCapLink</b> entities.
     */
    public void setGrantOverHeadCostCapLink( @Nonnull final List<GrantOverHeadCostCapLink> value )
    {
        if( toGrantOverHeadCostCapLink == null ) {
            toGrantOverHeadCostCapLink = Lists.newArrayList();
        }
        toGrantOverHeadCostCapLink.clear();
        toGrantOverHeadCostCapLink.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>GrantOverHeadCostCapLink</b> entities. This corresponds to the OData
     * navigation property <b>to_GrantOverHeadCostCapLink</b>.
     * <p>
     * If the navigation property <b>to_GrantOverHeadCostCapLink</b> of a queried <b>GrantCore</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>GrantOverHeadCostCapLink</b> entities.
     */
    public void addGrantOverHeadCostCapLink( GrantOverHeadCostCapLink... entity )
    {
        if( toGrantOverHeadCostCapLink == null ) {
            toGrantOverHeadCostCapLink = Lists.newArrayList();
        }
        toGrantOverHeadCostCapLink.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>GrantOverHeadCostLink</b> entities (one to many) associated with this entity. This corresponds to
     * the OData navigation property <b>to_GrantOverHeadCostLink</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>GrantOverHeadCostLink</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<GrantOverHeadCostLink> fetchGrantOverHeadCostLink()
    {
        return fetchFieldAsList("to_GrantOverHeadCostLink", GrantOverHeadCostLink.class);
    }

    /**
     * Retrieval of associated <b>GrantOverHeadCostLink</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_GrantOverHeadCostLink</b>.
     * <p>
     * If the navigation property <b>to_GrantOverHeadCostLink</b> of a queried <b>GrantCore</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>GrantOverHeadCostLink</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<GrantOverHeadCostLink> getGrantOverHeadCostLinkOrFetch()
    {
        if( toGrantOverHeadCostLink == null ) {
            toGrantOverHeadCostLink = fetchGrantOverHeadCostLink();
        }
        return toGrantOverHeadCostLink;
    }

    /**
     * Retrieval of associated <b>GrantOverHeadCostLink</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_GrantOverHeadCostLink</b>.
     * <p>
     * If the navigation property for an entity <b>GrantCore</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_GrantOverHeadCostLink</b> is already loaded, the result
     *         will contain the <b>GrantOverHeadCostLink</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<GrantOverHeadCostLink>> getGrantOverHeadCostLinkIfPresent()
    {
        return Option.of(toGrantOverHeadCostLink);
    }

    /**
     * Overwrites the list of associated <b>GrantOverHeadCostLink</b> entities for the loaded navigation property
     * <b>to_GrantOverHeadCostLink</b>.
     * <p>
     * If the navigation property <b>to_GrantOverHeadCostLink</b> of a queried <b>GrantCore</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>GrantOverHeadCostLink</b> entities.
     */
    public void setGrantOverHeadCostLink( @Nonnull final List<GrantOverHeadCostLink> value )
    {
        if( toGrantOverHeadCostLink == null ) {
            toGrantOverHeadCostLink = Lists.newArrayList();
        }
        toGrantOverHeadCostLink.clear();
        toGrantOverHeadCostLink.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>GrantOverHeadCostLink</b> entities. This corresponds to the OData
     * navigation property <b>to_GrantOverHeadCostLink</b>.
     * <p>
     * If the navigation property <b>to_GrantOverHeadCostLink</b> of a queried <b>GrantCore</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>GrantOverHeadCostLink</b> entities.
     */
    public void addGrantOverHeadCostLink( GrantOverHeadCostLink... entity )
    {
        if( toGrantOverHeadCostLink == null ) {
            toGrantOverHeadCostLink = Lists.newArrayList();
        }
        toGrantOverHeadCostLink.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>GrantSponsoredClassesLink</b> entities (one to many) associated with this entity. This corresponds
     * to the OData navigation property <b>to_GrantSponsoredClassesLink</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>GrantSponsoredClassesLink</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<GrantSponsoredClassesLink> fetchGrantSponsoredClassesLink()
    {
        return fetchFieldAsList("to_GrantSponsoredClassesLink", GrantSponsoredClassesLink.class);
    }

    /**
     * Retrieval of associated <b>GrantSponsoredClassesLink</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_GrantSponsoredClassesLink</b>.
     * <p>
     * If the navigation property <b>to_GrantSponsoredClassesLink</b> of a queried <b>GrantCore</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>GrantSponsoredClassesLink</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<GrantSponsoredClassesLink> getGrantSponsoredClassesLinkOrFetch()
    {
        if( toGrantSponsoredClassesLink == null ) {
            toGrantSponsoredClassesLink = fetchGrantSponsoredClassesLink();
        }
        return toGrantSponsoredClassesLink;
    }

    /**
     * Retrieval of associated <b>GrantSponsoredClassesLink</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_GrantSponsoredClassesLink</b>.
     * <p>
     * If the navigation property for an entity <b>GrantCore</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_GrantSponsoredClassesLink</b> is already loaded, the
     *         result will contain the <b>GrantSponsoredClassesLink</b> entities. If not, an <code>Option</code> with
     *         result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<GrantSponsoredClassesLink>> getGrantSponsoredClassesLinkIfPresent()
    {
        return Option.of(toGrantSponsoredClassesLink);
    }

    /**
     * Overwrites the list of associated <b>GrantSponsoredClassesLink</b> entities for the loaded navigation property
     * <b>to_GrantSponsoredClassesLink</b>.
     * <p>
     * If the navigation property <b>to_GrantSponsoredClassesLink</b> of a queried <b>GrantCore</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>GrantSponsoredClassesLink</b> entities.
     */
    public void setGrantSponsoredClassesLink( @Nonnull final List<GrantSponsoredClassesLink> value )
    {
        if( toGrantSponsoredClassesLink == null ) {
            toGrantSponsoredClassesLink = Lists.newArrayList();
        }
        toGrantSponsoredClassesLink.clear();
        toGrantSponsoredClassesLink.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>GrantSponsoredClassesLink</b> entities. This corresponds to the OData
     * navigation property <b>to_GrantSponsoredClassesLink</b>.
     * <p>
     * If the navigation property <b>to_GrantSponsoredClassesLink</b> of a queried <b>GrantCore</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>GrantSponsoredClassesLink</b> entities.
     */
    public void addGrantSponsoredClassesLink( GrantSponsoredClassesLink... entity )
    {
        if( toGrantSponsoredClassesLink == null ) {
            toGrantSponsoredClassesLink = Lists.newArrayList();
        }
        toGrantSponsoredClassesLink.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>GrantSponsoredProgramsLink</b> entities (one to many) associated with this entity. This
     * corresponds to the OData navigation property <b>to_GrantSponsoredProgramsLink</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>GrantSponsoredProgramsLink</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<GrantSponsoredProgramsLink> fetchGrantSponsoredProgramsLink()
    {
        return fetchFieldAsList("to_GrantSponsoredProgramsLink", GrantSponsoredProgramsLink.class);
    }

    /**
     * Retrieval of associated <b>GrantSponsoredProgramsLink</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_GrantSponsoredProgramsLink</b>.
     * <p>
     * If the navigation property <b>to_GrantSponsoredProgramsLink</b> of a queried <b>GrantCore</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>GrantSponsoredProgramsLink</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<GrantSponsoredProgramsLink> getGrantSponsoredProgramsLinkOrFetch()
    {
        if( toGrantSponsoredProgramsLink == null ) {
            toGrantSponsoredProgramsLink = fetchGrantSponsoredProgramsLink();
        }
        return toGrantSponsoredProgramsLink;
    }

    /**
     * Retrieval of associated <b>GrantSponsoredProgramsLink</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_GrantSponsoredProgramsLink</b>.
     * <p>
     * If the navigation property for an entity <b>GrantCore</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_GrantSponsoredProgramsLink</b> is already loaded, the
     *         result will contain the <b>GrantSponsoredProgramsLink</b> entities. If not, an <code>Option</code> with
     *         result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<GrantSponsoredProgramsLink>> getGrantSponsoredProgramsLinkIfPresent()
    {
        return Option.of(toGrantSponsoredProgramsLink);
    }

    /**
     * Overwrites the list of associated <b>GrantSponsoredProgramsLink</b> entities for the loaded navigation property
     * <b>to_GrantSponsoredProgramsLink</b>.
     * <p>
     * If the navigation property <b>to_GrantSponsoredProgramsLink</b> of a queried <b>GrantCore</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>GrantSponsoredProgramsLink</b> entities.
     */
    public void setGrantSponsoredProgramsLink( @Nonnull final List<GrantSponsoredProgramsLink> value )
    {
        if( toGrantSponsoredProgramsLink == null ) {
            toGrantSponsoredProgramsLink = Lists.newArrayList();
        }
        toGrantSponsoredProgramsLink.clear();
        toGrantSponsoredProgramsLink.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>GrantSponsoredProgramsLink</b> entities. This corresponds to the OData
     * navigation property <b>to_GrantSponsoredProgramsLink</b>.
     * <p>
     * If the navigation property <b>to_GrantSponsoredProgramsLink</b> of a queried <b>GrantCore</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>GrantSponsoredProgramsLink</b> entities.
     */
    public void addGrantSponsoredProgramsLink( GrantSponsoredProgramsLink... entity )
    {
        if( toGrantSponsoredProgramsLink == null ) {
            toGrantSponsoredProgramsLink = Lists.newArrayList();
        }
        toGrantSponsoredProgramsLink.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>GrantCoreText</b> entities (one to many) associated with this entity. This corresponds to the
     * OData navigation property <b>to_Text</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>GrantCoreText</b> entities. If no entities are associated then
     *         an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<GrantCoreText> fetchText()
    {
        return fetchFieldAsList("to_Text", GrantCoreText.class);
    }

    /**
     * Retrieval of associated <b>GrantCoreText</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_Text</b>.
     * <p>
     * If the navigation property <b>to_Text</b> of a queried <b>GrantCore</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>GrantCoreText</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<GrantCoreText> getTextOrFetch()
    {
        if( toText == null ) {
            toText = fetchText();
        }
        return toText;
    }

    /**
     * Retrieval of associated <b>GrantCoreText</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_Text</b>.
     * <p>
     * If the navigation property for an entity <b>GrantCore</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_Text</b> is already loaded, the result will contain the
     *         <b>GrantCoreText</b> entities. If not, an <code>Option</code> with result state <code>empty</code> is
     *         returned.
     */
    @Nonnull
    public Option<List<GrantCoreText>> getTextIfPresent()
    {
        return Option.of(toText);
    }

    /**
     * Overwrites the list of associated <b>GrantCoreText</b> entities for the loaded navigation property
     * <b>to_Text</b>.
     * <p>
     * If the navigation property <b>to_Text</b> of a queried <b>GrantCore</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>GrantCoreText</b> entities.
     */
    public void setText( @Nonnull final List<GrantCoreText> value )
    {
        if( toText == null ) {
            toText = Lists.newArrayList();
        }
        toText.clear();
        toText.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>GrantCoreText</b> entities. This corresponds to the OData navigation
     * property <b>to_Text</b>.
     * <p>
     * If the navigation property <b>to_Text</b> of a queried <b>GrantCore</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>GrantCoreText</b> entities.
     */
    public void addText( GrantCoreText... entity )
    {
        if( toText == null ) {
            toText = Lists.newArrayList();
        }
        toText.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of GrantCore instances.
     *
     */
    public final static class GrantCoreBuilder
    {

        private List<GrantBdgtValidityLink> toGrantBdgtValidityLink = Lists.newArrayList();
        private List<GrantCostSharingLink> toGrantCostSharingLink = Lists.newArrayList();
        private List<GrantFundsLink> toGrantFundsLink = Lists.newArrayList();
        private List<GrantObjOvrHeadCostCapLink> toGrantObjOvrHeadCostCapLink = Lists.newArrayList();
        private List<GrantOverHeadCostCapLink> toGrantOverHeadCostCapLink = Lists.newArrayList();
        private List<GrantOverHeadCostLink> toGrantOverHeadCostLink = Lists.newArrayList();
        private List<GrantSponsoredClassesLink> toGrantSponsoredClassesLink = Lists.newArrayList();
        private List<GrantSponsoredProgramsLink> toGrantSponsoredProgramsLink = Lists.newArrayList();
        private List<GrantCoreText> toText = Lists.newArrayList();

        private GrantCore.GrantCoreBuilder toGrantBdgtValidityLink( final List<GrantBdgtValidityLink> value )
        {
            toGrantBdgtValidityLink.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_GrantBdgtValidityLink</b> for <b>GrantCore</b> to multiple
         * <b>GrantBdgtValidityLink</b>.
         *
         * @param value
         *            The GrantBdgtValidityLinks to build this GrantCore with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public GrantCore.GrantCoreBuilder grantBdgtValidityLink( GrantBdgtValidityLink... value )
        {
            return toGrantBdgtValidityLink(Lists.newArrayList(value));
        }

        private GrantCore.GrantCoreBuilder toGrantCostSharingLink( final List<GrantCostSharingLink> value )
        {
            toGrantCostSharingLink.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_GrantCostSharingLink</b> for <b>GrantCore</b> to multiple
         * <b>GrantCostSharingLink</b>.
         *
         * @param value
         *            The GrantCostSharingLinks to build this GrantCore with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public GrantCore.GrantCoreBuilder grantCostSharingLink( GrantCostSharingLink... value )
        {
            return toGrantCostSharingLink(Lists.newArrayList(value));
        }

        private GrantCore.GrantCoreBuilder toGrantFundsLink( final List<GrantFundsLink> value )
        {
            toGrantFundsLink.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_GrantFundsLink</b> for <b>GrantCore</b> to multiple <b>GrantFundsLink</b>.
         *
         * @param value
         *            The GrantFundsLinks to build this GrantCore with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public GrantCore.GrantCoreBuilder grantFundsLink( GrantFundsLink... value )
        {
            return toGrantFundsLink(Lists.newArrayList(value));
        }

        private GrantCore.GrantCoreBuilder toGrantObjOvrHeadCostCapLink( final List<GrantObjOvrHeadCostCapLink> value )
        {
            toGrantObjOvrHeadCostCapLink.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_GrantObjOvrHeadCostCapLink</b> for <b>GrantCore</b> to multiple
         * <b>GrantObjOvrHeadCostCapLink</b>.
         *
         * @param value
         *            The GrantObjOvrHeadCostCapLinks to build this GrantCore with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public GrantCore.GrantCoreBuilder grantObjOvrHeadCostCapLink( GrantObjOvrHeadCostCapLink... value )
        {
            return toGrantObjOvrHeadCostCapLink(Lists.newArrayList(value));
        }

        private GrantCore.GrantCoreBuilder toGrantOverHeadCostCapLink( final List<GrantOverHeadCostCapLink> value )
        {
            toGrantOverHeadCostCapLink.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_GrantOverHeadCostCapLink</b> for <b>GrantCore</b> to multiple
         * <b>GrantOverHeadCostCapLink</b>.
         *
         * @param value
         *            The GrantOverHeadCostCapLinks to build this GrantCore with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public GrantCore.GrantCoreBuilder grantOverHeadCostCapLink( GrantOverHeadCostCapLink... value )
        {
            return toGrantOverHeadCostCapLink(Lists.newArrayList(value));
        }

        private GrantCore.GrantCoreBuilder toGrantOverHeadCostLink( final List<GrantOverHeadCostLink> value )
        {
            toGrantOverHeadCostLink.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_GrantOverHeadCostLink</b> for <b>GrantCore</b> to multiple
         * <b>GrantOverHeadCostLink</b>.
         *
         * @param value
         *            The GrantOverHeadCostLinks to build this GrantCore with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public GrantCore.GrantCoreBuilder grantOverHeadCostLink( GrantOverHeadCostLink... value )
        {
            return toGrantOverHeadCostLink(Lists.newArrayList(value));
        }

        private GrantCore.GrantCoreBuilder toGrantSponsoredClassesLink( final List<GrantSponsoredClassesLink> value )
        {
            toGrantSponsoredClassesLink.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_GrantSponsoredClassesLink</b> for <b>GrantCore</b> to multiple
         * <b>GrantSponsoredClassesLink</b>.
         *
         * @param value
         *            The GrantSponsoredClassesLinks to build this GrantCore with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public GrantCore.GrantCoreBuilder grantSponsoredClassesLink( GrantSponsoredClassesLink... value )
        {
            return toGrantSponsoredClassesLink(Lists.newArrayList(value));
        }

        private GrantCore.GrantCoreBuilder toGrantSponsoredProgramsLink( final List<GrantSponsoredProgramsLink> value )
        {
            toGrantSponsoredProgramsLink.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_GrantSponsoredProgramsLink</b> for <b>GrantCore</b> to multiple
         * <b>GrantSponsoredProgramsLink</b>.
         *
         * @param value
         *            The GrantSponsoredProgramsLinks to build this GrantCore with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public GrantCore.GrantCoreBuilder grantSponsoredProgramsLink( GrantSponsoredProgramsLink... value )
        {
            return toGrantSponsoredProgramsLink(Lists.newArrayList(value));
        }

        private GrantCore.GrantCoreBuilder toText( final List<GrantCoreText> value )
        {
            toText.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_Text</b> for <b>GrantCore</b> to multiple <b>GrantCoreText</b>.
         *
         * @param value
         *            The GrantCoreTexts to build this GrantCore with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public GrantCore.GrantCoreBuilder text( GrantCoreText... value )
        {
            return toText(Lists.newArrayList(value));
        }

    }

}
