/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.selectable.GrantCostSharingLinkSelectable;

/**
 * Fluent helper to fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantCostSharingLink
 * GrantCostSharingLink} entity using key fields. This fluent helper allows methods which modify the underlying query to
 * be called before executing the query itself.
 *
 */
public class GrantCostSharingLinkByKeyFluentHelper
    extends
    FluentHelperByKey<GrantCostSharingLinkByKeyFluentHelper, GrantCostSharingLink, GrantCostSharingLinkSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantCostSharingLink GrantCostSharingLink}
     * entity with the provided key field values. To perform execution, call the {@link #executeRequest executeRequest}
     * method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code GrantCostSharingLink}
     * @param financialManagementArea
     *            Financial Management Area
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param grantID
     *            Grant
     *            <p>
     *            Constraints: Not nullable, Maximum length: 20
     *            </p>
     * @param sponsoredClass
     *            Sponsored Class
     *            <p>
     *            Constraints: Not nullable, Maximum length: 20
     *            </p>
     * @param fund
     *            Fund
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param servicePath
     *            Service path to be used to fetch a single {@code GrantCostSharingLink}
     * @param gteeMCostSharingSource
     *            Cost Sharing Source
     *            <p>
     *            Constraints: Not nullable, Maximum length: 1
     *            </p>
     * @param sponsoredProgram
     *            Sponsored Program
     *            <p>
     *            Constraints: Not nullable, Maximum length: 20
     *            </p>
     */
    public GrantCostSharingLinkByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String grantID,
        final String financialManagementArea,
        final String fund,
        final String sponsoredProgram,
        final String sponsoredClass,
        final String gteeMCostSharingSource )
    {
        super(servicePath, entityCollection);
        this.key.put("GrantID", grantID);
        this.key.put("FinancialManagementArea", financialManagementArea);
        this.key.put("Fund", fund);
        this.key.put("SponsoredProgram", sponsoredProgram);
        this.key.put("SponsoredClass", sponsoredClass);
        this.key.put("GteeMCostSharingSource", gteeMCostSharingSource);
    }

    @Override
    @Nonnull
    protected Class<GrantCostSharingLink> getEntityClass()
    {
        return GrantCostSharingLink.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
