/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.field.GrantObjOvrHeadCostCapLinkField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.link.GrantObjOvrHeadCostCapLinkOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.selectable.GrantObjOvrHeadCostCapLinkSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Object Overhead Cost Cap for Grant
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>GrantObjOvrHeadCostCapLink_Type</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class GrantObjOvrHeadCostCapLink extends VdmEntity<GrantObjOvrHeadCostCapLink>
{

    /**
     * Selector for all available fields of GrantObjOvrHeadCostCapLink.
     *
     */
    public final static GrantObjOvrHeadCostCapLinkSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>GrantID</b>
     * </p>
     *
     * @return Grant
     */
    @Key
    @SerializedName( "GrantID" )
    @JsonProperty( "GrantID" )
    @Nullable
    @ODataField( odataName = "GrantID" )
    private String grantID;
    /**
     * Use with available fluent helpers to apply the <b>GrantID</b> field to query operations.
     *
     */
    public final static GrantObjOvrHeadCostCapLinkField<String> GRANT_ID =
        new GrantObjOvrHeadCostCapLinkField<String>("GrantID");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>SponsoredProgram</b>
     * </p>
     *
     * @return Sponsored Program
     */
    @Key
    @SerializedName( "SponsoredProgram" )
    @JsonProperty( "SponsoredProgram" )
    @Nullable
    @ODataField( odataName = "SponsoredProgram" )
    private String sponsoredProgram;
    /**
     * Use with available fluent helpers to apply the <b>SponsoredProgram</b> field to query operations.
     *
     */
    public final static GrantObjOvrHeadCostCapLinkField<String> SPONSORED_PROGRAM =
        new GrantObjOvrHeadCostCapLinkField<String>("SponsoredProgram");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>SponsoredClass</b>
     * </p>
     *
     * @return Sponsored Class
     */
    @Key
    @SerializedName( "SponsoredClass" )
    @JsonProperty( "SponsoredClass" )
    @Nullable
    @ODataField( odataName = "SponsoredClass" )
    private String sponsoredClass;
    /**
     * Use with available fluent helpers to apply the <b>SponsoredClass</b> field to query operations.
     *
     */
    public final static GrantObjOvrHeadCostCapLinkField<String> SPONSORED_CLASS =
        new GrantObjOvrHeadCostCapLinkField<String>("SponsoredClass");
    /**
     * (Key Field) Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityStartDate</b>
     * </p>
     *
     * @return Valid-from Date
     */
    @Key
    @SerializedName( "ValidityStartDate" )
    @JsonProperty( "ValidityStartDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ValidityStartDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime validityStartDate;
    /**
     * Use with available fluent helpers to apply the <b>ValidityStartDate</b> field to query operations.
     *
     */
    public final static GrantObjOvrHeadCostCapLinkField<LocalDateTime> VALIDITY_START_DATE =
        new GrantObjOvrHeadCostCapLinkField<LocalDateTime>("ValidityStartDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityEndDate</b>
     * </p>
     *
     * @return Valid-to Date
     */
    @SerializedName( "ValidityEndDate" )
    @JsonProperty( "ValidityEndDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ValidityEndDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime validityEndDate;
    /**
     * Use with available fluent helpers to apply the <b>ValidityEndDate</b> field to query operations.
     *
     */
    public final static GrantObjOvrHeadCostCapLinkField<LocalDateTime> VALIDITY_END_DATE =
        new GrantObjOvrHeadCostCapLinkField<LocalDateTime>("ValidityEndDate");
    /**
     * Constraints: Not nullable, Precision: 12, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>OverheadCostCapAmount</b>
     * </p>
     *
     * @return Maximum IDC allowed
     */
    @SerializedName( "OverheadCostCapAmount" )
    @JsonProperty( "OverheadCostCapAmount" )
    @Nullable
    @ODataField( odataName = "OverheadCostCapAmount" )
    private BigDecimal overheadCostCapAmount;
    /**
     * Use with available fluent helpers to apply the <b>OverheadCostCapAmount</b> field to query operations.
     *
     */
    public final static GrantObjOvrHeadCostCapLinkField<BigDecimal> OVERHEAD_COST_CAP_AMOUNT =
        new GrantObjOvrHeadCostCapLinkField<BigDecimal>("OverheadCostCapAmount");
    /**
     * Constraints: Not nullable, Precision: 12, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>UsedOverheadCostCapAmount</b>
     * </p>
     *
     * @return Running Total (Accumulator)
     */
    @SerializedName( "UsedOverheadCostCapAmount" )
    @JsonProperty( "UsedOverheadCostCapAmount" )
    @Nullable
    @ODataField( odataName = "UsedOverheadCostCapAmount" )
    private BigDecimal usedOverheadCostCapAmount;
    /**
     * Use with available fluent helpers to apply the <b>UsedOverheadCostCapAmount</b> field to query operations.
     *
     */
    public final static GrantObjOvrHeadCostCapLinkField<BigDecimal> USED_OVERHEAD_COST_CAP_AMOUNT =
        new GrantObjOvrHeadCostCapLinkField<BigDecimal>("UsedOverheadCostCapAmount");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>GrantCurrency</b>
     * </p>
     *
     * @return Grant currency
     */
    @SerializedName( "GrantCurrency" )
    @JsonProperty( "GrantCurrency" )
    @Nullable
    @ODataField( odataName = "GrantCurrency" )
    private String grantCurrency;
    /**
     * Use with available fluent helpers to apply the <b>GrantCurrency</b> field to query operations.
     *
     */
    public final static GrantObjOvrHeadCostCapLinkField<String> GRANT_CURRENCY =
        new GrantObjOvrHeadCostCapLinkField<String>("GrantCurrency");
    /**
     * Navigation property <b>to_Grant</b> for <b>GrantObjOvrHeadCostCapLink</b> to single <b>GrantCore</b>.
     *
     */
    @SerializedName( "to_Grant" )
    @JsonProperty( "to_Grant" )
    @ODataField( odataName = "to_Grant" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private GrantCore toGrant;
    /**
     * Use with available fluent helpers to apply the <b>to_Grant</b> navigation property to query operations.
     *
     */
    public final static GrantObjOvrHeadCostCapLinkOneToOneLink<GrantCore> TO_GRANT =
        new GrantObjOvrHeadCostCapLinkOneToOneLink<GrantCore>("to_Grant");

    @Nonnull
    @Override
    public Class<GrantObjOvrHeadCostCapLink> getType()
    {
        return GrantObjOvrHeadCostCapLink.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>GrantID</b>
     * </p>
     *
     * @param grantID
     *            Grant
     */
    public void setGrantID( @Nullable final String grantID )
    {
        rememberChangedField("GrantID", this.grantID);
        this.grantID = grantID;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>SponsoredProgram</b>
     * </p>
     *
     * @param sponsoredProgram
     *            Sponsored Program
     */
    public void setSponsoredProgram( @Nullable final String sponsoredProgram )
    {
        rememberChangedField("SponsoredProgram", this.sponsoredProgram);
        this.sponsoredProgram = sponsoredProgram;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>SponsoredClass</b>
     * </p>
     *
     * @param sponsoredClass
     *            Sponsored Class
     */
    public void setSponsoredClass( @Nullable final String sponsoredClass )
    {
        rememberChangedField("SponsoredClass", this.sponsoredClass);
        this.sponsoredClass = sponsoredClass;
    }

    /**
     * (Key Field) Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityStartDate</b>
     * </p>
     *
     * @param validityStartDate
     *            Valid-from Date
     */
    public void setValidityStartDate( @Nullable final LocalDateTime validityStartDate )
    {
        rememberChangedField("ValidityStartDate", this.validityStartDate);
        this.validityStartDate = validityStartDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityEndDate</b>
     * </p>
     *
     * @param validityEndDate
     *            Valid-to Date
     */
    public void setValidityEndDate( @Nullable final LocalDateTime validityEndDate )
    {
        rememberChangedField("ValidityEndDate", this.validityEndDate);
        this.validityEndDate = validityEndDate;
    }

    /**
     * Constraints: Not nullable, Precision: 12, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>OverheadCostCapAmount</b>
     * </p>
     *
     * @param overheadCostCapAmount
     *            Maximum IDC allowed
     */
    public void setOverheadCostCapAmount( @Nullable final BigDecimal overheadCostCapAmount )
    {
        rememberChangedField("OverheadCostCapAmount", this.overheadCostCapAmount);
        this.overheadCostCapAmount = overheadCostCapAmount;
    }

    /**
     * Constraints: Not nullable, Precision: 12, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>UsedOverheadCostCapAmount</b>
     * </p>
     *
     * @param usedOverheadCostCapAmount
     *            Running Total (Accumulator)
     */
    public void setUsedOverheadCostCapAmount( @Nullable final BigDecimal usedOverheadCostCapAmount )
    {
        rememberChangedField("UsedOverheadCostCapAmount", this.usedOverheadCostCapAmount);
        this.usedOverheadCostCapAmount = usedOverheadCostCapAmount;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>GrantCurrency</b>
     * </p>
     *
     * @param grantCurrency
     *            Grant currency
     */
    public void setGrantCurrency( @Nullable final String grantCurrency )
    {
        rememberChangedField("GrantCurrency", this.grantCurrency);
        this.grantCurrency = grantCurrency;
    }

    @Override
    protected String getEntityCollection()
    {
        return "GrantObjOvrHeadCostCapLink";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("GrantID", getGrantID());
        result.put("SponsoredProgram", getSponsoredProgram());
        result.put("SponsoredClass", getSponsoredClass());
        result.put("ValidityStartDate", getValidityStartDate());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("GrantID", getGrantID());
        values.put("SponsoredProgram", getSponsoredProgram());
        values.put("SponsoredClass", getSponsoredClass());
        values.put("ValidityStartDate", getValidityStartDate());
        values.put("ValidityEndDate", getValidityEndDate());
        values.put("OverheadCostCapAmount", getOverheadCostCapAmount());
        values.put("UsedOverheadCostCapAmount", getUsedOverheadCostCapAmount());
        values.put("GrantCurrency", getGrantCurrency());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("GrantID") ) {
                final Object value = values.remove("GrantID");
                if( (value == null) || (!value.equals(getGrantID())) ) {
                    setGrantID(((String) value));
                }
            }
            if( values.containsKey("SponsoredProgram") ) {
                final Object value = values.remove("SponsoredProgram");
                if( (value == null) || (!value.equals(getSponsoredProgram())) ) {
                    setSponsoredProgram(((String) value));
                }
            }
            if( values.containsKey("SponsoredClass") ) {
                final Object value = values.remove("SponsoredClass");
                if( (value == null) || (!value.equals(getSponsoredClass())) ) {
                    setSponsoredClass(((String) value));
                }
            }
            if( values.containsKey("ValidityStartDate") ) {
                final Object value = values.remove("ValidityStartDate");
                if( (value == null) || (!value.equals(getValidityStartDate())) ) {
                    setValidityStartDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ValidityEndDate") ) {
                final Object value = values.remove("ValidityEndDate");
                if( (value == null) || (!value.equals(getValidityEndDate())) ) {
                    setValidityEndDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("OverheadCostCapAmount") ) {
                final Object value = values.remove("OverheadCostCapAmount");
                if( (value == null) || (!value.equals(getOverheadCostCapAmount())) ) {
                    setOverheadCostCapAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("UsedOverheadCostCapAmount") ) {
                final Object value = values.remove("UsedOverheadCostCapAmount");
                if( (value == null) || (!value.equals(getUsedOverheadCostCapAmount())) ) {
                    setUsedOverheadCostCapAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("GrantCurrency") ) {
                final Object value = values.remove("GrantCurrency");
                if( (value == null) || (!value.equals(getGrantCurrency())) ) {
                    setGrantCurrency(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_Grant") ) {
                final Object value = (values).remove("to_Grant");
                if( value instanceof Map ) {
                    if( toGrant == null ) {
                        toGrant = new GrantCore();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toGrant.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> GrantObjOvrHeadCostCapLinkField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final Class<T> fieldType )
    {
        return new GrantObjOvrHeadCostCapLinkField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> GrantObjOvrHeadCostCapLinkField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new GrantObjOvrHeadCostCapLinkField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.GrantService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toGrant != null ) {
            (values).put("to_Grant", toGrant);
        }
        return values;
    }

    /**
     * Fetches the <b>GrantCore</b> entity (one to one) associated with this entity. This corresponds to the OData
     * navigation property <b>to_Grant</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>GrantCore</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public GrantCore fetchGrant()
    {
        return fetchFieldAsSingle("to_Grant", GrantCore.class);
    }

    /**
     * Retrieval of associated <b>GrantCore</b> entity (one to one). This corresponds to the OData navigation property
     * <b>to_Grant</b>.
     * <p>
     * If the navigation property <b>to_Grant</b> of a queried <b>GrantObjOvrHeadCostCapLink</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>GrantCore</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public GrantCore getGrantOrFetch()
    {
        if( toGrant == null ) {
            toGrant = fetchGrant();
        }
        return toGrant;
    }

    /**
     * Retrieval of associated <b>GrantCore</b> entity (one to one). This corresponds to the OData navigation property
     * <b>to_Grant</b>.
     * <p>
     * If the navigation property for an entity <b>GrantObjOvrHeadCostCapLink</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_Grant</b> is already loaded, the result will contain the
     *         <b>GrantCore</b> entity. If not, an <code>Option</code> with result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<GrantCore> getGrantIfPresent()
    {
        return Option.of(toGrant);
    }

    /**
     * Overwrites the associated <b>GrantCore</b> entity for the loaded navigation property <b>to_Grant</b>.
     *
     * @param value
     *            New <b>GrantCore</b> entity.
     */
    public void setGrant( final GrantCore value )
    {
        toGrant = value;
    }

    /**
     * Helper class to allow for fluent creation of GrantObjOvrHeadCostCapLink instances.
     *
     */
    public final static class GrantObjOvrHeadCostCapLinkBuilder
    {

        private GrantCore toGrant;

        private GrantObjOvrHeadCostCapLink.GrantObjOvrHeadCostCapLinkBuilder toGrant( final GrantCore value )
        {
            toGrant = value;
            return this;
        }

        /**
         * Navigation property <b>to_Grant</b> for <b>GrantObjOvrHeadCostCapLink</b> to single <b>GrantCore</b>.
         *
         * @param value
         *            The GrantCore to build this GrantObjOvrHeadCostCapLink with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public GrantObjOvrHeadCostCapLink.GrantObjOvrHeadCostCapLinkBuilder grant( final GrantCore value )
        {
            return toGrant(value);
        }

    }

}
