/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.field.GrantSponsoredProgramsLinkField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.link.GrantSponsoredProgramsLinkOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.selectable.GrantSponsoredProgramsLinkSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Grant Specific Sponsored Programs
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>GrantSponsoredProgramsLink_Type</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class GrantSponsoredProgramsLink extends VdmEntity<GrantSponsoredProgramsLink>
{

    /**
     * Selector for all available fields of GrantSponsoredProgramsLink.
     *
     */
    public final static GrantSponsoredProgramsLinkSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>GrantID</b>
     * </p>
     *
     * @return Grant
     */
    @Key
    @SerializedName( "GrantID" )
    @JsonProperty( "GrantID" )
    @Nullable
    @ODataField( odataName = "GrantID" )
    private String grantID;
    /**
     * Use with available fluent helpers to apply the <b>GrantID</b> field to query operations.
     *
     */
    public final static GrantSponsoredProgramsLinkField<String> GRANT_ID =
        new GrantSponsoredProgramsLinkField<String>("GrantID");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>SponsoredProgram</b>
     * </p>
     *
     * @return Sponsored Program
     */
    @Key
    @SerializedName( "SponsoredProgram" )
    @JsonProperty( "SponsoredProgram" )
    @Nullable
    @ODataField( odataName = "SponsoredProgram" )
    private String sponsoredProgram;
    /**
     * Use with available fluent helpers to apply the <b>SponsoredProgram</b> field to query operations.
     *
     */
    public final static GrantSponsoredProgramsLinkField<String> SPONSORED_PROGRAM =
        new GrantSponsoredProgramsLinkField<String>("SponsoredProgram");
    /**
     * Navigation property <b>to_Grant</b> for <b>GrantSponsoredProgramsLink</b> to single <b>GrantCore</b>.
     *
     */
    @SerializedName( "to_Grant" )
    @JsonProperty( "to_Grant" )
    @ODataField( odataName = "to_Grant" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private GrantCore toGrant;
    /**
     * Use with available fluent helpers to apply the <b>to_Grant</b> navigation property to query operations.
     *
     */
    public final static GrantSponsoredProgramsLinkOneToOneLink<GrantCore> TO_GRANT =
        new GrantSponsoredProgramsLinkOneToOneLink<GrantCore>("to_Grant");

    @Nonnull
    @Override
    public Class<GrantSponsoredProgramsLink> getType()
    {
        return GrantSponsoredProgramsLink.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>GrantID</b>
     * </p>
     *
     * @param grantID
     *            Grant
     */
    public void setGrantID( @Nullable final String grantID )
    {
        rememberChangedField("GrantID", this.grantID);
        this.grantID = grantID;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>SponsoredProgram</b>
     * </p>
     *
     * @param sponsoredProgram
     *            Sponsored Program
     */
    public void setSponsoredProgram( @Nullable final String sponsoredProgram )
    {
        rememberChangedField("SponsoredProgram", this.sponsoredProgram);
        this.sponsoredProgram = sponsoredProgram;
    }

    @Override
    protected String getEntityCollection()
    {
        return "GrantSponsoredProgramsLink";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("GrantID", getGrantID());
        result.put("SponsoredProgram", getSponsoredProgram());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("GrantID", getGrantID());
        values.put("SponsoredProgram", getSponsoredProgram());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("GrantID") ) {
                final Object value = values.remove("GrantID");
                if( (value == null) || (!value.equals(getGrantID())) ) {
                    setGrantID(((String) value));
                }
            }
            if( values.containsKey("SponsoredProgram") ) {
                final Object value = values.remove("SponsoredProgram");
                if( (value == null) || (!value.equals(getSponsoredProgram())) ) {
                    setSponsoredProgram(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_Grant") ) {
                final Object value = (values).remove("to_Grant");
                if( value instanceof Map ) {
                    if( toGrant == null ) {
                        toGrant = new GrantCore();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toGrant.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> GrantSponsoredProgramsLinkField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final Class<T> fieldType )
    {
        return new GrantSponsoredProgramsLinkField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> GrantSponsoredProgramsLinkField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new GrantSponsoredProgramsLinkField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.GrantService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toGrant != null ) {
            (values).put("to_Grant", toGrant);
        }
        return values;
    }

    /**
     * Fetches the <b>GrantCore</b> entity (one to one) associated with this entity. This corresponds to the OData
     * navigation property <b>to_Grant</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>GrantCore</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public GrantCore fetchGrant()
    {
        return fetchFieldAsSingle("to_Grant", GrantCore.class);
    }

    /**
     * Retrieval of associated <b>GrantCore</b> entity (one to one). This corresponds to the OData navigation property
     * <b>to_Grant</b>.
     * <p>
     * If the navigation property <b>to_Grant</b> of a queried <b>GrantSponsoredProgramsLink</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>GrantCore</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public GrantCore getGrantOrFetch()
    {
        if( toGrant == null ) {
            toGrant = fetchGrant();
        }
        return toGrant;
    }

    /**
     * Retrieval of associated <b>GrantCore</b> entity (one to one). This corresponds to the OData navigation property
     * <b>to_Grant</b>.
     * <p>
     * If the navigation property for an entity <b>GrantSponsoredProgramsLink</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_Grant</b> is already loaded, the result will contain the
     *         <b>GrantCore</b> entity. If not, an <code>Option</code> with result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<GrantCore> getGrantIfPresent()
    {
        return Option.of(toGrant);
    }

    /**
     * Overwrites the associated <b>GrantCore</b> entity for the loaded navigation property <b>to_Grant</b>.
     *
     * @param value
     *            New <b>GrantCore</b> entity.
     */
    public void setGrant( final GrantCore value )
    {
        toGrant = value;
    }

    /**
     * Helper class to allow for fluent creation of GrantSponsoredProgramsLink instances.
     *
     */
    public final static class GrantSponsoredProgramsLinkBuilder
    {

        private GrantCore toGrant;

        private GrantSponsoredProgramsLink.GrantSponsoredProgramsLinkBuilder toGrant( final GrantCore value )
        {
            toGrant = value;
            return this;
        }

        /**
         * Navigation property <b>to_Grant</b> for <b>GrantSponsoredProgramsLink</b> to single <b>GrantCore</b>.
         *
         * @param value
         *            The GrantCore to build this GrantSponsoredProgramsLink with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public GrantSponsoredProgramsLink.GrantSponsoredProgramsLinkBuilder grant( final GrantCore value )
        {
            return toGrant(value);
        }

    }

}
