/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.selectable.GrantSponsoredProgramsLinkSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantSponsoredProgramsLink
 * GrantSponsoredProgramsLink} entity using key fields. This fluent helper allows methods which modify the underlying
 * query to be called before executing the query itself.
 *
 */
public class GrantSponsoredProgramsLinkByKeyFluentHelper
    extends
    FluentHelperByKey<GrantSponsoredProgramsLinkByKeyFluentHelper, GrantSponsoredProgramsLink, GrantSponsoredProgramsLinkSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantSponsoredProgramsLink
     * GrantSponsoredProgramsLink} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code GrantSponsoredProgramsLink}
     * @param grantID
     *            Grant
     *            <p>
     *            Constraints: Not nullable, Maximum length: 20
     *            </p>
     * @param servicePath
     *            Service path to be used to fetch a single {@code GrantSponsoredProgramsLink}
     * @param sponsoredProgram
     *            Sponsored Program
     *            <p>
     *            Constraints: Not nullable, Maximum length: 20
     *            </p>
     */
    public GrantSponsoredProgramsLinkByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String grantID,
        final String sponsoredProgram )
    {
        super(servicePath, entityCollection);
        this.key.put("GrantID", grantID);
        this.key.put("SponsoredProgram", sponsoredProgram);
    }

    @Override
    @Nonnull
    protected Class<GrantSponsoredProgramsLink> getEntityClass()
    {
        return GrantSponsoredProgramsLink.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
