/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchFluentHelperBasic;

/**
 * Default implementation of the {@link GrantServiceBatch} interface exposed in the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.GrantService GrantService}, allowing you to create multiple
 * changesets and finally execute the batch request.
 *
 */
public class DefaultGrantServiceBatch extends BatchFluentHelperBasic<GrantServiceBatch, GrantServiceBatchChangeSet>
    implements
    GrantServiceBatch
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.GrantService service;
    @Nonnull
    private final String servicePath;

    /**
     * Creates a new instance of this DefaultGrantServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultGrantServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.GrantService service )
    {
        this(service, com.sap.cloud.sdk.s4hana.datamodel.odata.services.GrantService.DEFAULT_SERVICE_PATH);
    }

    /**
     * Creates a new instance of this DefaultGrantServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     * @param servicePath
     *            The custom service path to operate on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultGrantServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.GrantService service,
        @Nonnull final String servicePath )
    {
        this.service = service;
        this.servicePath = servicePath;
    }

    @Nonnull
    @Override
    protected String getServicePathForBatchRequest()
    {
        return servicePath;
    }

    @Nonnull
    @Override
    protected DefaultGrantServiceBatch getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public GrantServiceBatchChangeSet beginChangeSet()
    {
        return new DefaultGrantServiceBatchChangeSet(this, service);
    }

}
