/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchChangeSetFluentHelperBasic;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantBdgtValidityLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantCore;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantCoreText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantCostSharingLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantFundsLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantObjOvrHeadCostCapLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantOverHeadCostCapLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantOverHeadCostLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantSponsoredClassesLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantSponsoredProgramsLink;

/**
 * Implementation of the {@link GrantServiceBatchChangeSet} interface, enabling you to combine multiple operations into
 * one changeset. For further information have a look into the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.GrantService GrantService}.
 *
 */
public class DefaultGrantServiceBatchChangeSet
    extends
    BatchChangeSetFluentHelperBasic<GrantServiceBatch, GrantServiceBatchChangeSet>
    implements
    GrantServiceBatchChangeSet
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.GrantService service;

    @SuppressWarnings( "deprecation" )
    DefaultGrantServiceBatchChangeSet(
        @Nonnull final DefaultGrantServiceBatch batchFluentHelper,
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.GrantService service )
    {
        super(batchFluentHelper, batchFluentHelper);
        this.service = service;
    }

    @Nonnull
    @Override
    protected DefaultGrantServiceBatchChangeSet getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public GrantServiceBatchChangeSet updateGrantBdgtValidityLink(
        @Nonnull final GrantBdgtValidityLink grantBdgtValidityLink )
    {
        return addRequestUpdate(service::updateGrantBdgtValidityLink, grantBdgtValidityLink);
    }

    @Nonnull
    @Override
    public GrantServiceBatchChangeSet deleteGrantBdgtValidityLink(
        @Nonnull final GrantBdgtValidityLink grantBdgtValidityLink )
    {
        return addRequestDelete(service::deleteGrantBdgtValidityLink, grantBdgtValidityLink);
    }

    @Nonnull
    @Override
    public GrantServiceBatchChangeSet createGrantCore( @Nonnull final GrantCore grantCore )
    {
        return addRequestCreate(service::createGrantCore, grantCore);
    }

    @Nonnull
    @Override
    public GrantServiceBatchChangeSet updateGrantCore( @Nonnull final GrantCore grantCore )
    {
        return addRequestUpdate(service::updateGrantCore, grantCore);
    }

    @Nonnull
    @Override
    public GrantServiceBatchChangeSet deleteGrantCore( @Nonnull final GrantCore grantCore )
    {
        return addRequestDelete(service::deleteGrantCore, grantCore);
    }

    @Nonnull
    @Override
    public GrantServiceBatchChangeSet updateGrantCoreText( @Nonnull final GrantCoreText grantCoreText )
    {
        return addRequestUpdate(service::updateGrantCoreText, grantCoreText);
    }

    @Nonnull
    @Override
    public GrantServiceBatchChangeSet updateGrantCostSharingLink(
        @Nonnull final GrantCostSharingLink grantCostSharingLink )
    {
        return addRequestUpdate(service::updateGrantCostSharingLink, grantCostSharingLink);
    }

    @Nonnull
    @Override
    public GrantServiceBatchChangeSet deleteGrantCostSharingLink(
        @Nonnull final GrantCostSharingLink grantCostSharingLink )
    {
        return addRequestDelete(service::deleteGrantCostSharingLink, grantCostSharingLink);
    }

    @Nonnull
    @Override
    public GrantServiceBatchChangeSet updateGrantFundsLink( @Nonnull final GrantFundsLink grantFundsLink )
    {
        return addRequestUpdate(service::updateGrantFundsLink, grantFundsLink);
    }

    @Nonnull
    @Override
    public GrantServiceBatchChangeSet deleteGrantFundsLink( @Nonnull final GrantFundsLink grantFundsLink )
    {
        return addRequestDelete(service::deleteGrantFundsLink, grantFundsLink);
    }

    @Nonnull
    @Override
    public GrantServiceBatchChangeSet updateGrantObjOvrHeadCostCapLink(
        @Nonnull final GrantObjOvrHeadCostCapLink grantObjOvrHeadCostCapLink )
    {
        return addRequestUpdate(service::updateGrantObjOvrHeadCostCapLink, grantObjOvrHeadCostCapLink);
    }

    @Nonnull
    @Override
    public GrantServiceBatchChangeSet deleteGrantObjOvrHeadCostCapLink(
        @Nonnull final GrantObjOvrHeadCostCapLink grantObjOvrHeadCostCapLink )
    {
        return addRequestDelete(service::deleteGrantObjOvrHeadCostCapLink, grantObjOvrHeadCostCapLink);
    }

    @Nonnull
    @Override
    public GrantServiceBatchChangeSet updateGrantOverHeadCostCapLink(
        @Nonnull final GrantOverHeadCostCapLink grantOverHeadCostCapLink )
    {
        return addRequestUpdate(service::updateGrantOverHeadCostCapLink, grantOverHeadCostCapLink);
    }

    @Nonnull
    @Override
    public GrantServiceBatchChangeSet deleteGrantOverHeadCostCapLink(
        @Nonnull final GrantOverHeadCostCapLink grantOverHeadCostCapLink )
    {
        return addRequestDelete(service::deleteGrantOverHeadCostCapLink, grantOverHeadCostCapLink);
    }

    @Nonnull
    @Override
    public GrantServiceBatchChangeSet updateGrantOverHeadCostLink(
        @Nonnull final GrantOverHeadCostLink grantOverHeadCostLink )
    {
        return addRequestUpdate(service::updateGrantOverHeadCostLink, grantOverHeadCostLink);
    }

    @Nonnull
    @Override
    public GrantServiceBatchChangeSet deleteGrantOverHeadCostLink(
        @Nonnull final GrantOverHeadCostLink grantOverHeadCostLink )
    {
        return addRequestDelete(service::deleteGrantOverHeadCostLink, grantOverHeadCostLink);
    }

    @Nonnull
    @Override
    public GrantServiceBatchChangeSet updateGrantSponsoredClassesLink(
        @Nonnull final GrantSponsoredClassesLink grantSponsoredClassesLink )
    {
        return addRequestUpdate(service::updateGrantSponsoredClassesLink, grantSponsoredClassesLink);
    }

    @Nonnull
    @Override
    public GrantServiceBatchChangeSet deleteGrantSponsoredClassesLink(
        @Nonnull final GrantSponsoredClassesLink grantSponsoredClassesLink )
    {
        return addRequestDelete(service::deleteGrantSponsoredClassesLink, grantSponsoredClassesLink);
    }

    @Nonnull
    @Override
    public GrantServiceBatchChangeSet updateGrantSponsoredProgramsLink(
        @Nonnull final GrantSponsoredProgramsLink grantSponsoredProgramsLink )
    {
        return addRequestUpdate(service::updateGrantSponsoredProgramsLink, grantSponsoredProgramsLink);
    }

    @Nonnull
    @Override
    public GrantServiceBatchChangeSet deleteGrantSponsoredProgramsLink(
        @Nonnull final GrantSponsoredProgramsLink grantSponsoredProgramsLink )
    {
        return addRequestDelete(service::deleteGrantSponsoredProgramsLink, grantSponsoredProgramsLink);
    }

}
