/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.FluentHelperBatchChangeSet;
import com.sap.cloud.sdk.datamodel.odata.helper.batch.FluentHelperBatchEndChangeSet;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantBdgtValidityLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantCore;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantCoreText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantCostSharingLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantFundsLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantObjOvrHeadCostCapLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantOverHeadCostCapLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantOverHeadCostLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantSponsoredClassesLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantSponsoredProgramsLink;

/**
 * This interface enables you to combine multiple operations into one change set. For further information have a look
 * into the {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.GrantService GrantService}.
 *
 */
public interface GrantServiceBatchChangeSet
    extends
    FluentHelperBatchChangeSet<GrantServiceBatchChangeSet>,
    FluentHelperBatchEndChangeSet<GrantServiceBatch>
{

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantBdgtValidityLink
     * GrantBdgtValidityLink} entity and save it to the S/4HANA system.
     *
     * @param grantBdgtValidityLink
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantBdgtValidityLink
     *            GrantBdgtValidityLink} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    GrantServiceBatchChangeSet
        updateGrantBdgtValidityLink( @Nonnull final GrantBdgtValidityLink grantBdgtValidityLink );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantBdgtValidityLink
     * GrantBdgtValidityLink} entity in the S/4HANA system.
     *
     * @param grantBdgtValidityLink
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantBdgtValidityLink
     *            GrantBdgtValidityLink} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    GrantServiceBatchChangeSet
        deleteGrantBdgtValidityLink( @Nonnull final GrantBdgtValidityLink grantBdgtValidityLink );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantCore GrantCore} entity and
     * save it to the S/4HANA system.
     *
     * @param grantCore
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantCore GrantCore} entity object
     *            that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    GrantServiceBatchChangeSet createGrantCore( @Nonnull final GrantCore grantCore );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantCore GrantCore} entity
     * and save it to the S/4HANA system.
     *
     * @param grantCore
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantCore GrantCore} entity object
     *            that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    GrantServiceBatchChangeSet updateGrantCore( @Nonnull final GrantCore grantCore );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantCore GrantCore} entity
     * in the S/4HANA system.
     *
     * @param grantCore
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantCore GrantCore} entity object
     *            that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    GrantServiceBatchChangeSet deleteGrantCore( @Nonnull final GrantCore grantCore );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantCoreText GrantCoreText}
     * entity and save it to the S/4HANA system.
     *
     * @param grantCoreText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantCoreText GrantCoreText} entity
     *            object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    GrantServiceBatchChangeSet updateGrantCoreText( @Nonnull final GrantCoreText grantCoreText );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantCostSharingLink
     * GrantCostSharingLink} entity and save it to the S/4HANA system.
     *
     * @param grantCostSharingLink
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantCostSharingLink
     *            GrantCostSharingLink} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    GrantServiceBatchChangeSet updateGrantCostSharingLink( @Nonnull final GrantCostSharingLink grantCostSharingLink );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantCostSharingLink
     * GrantCostSharingLink} entity in the S/4HANA system.
     *
     * @param grantCostSharingLink
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantCostSharingLink
     *            GrantCostSharingLink} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    GrantServiceBatchChangeSet deleteGrantCostSharingLink( @Nonnull final GrantCostSharingLink grantCostSharingLink );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantFundsLink
     * GrantFundsLink} entity and save it to the S/4HANA system.
     *
     * @param grantFundsLink
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantFundsLink GrantFundsLink} entity
     *            object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    GrantServiceBatchChangeSet updateGrantFundsLink( @Nonnull final GrantFundsLink grantFundsLink );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantFundsLink
     * GrantFundsLink} entity in the S/4HANA system.
     *
     * @param grantFundsLink
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantFundsLink GrantFundsLink} entity
     *            object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    GrantServiceBatchChangeSet deleteGrantFundsLink( @Nonnull final GrantFundsLink grantFundsLink );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantObjOvrHeadCostCapLink
     * GrantObjOvrHeadCostCapLink} entity and save it to the S/4HANA system.
     *
     * @param grantObjOvrHeadCostCapLink
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantObjOvrHeadCostCapLink
     *            GrantObjOvrHeadCostCapLink} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    GrantServiceBatchChangeSet
        updateGrantObjOvrHeadCostCapLink( @Nonnull final GrantObjOvrHeadCostCapLink grantObjOvrHeadCostCapLink );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantObjOvrHeadCostCapLink
     * GrantObjOvrHeadCostCapLink} entity in the S/4HANA system.
     *
     * @param grantObjOvrHeadCostCapLink
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantObjOvrHeadCostCapLink
     *            GrantObjOvrHeadCostCapLink} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    GrantServiceBatchChangeSet
        deleteGrantObjOvrHeadCostCapLink( @Nonnull final GrantObjOvrHeadCostCapLink grantObjOvrHeadCostCapLink );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantOverHeadCostCapLink
     * GrantOverHeadCostCapLink} entity and save it to the S/4HANA system.
     *
     * @param grantOverHeadCostCapLink
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantOverHeadCostCapLink
     *            GrantOverHeadCostCapLink} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    GrantServiceBatchChangeSet
        updateGrantOverHeadCostCapLink( @Nonnull final GrantOverHeadCostCapLink grantOverHeadCostCapLink );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantOverHeadCostCapLink
     * GrantOverHeadCostCapLink} entity in the S/4HANA system.
     *
     * @param grantOverHeadCostCapLink
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantOverHeadCostCapLink
     *            GrantOverHeadCostCapLink} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    GrantServiceBatchChangeSet
        deleteGrantOverHeadCostCapLink( @Nonnull final GrantOverHeadCostCapLink grantOverHeadCostCapLink );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantOverHeadCostLink
     * GrantOverHeadCostLink} entity and save it to the S/4HANA system.
     *
     * @param grantOverHeadCostLink
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantOverHeadCostLink
     *            GrantOverHeadCostLink} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    GrantServiceBatchChangeSet
        updateGrantOverHeadCostLink( @Nonnull final GrantOverHeadCostLink grantOverHeadCostLink );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantOverHeadCostLink
     * GrantOverHeadCostLink} entity in the S/4HANA system.
     *
     * @param grantOverHeadCostLink
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantOverHeadCostLink
     *            GrantOverHeadCostLink} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    GrantServiceBatchChangeSet
        deleteGrantOverHeadCostLink( @Nonnull final GrantOverHeadCostLink grantOverHeadCostLink );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantSponsoredClassesLink
     * GrantSponsoredClassesLink} entity and save it to the S/4HANA system.
     *
     * @param grantSponsoredClassesLink
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantSponsoredClassesLink
     *            GrantSponsoredClassesLink} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    GrantServiceBatchChangeSet
        updateGrantSponsoredClassesLink( @Nonnull final GrantSponsoredClassesLink grantSponsoredClassesLink );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantSponsoredClassesLink
     * GrantSponsoredClassesLink} entity in the S/4HANA system.
     *
     * @param grantSponsoredClassesLink
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantSponsoredClassesLink
     *            GrantSponsoredClassesLink} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    GrantServiceBatchChangeSet
        deleteGrantSponsoredClassesLink( @Nonnull final GrantSponsoredClassesLink grantSponsoredClassesLink );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantSponsoredProgramsLink
     * GrantSponsoredProgramsLink} entity and save it to the S/4HANA system.
     *
     * @param grantSponsoredProgramsLink
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantSponsoredProgramsLink
     *            GrantSponsoredProgramsLink} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    GrantServiceBatchChangeSet
        updateGrantSponsoredProgramsLink( @Nonnull final GrantSponsoredProgramsLink grantSponsoredProgramsLink );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantSponsoredProgramsLink
     * GrantSponsoredProgramsLink} entity in the S/4HANA system.
     *
     * @param grantSponsoredProgramsLink
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantSponsoredProgramsLink
     *            GrantSponsoredProgramsLink} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    GrantServiceBatchChangeSet
        deleteGrantSponsoredProgramsLink( @Nonnull final GrantSponsoredProgramsLink grantSponsoredProgramsLink );

}
