/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantBdgtValidityLink;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantBdgtValidityLink GrantBdgtValidityLink}. This
 * interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.field.GrantBdgtValidityLinkField
 * GrantBdgtValidityLinkField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.link.GrantBdgtValidityLinkLink
 * GrantBdgtValidityLinkLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantBdgtValidityLink#GRANT_ID GRANT_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantBdgtValidityLink#GRANTEE_MGMT_BDGT_PHASE
 * GRANTEE_MGMT_BDGT_PHASE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantBdgtValidityLink#GRANTEE_MGMT_BUDGET_STATUS
 * GRANTEE_MGMT_BUDGET_STATUS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantBdgtValidityLink#GTEE_M_BUDGET_VALIDITY_NUMBER
 * GTEE_M_BUDGET_VALIDITY_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantBdgtValidityLink#VALIDITY_START_DATE
 * VALIDITY_START_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantBdgtValidityLink#VALIDITY_END_DATE
 * VALIDITY_END_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantBdgtValidityLink#SPONSOR_FISCAL_YEAR
 * SPONSOR_FISCAL_YEAR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantBdgtValidityLink#GRANTEE_FISCAL_YEAR
 * GRANTEE_FISCAL_YEAR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantBdgtValidityLink#GTEE_M_BUDGET_BLOCK
 * GTEE_M_BUDGET_BLOCK}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantBdgtValidityLink#TO_GRANT TO_GRANT}</li>
 * </ul>
 *
 */
public interface GrantBdgtValidityLinkSelectable extends EntitySelectable<GrantBdgtValidityLink>
{

}
