/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantCore;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantCore GrantCore}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.field.GrantCoreField GrantCoreField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.link.GrantCoreLink GrantCoreLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantCore#GRANT_ID GRANT_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantCore#COMPANY_CODE COMPANY_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantCore#GRANT_AUTHZN_GRP
 * GRANT_AUTHZN_GRP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantCore#VALIDITY_START_DATE
 * VALIDITY_START_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantCore#VALIDITY_END_DATE
 * VALIDITY_END_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantCore#GRANT_NAME GRANT_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantCore#GRANT_DESCRIPTION
 * GRANT_DESCRIPTION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantCore#GRANT_IS_NOT_RELEVANT_GRANT
 * GRANT_IS_NOT_RELEVANT_GRANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantCore#GRANTEE_MGMT_SPONSOR
 * GRANTEE_MGMT_SPONSOR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantCore#GRANT_LFCYC_STATUS_FOR_AUTHZN
 * GRANT_LFCYC_STATUS_FOR_AUTHZN}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantCore#GRANT_TYPE GRANT_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantCore#GRANT_IS_BLOCKED_FOR_POSTING
 * GRANT_IS_BLOCKED_FOR_POSTING}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantCore#GRANT_CURRENCY GRANT_CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantCore#GRANT_TOTAL_AMOUNT_IN_GRANT_CRCY
 * GRANT_TOTAL_AMOUNT_IN_GRANT_CRCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantCore#GTEE_M_INDRCT_COST_SHRNG_RULE
 * GTEE_M_INDRCT_COST_SHRNG_RULE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantCore#GTEE_M_INDIRECT_COST_RATE_IN_PERCENT
 * GTEE_M_INDIRECT_COST_RATE_IN_PERCENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantCore#GRANT_LIFECYCLE_STATUS
 * GRANT_LIFECYCLE_STATUS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantCore#CRITICALITY CRITICALITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantCore#GRANT_STATUS_PROFILE
 * GRANT_STATUS_PROFILE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantCore#GRANT_USER_STATUS
 * GRANT_USER_STATUS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantCore#GRANTEE_MGMT_COST_SHARING_RULE
 * GRANTEE_MGMT_COST_SHARING_RULE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantCore#GTEE_M_COST_SHARING_OVERALL_RATE
 * GTEE_M_COST_SHARING_OVERALL_RATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantCore#GRANTEE_MGMT_BILLING_RULE
 * GRANTEE_MGMT_BILLING_RULE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantCore#PRE_AWARD_PSTG_IS_ALLOWED_FOR_GRANT
 * PRE_AWARD_PSTG_IS_ALLOWED_FOR_GRANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantCore#GRANT_FISCAL_YEAR_VARIANT
 * GRANT_FISCAL_YEAR_VARIANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantCore#GTEE_M_TIME_SLICE_SPLITTING_RULE
 * GTEE_M_TIME_SLICE_SPLITTING_RULE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantCore#COST_CENTER COST_CENTER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantCore#CONTROLLING_AREA
 * CONTROLLING_AREA}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantCore#GRANT_VALIDITY_PERIOD
 * GRANT_VALIDITY_PERIOD}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantCore#GRANT_BLOCKED_BY_WORKFLOW
 * GRANT_BLOCKED_BY_WORKFLOW}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantCore#TO_GRANT_BDGT_VALIDITY_LINK
 * TO_GRANT_BDGT_VALIDITY_LINK}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantCore#TO_GRANT_COST_SHARING_LINK
 * TO_GRANT_COST_SHARING_LINK}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantCore#TO_GRANT_FUNDS_LINK
 * TO_GRANT_FUNDS_LINK}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantCore#TO_GRANT_OBJ_OVR_HEAD_COST_CAP_LINK
 * TO_GRANT_OBJ_OVR_HEAD_COST_CAP_LINK}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantCore#TO_GRANT_OVER_HEAD_COST_CAP_LINK
 * TO_GRANT_OVER_HEAD_COST_CAP_LINK}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantCore#TO_GRANT_OVER_HEAD_COST_LINK
 * TO_GRANT_OVER_HEAD_COST_LINK}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantCore#TO_GRANT_SPONSORED_CLASSES_LINK
 * TO_GRANT_SPONSORED_CLASSES_LINK}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantCore#TO_GRANT_SPONSORED_PROGRAMS_LINK
 * TO_GRANT_SPONSORED_PROGRAMS_LINK}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantCore#TO_TEXT TO_TEXT}</li>
 * </ul>
 *
 */
public interface GrantCoreSelectable extends EntitySelectable<GrantCore>
{

}
