/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantCostSharingLink;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantCostSharingLink GrantCostSharingLink}. This
 * interface is used by {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.field.GrantCostSharingLinkField
 * GrantCostSharingLinkField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.link.GrantCostSharingLinkLink
 * GrantCostSharingLinkLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantCostSharingLink#GRANT_ID GRANT_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantCostSharingLink#FINANCIAL_MANAGEMENT_AREA
 * FINANCIAL_MANAGEMENT_AREA}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantCostSharingLink#FUND FUND}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantCostSharingLink#SPONSORED_PROGRAM
 * SPONSORED_PROGRAM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantCostSharingLink#SPONSORED_CLASS
 * SPONSORED_CLASS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantCostSharingLink#GTEE_M_COST_SHARING_SOURCE
 * GTEE_M_COST_SHARING_SOURCE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantCostSharingLink#GRANTEE_MGMT_COST_SHARING_TYPE
 * GRANTEE_MGMT_COST_SHARING_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantCostSharingLink#GTEE_M_COST_SHARING_RATE_IN_PERCENT
 * GTEE_M_COST_SHARING_RATE_IN_PERCENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantCostSharingLink#TO_GRANT TO_GRANT}</li>
 * </ul>
 *
 */
public interface GrantCostSharingLinkSelectable extends EntitySelectable<GrantCostSharingLink>
{

}
