/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantFundsLink;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantFundsLink GrantFundsLink}. This interface is
 * used by {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.field.GrantFundsLinkField
 * GrantFundsLinkField} and {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.link.GrantFundsLinkLink
 * GrantFundsLinkLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantFundsLink#GRANT_ID GRANT_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantFundsLink#FINANCIAL_MANAGEMENT_AREA
 * FINANCIAL_MANAGEMENT_AREA}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantFundsLink#FUND FUND}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantFundsLink#FUND_IS_RLVT_FOR_COST_SHARING
 * FUND_IS_RLVT_FOR_COST_SHARING}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantFundsLink#FUND_IS_RLVT_FOR_INDRCT_COST_RCVRY
 * FUND_IS_RLVT_FOR_INDRCT_COST_RCVRY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantFundsLink#FUND_IS_RLVT_FOR_PROGRAM_INCOME
 * FUND_IS_RLVT_FOR_PROGRAM_INCOME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantFundsLink#TO_GRANT TO_GRANT}</li>
 * </ul>
 *
 */
public interface GrantFundsLinkSelectable extends EntitySelectable<GrantFundsLink>
{

}
