/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantObjOvrHeadCostCapLink;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantObjOvrHeadCostCapLink
 * GrantObjOvrHeadCostCapLink}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.field.GrantObjOvrHeadCostCapLinkField
 * GrantObjOvrHeadCostCapLinkField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.link.GrantObjOvrHeadCostCapLinkLink
 * GrantObjOvrHeadCostCapLinkLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantObjOvrHeadCostCapLink#GRANT_ID
 * GRANT_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantObjOvrHeadCostCapLink#SPONSORED_PROGRAM
 * SPONSORED_PROGRAM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantObjOvrHeadCostCapLink#SPONSORED_CLASS
 * SPONSORED_CLASS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantObjOvrHeadCostCapLink#VALIDITY_START_DATE
 * VALIDITY_START_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantObjOvrHeadCostCapLink#VALIDITY_END_DATE
 * VALIDITY_END_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantObjOvrHeadCostCapLink#OVERHEAD_COST_CAP_AMOUNT
 * OVERHEAD_COST_CAP_AMOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantObjOvrHeadCostCapLink#USED_OVERHEAD_COST_CAP_AMOUNT
 * USED_OVERHEAD_COST_CAP_AMOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantObjOvrHeadCostCapLink#GRANT_CURRENCY
 * GRANT_CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantObjOvrHeadCostCapLink#TO_GRANT
 * TO_GRANT}</li>
 * </ul>
 *
 */
public interface GrantObjOvrHeadCostCapLinkSelectable extends EntitySelectable<GrantObjOvrHeadCostCapLink>
{

}
