/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantOverHeadCostCapLink;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantOverHeadCostCapLink GrantOverHeadCostCapLink}.
 * This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.field.GrantOverHeadCostCapLinkField
 * GrantOverHeadCostCapLinkField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.link.GrantOverHeadCostCapLinkLink
 * GrantOverHeadCostCapLinkLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantOverHeadCostCapLink#GRANT_ID GRANT_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantOverHeadCostCapLink#VALIDITY_START_DATE
 * VALIDITY_START_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantOverHeadCostCapLink#VALIDITY_END_DATE
 * VALIDITY_END_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantOverHeadCostCapLink#OVERHEAD_COST_CAP_AMOUNT
 * OVERHEAD_COST_CAP_AMOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantOverHeadCostCapLink#USED_OVERHEAD_COST_CAP_AMOUNT
 * USED_OVERHEAD_COST_CAP_AMOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantOverHeadCostCapLink#GRANT_CURRENCY
 * GRANT_CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantOverHeadCostCapLink#TO_GRANT TO_GRANT}</li>
 * </ul>
 *
 */
public interface GrantOverHeadCostCapLinkSelectable extends EntitySelectable<GrantOverHeadCostCapLink>
{

}
