/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantOverHeadCostLink;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantOverHeadCostLink GrantOverHeadCostLink}. This
 * interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.field.GrantOverHeadCostLinkField
 * GrantOverHeadCostLinkField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.link.GrantOverHeadCostLinkLink
 * GrantOverHeadCostLinkLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantOverHeadCostLink#GRANT_ID GRANT_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantOverHeadCostLink#SPONSORED_PROGRAM
 * SPONSORED_PROGRAM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantOverHeadCostLink#SPONSORED_CLASS
 * SPONSORED_CLASS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantOverHeadCostLink#VALIDITY_START_DATE
 * VALIDITY_START_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantOverHeadCostLink#VALIDITY_END_DATE
 * VALIDITY_END_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantOverHeadCostLink#GTEE_M_INDIRECT_COST_RATE_IN_PERCENT
 * GTEE_M_INDIRECT_COST_RATE_IN_PERCENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantOverHeadCostLink#TO_GRANT TO_GRANT}</li>
 * </ul>
 *
 */
public interface GrantOverHeadCostLinkSelectable extends EntitySelectable<GrantOverHeadCostLink>
{

}
