/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantSponsoredClassesLink;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantSponsoredClassesLink
 * GrantSponsoredClassesLink}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.field.GrantSponsoredClassesLinkField
 * GrantSponsoredClassesLinkField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.link.GrantSponsoredClassesLinkLink
 * GrantSponsoredClassesLinkLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantSponsoredClassesLink#GRANT_ID
 * GRANT_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantSponsoredClassesLink#SPONSORED_CLASS
 * SPONSORED_CLASS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantSponsoredClassesLink#SPNSRD_CL_IS_INDRCT_COST_SHRNG_RLVT
 * SPNSRD_CL_IS_INDRCT_COST_SHRNG_RLVT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantSponsoredClassesLink#TO_GRANT
 * TO_GRANT}</li>
 * </ul>
 *
 */
public interface GrantSponsoredClassesLinkSelectable extends EntitySelectable<GrantSponsoredClassesLink>
{

}
