/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantSponsoredProgramsLink;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantSponsoredProgramsLink
 * GrantSponsoredProgramsLink}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.field.GrantSponsoredProgramsLinkField
 * GrantSponsoredProgramsLinkField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.link.GrantSponsoredProgramsLinkLink
 * GrantSponsoredProgramsLinkLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantSponsoredProgramsLink#GRANT_ID
 * GRANT_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantSponsoredProgramsLink#SPONSORED_PROGRAM
 * SPONSORED_PROGRAM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.grant.GrantSponsoredProgramsLink#TO_GRANT
 * TO_GRANT}</li>
 * </ul>
 *
 */
public interface GrantSponsoredProgramsLinkSelectable extends EntitySelectable<GrantSponsoredProgramsLink>
{

}
