/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.granthierarchy;

import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.granthierarchy.field.GrantCoreHierNodeField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.granthierarchy.link.GrantCoreHierNodeLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.granthierarchy.link.GrantCoreHierNodeOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.granthierarchy.selectable.GrantCoreHierNodeSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Grant Hierarchy Node
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_GrantCoreHierNode_Type</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class GrantCoreHierNode extends VdmEntity<GrantCoreHierNode>
{

    /**
     * Selector for all available fields of GrantCoreHierNode.
     *
     */
    public final static GrantCoreHierNodeSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 42
     * <p>
     * Original property name from the Odata EDM: <b>GrantHierarchy</b>
     * </p>
     *
     * @return Grant Hierarchy
     */
    @Key
    @SerializedName( "GrantHierarchy" )
    @JsonProperty( "GrantHierarchy" )
    @Nullable
    @ODataField( odataName = "GrantHierarchy" )
    private String grantHierarchy;
    /**
     * Use with available fluent helpers to apply the <b>GrantHierarchy</b> field to query operations.
     *
     */
    public final static GrantCoreHierNodeField<String> GRANT_HIERARCHY =
        new GrantCoreHierNodeField<String>("GrantHierarchy");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>HierarchyNode</b>
     * </p>
     *
     * @return Hierarchy node
     */
    @Key
    @SerializedName( "HierarchyNode" )
    @JsonProperty( "HierarchyNode" )
    @Nullable
    @ODataField( odataName = "HierarchyNode" )
    private String hierarchyNode;
    /**
     * Use with available fluent helpers to apply the <b>HierarchyNode</b> field to query operations.
     *
     */
    public final static GrantCoreHierNodeField<String> HIERARCHY_NODE =
        new GrantCoreHierNodeField<String>("HierarchyNode");
    /**
     * (Key Field) Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityEndDate</b>
     * </p>
     *
     * @return Validity End Date
     */
    @Key
    @SerializedName( "ValidityEndDate" )
    @JsonProperty( "ValidityEndDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ValidityEndDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime validityEndDate;
    /**
     * Use with available fluent helpers to apply the <b>ValidityEndDate</b> field to query operations.
     *
     */
    public final static GrantCoreHierNodeField<LocalDateTime> VALIDITY_END_DATE =
        new GrantCoreHierNodeField<LocalDateTime>("ValidityEndDate");
    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>ParentNode</b>
     * </p>
     *
     * @return Hierarchy parent node
     */
    @SerializedName( "ParentNode" )
    @JsonProperty( "ParentNode" )
    @Nullable
    @ODataField( odataName = "ParentNode" )
    private String parentNode;
    /**
     * Use with available fluent helpers to apply the <b>ParentNode</b> field to query operations.
     *
     */
    public final static GrantCoreHierNodeField<String> PARENT_NODE = new GrantCoreHierNodeField<String>("ParentNode");
    /**
     * Constraints: Not nullable, Maximum length: 15
     * <p>
     * Original property name from the Odata EDM: <b>HierarchyVersion</b>
     * </p>
     *
     * @return Hierarchy version
     */
    @SerializedName( "HierarchyVersion" )
    @JsonProperty( "HierarchyVersion" )
    @Nullable
    @ODataField( odataName = "HierarchyVersion" )
    private String hierarchyVersion;
    /**
     * Use with available fluent helpers to apply the <b>HierarchyVersion</b> field to query operations.
     *
     */
    public final static GrantCoreHierNodeField<String> HIERARCHY_VERSION =
        new GrantCoreHierNodeField<String>("HierarchyVersion");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityStartDate</b>
     * </p>
     *
     * @return Validity Start Date
     */
    @SerializedName( "ValidityStartDate" )
    @JsonProperty( "ValidityStartDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ValidityStartDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime validityStartDate;
    /**
     * Use with available fluent helpers to apply the <b>ValidityStartDate</b> field to query operations.
     *
     */
    public final static GrantCoreHierNodeField<LocalDateTime> VALIDITY_START_DATE =
        new GrantCoreHierNodeField<LocalDateTime>("ValidityStartDate");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>GrantID</b>
     * </p>
     *
     * @return Grant
     */
    @SerializedName( "GrantID" )
    @JsonProperty( "GrantID" )
    @Nullable
    @ODataField( odataName = "GrantID" )
    private String grantID;
    /**
     * Use with available fluent helpers to apply the <b>GrantID</b> field to query operations.
     *
     */
    public final static GrantCoreHierNodeField<String> GRANT_ID = new GrantCoreHierNodeField<String>("GrantID");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>HierarchyNodeSequence</b>
     * </p>
     *
     * @return Hierarchy Sequence Number
     */
    @SerializedName( "HierarchyNodeSequence" )
    @JsonProperty( "HierarchyNodeSequence" )
    @Nullable
    @ODataField( odataName = "HierarchyNodeSequence" )
    private String hierarchyNodeSequence;
    /**
     * Use with available fluent helpers to apply the <b>HierarchyNodeSequence</b> field to query operations.
     *
     */
    public final static GrantCoreHierNodeField<String> HIERARCHY_NODE_SEQUENCE =
        new GrantCoreHierNodeField<String>("HierarchyNodeSequence");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>HierarchyNodeLevel</b>
     * </p>
     *
     * @return Hierarchy Level
     */
    @SerializedName( "HierarchyNodeLevel" )
    @JsonProperty( "HierarchyNodeLevel" )
    @Nullable
    @ODataField( odataName = "HierarchyNodeLevel" )
    private String hierarchyNodeLevel;
    /**
     * Use with available fluent helpers to apply the <b>HierarchyNodeLevel</b> field to query operations.
     *
     */
    public final static GrantCoreHierNodeField<String> HIERARCHY_NODE_LEVEL =
        new GrantCoreHierNodeField<String>("HierarchyNodeLevel");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>NodeType</b>
     * </p>
     *
     * @return Hierarchy node type
     */
    @SerializedName( "NodeType" )
    @JsonProperty( "NodeType" )
    @Nullable
    @ODataField( odataName = "NodeType" )
    private String nodeType;
    /**
     * Use with available fluent helpers to apply the <b>NodeType</b> field to query operations.
     *
     */
    public final static GrantCoreHierNodeField<String> NODE_TYPE = new GrantCoreHierNodeField<String>("NodeType");
    /**
     * Navigation property <b>to_GrantCoreHierarchy</b> for <b>GrantCoreHierNode</b> to single
     * <b>GrantCoreHierarchy</b>.
     *
     */
    @SerializedName( "to_GrantCoreHierarchy" )
    @JsonProperty( "to_GrantCoreHierarchy" )
    @ODataField( odataName = "to_GrantCoreHierarchy" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private GrantCoreHierarchy toGrantCoreHierarchy;
    /**
     * Navigation property <b>to_GrantCoreHierarchyNodeText</b> for <b>GrantCoreHierNode</b> to multiple
     * <b>GrantCoreHierarchyNodeText</b>.
     *
     */
    @SerializedName( "to_GrantCoreHierarchyNodeText" )
    @JsonProperty( "to_GrantCoreHierarchyNodeText" )
    @ODataField( odataName = "to_GrantCoreHierarchyNodeText" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<GrantCoreHierarchyNodeText> toGrantCoreHierarchyNodeText;
    /**
     * Use with available fluent helpers to apply the <b>to_GrantCoreHierarchy</b> navigation property to query
     * operations.
     *
     */
    public final static GrantCoreHierNodeOneToOneLink<GrantCoreHierarchy> TO_GRANT_CORE_HIERARCHY =
        new GrantCoreHierNodeOneToOneLink<GrantCoreHierarchy>("to_GrantCoreHierarchy");
    /**
     * Use with available fluent helpers to apply the <b>to_GrantCoreHierarchyNodeText</b> navigation property to query
     * operations.
     *
     */
    public final static GrantCoreHierNodeLink<GrantCoreHierarchyNodeText> TO_GRANT_CORE_HIERARCHY_NODE_TEXT =
        new GrantCoreHierNodeLink<GrantCoreHierarchyNodeText>("to_GrantCoreHierarchyNodeText");

    @Nonnull
    @Override
    public Class<GrantCoreHierNode> getType()
    {
        return GrantCoreHierNode.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 42
     * <p>
     * Original property name from the Odata EDM: <b>GrantHierarchy</b>
     * </p>
     *
     * @param grantHierarchy
     *            Grant Hierarchy
     */
    public void setGrantHierarchy( @Nullable final String grantHierarchy )
    {
        rememberChangedField("GrantHierarchy", this.grantHierarchy);
        this.grantHierarchy = grantHierarchy;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>HierarchyNode</b>
     * </p>
     *
     * @param hierarchyNode
     *            Hierarchy node
     */
    public void setHierarchyNode( @Nullable final String hierarchyNode )
    {
        rememberChangedField("HierarchyNode", this.hierarchyNode);
        this.hierarchyNode = hierarchyNode;
    }

    /**
     * (Key Field) Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityEndDate</b>
     * </p>
     *
     * @param validityEndDate
     *            Validity End Date
     */
    public void setValidityEndDate( @Nullable final LocalDateTime validityEndDate )
    {
        rememberChangedField("ValidityEndDate", this.validityEndDate);
        this.validityEndDate = validityEndDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>ParentNode</b>
     * </p>
     *
     * @param parentNode
     *            Hierarchy parent node
     */
    public void setParentNode( @Nullable final String parentNode )
    {
        rememberChangedField("ParentNode", this.parentNode);
        this.parentNode = parentNode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 15
     * <p>
     * Original property name from the Odata EDM: <b>HierarchyVersion</b>
     * </p>
     *
     * @param hierarchyVersion
     *            Hierarchy version
     */
    public void setHierarchyVersion( @Nullable final String hierarchyVersion )
    {
        rememberChangedField("HierarchyVersion", this.hierarchyVersion);
        this.hierarchyVersion = hierarchyVersion;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityStartDate</b>
     * </p>
     *
     * @param validityStartDate
     *            Validity Start Date
     */
    public void setValidityStartDate( @Nullable final LocalDateTime validityStartDate )
    {
        rememberChangedField("ValidityStartDate", this.validityStartDate);
        this.validityStartDate = validityStartDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>GrantID</b>
     * </p>
     *
     * @param grantID
     *            Grant
     */
    public void setGrantID( @Nullable final String grantID )
    {
        rememberChangedField("GrantID", this.grantID);
        this.grantID = grantID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>HierarchyNodeSequence</b>
     * </p>
     *
     * @param hierarchyNodeSequence
     *            Hierarchy Sequence Number
     */
    public void setHierarchyNodeSequence( @Nullable final String hierarchyNodeSequence )
    {
        rememberChangedField("HierarchyNodeSequence", this.hierarchyNodeSequence);
        this.hierarchyNodeSequence = hierarchyNodeSequence;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>HierarchyNodeLevel</b>
     * </p>
     *
     * @param hierarchyNodeLevel
     *            Hierarchy Level
     */
    public void setHierarchyNodeLevel( @Nullable final String hierarchyNodeLevel )
    {
        rememberChangedField("HierarchyNodeLevel", this.hierarchyNodeLevel);
        this.hierarchyNodeLevel = hierarchyNodeLevel;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>NodeType</b>
     * </p>
     *
     * @param nodeType
     *            Hierarchy node type
     */
    public void setNodeType( @Nullable final String nodeType )
    {
        rememberChangedField("NodeType", this.nodeType);
        this.nodeType = nodeType;
    }

    @Override
    protected String getEntityCollection()
    {
        return "GrantHierarchyNode";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("GrantHierarchy", getGrantHierarchy());
        result.put("HierarchyNode", getHierarchyNode());
        result.put("ValidityEndDate", getValidityEndDate());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("GrantHierarchy", getGrantHierarchy());
        values.put("HierarchyNode", getHierarchyNode());
        values.put("ValidityEndDate", getValidityEndDate());
        values.put("ParentNode", getParentNode());
        values.put("HierarchyVersion", getHierarchyVersion());
        values.put("ValidityStartDate", getValidityStartDate());
        values.put("GrantID", getGrantID());
        values.put("HierarchyNodeSequence", getHierarchyNodeSequence());
        values.put("HierarchyNodeLevel", getHierarchyNodeLevel());
        values.put("NodeType", getNodeType());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("GrantHierarchy") ) {
                final Object value = values.remove("GrantHierarchy");
                if( (value == null) || (!value.equals(getGrantHierarchy())) ) {
                    setGrantHierarchy(((String) value));
                }
            }
            if( values.containsKey("HierarchyNode") ) {
                final Object value = values.remove("HierarchyNode");
                if( (value == null) || (!value.equals(getHierarchyNode())) ) {
                    setHierarchyNode(((String) value));
                }
            }
            if( values.containsKey("ValidityEndDate") ) {
                final Object value = values.remove("ValidityEndDate");
                if( (value == null) || (!value.equals(getValidityEndDate())) ) {
                    setValidityEndDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ParentNode") ) {
                final Object value = values.remove("ParentNode");
                if( (value == null) || (!value.equals(getParentNode())) ) {
                    setParentNode(((String) value));
                }
            }
            if( values.containsKey("HierarchyVersion") ) {
                final Object value = values.remove("HierarchyVersion");
                if( (value == null) || (!value.equals(getHierarchyVersion())) ) {
                    setHierarchyVersion(((String) value));
                }
            }
            if( values.containsKey("ValidityStartDate") ) {
                final Object value = values.remove("ValidityStartDate");
                if( (value == null) || (!value.equals(getValidityStartDate())) ) {
                    setValidityStartDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("GrantID") ) {
                final Object value = values.remove("GrantID");
                if( (value == null) || (!value.equals(getGrantID())) ) {
                    setGrantID(((String) value));
                }
            }
            if( values.containsKey("HierarchyNodeSequence") ) {
                final Object value = values.remove("HierarchyNodeSequence");
                if( (value == null) || (!value.equals(getHierarchyNodeSequence())) ) {
                    setHierarchyNodeSequence(((String) value));
                }
            }
            if( values.containsKey("HierarchyNodeLevel") ) {
                final Object value = values.remove("HierarchyNodeLevel");
                if( (value == null) || (!value.equals(getHierarchyNodeLevel())) ) {
                    setHierarchyNodeLevel(((String) value));
                }
            }
            if( values.containsKey("NodeType") ) {
                final Object value = values.remove("NodeType");
                if( (value == null) || (!value.equals(getNodeType())) ) {
                    setNodeType(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_GrantCoreHierarchy") ) {
                final Object value = (values).remove("to_GrantCoreHierarchy");
                if( value instanceof Map ) {
                    if( toGrantCoreHierarchy == null ) {
                        toGrantCoreHierarchy = new GrantCoreHierarchy();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toGrantCoreHierarchy.fromMap(inputMap);
                }
            }
            if( (values).containsKey("to_GrantCoreHierarchyNodeText") ) {
                final Object value = (values).remove("to_GrantCoreHierarchyNodeText");
                if( value instanceof Iterable ) {
                    if( toGrantCoreHierarchyNodeText == null ) {
                        toGrantCoreHierarchyNodeText = Lists.newArrayList();
                    } else {
                        toGrantCoreHierarchyNodeText = Lists.newArrayList(toGrantCoreHierarchyNodeText);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        GrantCoreHierarchyNodeText entity;
                        if( toGrantCoreHierarchyNodeText.size() > i ) {
                            entity = toGrantCoreHierarchyNodeText.get(i);
                        } else {
                            entity = new GrantCoreHierarchyNodeText();
                            toGrantCoreHierarchyNodeText.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> GrantCoreHierNodeField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new GrantCoreHierNodeField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> GrantCoreHierNodeField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new GrantCoreHierNodeField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.GrantHierarchyService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toGrantCoreHierarchy != null ) {
            (values).put("to_GrantCoreHierarchy", toGrantCoreHierarchy);
        }
        if( toGrantCoreHierarchyNodeText != null ) {
            (values).put("to_GrantCoreHierarchyNodeText", toGrantCoreHierarchyNodeText);
        }
        return values;
    }

    /**
     * Fetches the <b>GrantCoreHierarchy</b> entity (one to one) associated with this entity. This corresponds to the
     * OData navigation property <b>to_GrantCoreHierarchy</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>GrantCoreHierarchy</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public GrantCoreHierarchy fetchGrantCoreHierarchy()
    {
        return fetchFieldAsSingle("to_GrantCoreHierarchy", GrantCoreHierarchy.class);
    }

    /**
     * Retrieval of associated <b>GrantCoreHierarchy</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_GrantCoreHierarchy</b>.
     * <p>
     * If the navigation property <b>to_GrantCoreHierarchy</b> of a queried <b>GrantCoreHierNode</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>GrantCoreHierarchy</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public GrantCoreHierarchy getGrantCoreHierarchyOrFetch()
    {
        if( toGrantCoreHierarchy == null ) {
            toGrantCoreHierarchy = fetchGrantCoreHierarchy();
        }
        return toGrantCoreHierarchy;
    }

    /**
     * Retrieval of associated <b>GrantCoreHierarchy</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_GrantCoreHierarchy</b>.
     * <p>
     * If the navigation property for an entity <b>GrantCoreHierNode</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_GrantCoreHierarchy</b> is already loaded, the result
     *         will contain the <b>GrantCoreHierarchy</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<GrantCoreHierarchy> getGrantCoreHierarchyIfPresent()
    {
        return Option.of(toGrantCoreHierarchy);
    }

    /**
     * Overwrites the associated <b>GrantCoreHierarchy</b> entity for the loaded navigation property
     * <b>to_GrantCoreHierarchy</b>.
     *
     * @param value
     *            New <b>GrantCoreHierarchy</b> entity.
     */
    public void setGrantCoreHierarchy( final GrantCoreHierarchy value )
    {
        toGrantCoreHierarchy = value;
    }

    /**
     * Fetches the <b>GrantCoreHierarchyNodeText</b> entities (one to many) associated with this entity. This
     * corresponds to the OData navigation property <b>to_GrantCoreHierarchyNodeText</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>GrantCoreHierarchyNodeText</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<GrantCoreHierarchyNodeText> fetchGrantCoreHierarchyNodeText()
    {
        return fetchFieldAsList("to_GrantCoreHierarchyNodeText", GrantCoreHierarchyNodeText.class);
    }

    /**
     * Retrieval of associated <b>GrantCoreHierarchyNodeText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_GrantCoreHierarchyNodeText</b>.
     * <p>
     * If the navigation property <b>to_GrantCoreHierarchyNodeText</b> of a queried <b>GrantCoreHierNode</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>GrantCoreHierarchyNodeText</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<GrantCoreHierarchyNodeText> getGrantCoreHierarchyNodeTextOrFetch()
    {
        if( toGrantCoreHierarchyNodeText == null ) {
            toGrantCoreHierarchyNodeText = fetchGrantCoreHierarchyNodeText();
        }
        return toGrantCoreHierarchyNodeText;
    }

    /**
     * Retrieval of associated <b>GrantCoreHierarchyNodeText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_GrantCoreHierarchyNodeText</b>.
     * <p>
     * If the navigation property for an entity <b>GrantCoreHierNode</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_GrantCoreHierarchyNodeText</b> is already loaded, the
     *         result will contain the <b>GrantCoreHierarchyNodeText</b> entities. If not, an <code>Option</code> with
     *         result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<GrantCoreHierarchyNodeText>> getGrantCoreHierarchyNodeTextIfPresent()
    {
        return Option.of(toGrantCoreHierarchyNodeText);
    }

    /**
     * Overwrites the list of associated <b>GrantCoreHierarchyNodeText</b> entities for the loaded navigation property
     * <b>to_GrantCoreHierarchyNodeText</b>.
     * <p>
     * If the navigation property <b>to_GrantCoreHierarchyNodeText</b> of a queried <b>GrantCoreHierNode</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>GrantCoreHierarchyNodeText</b> entities.
     */
    public void setGrantCoreHierarchyNodeText( @Nonnull final List<GrantCoreHierarchyNodeText> value )
    {
        if( toGrantCoreHierarchyNodeText == null ) {
            toGrantCoreHierarchyNodeText = Lists.newArrayList();
        }
        toGrantCoreHierarchyNodeText.clear();
        toGrantCoreHierarchyNodeText.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>GrantCoreHierarchyNodeText</b> entities. This corresponds to the OData
     * navigation property <b>to_GrantCoreHierarchyNodeText</b>.
     * <p>
     * If the navigation property <b>to_GrantCoreHierarchyNodeText</b> of a queried <b>GrantCoreHierNode</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>GrantCoreHierarchyNodeText</b> entities.
     */
    public void addGrantCoreHierarchyNodeText( GrantCoreHierarchyNodeText... entity )
    {
        if( toGrantCoreHierarchyNodeText == null ) {
            toGrantCoreHierarchyNodeText = Lists.newArrayList();
        }
        toGrantCoreHierarchyNodeText.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of GrantCoreHierNode instances.
     *
     */
    public final static class GrantCoreHierNodeBuilder
    {

        private GrantCoreHierarchy toGrantCoreHierarchy;
        private List<GrantCoreHierarchyNodeText> toGrantCoreHierarchyNodeText = Lists.newArrayList();

        private GrantCoreHierNode.GrantCoreHierNodeBuilder toGrantCoreHierarchy( final GrantCoreHierarchy value )
        {
            toGrantCoreHierarchy = value;
            return this;
        }

        /**
         * Navigation property <b>to_GrantCoreHierarchy</b> for <b>GrantCoreHierNode</b> to single
         * <b>GrantCoreHierarchy</b>.
         *
         * @param value
         *            The GrantCoreHierarchy to build this GrantCoreHierNode with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public GrantCoreHierNode.GrantCoreHierNodeBuilder grantCoreHierarchy( final GrantCoreHierarchy value )
        {
            return toGrantCoreHierarchy(value);
        }

        private GrantCoreHierNode.GrantCoreHierNodeBuilder toGrantCoreHierarchyNodeText(
            final List<GrantCoreHierarchyNodeText> value )
        {
            toGrantCoreHierarchyNodeText.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_GrantCoreHierarchyNodeText</b> for <b>GrantCoreHierNode</b> to multiple
         * <b>GrantCoreHierarchyNodeText</b>.
         *
         * @param value
         *            The GrantCoreHierarchyNodeTexts to build this GrantCoreHierNode with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public GrantCoreHierNode.GrantCoreHierNodeBuilder grantCoreHierarchyNodeText(
            GrantCoreHierarchyNodeText... value )
        {
            return toGrantCoreHierarchyNodeText(Lists.newArrayList(value));
        }

    }

}
