/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.granthierarchy;

import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.granthierarchy.field.GrantCoreHierarchyField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.granthierarchy.link.GrantCoreHierarchyLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.granthierarchy.selectable.GrantCoreHierarchySelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Grant Hierarchy
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>GrantCoreHierarchy_Type</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class GrantCoreHierarchy extends VdmEntity<GrantCoreHierarchy>
{

    /**
     * Selector for all available fields of GrantCoreHierarchy.
     *
     */
    public final static GrantCoreHierarchySelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 42
     * <p>
     * Original property name from the Odata EDM: <b>GrantHierarchy</b>
     * </p>
     *
     * @return Grant Hierarchy
     */
    @Key
    @SerializedName( "GrantHierarchy" )
    @JsonProperty( "GrantHierarchy" )
    @Nullable
    @ODataField( odataName = "GrantHierarchy" )
    private String grantHierarchy;
    /**
     * Use with available fluent helpers to apply the <b>GrantHierarchy</b> field to query operations.
     *
     */
    public final static GrantCoreHierarchyField<String> GRANT_HIERARCHY =
        new GrantCoreHierarchyField<String>("GrantHierarchy");
    /**
     * (Key Field) Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityEndDate</b>
     * </p>
     *
     * @return Validity End Date
     */
    @Key
    @SerializedName( "ValidityEndDate" )
    @JsonProperty( "ValidityEndDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ValidityEndDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime validityEndDate;
    /**
     * Use with available fluent helpers to apply the <b>ValidityEndDate</b> field to query operations.
     *
     */
    public final static GrantCoreHierarchyField<LocalDateTime> VALIDITY_END_DATE =
        new GrantCoreHierarchyField<LocalDateTime>("ValidityEndDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityStartDate</b>
     * </p>
     *
     * @return Validity Start Date
     */
    @SerializedName( "ValidityStartDate" )
    @JsonProperty( "ValidityStartDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ValidityStartDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime validityStartDate;
    /**
     * Use with available fluent helpers to apply the <b>ValidityStartDate</b> field to query operations.
     *
     */
    public final static GrantCoreHierarchyField<LocalDateTime> VALIDITY_START_DATE =
        new GrantCoreHierarchyField<LocalDateTime>("ValidityStartDate");
    /**
     * Navigation property <b>to_GrantCoreHierarchyText</b> for <b>GrantCoreHierarchy</b> to multiple
     * <b>GrantCoreHierarchyText</b>.
     *
     */
    @SerializedName( "to_GrantCoreHierarchyText" )
    @JsonProperty( "to_GrantCoreHierarchyText" )
    @ODataField( odataName = "to_GrantCoreHierarchyText" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<GrantCoreHierarchyText> toGrantCoreHierarchyText;
    /**
     * Navigation property <b>to_GrantCoreHierNode</b> for <b>GrantCoreHierarchy</b> to multiple
     * <b>GrantCoreHierNode</b>.
     *
     */
    @SerializedName( "to_GrantCoreHierNode" )
    @JsonProperty( "to_GrantCoreHierNode" )
    @ODataField( odataName = "to_GrantCoreHierNode" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<GrantCoreHierNode> toGrantCoreHierNode;
    /**
     * Use with available fluent helpers to apply the <b>to_GrantCoreHierarchyText</b> navigation property to query
     * operations.
     *
     */
    public final static GrantCoreHierarchyLink<GrantCoreHierarchyText> TO_GRANT_CORE_HIERARCHY_TEXT =
        new GrantCoreHierarchyLink<GrantCoreHierarchyText>("to_GrantCoreHierarchyText");
    /**
     * Use with available fluent helpers to apply the <b>to_GrantCoreHierNode</b> navigation property to query
     * operations.
     *
     */
    public final static GrantCoreHierarchyLink<GrantCoreHierNode> TO_GRANT_CORE_HIER_NODE =
        new GrantCoreHierarchyLink<GrantCoreHierNode>("to_GrantCoreHierNode");

    @Nonnull
    @Override
    public Class<GrantCoreHierarchy> getType()
    {
        return GrantCoreHierarchy.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 42
     * <p>
     * Original property name from the Odata EDM: <b>GrantHierarchy</b>
     * </p>
     *
     * @param grantHierarchy
     *            Grant Hierarchy
     */
    public void setGrantHierarchy( @Nullable final String grantHierarchy )
    {
        rememberChangedField("GrantHierarchy", this.grantHierarchy);
        this.grantHierarchy = grantHierarchy;
    }

    /**
     * (Key Field) Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityEndDate</b>
     * </p>
     *
     * @param validityEndDate
     *            Validity End Date
     */
    public void setValidityEndDate( @Nullable final LocalDateTime validityEndDate )
    {
        rememberChangedField("ValidityEndDate", this.validityEndDate);
        this.validityEndDate = validityEndDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityStartDate</b>
     * </p>
     *
     * @param validityStartDate
     *            Validity Start Date
     */
    public void setValidityStartDate( @Nullable final LocalDateTime validityStartDate )
    {
        rememberChangedField("ValidityStartDate", this.validityStartDate);
        this.validityStartDate = validityStartDate;
    }

    @Override
    protected String getEntityCollection()
    {
        return "GrantHierarchy";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("GrantHierarchy", getGrantHierarchy());
        result.put("ValidityEndDate", getValidityEndDate());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("GrantHierarchy", getGrantHierarchy());
        values.put("ValidityEndDate", getValidityEndDate());
        values.put("ValidityStartDate", getValidityStartDate());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("GrantHierarchy") ) {
                final Object value = values.remove("GrantHierarchy");
                if( (value == null) || (!value.equals(getGrantHierarchy())) ) {
                    setGrantHierarchy(((String) value));
                }
            }
            if( values.containsKey("ValidityEndDate") ) {
                final Object value = values.remove("ValidityEndDate");
                if( (value == null) || (!value.equals(getValidityEndDate())) ) {
                    setValidityEndDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ValidityStartDate") ) {
                final Object value = values.remove("ValidityStartDate");
                if( (value == null) || (!value.equals(getValidityStartDate())) ) {
                    setValidityStartDate(((LocalDateTime) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_GrantCoreHierarchyText") ) {
                final Object value = (values).remove("to_GrantCoreHierarchyText");
                if( value instanceof Iterable ) {
                    if( toGrantCoreHierarchyText == null ) {
                        toGrantCoreHierarchyText = Lists.newArrayList();
                    } else {
                        toGrantCoreHierarchyText = Lists.newArrayList(toGrantCoreHierarchyText);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        GrantCoreHierarchyText entity;
                        if( toGrantCoreHierarchyText.size() > i ) {
                            entity = toGrantCoreHierarchyText.get(i);
                        } else {
                            entity = new GrantCoreHierarchyText();
                            toGrantCoreHierarchyText.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_GrantCoreHierNode") ) {
                final Object value = (values).remove("to_GrantCoreHierNode");
                if( value instanceof Iterable ) {
                    if( toGrantCoreHierNode == null ) {
                        toGrantCoreHierNode = Lists.newArrayList();
                    } else {
                        toGrantCoreHierNode = Lists.newArrayList(toGrantCoreHierNode);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        GrantCoreHierNode entity;
                        if( toGrantCoreHierNode.size() > i ) {
                            entity = toGrantCoreHierNode.get(i);
                        } else {
                            entity = new GrantCoreHierNode();
                            toGrantCoreHierNode.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> GrantCoreHierarchyField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new GrantCoreHierarchyField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> GrantCoreHierarchyField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new GrantCoreHierarchyField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.GrantHierarchyService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toGrantCoreHierarchyText != null ) {
            (values).put("to_GrantCoreHierarchyText", toGrantCoreHierarchyText);
        }
        if( toGrantCoreHierNode != null ) {
            (values).put("to_GrantCoreHierNode", toGrantCoreHierNode);
        }
        return values;
    }

    /**
     * Fetches the <b>GrantCoreHierarchyText</b> entities (one to many) associated with this entity. This corresponds to
     * the OData navigation property <b>to_GrantCoreHierarchyText</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>GrantCoreHierarchyText</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<GrantCoreHierarchyText> fetchGrantCoreHierarchyText()
    {
        return fetchFieldAsList("to_GrantCoreHierarchyText", GrantCoreHierarchyText.class);
    }

    /**
     * Retrieval of associated <b>GrantCoreHierarchyText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_GrantCoreHierarchyText</b>.
     * <p>
     * If the navigation property <b>to_GrantCoreHierarchyText</b> of a queried <b>GrantCoreHierarchy</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>GrantCoreHierarchyText</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<GrantCoreHierarchyText> getGrantCoreHierarchyTextOrFetch()
    {
        if( toGrantCoreHierarchyText == null ) {
            toGrantCoreHierarchyText = fetchGrantCoreHierarchyText();
        }
        return toGrantCoreHierarchyText;
    }

    /**
     * Retrieval of associated <b>GrantCoreHierarchyText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_GrantCoreHierarchyText</b>.
     * <p>
     * If the navigation property for an entity <b>GrantCoreHierarchy</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_GrantCoreHierarchyText</b> is already loaded, the result
     *         will contain the <b>GrantCoreHierarchyText</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<GrantCoreHierarchyText>> getGrantCoreHierarchyTextIfPresent()
    {
        return Option.of(toGrantCoreHierarchyText);
    }

    /**
     * Overwrites the list of associated <b>GrantCoreHierarchyText</b> entities for the loaded navigation property
     * <b>to_GrantCoreHierarchyText</b>.
     * <p>
     * If the navigation property <b>to_GrantCoreHierarchyText</b> of a queried <b>GrantCoreHierarchy</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>GrantCoreHierarchyText</b> entities.
     */
    public void setGrantCoreHierarchyText( @Nonnull final List<GrantCoreHierarchyText> value )
    {
        if( toGrantCoreHierarchyText == null ) {
            toGrantCoreHierarchyText = Lists.newArrayList();
        }
        toGrantCoreHierarchyText.clear();
        toGrantCoreHierarchyText.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>GrantCoreHierarchyText</b> entities. This corresponds to the OData
     * navigation property <b>to_GrantCoreHierarchyText</b>.
     * <p>
     * If the navigation property <b>to_GrantCoreHierarchyText</b> of a queried <b>GrantCoreHierarchy</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>GrantCoreHierarchyText</b> entities.
     */
    public void addGrantCoreHierarchyText( GrantCoreHierarchyText... entity )
    {
        if( toGrantCoreHierarchyText == null ) {
            toGrantCoreHierarchyText = Lists.newArrayList();
        }
        toGrantCoreHierarchyText.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>GrantCoreHierNode</b> entities (one to many) associated with this entity. This corresponds to the
     * OData navigation property <b>to_GrantCoreHierNode</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>GrantCoreHierNode</b> entities. If no entities are associated
     *         then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<GrantCoreHierNode> fetchGrantCoreHierNode()
    {
        return fetchFieldAsList("to_GrantCoreHierNode", GrantCoreHierNode.class);
    }

    /**
     * Retrieval of associated <b>GrantCoreHierNode</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_GrantCoreHierNode</b>.
     * <p>
     * If the navigation property <b>to_GrantCoreHierNode</b> of a queried <b>GrantCoreHierarchy</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>GrantCoreHierNode</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<GrantCoreHierNode> getGrantCoreHierNodeOrFetch()
    {
        if( toGrantCoreHierNode == null ) {
            toGrantCoreHierNode = fetchGrantCoreHierNode();
        }
        return toGrantCoreHierNode;
    }

    /**
     * Retrieval of associated <b>GrantCoreHierNode</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_GrantCoreHierNode</b>.
     * <p>
     * If the navigation property for an entity <b>GrantCoreHierarchy</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_GrantCoreHierNode</b> is already loaded, the result will
     *         contain the <b>GrantCoreHierNode</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<GrantCoreHierNode>> getGrantCoreHierNodeIfPresent()
    {
        return Option.of(toGrantCoreHierNode);
    }

    /**
     * Overwrites the list of associated <b>GrantCoreHierNode</b> entities for the loaded navigation property
     * <b>to_GrantCoreHierNode</b>.
     * <p>
     * If the navigation property <b>to_GrantCoreHierNode</b> of a queried <b>GrantCoreHierarchy</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>GrantCoreHierNode</b> entities.
     */
    public void setGrantCoreHierNode( @Nonnull final List<GrantCoreHierNode> value )
    {
        if( toGrantCoreHierNode == null ) {
            toGrantCoreHierNode = Lists.newArrayList();
        }
        toGrantCoreHierNode.clear();
        toGrantCoreHierNode.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>GrantCoreHierNode</b> entities. This corresponds to the OData
     * navigation property <b>to_GrantCoreHierNode</b>.
     * <p>
     * If the navigation property <b>to_GrantCoreHierNode</b> of a queried <b>GrantCoreHierarchy</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>GrantCoreHierNode</b> entities.
     */
    public void addGrantCoreHierNode( GrantCoreHierNode... entity )
    {
        if( toGrantCoreHierNode == null ) {
            toGrantCoreHierNode = Lists.newArrayList();
        }
        toGrantCoreHierNode.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of GrantCoreHierarchy instances.
     *
     */
    public final static class GrantCoreHierarchyBuilder
    {

        private List<GrantCoreHierarchyText> toGrantCoreHierarchyText = Lists.newArrayList();
        private List<GrantCoreHierNode> toGrantCoreHierNode = Lists.newArrayList();

        private GrantCoreHierarchy.GrantCoreHierarchyBuilder toGrantCoreHierarchyText(
            final List<GrantCoreHierarchyText> value )
        {
            toGrantCoreHierarchyText.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_GrantCoreHierarchyText</b> for <b>GrantCoreHierarchy</b> to multiple
         * <b>GrantCoreHierarchyText</b>.
         *
         * @param value
         *            The GrantCoreHierarchyTexts to build this GrantCoreHierarchy with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public GrantCoreHierarchy.GrantCoreHierarchyBuilder grantCoreHierarchyText( GrantCoreHierarchyText... value )
        {
            return toGrantCoreHierarchyText(Lists.newArrayList(value));
        }

        private GrantCoreHierarchy.GrantCoreHierarchyBuilder toGrantCoreHierNode( final List<GrantCoreHierNode> value )
        {
            toGrantCoreHierNode.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_GrantCoreHierNode</b> for <b>GrantCoreHierarchy</b> to multiple
         * <b>GrantCoreHierNode</b>.
         *
         * @param value
         *            The GrantCoreHierNodes to build this GrantCoreHierarchy with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public GrantCoreHierarchy.GrantCoreHierarchyBuilder grantCoreHierNode( GrantCoreHierNode... value )
        {
            return toGrantCoreHierNode(Lists.newArrayList(value));
        }

    }

}
