/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.granthierarchy.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchChangeSetFluentHelperBasic;

/**
 * Implementation of the {@link GrantHierarchyServiceBatchChangeSet} interface, enabling you to combine multiple
 * operations into one changeset. For further information have a look into the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.GrantHierarchyService GrantHierarchyService}.
 *
 */
public class DefaultGrantHierarchyServiceBatchChangeSet
    extends
    BatchChangeSetFluentHelperBasic<GrantHierarchyServiceBatch, GrantHierarchyServiceBatchChangeSet>
    implements
    GrantHierarchyServiceBatchChangeSet
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.GrantHierarchyService service;

    @SuppressWarnings( "deprecation" )
    DefaultGrantHierarchyServiceBatchChangeSet(
        @Nonnull final DefaultGrantHierarchyServiceBatch batchFluentHelper,
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.GrantHierarchyService service )
    {
        super(batchFluentHelper, batchFluentHelper);
        this.service = service;
    }

    @Nonnull
    @Override
    protected DefaultGrantHierarchyServiceBatchChangeSet getThis()
    {
        return this;
    }

}
