/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.granthierarchy.link;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.EntityLink;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmObject;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.granthierarchy.GrantCoreHierarchyNodeText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.granthierarchy.selectable.GrantCoreHierarchyNodeTextSelectable;

/**
 * Template class to represent entity navigation links of
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.granthierarchy.GrantCoreHierarchyNodeText
 * GrantCoreHierarchyNodeText} to other entities. Instances of this object are used in query modifier methods of the
 * entity fluent helpers. Contains methods to compare a field's value with a provided value.
 *
 * Use the constants declared in each entity inner class. Instantiating directly requires knowing the underlying OData
 * field names, so use the constructor with caution.
 *
 * @param <ObjectT>
 *            Entity type of subclasses from {@link com.sap.cloud.sdk.datamodel.odata.helper.VdmObject VdmObject}.
 *
 */
public class GrantCoreHierarchyNodeTextLink<ObjectT extends VdmObject<?>>
    extends
    EntityLink<GrantCoreHierarchyNodeTextLink<ObjectT>, GrantCoreHierarchyNodeText, ObjectT>
    implements
    GrantCoreHierarchyNodeTextSelectable
{

    /**
     * Use the constants declared in each entity inner class. Instantiating directly requires knowing the underlying
     * OData field names, so use with caution.
     *
     * @param fieldName
     *            OData navigation field name. Must match the field returned by the underlying OData service.
     */
    public GrantCoreHierarchyNodeTextLink( final String fieldName )
    {
        super(fieldName);
    }

    private GrantCoreHierarchyNodeTextLink(
        final EntityLink<GrantCoreHierarchyNodeTextLink<ObjectT>, GrantCoreHierarchyNodeText, ObjectT> toClone )
    {
        super(toClone);
    }

    @Nonnull
    @Override
    protected GrantCoreHierarchyNodeTextLink<ObjectT> translateLinkType(
        final EntityLink<GrantCoreHierarchyNodeTextLink<ObjectT>, GrantCoreHierarchyNodeText, ObjectT> link )
    {
        return new GrantCoreHierarchyNodeTextLink<ObjectT>(link);
    }

}
