/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.granthierarchy.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.granthierarchy.GrantCoreHierarchyNodeText;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.granthierarchy.GrantCoreHierarchyNodeText
 * GrantCoreHierarchyNodeText}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.granthierarchy.field.GrantCoreHierarchyNodeTextField
 * GrantCoreHierarchyNodeTextField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.granthierarchy.link.GrantCoreHierarchyNodeTextLink
 * GrantCoreHierarchyNodeTextLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.granthierarchy.GrantCoreHierarchyNodeText#GRANT_HIERARCHY
 * GRANT_HIERARCHY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.granthierarchy.GrantCoreHierarchyNodeText#HIERARCHY_NODE
 * HIERARCHY_NODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.granthierarchy.GrantCoreHierarchyNodeText#VALIDITY_END_DATE
 * VALIDITY_END_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.granthierarchy.GrantCoreHierarchyNodeText#LANGUAGE
 * LANGUAGE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.granthierarchy.GrantCoreHierarchyNodeText#HIERARCHY_NODE_TEXT
 * HIERARCHY_NODE_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.granthierarchy.GrantCoreHierarchyNodeText#VALIDITY_START_DATE
 * VALIDITY_START_DATE}</li>
 * </ul>
 *
 */
public interface GrantCoreHierarchyNodeTextSelectable extends EntitySelectable<GrantCoreHierarchyNodeText>
{

}
