/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.granthierarchy.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.granthierarchy.GrantCoreHierarchy;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.granthierarchy.GrantCoreHierarchy GrantCoreHierarchy}.
 * This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.granthierarchy.field.GrantCoreHierarchyField
 * GrantCoreHierarchyField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.granthierarchy.link.GrantCoreHierarchyLink
 * GrantCoreHierarchyLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.granthierarchy.GrantCoreHierarchy#GRANT_HIERARCHY
 * GRANT_HIERARCHY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.granthierarchy.GrantCoreHierarchy#VALIDITY_END_DATE
 * VALIDITY_END_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.granthierarchy.GrantCoreHierarchy#VALIDITY_START_DATE
 * VALIDITY_START_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.granthierarchy.GrantCoreHierarchy#TO_GRANT_CORE_HIERARCHY_TEXT
 * TO_GRANT_CORE_HIERARCHY_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.granthierarchy.GrantCoreHierarchy#TO_GRANT_CORE_HIER_NODE
 * TO_GRANT_CORE_HIER_NODE}</li>
 * </ul>
 *
 */
public interface GrantCoreHierarchySelectable extends EntitySelectable<GrantCoreHierarchy>
{

}
