/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.handlingunit;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.handlingunit.field.HandlingUnitField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.handlingunit.link.HandlingUnitLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.handlingunit.selectable.HandlingUnitSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Handling Unit (Deprecated)
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>HandlingUnitType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class HandlingUnit extends VdmEntity<HandlingUnit>
{

    /**
     * Selector for all available fields of HandlingUnit.
     *
     */
    public final static HandlingUnitSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>HandlingUnitExternalID</b>
     * </p>
     *
     * @return External Handling Unit Identification
     */
    @Key
    @SerializedName( "HandlingUnitExternalID" )
    @JsonProperty( "HandlingUnitExternalID" )
    @Nullable
    @ODataField( odataName = "HandlingUnitExternalID" )
    private String handlingUnitExternalID;
    /**
     * Use with available fluent helpers to apply the <b>HandlingUnitExternalID</b> field to query operations.
     *
     */
    public final static HandlingUnitField<String> HANDLING_UNIT_EXTERNAL_ID =
        new HandlingUnitField<String>("HandlingUnitExternalID");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Warehouse</b>
     * </p>
     *
     * @return Warehouse Number/Warehouse Complex
     */
    @Key
    @SerializedName( "Warehouse" )
    @JsonProperty( "Warehouse" )
    @Nullable
    @ODataField( odataName = "Warehouse" )
    private String warehouse;
    /**
     * Use with available fluent helpers to apply the <b>Warehouse</b> field to query operations.
     *
     */
    public final static HandlingUnitField<String> WAREHOUSE = new HandlingUnitField<String>("Warehouse");
    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>PackagingMaterial</b>
     * </p>
     *
     * @return Packaging Materials
     */
    @SerializedName( "PackagingMaterial" )
    @JsonProperty( "PackagingMaterial" )
    @Nullable
    @ODataField( odataName = "PackagingMaterial" )
    private String packagingMaterial;
    /**
     * Use with available fluent helpers to apply the <b>PackagingMaterial</b> field to query operations.
     *
     */
    public final static HandlingUnitField<String> PACKAGING_MATERIAL =
        new HandlingUnitField<String>("PackagingMaterial");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PackagingMaterialType</b>
     * </p>
     *
     * @return Packaging Material Type
     */
    @SerializedName( "PackagingMaterialType" )
    @JsonProperty( "PackagingMaterialType" )
    @Nullable
    @ODataField( odataName = "PackagingMaterialType" )
    private String packagingMaterialType;
    /**
     * Use with available fluent helpers to apply the <b>PackagingMaterialType</b> field to query operations.
     *
     */
    public final static HandlingUnitField<String> PACKAGING_MATERIAL_TYPE =
        new HandlingUnitField<String>("PackagingMaterialType");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @return Plant
     */
    @SerializedName( "Plant" )
    @JsonProperty( "Plant" )
    @Nullable
    @ODataField( odataName = "Plant" )
    private String plant;
    /**
     * Use with available fluent helpers to apply the <b>Plant</b> field to query operations.
     *
     */
    public final static HandlingUnitField<String> PLANT = new HandlingUnitField<String>("Plant");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>StorageLocation</b>
     * </p>
     *
     * @return Storage Location
     */
    @SerializedName( "StorageLocation" )
    @JsonProperty( "StorageLocation" )
    @Nullable
    @ODataField( odataName = "StorageLocation" )
    private String storageLocation;
    /**
     * Use with available fluent helpers to apply the <b>StorageLocation</b> field to query operations.
     *
     */
    public final static HandlingUnitField<String> STORAGE_LOCATION = new HandlingUnitField<String>("StorageLocation");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ShippingPoint</b>
     * </p>
     *
     * @return Shipping Point / Receiving Point
     */
    @SerializedName( "ShippingPoint" )
    @JsonProperty( "ShippingPoint" )
    @Nullable
    @ODataField( odataName = "ShippingPoint" )
    private String shippingPoint;
    /**
     * Use with available fluent helpers to apply the <b>ShippingPoint</b> field to query operations.
     *
     */
    public final static HandlingUnitField<String> SHIPPING_POINT = new HandlingUnitField<String>("ShippingPoint");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>ParentHandlingUnitNumber</b>
     * </p>
     *
     * @return External Handling Unit Identification
     */
    @SerializedName( "ParentHandlingUnitNumber" )
    @JsonProperty( "ParentHandlingUnitNumber" )
    @Nullable
    @ODataField( odataName = "ParentHandlingUnitNumber" )
    private String parentHandlingUnitNumber;
    /**
     * Use with available fluent helpers to apply the <b>ParentHandlingUnitNumber</b> field to query operations.
     *
     */
    public final static HandlingUnitField<String> PARENT_HANDLING_UNIT_NUMBER =
        new HandlingUnitField<String>("ParentHandlingUnitNumber");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>GrossWeight</b>
     * </p>
     *
     * @return Total Weight of Handling Unit
     */
    @SerializedName( "GrossWeight" )
    @JsonProperty( "GrossWeight" )
    @Nullable
    @ODataField( odataName = "GrossWeight" )
    private BigDecimal grossWeight;
    /**
     * Use with available fluent helpers to apply the <b>GrossWeight</b> field to query operations.
     *
     */
    public final static HandlingUnitField<BigDecimal> GROSS_WEIGHT = new HandlingUnitField<BigDecimal>("GrossWeight");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>NetWeight</b>
     * </p>
     *
     * @return Loading Weight of Handling Unit
     */
    @SerializedName( "NetWeight" )
    @JsonProperty( "NetWeight" )
    @Nullable
    @ODataField( odataName = "NetWeight" )
    private BigDecimal netWeight;
    /**
     * Use with available fluent helpers to apply the <b>NetWeight</b> field to query operations.
     *
     */
    public final static HandlingUnitField<BigDecimal> NET_WEIGHT = new HandlingUnitField<BigDecimal>("NetWeight");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>HandlingUnitMaxWeight</b>
     * </p>
     *
     * @return Allowed Loading Weight of a Handling Unit
     */
    @SerializedName( "HandlingUnitMaxWeight" )
    @JsonProperty( "HandlingUnitMaxWeight" )
    @Nullable
    @ODataField( odataName = "HandlingUnitMaxWeight" )
    private BigDecimal handlingUnitMaxWeight;
    /**
     * Use with available fluent helpers to apply the <b>HandlingUnitMaxWeight</b> field to query operations.
     *
     */
    public final static HandlingUnitField<BigDecimal> HANDLING_UNIT_MAX_WEIGHT =
        new HandlingUnitField<BigDecimal>("HandlingUnitMaxWeight");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>WeightUnit</b>
     * </p>
     *
     * @return Unit of Weight
     */
    @SerializedName( "WeightUnit" )
    @JsonProperty( "WeightUnit" )
    @Nullable
    @ODataField( odataName = "WeightUnit" )
    private String weightUnit;
    /**
     * Use with available fluent helpers to apply the <b>WeightUnit</b> field to query operations.
     *
     */
    public final static HandlingUnitField<String> WEIGHT_UNIT = new HandlingUnitField<String>("WeightUnit");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>HandlingUnitTareWeight</b>
     * </p>
     *
     * @return Tare Weight of Handling Unit
     */
    @SerializedName( "HandlingUnitTareWeight" )
    @JsonProperty( "HandlingUnitTareWeight" )
    @Nullable
    @ODataField( odataName = "HandlingUnitTareWeight" )
    private BigDecimal handlingUnitTareWeight;
    /**
     * Use with available fluent helpers to apply the <b>HandlingUnitTareWeight</b> field to query operations.
     *
     */
    public final static HandlingUnitField<BigDecimal> HANDLING_UNIT_TARE_WEIGHT =
        new HandlingUnitField<BigDecimal>("HandlingUnitTareWeight");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>HandlingUnitTareWeightUnit</b>
     * </p>
     *
     * @return Unit of Weight
     */
    @SerializedName( "HandlingUnitTareWeightUnit" )
    @JsonProperty( "HandlingUnitTareWeightUnit" )
    @Nullable
    @ODataField( odataName = "HandlingUnitTareWeightUnit" )
    private String handlingUnitTareWeightUnit;
    /**
     * Use with available fluent helpers to apply the <b>HandlingUnitTareWeightUnit</b> field to query operations.
     *
     */
    public final static HandlingUnitField<String> HANDLING_UNIT_TARE_WEIGHT_UNIT =
        new HandlingUnitField<String>("HandlingUnitTareWeightUnit");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>GrossVolume</b>
     * </p>
     *
     * @return Total Volume of Handling Unit
     */
    @SerializedName( "GrossVolume" )
    @JsonProperty( "GrossVolume" )
    @Nullable
    @ODataField( odataName = "GrossVolume" )
    private BigDecimal grossVolume;
    /**
     * Use with available fluent helpers to apply the <b>GrossVolume</b> field to query operations.
     *
     */
    public final static HandlingUnitField<BigDecimal> GROSS_VOLUME = new HandlingUnitField<BigDecimal>("GrossVolume");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>HandlingUnitNetVolume</b>
     * </p>
     *
     * @return Loading Volume of Handling Unit
     */
    @SerializedName( "HandlingUnitNetVolume" )
    @JsonProperty( "HandlingUnitNetVolume" )
    @Nullable
    @ODataField( odataName = "HandlingUnitNetVolume" )
    private BigDecimal handlingUnitNetVolume;
    /**
     * Use with available fluent helpers to apply the <b>HandlingUnitNetVolume</b> field to query operations.
     *
     */
    public final static HandlingUnitField<BigDecimal> HANDLING_UNIT_NET_VOLUME =
        new HandlingUnitField<BigDecimal>("HandlingUnitNetVolume");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>VolumeUnit</b>
     * </p>
     *
     * @return Volume Unit
     */
    @SerializedName( "VolumeUnit" )
    @JsonProperty( "VolumeUnit" )
    @Nullable
    @ODataField( odataName = "VolumeUnit" )
    private String volumeUnit;
    /**
     * Use with available fluent helpers to apply the <b>VolumeUnit</b> field to query operations.
     *
     */
    public final static HandlingUnitField<String> VOLUME_UNIT = new HandlingUnitField<String>("VolumeUnit");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>HandlingUnitTareVolume</b>
     * </p>
     *
     * @return Tare Volume of Handling Unit
     */
    @SerializedName( "HandlingUnitTareVolume" )
    @JsonProperty( "HandlingUnitTareVolume" )
    @Nullable
    @ODataField( odataName = "HandlingUnitTareVolume" )
    private BigDecimal handlingUnitTareVolume;
    /**
     * Use with available fluent helpers to apply the <b>HandlingUnitTareVolume</b> field to query operations.
     *
     */
    public final static HandlingUnitField<BigDecimal> HANDLING_UNIT_TARE_VOLUME =
        new HandlingUnitField<BigDecimal>("HandlingUnitTareVolume");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>HandlingUnitTareVolumeUnit</b>
     * </p>
     *
     * @return Volume Unit
     */
    @SerializedName( "HandlingUnitTareVolumeUnit" )
    @JsonProperty( "HandlingUnitTareVolumeUnit" )
    @Nullable
    @ODataField( odataName = "HandlingUnitTareVolumeUnit" )
    private String handlingUnitTareVolumeUnit;
    /**
     * Use with available fluent helpers to apply the <b>HandlingUnitTareVolumeUnit</b> field to query operations.
     *
     */
    public final static HandlingUnitField<String> HANDLING_UNIT_TARE_VOLUME_UNIT =
        new HandlingUnitField<String>("HandlingUnitTareVolumeUnit");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>HandlingUnitLength</b>
     * </p>
     *
     * @return Length
     */
    @SerializedName( "HandlingUnitLength" )
    @JsonProperty( "HandlingUnitLength" )
    @Nullable
    @ODataField( odataName = "HandlingUnitLength" )
    private BigDecimal handlingUnitLength;
    /**
     * Use with available fluent helpers to apply the <b>HandlingUnitLength</b> field to query operations.
     *
     */
    public final static HandlingUnitField<BigDecimal> HANDLING_UNIT_LENGTH =
        new HandlingUnitField<BigDecimal>("HandlingUnitLength");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>HandlingUnitWidth</b>
     * </p>
     *
     * @return Width
     */
    @SerializedName( "HandlingUnitWidth" )
    @JsonProperty( "HandlingUnitWidth" )
    @Nullable
    @ODataField( odataName = "HandlingUnitWidth" )
    private BigDecimal handlingUnitWidth;
    /**
     * Use with available fluent helpers to apply the <b>HandlingUnitWidth</b> field to query operations.
     *
     */
    public final static HandlingUnitField<BigDecimal> HANDLING_UNIT_WIDTH =
        new HandlingUnitField<BigDecimal>("HandlingUnitWidth");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>HandlingUnitHeight</b>
     * </p>
     *
     * @return Height
     */
    @SerializedName( "HandlingUnitHeight" )
    @JsonProperty( "HandlingUnitHeight" )
    @Nullable
    @ODataField( odataName = "HandlingUnitHeight" )
    private BigDecimal handlingUnitHeight;
    /**
     * Use with available fluent helpers to apply the <b>HandlingUnitHeight</b> field to query operations.
     *
     */
    public final static HandlingUnitField<BigDecimal> HANDLING_UNIT_HEIGHT =
        new HandlingUnitField<BigDecimal>("HandlingUnitHeight");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>UnitOfMeasureDimension</b>
     * </p>
     *
     * @return Unit of Dimension for Length/Width/Height
     */
    @SerializedName( "UnitOfMeasureDimension" )
    @JsonProperty( "UnitOfMeasureDimension" )
    @Nullable
    @ODataField( odataName = "UnitOfMeasureDimension" )
    private String unitOfMeasureDimension;
    /**
     * Use with available fluent helpers to apply the <b>UnitOfMeasureDimension</b> field to query operations.
     *
     */
    public final static HandlingUnitField<String> UNIT_OF_MEASURE_DIMENSION =
        new HandlingUnitField<String>("UnitOfMeasureDimension");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>HandlingUnitPackingObjectKey</b>
     * </p>
     *
     * @return Key for Object to Which the Handling Unit is Assigned
     */
    @SerializedName( "HandlingUnitPackingObjectKey" )
    @JsonProperty( "HandlingUnitPackingObjectKey" )
    @Nullable
    @ODataField( odataName = "HandlingUnitPackingObjectKey" )
    private String handlingUnitPackingObjectKey;
    /**
     * Use with available fluent helpers to apply the <b>HandlingUnitPackingObjectKey</b> field to query operations.
     *
     */
    public final static HandlingUnitField<String> HANDLING_UNIT_PACKING_OBJECT_KEY =
        new HandlingUnitField<String>("HandlingUnitPackingObjectKey");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>HandlingUnitReferenceDocument</b>
     * </p>
     *
     * @return Sales and Distribution Document Number
     */
    @SerializedName( "HandlingUnitReferenceDocument" )
    @JsonProperty( "HandlingUnitReferenceDocument" )
    @Nullable
    @ODataField( odataName = "HandlingUnitReferenceDocument" )
    private String handlingUnitReferenceDocument;
    /**
     * Use with available fluent helpers to apply the <b>HandlingUnitReferenceDocument</b> field to query operations.
     *
     */
    public final static HandlingUnitField<String> HANDLING_UNIT_REFERENCE_DOCUMENT =
        new HandlingUnitField<String>("HandlingUnitReferenceDocument");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUser</b>
     * </p>
     *
     * @return Name of Person Responsible for Creating the Object
     */
    @SerializedName( "CreatedByUser" )
    @JsonProperty( "CreatedByUser" )
    @Nullable
    @ODataField( odataName = "CreatedByUser" )
    private String createdByUser;
    /**
     * Use with available fluent helpers to apply the <b>CreatedByUser</b> field to query operations.
     *
     */
    public final static HandlingUnitField<String> CREATED_BY_USER = new HandlingUnitField<String>("CreatedByUser");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationDateTime</b>
     * </p>
     *
     * @return The creationDateTime contained in this entity.
     */
    @SerializedName( "CreationDateTime" )
    @JsonProperty( "CreationDateTime" )
    @Nullable
    @ODataField( odataName = "CreationDateTime" )
    private BigDecimal creationDateTime;
    /**
     * Use with available fluent helpers to apply the <b>CreationDateTime</b> field to query operations.
     *
     */
    public final static HandlingUnitField<BigDecimal> CREATION_DATE_TIME =
        new HandlingUnitField<BigDecimal>("CreationDateTime");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>LastChangedByUser</b>
     * </p>
     *
     * @return Name of Person Who Changed Object
     */
    @SerializedName( "LastChangedByUser" )
    @JsonProperty( "LastChangedByUser" )
    @Nullable
    @ODataField( odataName = "LastChangedByUser" )
    private String lastChangedByUser;
    /**
     * Use with available fluent helpers to apply the <b>LastChangedByUser</b> field to query operations.
     *
     */
    public final static HandlingUnitField<String> LAST_CHANGED_BY_USER =
        new HandlingUnitField<String>("LastChangedByUser");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDateTime</b>
     * </p>
     *
     * @return The lastChangeDateTime contained in this entity.
     */
    @SerializedName( "LastChangeDateTime" )
    @JsonProperty( "LastChangeDateTime" )
    @Nullable
    @ODataField( odataName = "LastChangeDateTime" )
    private BigDecimal lastChangeDateTime;
    /**
     * Use with available fluent helpers to apply the <b>LastChangeDateTime</b> field to query operations.
     *
     */
    public final static HandlingUnitField<BigDecimal> LAST_CHANGE_DATE_TIME =
        new HandlingUnitField<BigDecimal>("LastChangeDateTime");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>HandlingUnitProcessStatus</b>
     * </p>
     *
     * @return Handling Unit Process Status
     */
    @SerializedName( "HandlingUnitProcessStatus" )
    @JsonProperty( "HandlingUnitProcessStatus" )
    @Nullable
    @ODataField( odataName = "HandlingUnitProcessStatus" )
    private String handlingUnitProcessStatus;
    /**
     * Use with available fluent helpers to apply the <b>HandlingUnitProcessStatus</b> field to query operations.
     *
     */
    public final static HandlingUnitField<String> HANDLING_UNIT_PROCESS_STATUS =
        new HandlingUnitField<String>("HandlingUnitProcessStatus");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>StorageType</b>
     * </p>
     *
     * @return Storage Type
     */
    @SerializedName( "StorageType" )
    @JsonProperty( "StorageType" )
    @Nullable
    @ODataField( odataName = "StorageType" )
    private String storageType;
    /**
     * Use with available fluent helpers to apply the <b>StorageType</b> field to query operations.
     *
     */
    public final static HandlingUnitField<String> STORAGE_TYPE = new HandlingUnitField<String>("StorageType");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>StorageSection</b>
     * </p>
     *
     * @return Storage Section
     */
    @SerializedName( "StorageSection" )
    @JsonProperty( "StorageSection" )
    @Nullable
    @ODataField( odataName = "StorageSection" )
    private String storageSection;
    /**
     * Use with available fluent helpers to apply the <b>StorageSection</b> field to query operations.
     *
     */
    public final static HandlingUnitField<String> STORAGE_SECTION = new HandlingUnitField<String>("StorageSection");
    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>StorageBin</b>
     * </p>
     *
     * @return Storage Bin
     */
    @SerializedName( "StorageBin" )
    @JsonProperty( "StorageBin" )
    @Nullable
    @ODataField( odataName = "StorageBin" )
    private String storageBin;
    /**
     * Use with available fluent helpers to apply the <b>StorageBin</b> field to query operations.
     *
     */
    public final static HandlingUnitField<String> STORAGE_BIN = new HandlingUnitField<String>("StorageBin");
    /**
     * Navigation property <b>to_HandlingUnitItem</b> for <b>HandlingUnit</b> to multiple <b>HandlingUnitItem</b>.
     *
     */
    @SerializedName( "to_HandlingUnitItem" )
    @JsonProperty( "to_HandlingUnitItem" )
    @ODataField( odataName = "to_HandlingUnitItem" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<HandlingUnitItem> toHandlingUnitItem;
    /**
     * Use with available fluent helpers to apply the <b>to_HandlingUnitItem</b> navigation property to query
     * operations.
     *
     */
    public final static HandlingUnitLink<HandlingUnitItem> TO_HANDLING_UNIT_ITEM =
        new HandlingUnitLink<HandlingUnitItem>("to_HandlingUnitItem");

    @Nonnull
    @Override
    public Class<HandlingUnit> getType()
    {
        return HandlingUnit.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>HandlingUnitExternalID</b>
     * </p>
     *
     * @param handlingUnitExternalID
     *            External Handling Unit Identification
     */
    public void setHandlingUnitExternalID( @Nullable final String handlingUnitExternalID )
    {
        rememberChangedField("HandlingUnitExternalID", this.handlingUnitExternalID);
        this.handlingUnitExternalID = handlingUnitExternalID;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Warehouse</b>
     * </p>
     *
     * @param warehouse
     *            Warehouse Number/Warehouse Complex
     */
    public void setWarehouse( @Nullable final String warehouse )
    {
        rememberChangedField("Warehouse", this.warehouse);
        this.warehouse = warehouse;
    }

    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>PackagingMaterial</b>
     * </p>
     *
     * @param packagingMaterial
     *            Packaging Materials
     */
    public void setPackagingMaterial( @Nullable final String packagingMaterial )
    {
        rememberChangedField("PackagingMaterial", this.packagingMaterial);
        this.packagingMaterial = packagingMaterial;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PackagingMaterialType</b>
     * </p>
     *
     * @param packagingMaterialType
     *            Packaging Material Type
     */
    public void setPackagingMaterialType( @Nullable final String packagingMaterialType )
    {
        rememberChangedField("PackagingMaterialType", this.packagingMaterialType);
        this.packagingMaterialType = packagingMaterialType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @param plant
     *            Plant
     */
    public void setPlant( @Nullable final String plant )
    {
        rememberChangedField("Plant", this.plant);
        this.plant = plant;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>StorageLocation</b>
     * </p>
     *
     * @param storageLocation
     *            Storage Location
     */
    public void setStorageLocation( @Nullable final String storageLocation )
    {
        rememberChangedField("StorageLocation", this.storageLocation);
        this.storageLocation = storageLocation;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ShippingPoint</b>
     * </p>
     *
     * @param shippingPoint
     *            Shipping Point / Receiving Point
     */
    public void setShippingPoint( @Nullable final String shippingPoint )
    {
        rememberChangedField("ShippingPoint", this.shippingPoint);
        this.shippingPoint = shippingPoint;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>ParentHandlingUnitNumber</b>
     * </p>
     *
     * @param parentHandlingUnitNumber
     *            External Handling Unit Identification
     */
    public void setParentHandlingUnitNumber( @Nullable final String parentHandlingUnitNumber )
    {
        rememberChangedField("ParentHandlingUnitNumber", this.parentHandlingUnitNumber);
        this.parentHandlingUnitNumber = parentHandlingUnitNumber;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>GrossWeight</b>
     * </p>
     *
     * @param grossWeight
     *            Total Weight of Handling Unit
     */
    public void setGrossWeight( @Nullable final BigDecimal grossWeight )
    {
        rememberChangedField("GrossWeight", this.grossWeight);
        this.grossWeight = grossWeight;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>NetWeight</b>
     * </p>
     *
     * @param netWeight
     *            Loading Weight of Handling Unit
     */
    public void setNetWeight( @Nullable final BigDecimal netWeight )
    {
        rememberChangedField("NetWeight", this.netWeight);
        this.netWeight = netWeight;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>HandlingUnitMaxWeight</b>
     * </p>
     *
     * @param handlingUnitMaxWeight
     *            Allowed Loading Weight of a Handling Unit
     */
    public void setHandlingUnitMaxWeight( @Nullable final BigDecimal handlingUnitMaxWeight )
    {
        rememberChangedField("HandlingUnitMaxWeight", this.handlingUnitMaxWeight);
        this.handlingUnitMaxWeight = handlingUnitMaxWeight;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>WeightUnit</b>
     * </p>
     *
     * @param weightUnit
     *            Unit of Weight
     */
    public void setWeightUnit( @Nullable final String weightUnit )
    {
        rememberChangedField("WeightUnit", this.weightUnit);
        this.weightUnit = weightUnit;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>HandlingUnitTareWeight</b>
     * </p>
     *
     * @param handlingUnitTareWeight
     *            Tare Weight of Handling Unit
     */
    public void setHandlingUnitTareWeight( @Nullable final BigDecimal handlingUnitTareWeight )
    {
        rememberChangedField("HandlingUnitTareWeight", this.handlingUnitTareWeight);
        this.handlingUnitTareWeight = handlingUnitTareWeight;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>HandlingUnitTareWeightUnit</b>
     * </p>
     *
     * @param handlingUnitTareWeightUnit
     *            Unit of Weight
     */
    public void setHandlingUnitTareWeightUnit( @Nullable final String handlingUnitTareWeightUnit )
    {
        rememberChangedField("HandlingUnitTareWeightUnit", this.handlingUnitTareWeightUnit);
        this.handlingUnitTareWeightUnit = handlingUnitTareWeightUnit;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>GrossVolume</b>
     * </p>
     *
     * @param grossVolume
     *            Total Volume of Handling Unit
     */
    public void setGrossVolume( @Nullable final BigDecimal grossVolume )
    {
        rememberChangedField("GrossVolume", this.grossVolume);
        this.grossVolume = grossVolume;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>HandlingUnitNetVolume</b>
     * </p>
     *
     * @param handlingUnitNetVolume
     *            Loading Volume of Handling Unit
     */
    public void setHandlingUnitNetVolume( @Nullable final BigDecimal handlingUnitNetVolume )
    {
        rememberChangedField("HandlingUnitNetVolume", this.handlingUnitNetVolume);
        this.handlingUnitNetVolume = handlingUnitNetVolume;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>VolumeUnit</b>
     * </p>
     *
     * @param volumeUnit
     *            Volume Unit
     */
    public void setVolumeUnit( @Nullable final String volumeUnit )
    {
        rememberChangedField("VolumeUnit", this.volumeUnit);
        this.volumeUnit = volumeUnit;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>HandlingUnitTareVolume</b>
     * </p>
     *
     * @param handlingUnitTareVolume
     *            Tare Volume of Handling Unit
     */
    public void setHandlingUnitTareVolume( @Nullable final BigDecimal handlingUnitTareVolume )
    {
        rememberChangedField("HandlingUnitTareVolume", this.handlingUnitTareVolume);
        this.handlingUnitTareVolume = handlingUnitTareVolume;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>HandlingUnitTareVolumeUnit</b>
     * </p>
     *
     * @param handlingUnitTareVolumeUnit
     *            Volume Unit
     */
    public void setHandlingUnitTareVolumeUnit( @Nullable final String handlingUnitTareVolumeUnit )
    {
        rememberChangedField("HandlingUnitTareVolumeUnit", this.handlingUnitTareVolumeUnit);
        this.handlingUnitTareVolumeUnit = handlingUnitTareVolumeUnit;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>HandlingUnitLength</b>
     * </p>
     *
     * @param handlingUnitLength
     *            Length
     */
    public void setHandlingUnitLength( @Nullable final BigDecimal handlingUnitLength )
    {
        rememberChangedField("HandlingUnitLength", this.handlingUnitLength);
        this.handlingUnitLength = handlingUnitLength;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>HandlingUnitWidth</b>
     * </p>
     *
     * @param handlingUnitWidth
     *            Width
     */
    public void setHandlingUnitWidth( @Nullable final BigDecimal handlingUnitWidth )
    {
        rememberChangedField("HandlingUnitWidth", this.handlingUnitWidth);
        this.handlingUnitWidth = handlingUnitWidth;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>HandlingUnitHeight</b>
     * </p>
     *
     * @param handlingUnitHeight
     *            Height
     */
    public void setHandlingUnitHeight( @Nullable final BigDecimal handlingUnitHeight )
    {
        rememberChangedField("HandlingUnitHeight", this.handlingUnitHeight);
        this.handlingUnitHeight = handlingUnitHeight;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>UnitOfMeasureDimension</b>
     * </p>
     *
     * @param unitOfMeasureDimension
     *            Unit of Dimension for Length/Width/Height
     */
    public void setUnitOfMeasureDimension( @Nullable final String unitOfMeasureDimension )
    {
        rememberChangedField("UnitOfMeasureDimension", this.unitOfMeasureDimension);
        this.unitOfMeasureDimension = unitOfMeasureDimension;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>HandlingUnitPackingObjectKey</b>
     * </p>
     *
     * @param handlingUnitPackingObjectKey
     *            Key for Object to Which the Handling Unit is Assigned
     */
    public void setHandlingUnitPackingObjectKey( @Nullable final String handlingUnitPackingObjectKey )
    {
        rememberChangedField("HandlingUnitPackingObjectKey", this.handlingUnitPackingObjectKey);
        this.handlingUnitPackingObjectKey = handlingUnitPackingObjectKey;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>HandlingUnitReferenceDocument</b>
     * </p>
     *
     * @param handlingUnitReferenceDocument
     *            Sales and Distribution Document Number
     */
    public void setHandlingUnitReferenceDocument( @Nullable final String handlingUnitReferenceDocument )
    {
        rememberChangedField("HandlingUnitReferenceDocument", this.handlingUnitReferenceDocument);
        this.handlingUnitReferenceDocument = handlingUnitReferenceDocument;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUser</b>
     * </p>
     *
     * @param createdByUser
     *            Name of Person Responsible for Creating the Object
     */
    public void setCreatedByUser( @Nullable final String createdByUser )
    {
        rememberChangedField("CreatedByUser", this.createdByUser);
        this.createdByUser = createdByUser;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationDateTime</b>
     * </p>
     *
     * @param creationDateTime
     *            The creationDateTime to set.
     */
    public void setCreationDateTime( @Nullable final BigDecimal creationDateTime )
    {
        rememberChangedField("CreationDateTime", this.creationDateTime);
        this.creationDateTime = creationDateTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>LastChangedByUser</b>
     * </p>
     *
     * @param lastChangedByUser
     *            Name of Person Who Changed Object
     */
    public void setLastChangedByUser( @Nullable final String lastChangedByUser )
    {
        rememberChangedField("LastChangedByUser", this.lastChangedByUser);
        this.lastChangedByUser = lastChangedByUser;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDateTime</b>
     * </p>
     *
     * @param lastChangeDateTime
     *            The lastChangeDateTime to set.
     */
    public void setLastChangeDateTime( @Nullable final BigDecimal lastChangeDateTime )
    {
        rememberChangedField("LastChangeDateTime", this.lastChangeDateTime);
        this.lastChangeDateTime = lastChangeDateTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>HandlingUnitProcessStatus</b>
     * </p>
     *
     * @param handlingUnitProcessStatus
     *            Handling Unit Process Status
     */
    public void setHandlingUnitProcessStatus( @Nullable final String handlingUnitProcessStatus )
    {
        rememberChangedField("HandlingUnitProcessStatus", this.handlingUnitProcessStatus);
        this.handlingUnitProcessStatus = handlingUnitProcessStatus;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>StorageType</b>
     * </p>
     *
     * @param storageType
     *            Storage Type
     */
    public void setStorageType( @Nullable final String storageType )
    {
        rememberChangedField("StorageType", this.storageType);
        this.storageType = storageType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>StorageSection</b>
     * </p>
     *
     * @param storageSection
     *            Storage Section
     */
    public void setStorageSection( @Nullable final String storageSection )
    {
        rememberChangedField("StorageSection", this.storageSection);
        this.storageSection = storageSection;
    }

    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>StorageBin</b>
     * </p>
     *
     * @param storageBin
     *            Storage Bin
     */
    public void setStorageBin( @Nullable final String storageBin )
    {
        rememberChangedField("StorageBin", this.storageBin);
        this.storageBin = storageBin;
    }

    @Override
    protected String getEntityCollection()
    {
        return "HandlingUnit";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("HandlingUnitExternalID", getHandlingUnitExternalID());
        result.put("Warehouse", getWarehouse());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("HandlingUnitExternalID", getHandlingUnitExternalID());
        values.put("Warehouse", getWarehouse());
        values.put("PackagingMaterial", getPackagingMaterial());
        values.put("PackagingMaterialType", getPackagingMaterialType());
        values.put("Plant", getPlant());
        values.put("StorageLocation", getStorageLocation());
        values.put("ShippingPoint", getShippingPoint());
        values.put("ParentHandlingUnitNumber", getParentHandlingUnitNumber());
        values.put("GrossWeight", getGrossWeight());
        values.put("NetWeight", getNetWeight());
        values.put("HandlingUnitMaxWeight", getHandlingUnitMaxWeight());
        values.put("WeightUnit", getWeightUnit());
        values.put("HandlingUnitTareWeight", getHandlingUnitTareWeight());
        values.put("HandlingUnitTareWeightUnit", getHandlingUnitTareWeightUnit());
        values.put("GrossVolume", getGrossVolume());
        values.put("HandlingUnitNetVolume", getHandlingUnitNetVolume());
        values.put("VolumeUnit", getVolumeUnit());
        values.put("HandlingUnitTareVolume", getHandlingUnitTareVolume());
        values.put("HandlingUnitTareVolumeUnit", getHandlingUnitTareVolumeUnit());
        values.put("HandlingUnitLength", getHandlingUnitLength());
        values.put("HandlingUnitWidth", getHandlingUnitWidth());
        values.put("HandlingUnitHeight", getHandlingUnitHeight());
        values.put("UnitOfMeasureDimension", getUnitOfMeasureDimension());
        values.put("HandlingUnitPackingObjectKey", getHandlingUnitPackingObjectKey());
        values.put("HandlingUnitReferenceDocument", getHandlingUnitReferenceDocument());
        values.put("CreatedByUser", getCreatedByUser());
        values.put("CreationDateTime", getCreationDateTime());
        values.put("LastChangedByUser", getLastChangedByUser());
        values.put("LastChangeDateTime", getLastChangeDateTime());
        values.put("HandlingUnitProcessStatus", getHandlingUnitProcessStatus());
        values.put("StorageType", getStorageType());
        values.put("StorageSection", getStorageSection());
        values.put("StorageBin", getStorageBin());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("HandlingUnitExternalID") ) {
                final Object value = values.remove("HandlingUnitExternalID");
                if( (value == null) || (!value.equals(getHandlingUnitExternalID())) ) {
                    setHandlingUnitExternalID(((String) value));
                }
            }
            if( values.containsKey("Warehouse") ) {
                final Object value = values.remove("Warehouse");
                if( (value == null) || (!value.equals(getWarehouse())) ) {
                    setWarehouse(((String) value));
                }
            }
            if( values.containsKey("PackagingMaterial") ) {
                final Object value = values.remove("PackagingMaterial");
                if( (value == null) || (!value.equals(getPackagingMaterial())) ) {
                    setPackagingMaterial(((String) value));
                }
            }
            if( values.containsKey("PackagingMaterialType") ) {
                final Object value = values.remove("PackagingMaterialType");
                if( (value == null) || (!value.equals(getPackagingMaterialType())) ) {
                    setPackagingMaterialType(((String) value));
                }
            }
            if( values.containsKey("Plant") ) {
                final Object value = values.remove("Plant");
                if( (value == null) || (!value.equals(getPlant())) ) {
                    setPlant(((String) value));
                }
            }
            if( values.containsKey("StorageLocation") ) {
                final Object value = values.remove("StorageLocation");
                if( (value == null) || (!value.equals(getStorageLocation())) ) {
                    setStorageLocation(((String) value));
                }
            }
            if( values.containsKey("ShippingPoint") ) {
                final Object value = values.remove("ShippingPoint");
                if( (value == null) || (!value.equals(getShippingPoint())) ) {
                    setShippingPoint(((String) value));
                }
            }
            if( values.containsKey("ParentHandlingUnitNumber") ) {
                final Object value = values.remove("ParentHandlingUnitNumber");
                if( (value == null) || (!value.equals(getParentHandlingUnitNumber())) ) {
                    setParentHandlingUnitNumber(((String) value));
                }
            }
            if( values.containsKey("GrossWeight") ) {
                final Object value = values.remove("GrossWeight");
                if( (value == null) || (!value.equals(getGrossWeight())) ) {
                    setGrossWeight(((BigDecimal) value));
                }
            }
            if( values.containsKey("NetWeight") ) {
                final Object value = values.remove("NetWeight");
                if( (value == null) || (!value.equals(getNetWeight())) ) {
                    setNetWeight(((BigDecimal) value));
                }
            }
            if( values.containsKey("HandlingUnitMaxWeight") ) {
                final Object value = values.remove("HandlingUnitMaxWeight");
                if( (value == null) || (!value.equals(getHandlingUnitMaxWeight())) ) {
                    setHandlingUnitMaxWeight(((BigDecimal) value));
                }
            }
            if( values.containsKey("WeightUnit") ) {
                final Object value = values.remove("WeightUnit");
                if( (value == null) || (!value.equals(getWeightUnit())) ) {
                    setWeightUnit(((String) value));
                }
            }
            if( values.containsKey("HandlingUnitTareWeight") ) {
                final Object value = values.remove("HandlingUnitTareWeight");
                if( (value == null) || (!value.equals(getHandlingUnitTareWeight())) ) {
                    setHandlingUnitTareWeight(((BigDecimal) value));
                }
            }
            if( values.containsKey("HandlingUnitTareWeightUnit") ) {
                final Object value = values.remove("HandlingUnitTareWeightUnit");
                if( (value == null) || (!value.equals(getHandlingUnitTareWeightUnit())) ) {
                    setHandlingUnitTareWeightUnit(((String) value));
                }
            }
            if( values.containsKey("GrossVolume") ) {
                final Object value = values.remove("GrossVolume");
                if( (value == null) || (!value.equals(getGrossVolume())) ) {
                    setGrossVolume(((BigDecimal) value));
                }
            }
            if( values.containsKey("HandlingUnitNetVolume") ) {
                final Object value = values.remove("HandlingUnitNetVolume");
                if( (value == null) || (!value.equals(getHandlingUnitNetVolume())) ) {
                    setHandlingUnitNetVolume(((BigDecimal) value));
                }
            }
            if( values.containsKey("VolumeUnit") ) {
                final Object value = values.remove("VolumeUnit");
                if( (value == null) || (!value.equals(getVolumeUnit())) ) {
                    setVolumeUnit(((String) value));
                }
            }
            if( values.containsKey("HandlingUnitTareVolume") ) {
                final Object value = values.remove("HandlingUnitTareVolume");
                if( (value == null) || (!value.equals(getHandlingUnitTareVolume())) ) {
                    setHandlingUnitTareVolume(((BigDecimal) value));
                }
            }
            if( values.containsKey("HandlingUnitTareVolumeUnit") ) {
                final Object value = values.remove("HandlingUnitTareVolumeUnit");
                if( (value == null) || (!value.equals(getHandlingUnitTareVolumeUnit())) ) {
                    setHandlingUnitTareVolumeUnit(((String) value));
                }
            }
            if( values.containsKey("HandlingUnitLength") ) {
                final Object value = values.remove("HandlingUnitLength");
                if( (value == null) || (!value.equals(getHandlingUnitLength())) ) {
                    setHandlingUnitLength(((BigDecimal) value));
                }
            }
            if( values.containsKey("HandlingUnitWidth") ) {
                final Object value = values.remove("HandlingUnitWidth");
                if( (value == null) || (!value.equals(getHandlingUnitWidth())) ) {
                    setHandlingUnitWidth(((BigDecimal) value));
                }
            }
            if( values.containsKey("HandlingUnitHeight") ) {
                final Object value = values.remove("HandlingUnitHeight");
                if( (value == null) || (!value.equals(getHandlingUnitHeight())) ) {
                    setHandlingUnitHeight(((BigDecimal) value));
                }
            }
            if( values.containsKey("UnitOfMeasureDimension") ) {
                final Object value = values.remove("UnitOfMeasureDimension");
                if( (value == null) || (!value.equals(getUnitOfMeasureDimension())) ) {
                    setUnitOfMeasureDimension(((String) value));
                }
            }
            if( values.containsKey("HandlingUnitPackingObjectKey") ) {
                final Object value = values.remove("HandlingUnitPackingObjectKey");
                if( (value == null) || (!value.equals(getHandlingUnitPackingObjectKey())) ) {
                    setHandlingUnitPackingObjectKey(((String) value));
                }
            }
            if( values.containsKey("HandlingUnitReferenceDocument") ) {
                final Object value = values.remove("HandlingUnitReferenceDocument");
                if( (value == null) || (!value.equals(getHandlingUnitReferenceDocument())) ) {
                    setHandlingUnitReferenceDocument(((String) value));
                }
            }
            if( values.containsKey("CreatedByUser") ) {
                final Object value = values.remove("CreatedByUser");
                if( (value == null) || (!value.equals(getCreatedByUser())) ) {
                    setCreatedByUser(((String) value));
                }
            }
            if( values.containsKey("CreationDateTime") ) {
                final Object value = values.remove("CreationDateTime");
                if( (value == null) || (!value.equals(getCreationDateTime())) ) {
                    setCreationDateTime(((BigDecimal) value));
                }
            }
            if( values.containsKey("LastChangedByUser") ) {
                final Object value = values.remove("LastChangedByUser");
                if( (value == null) || (!value.equals(getLastChangedByUser())) ) {
                    setLastChangedByUser(((String) value));
                }
            }
            if( values.containsKey("LastChangeDateTime") ) {
                final Object value = values.remove("LastChangeDateTime");
                if( (value == null) || (!value.equals(getLastChangeDateTime())) ) {
                    setLastChangeDateTime(((BigDecimal) value));
                }
            }
            if( values.containsKey("HandlingUnitProcessStatus") ) {
                final Object value = values.remove("HandlingUnitProcessStatus");
                if( (value == null) || (!value.equals(getHandlingUnitProcessStatus())) ) {
                    setHandlingUnitProcessStatus(((String) value));
                }
            }
            if( values.containsKey("StorageType") ) {
                final Object value = values.remove("StorageType");
                if( (value == null) || (!value.equals(getStorageType())) ) {
                    setStorageType(((String) value));
                }
            }
            if( values.containsKey("StorageSection") ) {
                final Object value = values.remove("StorageSection");
                if( (value == null) || (!value.equals(getStorageSection())) ) {
                    setStorageSection(((String) value));
                }
            }
            if( values.containsKey("StorageBin") ) {
                final Object value = values.remove("StorageBin");
                if( (value == null) || (!value.equals(getStorageBin())) ) {
                    setStorageBin(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_HandlingUnitItem") ) {
                final Object value = (values).remove("to_HandlingUnitItem");
                if( value instanceof Iterable ) {
                    if( toHandlingUnitItem == null ) {
                        toHandlingUnitItem = Lists.newArrayList();
                    } else {
                        toHandlingUnitItem = Lists.newArrayList(toHandlingUnitItem);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        HandlingUnitItem entity;
                        if( toHandlingUnitItem.size() > i ) {
                            entity = toHandlingUnitItem.get(i);
                        } else {
                            entity = new HandlingUnitItem();
                            toHandlingUnitItem.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> HandlingUnitField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new HandlingUnitField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> HandlingUnitField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new HandlingUnitField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.HandlingUnitService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toHandlingUnitItem != null ) {
            (values).put("to_HandlingUnitItem", toHandlingUnitItem);
        }
        return values;
    }

    /**
     * Fetches the <b>HandlingUnitItem</b> entities (one to many) associated with this entity. This corresponds to the
     * OData navigation property <b>to_HandlingUnitItem</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>HandlingUnitItem</b> entities. If no entities are associated
     *         then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<HandlingUnitItem> fetchHandlingUnitItem()
    {
        return fetchFieldAsList("to_HandlingUnitItem", HandlingUnitItem.class);
    }

    /**
     * Retrieval of associated <b>HandlingUnitItem</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_HandlingUnitItem</b>.
     * <p>
     * If the navigation property <b>to_HandlingUnitItem</b> of a queried <b>HandlingUnit</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>HandlingUnitItem</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<HandlingUnitItem> getHandlingUnitItemOrFetch()
    {
        if( toHandlingUnitItem == null ) {
            toHandlingUnitItem = fetchHandlingUnitItem();
        }
        return toHandlingUnitItem;
    }

    /**
     * Retrieval of associated <b>HandlingUnitItem</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_HandlingUnitItem</b>.
     * <p>
     * If the navigation property for an entity <b>HandlingUnit</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_HandlingUnitItem</b> is already loaded, the result will
     *         contain the <b>HandlingUnitItem</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<HandlingUnitItem>> getHandlingUnitItemIfPresent()
    {
        return Option.of(toHandlingUnitItem);
    }

    /**
     * Overwrites the list of associated <b>HandlingUnitItem</b> entities for the loaded navigation property
     * <b>to_HandlingUnitItem</b>.
     * <p>
     * If the navigation property <b>to_HandlingUnitItem</b> of a queried <b>HandlingUnit</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>HandlingUnitItem</b> entities.
     */
    public void setHandlingUnitItem( @Nonnull final List<HandlingUnitItem> value )
    {
        if( toHandlingUnitItem == null ) {
            toHandlingUnitItem = Lists.newArrayList();
        }
        toHandlingUnitItem.clear();
        toHandlingUnitItem.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>HandlingUnitItem</b> entities. This corresponds to the OData
     * navigation property <b>to_HandlingUnitItem</b>.
     * <p>
     * If the navigation property <b>to_HandlingUnitItem</b> of a queried <b>HandlingUnit</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>HandlingUnitItem</b> entities.
     */
    public void addHandlingUnitItem( HandlingUnitItem... entity )
    {
        if( toHandlingUnitItem == null ) {
            toHandlingUnitItem = Lists.newArrayList();
        }
        toHandlingUnitItem.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of HandlingUnit instances.
     *
     */
    public final static class HandlingUnitBuilder
    {

        private List<HandlingUnitItem> toHandlingUnitItem = Lists.newArrayList();

        private HandlingUnit.HandlingUnitBuilder toHandlingUnitItem( final List<HandlingUnitItem> value )
        {
            toHandlingUnitItem.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_HandlingUnitItem</b> for <b>HandlingUnit</b> to multiple <b>HandlingUnitItem</b>.
         *
         * @param value
         *            The HandlingUnitItems to build this HandlingUnit with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public HandlingUnit.HandlingUnitBuilder handlingUnitItem( HandlingUnitItem... value )
        {
            return toHandlingUnitItem(Lists.newArrayList(value));
        }

    }

}
