/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.handlingunit;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.Map;
import java.util.UUID;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.handlingunit.field.HandlingUnitItemField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.handlingunit.link.HandlingUnitItemOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.handlingunit.selectable.HandlingUnitItemSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Handling Unit Item (Deprecated)
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>HandlingUnitItemType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class HandlingUnitItem extends VdmEntity<HandlingUnitItem>
{

    /**
     * Selector for all available fields of HandlingUnitItem.
     *
     */
    public final static HandlingUnitItemSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>HandlingUnitExternalID</b>
     * </p>
     *
     * @return External Handling Unit Identification
     */
    @Key
    @SerializedName( "HandlingUnitExternalID" )
    @JsonProperty( "HandlingUnitExternalID" )
    @Nullable
    @ODataField( odataName = "HandlingUnitExternalID" )
    private String handlingUnitExternalID;
    /**
     * Use with available fluent helpers to apply the <b>HandlingUnitExternalID</b> field to query operations.
     *
     */
    public final static HandlingUnitItemField<String> HANDLING_UNIT_EXTERNAL_ID =
        new HandlingUnitItemField<String>("HandlingUnitExternalID");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Warehouse</b>
     * </p>
     *
     * @return Warehouse Number/Warehouse Complex
     */
    @Key
    @SerializedName( "Warehouse" )
    @JsonProperty( "Warehouse" )
    @Nullable
    @ODataField( odataName = "Warehouse" )
    private String warehouse;
    /**
     * Use with available fluent helpers to apply the <b>Warehouse</b> field to query operations.
     *
     */
    public final static HandlingUnitItemField<String> WAREHOUSE = new HandlingUnitItemField<String>("Warehouse");
    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>StockItemUUID</b>
     * </p>
     *
     * @return GUID Stock Item
     */
    @Key
    @SerializedName( "StockItemUUID" )
    @JsonProperty( "StockItemUUID" )
    @Nullable
    @ODataField( odataName = "StockItemUUID" )
    private UUID stockItemUUID;
    /**
     * Use with available fluent helpers to apply the <b>StockItemUUID</b> field to query operations.
     *
     */
    public final static HandlingUnitItemField<UUID> STOCK_ITEM_UUID = new HandlingUnitItemField<UUID>("StockItemUUID");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>HandlingUnitItem</b>
     * </p>
     *
     * @return Handling Unit Item
     */
    @SerializedName( "HandlingUnitItem" )
    @JsonProperty( "HandlingUnitItem" )
    @Nullable
    @ODataField( odataName = "HandlingUnitItem" )
    private String handlingUnitItem;
    /**
     * Use with available fluent helpers to apply the <b>HandlingUnitItem</b> field to query operations.
     *
     */
    public final static HandlingUnitItemField<String> HANDLING_UNIT_ITEM =
        new HandlingUnitItemField<String>("HandlingUnitItem");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>HandlingUnitReferenceDocument</b>
     * </p>
     *
     * @return Delivery
     */
    @SerializedName( "HandlingUnitReferenceDocument" )
    @JsonProperty( "HandlingUnitReferenceDocument" )
    @Nullable
    @ODataField( odataName = "HandlingUnitReferenceDocument" )
    private String handlingUnitReferenceDocument;
    /**
     * Use with available fluent helpers to apply the <b>HandlingUnitReferenceDocument</b> field to query operations.
     *
     */
    public final static HandlingUnitItemField<String> HANDLING_UNIT_REFERENCE_DOCUMENT =
        new HandlingUnitItemField<String>("HandlingUnitReferenceDocument");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>HandlingUnitRefDocumentItem</b>
     * </p>
     *
     * @return The handlingUnitRefDocumentItem contained in this entity.
     */
    @SerializedName( "HandlingUnitRefDocumentItem" )
    @JsonProperty( "HandlingUnitRefDocumentItem" )
    @Nullable
    @ODataField( odataName = "HandlingUnitRefDocumentItem" )
    private String handlingUnitRefDocumentItem;
    /**
     * Use with available fluent helpers to apply the <b>HandlingUnitRefDocumentItem</b> field to query operations.
     *
     */
    public final static HandlingUnitItemField<String> HANDLING_UNIT_REF_DOCUMENT_ITEM =
        new HandlingUnitItemField<String>("HandlingUnitRefDocumentItem");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>HandlingUnitQuantity</b>
     * </p>
     *
     * @return Base Quantity Packed in the Handling Unit Item
     */
    @SerializedName( "HandlingUnitQuantity" )
    @JsonProperty( "HandlingUnitQuantity" )
    @Nullable
    @ODataField( odataName = "HandlingUnitQuantity" )
    private BigDecimal handlingUnitQuantity;
    /**
     * Use with available fluent helpers to apply the <b>HandlingUnitQuantity</b> field to query operations.
     *
     */
    public final static HandlingUnitItemField<BigDecimal> HANDLING_UNIT_QUANTITY =
        new HandlingUnitItemField<BigDecimal>("HandlingUnitQuantity");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>HandlingUnitQuantityUnit</b>
     * </p>
     *
     * @return Base Unit of Measure of the Quantity to be Packed (VEMNG)
     */
    @SerializedName( "HandlingUnitQuantityUnit" )
    @JsonProperty( "HandlingUnitQuantityUnit" )
    @Nullable
    @ODataField( odataName = "HandlingUnitQuantityUnit" )
    private String handlingUnitQuantityUnit;
    /**
     * Use with available fluent helpers to apply the <b>HandlingUnitQuantityUnit</b> field to query operations.
     *
     */
    public final static HandlingUnitItemField<String> HANDLING_UNIT_QUANTITY_UNIT =
        new HandlingUnitItemField<String>("HandlingUnitQuantityUnit");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>HandlingUnitAltUnitOfMeasure</b>
     * </p>
     *
     * @return Alternative unit of measure for stock unit of measure
     */
    @SerializedName( "HandlingUnitAltUnitOfMeasure" )
    @JsonProperty( "HandlingUnitAltUnitOfMeasure" )
    @Nullable
    @ODataField( odataName = "HandlingUnitAltUnitOfMeasure" )
    private String handlingUnitAltUnitOfMeasure;
    /**
     * Use with available fluent helpers to apply the <b>HandlingUnitAltUnitOfMeasure</b> field to query operations.
     *
     */
    public final static HandlingUnitItemField<String> HANDLING_UNIT_ALT_UNIT_OF_MEASURE =
        new HandlingUnitItemField<String>("HandlingUnitAltUnitOfMeasure");
    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>Material</b>
     * </p>
     *
     * @return Material Number
     */
    @SerializedName( "Material" )
    @JsonProperty( "Material" )
    @Nullable
    @ODataField( odataName = "Material" )
    private String material;
    /**
     * Use with available fluent helpers to apply the <b>Material</b> field to query operations.
     *
     */
    public final static HandlingUnitItemField<String> MATERIAL = new HandlingUnitItemField<String>("Material");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ShelfLifeExpirationDate</b>
     * </p>
     *
     * @return Shelf Life Expiration or Best-Before Date
     */
    @SerializedName( "ShelfLifeExpirationDate" )
    @JsonProperty( "ShelfLifeExpirationDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ShelfLifeExpirationDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime shelfLifeExpirationDate;
    /**
     * Use with available fluent helpers to apply the <b>ShelfLifeExpirationDate</b> field to query operations.
     *
     */
    public final static HandlingUnitItemField<LocalDateTime> SHELF_LIFE_EXPIRATION_DATE =
        new HandlingUnitItemField<LocalDateTime>("ShelfLifeExpirationDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>HandlingUnitGoodsReceiptDate</b>
     * </p>
     *
     * @return Date of Goods Receipt
     */
    @SerializedName( "HandlingUnitGoodsReceiptDate" )
    @JsonProperty( "HandlingUnitGoodsReceiptDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "HandlingUnitGoodsReceiptDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime handlingUnitGoodsReceiptDate;
    /**
     * Use with available fluent helpers to apply the <b>HandlingUnitGoodsReceiptDate</b> field to query operations.
     *
     */
    public final static HandlingUnitItemField<LocalDateTime> HANDLING_UNIT_GOODS_RECEIPT_DATE =
        new HandlingUnitItemField<LocalDateTime>("HandlingUnitGoodsReceiptDate");
    /**
     * Navigation property <b>to_HandlingUnit</b> for <b>HandlingUnitItem</b> to single <b>HandlingUnit</b>.
     *
     */
    @SerializedName( "to_HandlingUnit" )
    @JsonProperty( "to_HandlingUnit" )
    @ODataField( odataName = "to_HandlingUnit" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private HandlingUnit toHandlingUnit;
    /**
     * Use with available fluent helpers to apply the <b>to_HandlingUnit</b> navigation property to query operations.
     *
     */
    public final static HandlingUnitItemOneToOneLink<HandlingUnit> TO_HANDLING_UNIT =
        new HandlingUnitItemOneToOneLink<HandlingUnit>("to_HandlingUnit");

    @Nonnull
    @Override
    public Class<HandlingUnitItem> getType()
    {
        return HandlingUnitItem.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>HandlingUnitExternalID</b>
     * </p>
     *
     * @param handlingUnitExternalID
     *            External Handling Unit Identification
     */
    public void setHandlingUnitExternalID( @Nullable final String handlingUnitExternalID )
    {
        rememberChangedField("HandlingUnitExternalID", this.handlingUnitExternalID);
        this.handlingUnitExternalID = handlingUnitExternalID;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Warehouse</b>
     * </p>
     *
     * @param warehouse
     *            Warehouse Number/Warehouse Complex
     */
    public void setWarehouse( @Nullable final String warehouse )
    {
        rememberChangedField("Warehouse", this.warehouse);
        this.warehouse = warehouse;
    }

    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>StockItemUUID</b>
     * </p>
     *
     * @param stockItemUUID
     *            GUID Stock Item
     */
    public void setStockItemUUID( @Nullable final UUID stockItemUUID )
    {
        rememberChangedField("StockItemUUID", this.stockItemUUID);
        this.stockItemUUID = stockItemUUID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>HandlingUnitItem</b>
     * </p>
     *
     * @param handlingUnitItem
     *            Handling Unit Item
     */
    public void setHandlingUnitItem( @Nullable final String handlingUnitItem )
    {
        rememberChangedField("HandlingUnitItem", this.handlingUnitItem);
        this.handlingUnitItem = handlingUnitItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>HandlingUnitReferenceDocument</b>
     * </p>
     *
     * @param handlingUnitReferenceDocument
     *            Delivery
     */
    public void setHandlingUnitReferenceDocument( @Nullable final String handlingUnitReferenceDocument )
    {
        rememberChangedField("HandlingUnitReferenceDocument", this.handlingUnitReferenceDocument);
        this.handlingUnitReferenceDocument = handlingUnitReferenceDocument;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>HandlingUnitRefDocumentItem</b>
     * </p>
     *
     * @param handlingUnitRefDocumentItem
     *            The handlingUnitRefDocumentItem to set.
     */
    public void setHandlingUnitRefDocumentItem( @Nullable final String handlingUnitRefDocumentItem )
    {
        rememberChangedField("HandlingUnitRefDocumentItem", this.handlingUnitRefDocumentItem);
        this.handlingUnitRefDocumentItem = handlingUnitRefDocumentItem;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>HandlingUnitQuantity</b>
     * </p>
     *
     * @param handlingUnitQuantity
     *            Base Quantity Packed in the Handling Unit Item
     */
    public void setHandlingUnitQuantity( @Nullable final BigDecimal handlingUnitQuantity )
    {
        rememberChangedField("HandlingUnitQuantity", this.handlingUnitQuantity);
        this.handlingUnitQuantity = handlingUnitQuantity;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>HandlingUnitQuantityUnit</b>
     * </p>
     *
     * @param handlingUnitQuantityUnit
     *            Base Unit of Measure of the Quantity to be Packed (VEMNG)
     */
    public void setHandlingUnitQuantityUnit( @Nullable final String handlingUnitQuantityUnit )
    {
        rememberChangedField("HandlingUnitQuantityUnit", this.handlingUnitQuantityUnit);
        this.handlingUnitQuantityUnit = handlingUnitQuantityUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>HandlingUnitAltUnitOfMeasure</b>
     * </p>
     *
     * @param handlingUnitAltUnitOfMeasure
     *            Alternative unit of measure for stock unit of measure
     */
    public void setHandlingUnitAltUnitOfMeasure( @Nullable final String handlingUnitAltUnitOfMeasure )
    {
        rememberChangedField("HandlingUnitAltUnitOfMeasure", this.handlingUnitAltUnitOfMeasure);
        this.handlingUnitAltUnitOfMeasure = handlingUnitAltUnitOfMeasure;
    }

    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>Material</b>
     * </p>
     *
     * @param material
     *            Material Number
     */
    public void setMaterial( @Nullable final String material )
    {
        rememberChangedField("Material", this.material);
        this.material = material;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ShelfLifeExpirationDate</b>
     * </p>
     *
     * @param shelfLifeExpirationDate
     *            Shelf Life Expiration or Best-Before Date
     */
    public void setShelfLifeExpirationDate( @Nullable final LocalDateTime shelfLifeExpirationDate )
    {
        rememberChangedField("ShelfLifeExpirationDate", this.shelfLifeExpirationDate);
        this.shelfLifeExpirationDate = shelfLifeExpirationDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>HandlingUnitGoodsReceiptDate</b>
     * </p>
     *
     * @param handlingUnitGoodsReceiptDate
     *            Date of Goods Receipt
     */
    public void setHandlingUnitGoodsReceiptDate( @Nullable final LocalDateTime handlingUnitGoodsReceiptDate )
    {
        rememberChangedField("HandlingUnitGoodsReceiptDate", this.handlingUnitGoodsReceiptDate);
        this.handlingUnitGoodsReceiptDate = handlingUnitGoodsReceiptDate;
    }

    @Override
    protected String getEntityCollection()
    {
        return "HandlingUnitItem";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("HandlingUnitExternalID", getHandlingUnitExternalID());
        result.put("Warehouse", getWarehouse());
        result.put("StockItemUUID", getStockItemUUID());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("HandlingUnitExternalID", getHandlingUnitExternalID());
        values.put("Warehouse", getWarehouse());
        values.put("StockItemUUID", getStockItemUUID());
        values.put("HandlingUnitItem", getHandlingUnitItem());
        values.put("HandlingUnitReferenceDocument", getHandlingUnitReferenceDocument());
        values.put("HandlingUnitRefDocumentItem", getHandlingUnitRefDocumentItem());
        values.put("HandlingUnitQuantity", getHandlingUnitQuantity());
        values.put("HandlingUnitQuantityUnit", getHandlingUnitQuantityUnit());
        values.put("HandlingUnitAltUnitOfMeasure", getHandlingUnitAltUnitOfMeasure());
        values.put("Material", getMaterial());
        values.put("ShelfLifeExpirationDate", getShelfLifeExpirationDate());
        values.put("HandlingUnitGoodsReceiptDate", getHandlingUnitGoodsReceiptDate());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("HandlingUnitExternalID") ) {
                final Object value = values.remove("HandlingUnitExternalID");
                if( (value == null) || (!value.equals(getHandlingUnitExternalID())) ) {
                    setHandlingUnitExternalID(((String) value));
                }
            }
            if( values.containsKey("Warehouse") ) {
                final Object value = values.remove("Warehouse");
                if( (value == null) || (!value.equals(getWarehouse())) ) {
                    setWarehouse(((String) value));
                }
            }
            if( values.containsKey("StockItemUUID") ) {
                final Object value = values.remove("StockItemUUID");
                if( (value == null) || (!value.equals(getStockItemUUID())) ) {
                    setStockItemUUID(((UUID) value));
                }
            }
            if( values.containsKey("HandlingUnitItem") ) {
                final Object value = values.remove("HandlingUnitItem");
                if( (value == null) || (!value.equals(getHandlingUnitItem())) ) {
                    setHandlingUnitItem(((String) value));
                }
            }
            if( values.containsKey("HandlingUnitReferenceDocument") ) {
                final Object value = values.remove("HandlingUnitReferenceDocument");
                if( (value == null) || (!value.equals(getHandlingUnitReferenceDocument())) ) {
                    setHandlingUnitReferenceDocument(((String) value));
                }
            }
            if( values.containsKey("HandlingUnitRefDocumentItem") ) {
                final Object value = values.remove("HandlingUnitRefDocumentItem");
                if( (value == null) || (!value.equals(getHandlingUnitRefDocumentItem())) ) {
                    setHandlingUnitRefDocumentItem(((String) value));
                }
            }
            if( values.containsKey("HandlingUnitQuantity") ) {
                final Object value = values.remove("HandlingUnitQuantity");
                if( (value == null) || (!value.equals(getHandlingUnitQuantity())) ) {
                    setHandlingUnitQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("HandlingUnitQuantityUnit") ) {
                final Object value = values.remove("HandlingUnitQuantityUnit");
                if( (value == null) || (!value.equals(getHandlingUnitQuantityUnit())) ) {
                    setHandlingUnitQuantityUnit(((String) value));
                }
            }
            if( values.containsKey("HandlingUnitAltUnitOfMeasure") ) {
                final Object value = values.remove("HandlingUnitAltUnitOfMeasure");
                if( (value == null) || (!value.equals(getHandlingUnitAltUnitOfMeasure())) ) {
                    setHandlingUnitAltUnitOfMeasure(((String) value));
                }
            }
            if( values.containsKey("Material") ) {
                final Object value = values.remove("Material");
                if( (value == null) || (!value.equals(getMaterial())) ) {
                    setMaterial(((String) value));
                }
            }
            if( values.containsKey("ShelfLifeExpirationDate") ) {
                final Object value = values.remove("ShelfLifeExpirationDate");
                if( (value == null) || (!value.equals(getShelfLifeExpirationDate())) ) {
                    setShelfLifeExpirationDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("HandlingUnitGoodsReceiptDate") ) {
                final Object value = values.remove("HandlingUnitGoodsReceiptDate");
                if( (value == null) || (!value.equals(getHandlingUnitGoodsReceiptDate())) ) {
                    setHandlingUnitGoodsReceiptDate(((LocalDateTime) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_HandlingUnit") ) {
                final Object value = (values).remove("to_HandlingUnit");
                if( value instanceof Map ) {
                    if( toHandlingUnit == null ) {
                        toHandlingUnit = new HandlingUnit();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toHandlingUnit.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> HandlingUnitItemField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new HandlingUnitItemField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> HandlingUnitItemField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new HandlingUnitItemField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.HandlingUnitService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toHandlingUnit != null ) {
            (values).put("to_HandlingUnit", toHandlingUnit);
        }
        return values;
    }

    /**
     * Fetches the <b>HandlingUnit</b> entity (one to one) associated with this entity. This corresponds to the OData
     * navigation property <b>to_HandlingUnit</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>HandlingUnit</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public HandlingUnit fetchHandlingUnit()
    {
        return fetchFieldAsSingle("to_HandlingUnit", HandlingUnit.class);
    }

    /**
     * Retrieval of associated <b>HandlingUnit</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_HandlingUnit</b>.
     * <p>
     * If the navigation property <b>to_HandlingUnit</b> of a queried <b>HandlingUnitItem</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>HandlingUnit</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public HandlingUnit getHandlingUnitOrFetch()
    {
        if( toHandlingUnit == null ) {
            toHandlingUnit = fetchHandlingUnit();
        }
        return toHandlingUnit;
    }

    /**
     * Retrieval of associated <b>HandlingUnit</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_HandlingUnit</b>.
     * <p>
     * If the navigation property for an entity <b>HandlingUnitItem</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_HandlingUnit</b> is already loaded, the result will
     *         contain the <b>HandlingUnit</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<HandlingUnit> getHandlingUnitIfPresent()
    {
        return Option.of(toHandlingUnit);
    }

    /**
     * Overwrites the associated <b>HandlingUnit</b> entity for the loaded navigation property <b>to_HandlingUnit</b>.
     *
     * @param value
     *            New <b>HandlingUnit</b> entity.
     */
    public void setHandlingUnit( final HandlingUnit value )
    {
        toHandlingUnit = value;
    }

    /**
     * Helper class to allow for fluent creation of HandlingUnitItem instances.
     *
     */
    public final static class HandlingUnitItemBuilder
    {

        private HandlingUnit toHandlingUnit;

        private HandlingUnitItem.HandlingUnitItemBuilder toHandlingUnit( final HandlingUnit value )
        {
            toHandlingUnit = value;
            return this;
        }

        /**
         * Navigation property <b>to_HandlingUnit</b> for <b>HandlingUnitItem</b> to single <b>HandlingUnit</b>.
         *
         * @param value
         *            The HandlingUnit to build this HandlingUnitItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public HandlingUnitItem.HandlingUnitItemBuilder handlingUnit( final HandlingUnit value )
        {
            return toHandlingUnit(value);
        }

    }

}
