/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.handlingunit.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchFluentHelperBasic;

/**
 * Default implementation of the {@link HandlingUnitServiceBatch} interface exposed in the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.HandlingUnitService HandlingUnitService}, allowing you to
 * create multiple changesets and finally execute the batch request.
 *
 */
public class DefaultHandlingUnitServiceBatch
    extends
    BatchFluentHelperBasic<HandlingUnitServiceBatch, HandlingUnitServiceBatchChangeSet>
    implements
    HandlingUnitServiceBatch
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.HandlingUnitService service;
    @Nonnull
    private final String servicePath;

    /**
     * Creates a new instance of this DefaultHandlingUnitServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultHandlingUnitServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.HandlingUnitService service )
    {
        this(service, com.sap.cloud.sdk.s4hana.datamodel.odata.services.HandlingUnitService.DEFAULT_SERVICE_PATH);
    }

    /**
     * Creates a new instance of this DefaultHandlingUnitServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     * @param servicePath
     *            The custom service path to operate on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultHandlingUnitServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.HandlingUnitService service,
        @Nonnull final String servicePath )
    {
        this.service = service;
        this.servicePath = servicePath;
    }

    @Nonnull
    @Override
    protected String getServicePathForBatchRequest()
    {
        return servicePath;
    }

    @Nonnull
    @Override
    protected DefaultHandlingUnitServiceBatch getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public HandlingUnitServiceBatchChangeSet beginChangeSet()
    {
        return new DefaultHandlingUnitServiceBatchChangeSet(this, service);
    }

}
